/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationExecutionExportRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.Matchers;

public class FlowTest
extends AbstractAuthenticationTest {
    @Test
    public void testRemoveSubflows() {
        this.createFlow(this.newFlow("Foo", "Foo flow", "generic", true, false));
        this.addFlowToParent("Foo", "child");
        this.addFlowToParent("child", "grandchild");
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = FlowTest.findFlowByAlias("Foo", flows);
        this.authMgmtResource.deleteFlow(found.getId());
        this.assertAdminEvents.clear();
        this.createFlow(this.newFlow("Foo", "Foo flow", "generic", true, false));
        this.addFlowToParent("Foo", "child");
        this.addFlowToParent("child", "grandchild");
    }

    private void addFlowToParent(String parentAlias, String childAlias) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("alias", childAlias);
        data.put("type", "generic");
        data.put("description", childAlias + " flow");
        this.authMgmtResource.addExecutionFlow(parentAlias, data);
    }

    @Test
    public void testAddFlowWithRestrictedCharInAlias() {
        Response resp = this.authMgmtResource.createFlow(this.newFlow("fo]o", "Browser flow", "basic-flow", true, false));
        Assert.assertEquals((long)400L, (long)resp.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveFlow() {
        List flows = this.authMgmtResource.getFlows();
        for (AuthenticationFlowRepresentation flow : flows) {
            try {
                this.authMgmtResource.deleteFlow(flow.getId());
                Assert.fail((String)"deleteFlow should fail for built in flow");
            }
            catch (BadRequestException e) {
                break;
            }
        }
        try (Response response = this.authMgmtResource.createFlow(this.newFlow("browser", "Browser flow", "basic-flow", true, false));){
            Assert.assertEquals((String)"createFlow using the alias of existing flow should fail", (long)409L, (long)response.getStatus());
        }
        response = this.authMgmtResource.createFlow(this.newFlow(null, "Browser flow", "basic-flow", true, false));
        try {
            Assert.assertEquals((String)"createFlow using the alias of existing flow should fail", (long)409L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        AuthenticationFlowRepresentation newFlow = this.newFlow("browser-2", "Browser flow", "basic-flow", true, false);
        this.createFlow(newFlow);
        flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = FlowTest.findFlowByAlias("browser-2", flows);
        Assert.assertNotNull((String)"created flow visible in parent", (Object)found);
        this.compareFlows(newFlow, found);
        try {
            this.authMgmtResource.getFlow("id-123-notExistent");
            Assert.fail((String)"Not expected to find unexistent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticationFlowRepresentation found2 = this.authMgmtResource.getFlow(found.getId());
        Assert.assertNotNull((String)"created flow visible directly", (Object)found2);
        this.compareFlows(newFlow, found2);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("alias", "SomeFlow");
        data.put("type", "basic-flow");
        data.put("description", "Test flow");
        data.put("provider", "registration-page-form");
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("alias", "SomeFlow2");
        data2.put("type", "form-flow");
        data2.put("description", "Test flow 2");
        data2.put("provider", "registration-page-form");
        try {
            this.authMgmtResource.addExecutionFlow("inexistent-parent-flow-alias", data);
            Assert.fail((String)"addExecutionFlow for inexistent parent should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            data.put("alias", "browser");
            this.authMgmtResource.addExecutionFlow("browser-2", data);
            Assert.fail((String)"addExecutionFlow should have failed as browser flow already exists");
        }
        catch (Exception exception) {
            // empty catch block
        }
        data.put("alias", "SomeFlow");
        this.authMgmtResource.addExecutionFlow("browser-2", data);
        this.authMgmtResource.addExecutionFlow("browser-2", data2);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("browser-2"), data, ResourceType.AUTH_EXECUTION_FLOW);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("browser-2"), data2, ResourceType.AUTH_EXECUTION_FLOW);
        flows = this.authMgmtResource.getFlows();
        found2 = FlowTest.findFlowByAlias("browser-2", flows);
        Assert.assertNotNull((String)"created flow visible in parent", (Object)found2);
        List execs = found2.getAuthenticationExecutions();
        Assert.assertNotNull((Object)execs);
        Assert.assertEquals((String)"Size two", (long)2L, (long)execs.size());
        AuthenticationExecutionExportRepresentation expected = new AuthenticationExecutionExportRepresentation();
        expected.setFlowAlias("SomeFlow");
        expected.setUserSetupAllowed(false);
        expected.setAuthenticatorFlow(true);
        expected.setRequirement("DISABLED");
        expected.setPriority(0);
        this.compareExecution(expected, (AuthenticationExecutionExportRepresentation)execs.get(0));
        expected = new AuthenticationExecutionExportRepresentation();
        expected.setFlowAlias("SomeFlow2");
        expected.setUserSetupAllowed(false);
        expected.setAuthenticator("registration-page-form");
        expected.setAuthenticatorFlow(true);
        expected.setRequirement("DISABLED");
        expected.setPriority(1);
        this.compareExecution(expected, (AuthenticationExecutionExportRepresentation)execs.get(1));
        this.authMgmtResource.deleteFlow(found.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authFlowPath(found.getId()), ResourceType.AUTH_FLOW);
        flows = this.authMgmtResource.getFlows();
        found = FlowTest.findFlowByAlias("browser-2", flows);
        Assert.assertNull((String)"flow deleted", (Object)found);
        try {
            this.authMgmtResource.deleteFlow("id-123-notExistent");
            Assert.fail((String)"Not expected to delete flow, which doesn't exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFlow() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "clients");
        try (Response response = this.authMgmtResource.copy("browser", params);){
            Assert.assertThat((String)"Copy flow using the new alias of existing flow should fail", (Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CONFLICT));
            Assert.assertThat((String)"Copy flow using the new alias of existing flow should fail", (Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.containsString((String)"already exists")));
            Assert.assertThat((String)"Copy flow using the new alias of existing flow should fail", (Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.containsString((String)"flow alias")));
        }
        params.clear();
        response = this.authMgmtResource.copy("non-existent", params);
        try {
            Assert.assertThat((String)"Copy non-existing flow", (Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.NOT_FOUND));
        }
        finally {
            response.close();
        }
        params.put("newName", "Copy of browser");
        response = this.authMgmtResource.copy("browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        try {
            Assert.assertThat((String)"Copy flow", (Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.CREATED));
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation browser = FlowTest.findFlowByAlias("browser", flows);
        AuthenticationFlowRepresentation copyOfBrowser = FlowTest.findFlowByAlias("Copy of browser", flows);
        Assert.assertNotNull((Object)browser);
        Assert.assertNotNull((Object)copyOfBrowser);
        browser.setAlias("Copy of browser");
        browser.setBuiltIn(false);
        ((AuthenticationExecutionExportRepresentation)browser.getAuthenticationExecutions().get(3)).setFlowAlias("Copy of browser forms");
        this.compareFlows(browser, copyOfBrowser);
        copyOfBrowser = this.authMgmtResource.getFlow(copyOfBrowser.getId());
        Assert.assertNotNull((Object)copyOfBrowser);
        this.compareFlows(browser, copyOfBrowser);
        this.authMgmtResource.deleteFlow(copyOfBrowser.getId());
    }

    @Test
    public void addExecutionFlow() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "parent");
        Response response = this.authMgmtResource.copy("browser", params);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        params = new HashMap();
        params.put("alias", "child");
        params.put("description", "Description");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        this.authMgmtResource.addExecutionFlow("parent", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("parent"), params, ResourceType.AUTH_EXECUTION_FLOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void editFlowTest() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "Copy of browser");
        Response response = this.authMgmtResource.copy("browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        try {
            Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation testFlow = FlowTest.findFlowByAlias("Copy of browser", flows);
        testFlow.setAlias("Copy of browser2");
        this.authMgmtResource.updateFlow(testFlow.getId(), testFlow);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authEditFlowPath(testFlow.getId()), ResourceType.AUTH_FLOW);
        flows = this.authMgmtResource.getFlows();
        Assert.assertEquals((Object)"Copy of browser2", (Object)FlowTest.findFlowByAlias("Copy of browser2", flows).getAlias());
        AuthenticationFlowRepresentation newFlow = this.newFlow("New Flow", "Test description", "basic-flow", true, false);
        this.createFlow(newFlow);
        flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation found = FlowTest.findFlowByAlias("New Flow", flows);
        Assert.assertNotNull((String)"created flow visible in parent", (Object)found);
        this.compareFlows(newFlow, found);
        testFlow.setAlias("New Flow");
        try {
            this.authMgmtResource.updateFlow(found.getId(), testFlow);
        }
        catch (ClientErrorException clientErrorException) {
            // empty catch block
        }
        flows = this.authMgmtResource.getFlows();
        Assert.assertEquals((Object)"Copy of browser2", (Object)FlowTest.findFlowByAlias("Copy of browser2", flows).getAlias());
        found.setDescription("New description");
        this.authMgmtResource.updateFlow(found.getId(), found);
        flows = this.authMgmtResource.getFlows();
        Assert.assertEquals((Object)"New description", (Object)FlowTest.findFlowByAlias("New Flow", flows).getDescription());
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authEditFlowPath(found.getId()), ResourceType.AUTH_FLOW);
        found.setAlias("New Flow2");
        found.setDescription("New description2");
        this.authMgmtResource.updateFlow(found.getId(), found);
        flows = this.authMgmtResource.getFlows();
        Assert.assertEquals((Object)"New Flow2", (Object)FlowTest.findFlowByAlias("New Flow2", flows).getAlias());
        Assert.assertEquals((Object)"New description2", (Object)FlowTest.findFlowByAlias("New Flow2", flows).getDescription());
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authEditFlowPath(found.getId()), ResourceType.AUTH_FLOW);
        Assert.assertNull((Object)FlowTest.findFlowByAlias("New Flow", flows));
        this.authMgmtResource.deleteFlow(testFlow.getId());
        this.authMgmtResource.deleteFlow(found.getId());
    }

    @Test
    public void editExecutionFlowTest() {
        HashMap<String, String> params = new HashMap<String, String>();
        AuthenticationFlowRepresentation newFlow = this.newFlow("Parent-Flow", "This is a parent flow", "basic-flow", true, false);
        this.createFlow(newFlow);
        params.put("alias", "Child-Flow");
        params.put("description", "This is a child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionFlowPath("Parent-Flow"), params, ResourceType.AUTH_EXECUTION_FLOW);
        List executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        params = new HashMap();
        params.put("alias", "Child-Flow");
        params.put("description", "This is another child flow");
        params.put("provider", "registration-page-form");
        params.put("type", "basic-flow");
        try {
            this.authMgmtResource.addExecutionFlow("Parent-Flow", params);
            Assert.fail((String)"addExecutionFlow the alias already exist");
        }
        catch (Exception exception) {
            // empty catch block
        }
        AuthenticationExecutionInfoRepresentation found = (AuthenticationExecutionInfoRepresentation)executionReps.get(0);
        found.setDisplayName("Parent-Flow");
        try {
            this.authMgmtResource.updateExecutions("Parent-Flow", found);
        }
        catch (ClientErrorException clientErrorException) {
            // empty catch block
        }
        found.setDisplayName("Child-Flow2");
        found.setDescription("This is another child flow2");
        this.authMgmtResource.updateExecutions("Parent-Flow", found);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("Parent-Flow"), ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        Assert.assertEquals((Object)"Child-Flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDisplayName());
        Assert.assertEquals((Object)"This is another child flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDescription());
        found.setDescription("This is another child flow3");
        this.authMgmtResource.updateExecutions("Parent-Flow", found);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("Parent-Flow"), ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("Parent-Flow");
        Assert.assertEquals((Object)"Child-Flow2", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDisplayName());
        Assert.assertEquals((Object)"This is another child flow3", (Object)((AuthenticationExecutionInfoRepresentation)executionReps.get(0)).getDescription());
    }
}

