/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin.authentication;

import java.util.HashMap;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.AssertAdminEvents;

public class ExecutionTest
extends AbstractAuthenticationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateAuthenticatorConfig() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newName", "new-browser-flow");
        Response response = this.authMgmtResource.copy("browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        try {
            Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        params.put("provider", "auth-conditional-otp-form");
        this.authMgmtResource.addExecution("new-browser-flow", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionPath("new-browser-flow"), params, ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions("new-browser-flow");
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider("auth-conditional-otp-form", executionReps);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("defaultOtpOutcome", "skip");
        config.put("otpControlAttribute", "test");
        config.put("forceOtpForHeaderPattern", "");
        config.put("forceOtpRole", "");
        config.put("noOtpRequiredForHeaderPattern", "");
        config.put("skipOtpRole", "");
        AuthenticatorConfigRepresentation authConfigRep = new AuthenticatorConfigRepresentation();
        authConfigRep.setAlias("conditional-otp-form-config-alias");
        authConfigRep.setConfig(config);
        response = this.authMgmtResource.newExecutionConfig(exec.getId(), authConfigRep);
        try {
            authConfigRep.setId(ApiUtil.getCreatedId((Response)response));
        }
        finally {
            response.close();
        }
        config.put("otpControlAttribute", "test-updated");
        authConfigRep.setConfig(config);
        this.authMgmtResource.updateAuthenticatorConfig(authConfigRep.getId(), authConfigRep);
        AuthenticatorConfigRepresentation updated = this.authMgmtResource.getAuthenticatorConfig(authConfigRep.getId());
        Assert.assertThat(updated.getConfig().values(), (Matcher)Matchers.hasItems((Object[])new String[]{"test-updated", "skip"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveExecution() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("provider", "idp-review-profile");
        try {
            this.authMgmtResource.addExecution("browser", params);
            Assert.fail((String)"add execution to built-in flow should fail");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        try {
            this.authMgmtResource.addExecution("not-existent", params);
            Assert.fail((String)"add execution to not-existent flow should fail");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        params.put("newName", "Copy-of-browser");
        Response response = this.authMgmtResource.copy("browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
        try {
            Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        params.put("provider", "test-execution");
        try {
            this.authMgmtResource.addExecution("CopyOfBrowser", params);
            Assert.fail((String)"add execution with inexistent provider should fail");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        params.put("provider", "idp-review-profile");
        this.authMgmtResource.addExecution("Copy-of-browser", params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionPath("Copy-of-browser"), params, ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions("Copy-of-browser");
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider("idp-review-profile", executionReps);
        Assert.assertNotNull((String)"idp-review-profile added", (Object)exec);
        AuthenticationExecutionInfoRepresentation authCookieExec = ExecutionTest.findExecutionByProvider("auth-cookie", executionReps);
        this.compareExecution(this.newExecInfo("Review Profile", "idp-review-profile", true, 0, 4, "DISABLED", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}), exec);
        this.authMgmtResource.removeExecution(exec.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authExecutionPath(exec.getId()), ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("Copy-of-browser");
        exec = ExecutionTest.findExecutionByProvider("idp-review-profile", executionReps);
        Assert.assertNull((String)"idp-review-profile removed", (Object)exec);
        this.authMgmtResource.removeExecution(authCookieExec.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authExecutionPath(authCookieExec.getId()), ResourceType.AUTH_EXECUTION);
        AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
        rep.setPriority(10);
        rep.setAuthenticator("auth-cookie");
        rep.setRequirement("CONDITIONAL");
        response = this.authMgmtResource.addExecution(rep);
        try {
            Assert.assertEquals((String)"added execution missing parent flow", (long)400L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        rep.setParentFlow("not-existent-id");
        response = this.authMgmtResource.addExecution(rep);
        try {
            Assert.assertEquals((String)"added execution missing parent flow", (long)400L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        AuthenticationFlowRepresentation browserFlow = ExecutionTest.findFlowByAlias("browser", this.authMgmtResource.getFlows());
        rep.setParentFlow(browserFlow.getId());
        response = this.authMgmtResource.addExecution(rep);
        try {
            Assert.assertEquals((String)"added execution to builtin flow", (long)400L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        List flows = this.authMgmtResource.getFlows();
        AuthenticationFlowRepresentation flow = ExecutionTest.findFlowByAlias("Copy-of-browser", flows);
        rep.setParentFlow(flow.getId());
        response = this.authMgmtResource.addExecution(rep);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AssertAdminEvents.isExpectedPrefixFollowedByUuid(AdminEventPaths.authMgmtBasePath() + "/executions"), (Object)rep, ResourceType.AUTH_EXECUTION);
        try {
            Assert.assertEquals((String)"added execution", (long)201L, (long)response.getStatus());
        }
        finally {
            response.close();
        }
        List executions = this.authMgmtResource.getExecutions("Copy-of-browser");
        exec = ExecutionTest.findExecutionByProvider("auth-cookie", executions);
        Assert.assertNotNull((String)"auth-cookie added", (Object)exec);
        this.compareExecution(this.newExecInfo("Cookie", "auth-cookie", false, 0, 3, "CONDITIONAL", null, new String[]{"REQUIRED", "ALTERNATIVE", "DISABLED"}), exec);
    }

    @Test
    public void testUpdateExecution() {
        List executionReps = this.authMgmtResource.getExecutions("browser");
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider("auth-cookie", executionReps);
        Assert.assertEquals((String)"auth-cookie set to ALTERNATIVE", (Object)"ALTERNATIVE", (Object)exec.getRequirement());
        exec.setRequirement("DISABLED");
        this.authMgmtResource.updateExecutions("browser", exec);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)exec, ResourceType.AUTH_EXECUTION);
        executionReps = this.authMgmtResource.getExecutions("browser");
        AuthenticationExecutionInfoRepresentation exec2 = ExecutionTest.findExecutionByProvider("auth-cookie", executionReps);
        this.compareExecution(exec, exec2);
    }

    @Test
    public void testClientFlowExecutions() {
        AuthenticationFlowRepresentation clientFlow = this.newFlow("new-client-flow", "desc", "client-flow", true, false);
        this.createFlow(clientFlow);
        HashMap<String, String> executionData = new HashMap<String, String>();
        executionData.put("provider", "client-secret");
        this.authMgmtResource.addExecution("new-client-flow", executionData);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionPath("new-client-flow"), executionData, ResourceType.AUTH_EXECUTION);
        try {
            this.authMgmtResource.getExecutions("not-existent");
            Assert.fail((String)"Not expected to find executions");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        List executions = this.authMgmtResource.getExecutions("new-client-flow");
        AuthenticationExecutionInfoRepresentation executionRep = ExecutionTest.findExecutionByProvider("client-secret", executions);
        Assert.assertNotNull((Object)executionRep);
        try {
            this.authMgmtResource.updateExecutions("not-existent", executionRep);
            Assert.fail((String)"Not expected to update execution with not-existent flow");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        AuthenticationExecutionInfoRepresentation executionRep2 = new AuthenticationExecutionInfoRepresentation();
        executionRep2.setId("not-existent");
        try {
            this.authMgmtResource.updateExecutions("new-client-flow", executionRep2);
            Assert.fail((String)"Not expected to update not-existent execution");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        executionRep.setRequirement("ALTERNATIVE");
        this.authMgmtResource.updateExecutions("new-client-flow", executionRep);
        this.assertAdminEvents.assertEvent("test", OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("new-client-flow"), (Object)executionRep, ResourceType.AUTH_EXECUTION);
        executionRep = ExecutionTest.findExecutionByProvider("client-secret", this.authMgmtResource.getExecutions("new-client-flow"));
        Assert.assertEquals((Object)"ALTERNATIVE", (Object)executionRep.getRequirement());
        try {
            this.authMgmtResource.removeExecution("not-existent");
            Assert.fail((String)"Didn't expect to find execution");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.authMgmtResource.removeExecution(executionRep.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authExecutionPath(executionRep.getId()), ResourceType.AUTH_EXECUTION);
        AuthenticationFlowRepresentation rep = ExecutionTest.findFlowByAlias("new-client-flow", this.authMgmtResource.getFlows());
        this.authMgmtResource.deleteFlow(rep.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authFlowPath(rep.getId()), ResourceType.AUTH_FLOW);
    }

    @Test
    @EnableFeature(value=Profile.Feature.WEB_AUTHN, skipRestart=true, onlyForProduct=true)
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testRequirementsInExecution() {
        HashMap<String, String> params = new HashMap<String, String>();
        String newBrowserFlow = "new-exec-flow";
        params.put("newName", newBrowserFlow);
        try (Response response = this.authMgmtResource.copy("browser", params);){
            this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authCopyFlowPath("browser"), params, ResourceType.AUTH_FLOW);
            Assert.assertEquals((String)"Copy flow", (long)201L, (long)response.getStatus());
        }
        this.addExecutionCheckReq(newBrowserFlow, "auth-username-form", params, "REQUIRED");
        this.addExecutionCheckReq(newBrowserFlow, "webauthn-authenticator", params, "DISABLED");
        this.addExecutionCheckReq(newBrowserFlow, "no-cookie-redirect", params, "REQUIRED");
        AuthenticationFlowRepresentation rep = ExecutionTest.findFlowByAlias(newBrowserFlow, this.authMgmtResource.getFlows());
        Assert.assertNotNull((Object)rep);
        this.authMgmtResource.deleteFlow(rep.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authFlowPath(rep.getId()), ResourceType.AUTH_FLOW);
    }

    private void addExecutionCheckReq(String flow, String providerID, HashMap<String, String> params, String expectedRequirement) {
        params.put("provider", providerID);
        this.authMgmtResource.addExecution(flow, params);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.authAddExecutionPath(flow), params, ResourceType.AUTH_EXECUTION);
        List executionReps = this.authMgmtResource.getExecutions(flow);
        AuthenticationExecutionInfoRepresentation exec = ExecutionTest.findExecutionByProvider(providerID, executionReps);
        Assert.assertNotNull((Object)exec);
        Assert.assertEquals((Object)expectedRequirement, (Object)exec.getRequirement());
        this.authMgmtResource.removeExecution(exec.getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.authExecutionPath(exec.getId()), ResourceType.AUTH_EXECUTION);
    }
}

