/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.LoginPage;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class UserTotpTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AccountTotpPage totpPage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    protected LoginPage loginPage;
    private TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Test
    public void setupTotp() {
        this.totpPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().client("account").detail("redirect_uri", this.getAccountRedirectUrl() + "?path=totp").assertEvent();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("Remove Google"));
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        Assert.assertEquals((Object)"Mobile authenticator configured.", (Object)this.profilePage.getSuccess());
        this.events.expectAccount(EventType.UPDATE_TOTP).assertEvent();
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("pficon-delete"));
        List users = this.adminClient.realms().realm("test").users().search("test-user@localhost", null, null, null, Integer.valueOf(0), Integer.valueOf(1));
        String userId = ((UserRepresentation)users.get(0)).getId();
        this.testingClient.testing().clearAdminEventQueue();
        CredentialRepresentation totpCredential = this.adminClient.realms().realm("test").users().get(userId).credentials().stream().filter(c -> "otp".equals(c.getType())).findFirst().get();
        this.adminClient.realms().realm("test").users().get(userId).removeCredential(totpCredential.getId());
        this.totpPage.open();
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("pficon-delete"));
        AdminEventRepresentation event = this.testingClient.testing().pollAdminEvent();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)OperationType.ACTION.name(), (Object)event.getOperationType());
        Assert.assertEquals((Object)("users/" + userId + "/credentials/" + totpCredential.getId()), (Object)event.getResourcePath());
    }
}

