/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.TokenVerifier;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.IdentityProviderResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.Profile;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.credential.CredentialModel;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.page.LoginPasswordUpdatePage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.PageUtils;
import org.keycloak.testsuite.pages.ProceedPage;
import org.keycloak.testsuite.runonserver.RunHelpers;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.util.JsonSerialization;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class UserTest
extends AbstractAdminTest {
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Drone
    protected WebDriver driver;
    @Page
    protected LoginPasswordUpdatePage passwordUpdatePage;
    @ArquillianResource
    protected OAuthClient oAuthClient;
    @Page
    protected InfoPage infoPage;
    @Page
    protected ProceedPage proceedPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    protected LoginPage loginPage;

    @After
    public void after() {
        this.realm.identityProviders().findAll().stream().forEach(ip -> this.realm.identityProviders().get(ip.getAlias()).remove());
        this.realm.groups().groups().stream().forEach(g -> this.realm.groups().group(g.getId()).remove());
    }

    public String createUser() {
        return this.createUser("user1", "user1@localhost");
    }

    public String createUser(String username, String email) {
        UserRepresentation user = new UserRepresentation();
        user.setUsername(username);
        user.setEmail(email);
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        return this.createUser(user);
    }

    private String createUser(UserRepresentation userRep) {
        return this.createUser(userRep, true);
    }

    private String createUser(UserRepresentation userRep, boolean assertAdminEvent) {
        Response response = this.realm.users().create(userRep);
        String createdId = ApiUtil.getCreatedId((Response)response);
        response.close();
        if (assertAdminEvent) {
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userResourcePath(createdId), (Object)userRep, ResourceType.USER);
        }
        this.getCleanup().addUserId(createdId);
        return createdId;
    }

    private void updateUser(UserResource user, UserRepresentation userRep) {
        user.update(userRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userResourcePath(userRep.getId()), (Object)userRep, ResourceType.USER);
    }

    @Test
    public void verifyCreateUser() {
        this.createUser();
    }

    @Test
    public void createUserWithTemporaryPasswordWithAdditionalPasswordUpdateShouldRemoveUpdatePasswordRequiredAction() {
        String userId = this.createUser();
        CredentialRepresentation credTmp = new CredentialRepresentation();
        credTmp.setType("password");
        credTmp.setValue("temp");
        credTmp.setTemporary(Boolean.TRUE);
        this.realm.users().get(userId).resetPassword(credTmp);
        CredentialRepresentation credPerm = new CredentialRepresentation();
        credPerm.setType("password");
        credPerm.setValue("perm");
        credPerm.setTemporary(null);
        this.realm.users().get(userId).resetPassword(credPerm);
        UserRepresentation userRep = this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertFalse((boolean)userRep.getRequiredActions().contains(UserModel.RequiredAction.UPDATE_PASSWORD.name()));
    }

    @Test
    public void createDuplicatedUser1() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        this.assertAdminEvents.assertEmpty();
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"User exists with same username", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    public void createDuplicatedUser2() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        this.assertAdminEvents.assertEmpty();
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"User exists with same email", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    public void createDuplicateEmailWithExistingDuplicates() {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setDuplicateEmailsAllowed(Boolean.valueOf(true));
        this.realm.update(rep);
        UserRepresentation user = new UserRepresentation();
        user.setEmail("user1@localhost");
        user.setUsername("user1");
        this.createUser(user, false);
        user.setUsername("user2");
        this.createUser(user, false);
        rep.setDuplicateEmailsAllowed(Boolean.valueOf(false));
        this.realm.update(rep);
        user.setUsername("user3");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"User exists with same email", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void createUserWithHashedCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_creds");
        user.setEmail("email@localhost");
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromValues((String)"my-algorithm", (byte[])"theSalt".getBytes(), (int)22, (String)"ABC");
        CredentialRepresentation hashedPassword = ModelToRepresentation.toRepresentation((CredentialModel)pcm);
        hashedPassword.setCreatedDate(Long.valueOf(1001L));
        hashedPassword.setUserLabel("deviceX");
        hashedPassword.setType("password");
        user.setCredentials(Arrays.asList(hashedPassword));
        this.createUser(user);
        CredentialModel credentialHashed = this.fetchCredentials("user_creds");
        PasswordCredentialModel pcmh = PasswordCredentialModel.createFromCredentialModel((CredentialModel)credentialHashed);
        org.junit.Assert.assertNotNull((String)"Expecting credential", (Object)credentialHashed);
        org.junit.Assert.assertEquals((Object)"my-algorithm", (Object)pcmh.getPasswordCredentialData().getAlgorithm());
        org.junit.Assert.assertEquals((Object)1001L, (Object)credentialHashed.getCreatedDate());
        org.junit.Assert.assertEquals((Object)"deviceX", (Object)credentialHashed.getUserLabel());
        org.junit.Assert.assertEquals((long)22L, (long)pcmh.getPasswordCredentialData().getHashIterations());
        org.junit.Assert.assertEquals((Object)"ABC", (Object)pcmh.getPasswordSecretData().getValue());
        org.junit.Assert.assertEquals((Object)"theSalt", (Object)new String(pcmh.getPasswordSecretData().getSalt()));
        org.junit.Assert.assertEquals((Object)"password", (Object)credentialHashed.getType());
    }

    @Test
    public void createUserWithDeprecatedCredentialsFormat() throws IOException {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_creds");
        user.setEmail("email@localhost");
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromValues((String)"my-algorithm", (byte[])"theSalt".getBytes(), (int)22, (String)"ABC");
        String deprecatedCredential = "{\n      \"type\" : \"password\",\n      \"hashedSaltedValue\" : \"" + pcm.getPasswordSecretData().getValue() + "\",\n      \"salt\" : \"" + Base64.encodeBytes((byte[])pcm.getPasswordSecretData().getSalt()) + "\",\n      \"hashIterations\" : " + pcm.getPasswordCredentialData().getHashIterations() + ",\n      \"algorithm\" : \"" + pcm.getPasswordCredentialData().getAlgorithm() + "\"\n    }";
        CredentialRepresentation deprecatedHashedPassword = (CredentialRepresentation)JsonSerialization.readValue((String)deprecatedCredential, CredentialRepresentation.class);
        org.junit.Assert.assertNotNull((Object)deprecatedHashedPassword.getHashedSaltedValue());
        org.junit.Assert.assertNull((Object)deprecatedHashedPassword.getCredentialData());
        deprecatedHashedPassword.setCreatedDate(Long.valueOf(1001L));
        deprecatedHashedPassword.setUserLabel("deviceX");
        deprecatedHashedPassword.setType("password");
        user.setCredentials(Arrays.asList(deprecatedHashedPassword));
        this.createUser(user, false);
        CredentialModel credentialHashed = this.fetchCredentials("user_creds");
        PasswordCredentialModel pcmh = PasswordCredentialModel.createFromCredentialModel((CredentialModel)credentialHashed);
        org.junit.Assert.assertNotNull((String)"Expecting credential", (Object)credentialHashed);
        org.junit.Assert.assertEquals((Object)"my-algorithm", (Object)pcmh.getPasswordCredentialData().getAlgorithm());
        org.junit.Assert.assertEquals((Object)1001L, (Object)credentialHashed.getCreatedDate());
        org.junit.Assert.assertEquals((Object)"deviceX", (Object)credentialHashed.getUserLabel());
        org.junit.Assert.assertEquals((long)22L, (long)pcmh.getPasswordCredentialData().getHashIterations());
        org.junit.Assert.assertEquals((Object)"ABC", (Object)pcmh.getPasswordSecretData().getValue());
        org.junit.Assert.assertEquals((Object)"theSalt", (Object)new String(pcmh.getPasswordSecretData().getSalt()));
        org.junit.Assert.assertEquals((Object)"password", (Object)credentialHashed.getType());
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void updateUserWithHashedCredentials() {
        String userId = this.createUser("user_hashed_creds", "user_hashed_creds@localhost");
        byte[] salt = new byte[]{-69, 85, 87, 99, 26, -107, 125, 99, -77, 30, -111, 118, 108, 100, -117, -56};
        PasswordCredentialModel credentialModel = PasswordCredentialModel.createFromValues((String)"pbkdf2-sha256", (byte[])salt, (int)27500, (String)"uskEPZWMr83pl2mzNB95SFXfIabe2UH9ClENVx/rrQqOjFEjL2aAOGpWsFNNF3qoll7Qht2mY5KxIDm3Rnve2w==");
        credentialModel.setCreatedDate(Long.valueOf(1001L));
        CredentialRepresentation hashedPassword = ModelToRepresentation.toRepresentation((CredentialModel)credentialModel);
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setCredentials(Collections.singletonList(hashedPassword));
        this.realm.users().get(userId).update(userRepresentation);
        String accountUrl = RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"admin-client-test"}).toString();
        this.driver.navigate().to(accountUrl);
        org.junit.Assert.assertEquals((Object)"Sign in to your account", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.loginPage.login("user_hashed_creds", "admin");
        org.junit.Assert.assertTrue((boolean)this.driver.getTitle().contains("Account Management"));
    }

    @Test
    public void createUserWithTempolaryCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_temppw");
        user.setEmail("email.temppw@localhost");
        CredentialRepresentation password = new CredentialRepresentation();
        password.setValue("password");
        password.setType("password");
        password.setTemporary(Boolean.valueOf(true));
        user.setCredentials(Arrays.asList(password));
        String userId = this.createUser(user);
        UserRepresentation userRep = this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertEquals((long)1L, (long)userRep.getRequiredActions().size());
        org.junit.Assert.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.toString(), userRep.getRequiredActions().get(0));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void createUserWithRawCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_rawpw");
        user.setEmail("email.raw@localhost");
        CredentialRepresentation rawPassword = new CredentialRepresentation();
        rawPassword.setValue("ABCD");
        rawPassword.setType("password");
        user.setCredentials(Arrays.asList(rawPassword));
        this.createUser(user);
        CredentialModel credential = this.fetchCredentials("user_rawpw");
        org.junit.Assert.assertNotNull((String)"Expecting credential", (Object)credential);
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromCredentialModel((CredentialModel)credential);
        org.junit.Assert.assertEquals((Object)"pbkdf2-sha256", (Object)pcm.getPasswordCredentialData().getAlgorithm());
        org.junit.Assert.assertEquals((long)27500L, (long)pcm.getPasswordCredentialData().getHashIterations());
        org.junit.Assert.assertNotEquals((Object)"ABCD", (Object)pcm.getPasswordSecretData().getValue());
        org.junit.Assert.assertEquals((Object)"password", (Object)credential.getType());
    }

    private CredentialModel fetchCredentials(String username) {
        return (CredentialModel)this.getTestingClient().server("admin-client-test").fetch(RunHelpers.fetchCredentials((String)username));
    }

    @Test
    public void createDuplicatedUser3() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("User1");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser4() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("USER1");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser5() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("User1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser6() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@LOCALHOST");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
    }

    @Test
    public void createDuplicatedUser7() {
        this.createUser("user1", "USer1@Localhost");
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setEmail("user1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)409L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEmpty();
    }

    @Test
    public void createTwoUsersWithEmptyStringEmails() {
        this.createUser("user1", "");
        this.createUser("user2", "");
    }

    @Test
    public void createUserWithFederationLink() {
        ComponentRepresentation dummyFederationProvider = new ComponentRepresentation();
        dummyFederationProvider.setId("dummy");
        dummyFederationProvider.setName("dummy");
        dummyFederationProvider.setProviderId("dummy");
        dummyFederationProvider.setProviderType(UserStorageProvider.class.getName());
        this.adminClient.realms().realm("admin-client-test").components().add(dummyFederationProvider);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.componentPath("dummy"), (Object)dummyFederationProvider, ResourceType.COMPONENT);
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setEmail("user1@localhost");
        user.setFederationLink("dummy");
        String userId = this.createUser(user);
        UserRepresentation createdUser = this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertNotNull((Object)createdUser);
        org.junit.Assert.assertEquals((Object)user.getFederationLink(), (Object)createdUser.getFederationLink());
    }

    @Test
    public void createUserWithoutUsername() {
        UserRepresentation user = new UserRepresentation();
        user.setEmail("user1@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"User name is missing", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    public void createUserWithEmailAsUsername() {
        this.switchRegistrationEmailAsUsername(true);
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        org.junit.Assert.assertEquals((Object)"user1@localhost", (Object)userRep.getUsername());
        this.switchRegistrationEmailAsUsername(false);
    }

    @Test
    public void createUserWithEmptyUsername() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("");
        user.setEmail("user2@localhost");
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"User name is missing", (Object)error.getErrorMessage());
        response.close();
    }

    @Test
    public void createUserWithInvalidPolicyPassword() {
        RealmRepresentation rep = this.realm.toRepresentation();
        String passwordPolicy = rep.getPasswordPolicy();
        rep.setPasswordPolicy("length(8)");
        this.realm.update(rep);
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user4");
        user.setEmail("user4@localhost");
        CredentialRepresentation rawPassword = new CredentialRepresentation();
        rawPassword.setValue("ABCD");
        rawPassword.setType("password");
        user.setCredentials(Arrays.asList(rawPassword));
        Response response = this.realm.users().create(user);
        org.junit.Assert.assertEquals((long)400L, (long)response.getStatus());
        ErrorRepresentation error = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        org.junit.Assert.assertEquals((Object)"Password policy not met", (Object)error.getErrorMessage());
        rep.setPasswordPolicy(passwordPolicy);
        this.realm.update(rep);
        response.close();
    }

    private List<String> createUsers() {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 1; i < 10; ++i) {
            UserRepresentation user = new UserRepresentation();
            user.setUsername("username" + i);
            user.setEmail("user" + i + "@localhost");
            user.setFirstName("First" + i);
            user.setLastName("Last" + i);
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            attributes.put("test", Collections.singletonList("test" + i));
            attributes.put("test" + i, Collections.singletonList("test" + i));
            attributes.put("attr", Collections.singletonList("common"));
            user.setAttributes(attributes);
            ids.add(this.createUser(user));
        }
        return ids;
    }

    @Test
    public void searchByEmail() {
        this.createUsers();
        List users = this.realm.users().search(null, null, null, "user1@localhost", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search(null, null, null, "@localhost", null, null);
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void searchByUsername() {
        this.createUsers();
        List users = this.realm.users().search("username1", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("user", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    private String mapToSearchQuery(Map<String, String> search) {
        return search.entrySet().stream().map(e -> String.format("%s:%s", e.getKey(), e.getValue())).collect(Collectors.joining(" "));
    }

    @Test
    public void searchByAttribute() {
        this.createUsers();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("test", "test1");
        List users = this.realm.users().searchByAttributes(this.mapToSearchQuery(attributes));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        attributes.clear();
        attributes.put("attr", "common");
        users = this.realm.users().searchByAttributes(this.mapToSearchQuery(attributes));
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void searchByMultipleAttributes() {
        this.createUsers();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("test", "test1");
        attributes.put("attr", "common");
        attributes.put("test1", "test1");
        List users = this.realm.users().searchByAttributes(this.mapToSearchQuery(attributes));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
    }

    @Test
    public void searchByAttributesWithPagination() {
        this.createUsers();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("attr", "common");
        for (int i = 1; i < 10; ++i) {
            List users = this.realm.users().searchByAttributes(Integer.valueOf(i - 1), Integer.valueOf(1), null, Boolean.valueOf(false), this.mapToSearchQuery(attributes));
            org.junit.Assert.assertEquals((long)1L, (long)users.size());
            org.junit.Assert.assertTrue((boolean)((UserRepresentation)users.get(0)).getAttributes().keySet().stream().anyMatch(attributes::containsKey));
        }
    }

    @Test
    public void searchByUsernameExactMatch() {
        this.createUsers();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("username11");
        this.createUser(user);
        List users = this.realm.users().search("username1", Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("user", Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)0L, (long)users.size());
    }

    @Test
    public void searchByFirstNameNullForLastName() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setFirstName("Erik");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        this.createUser(user);
        List users = this.realm.users().search("Erik", Integer.valueOf(0), Integer.valueOf(50));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
    }

    @Test
    public void searchByLastNameNullForFirstName() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user1");
        user.setLastName("de Wit");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(true));
        this.createUser(user);
        List users = this.realm.users().search("wit", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
    }

    @Test
    public void searchByEnabled() {
        String userCommonName = "enabled-disabled-user";
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername(userCommonName + "1");
        user1.setRequiredActions(Collections.emptyList());
        user1.setEnabled(Boolean.valueOf(true));
        this.createUser(user1);
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername(userCommonName + "2");
        user2.setRequiredActions(Collections.emptyList());
        user2.setEnabled(Boolean.valueOf(false));
        this.createUser(user2);
        List enabledUsers = this.realm.users().search(null, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        org.junit.Assert.assertEquals((long)1L, (long)enabledUsers.size());
        List enabledUsersWithFilter = this.realm.users().search(userCommonName, null, null, null, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)1L, (long)enabledUsersWithFilter.size());
        org.junit.Assert.assertEquals((Object)user1.getUsername(), (Object)((UserRepresentation)enabledUsersWithFilter.get(0)).getUsername());
        List disabledUsers = this.realm.users().search(userCommonName, null, null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(false));
        org.junit.Assert.assertEquals((long)1L, (long)disabledUsers.size());
        org.junit.Assert.assertEquals((Object)user2.getUsername(), (Object)((UserRepresentation)disabledUsers.get(0)).getUsername());
        List allUsers = this.realm.users().search(userCommonName, null, null, null, Integer.valueOf(0), Integer.valueOf(100), null, Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)2L, (long)allUsers.size());
    }

    @Test
    public void searchWithFilters() {
        this.createUser();
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user2");
        user.setFirstName("First");
        user.setLastName("Last");
        user.setEmail("user2@localhost");
        user.setRequiredActions(Collections.emptyList());
        user.setEnabled(Boolean.valueOf(false));
        this.createUser(user);
        List searchFirstNameAndDisabled = this.realm.users().search(null, "First", null, null, null, null, Boolean.valueOf(false), Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)1L, (long)searchFirstNameAndDisabled.size());
        org.junit.Assert.assertEquals((Object)user.getUsername(), (Object)((UserRepresentation)searchFirstNameAndDisabled.get(0)).getUsername());
        List searchLastNameAndEnabled = this.realm.users().search(null, null, "Last", null, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        org.junit.Assert.assertEquals((long)0L, (long)searchLastNameAndEnabled.size());
        List searchEmailAndDisabled = this.realm.users().search(null, null, null, "user2@localhost", Integer.valueOf(0), Integer.valueOf(50), Boolean.valueOf(false), Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)1L, (long)searchEmailAndDisabled.size());
        org.junit.Assert.assertEquals((Object)user.getUsername(), (Object)((UserRepresentation)searchEmailAndDisabled.get(0)).getUsername());
        List searchInvalidSizeAndDisabled = this.realm.users().search(null, null, null, null, Integer.valueOf(10), Integer.valueOf(20), null, Boolean.valueOf(false));
        org.junit.Assert.assertEquals((long)0L, (long)searchInvalidSizeAndDisabled.size());
    }

    @Test
    public void searchByIdp() {
        this.createUser();
        String identityProviderAlias1 = "identity-provider-alias1";
        this.addSampleIdentityProvider("identity-provider-alias1", 0);
        String identityProviderAlias2 = "identity-provider-alias2";
        this.addSampleIdentityProvider("identity-provider-alias2", 1);
        String commonIdpUserId = "commonIdpUserId";
        String idp1User1Username = "idp1user1";
        String idp1User1KeycloakId = this.createUser("idp1user1", "idp1user1@localhost");
        String idp1User1UserId = "idp1user1Id";
        FederatedIdentityRepresentation link1_1 = new FederatedIdentityRepresentation();
        link1_1.setUserId("idp1user1Id");
        link1_1.setUserName("idp1user1");
        this.addFederatedIdentity(idp1User1KeycloakId, "identity-provider-alias1", link1_1);
        String idp1User2Username = "idp1user2";
        String idp1User2KeycloakId = this.createUser("idp1user2", "idp1user2@localhost");
        FederatedIdentityRepresentation link1_2 = new FederatedIdentityRepresentation();
        link1_2.setUserId("commonIdpUserId");
        link1_2.setUserName("idp1user2");
        this.addFederatedIdentity(idp1User2KeycloakId, "identity-provider-alias1", link1_2);
        String idp2UserUsername = "idp2user";
        String idp2UserKeycloakId = this.createUser("idp2user", "idp2user@localhost");
        FederatedIdentityRepresentation link2 = new FederatedIdentityRepresentation();
        link2.setUserId("commonIdpUserId");
        link2.setUserName("idp2user");
        this.addFederatedIdentity(idp2UserKeycloakId, "identity-provider-alias2", link2);
        List searchForAllUsers = this.realm.users().search(null, null, null, null, null, null, null, null, null, null, null);
        org.junit.Assert.assertEquals((long)4L, (long)searchForAllUsers.size());
        List searchByIdpAlias = this.realm.users().search(null, null, null, null, null, "identity-provider-alias1", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)2L, (long)searchByIdpAlias.size());
        org.junit.Assert.assertEquals((Object)"idp1user1", (Object)((UserRepresentation)searchByIdpAlias.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"idp1user2", (Object)((UserRepresentation)searchByIdpAlias.get(1)).getUsername());
        List searchByIdpUserId = this.realm.users().search(null, null, null, null, null, null, "commonIdpUserId", null, null, null, null);
        org.junit.Assert.assertEquals((long)2L, (long)searchByIdpUserId.size());
        org.junit.Assert.assertEquals((Object)"idp1user2", (Object)((UserRepresentation)searchByIdpUserId.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"idp2user", (Object)((UserRepresentation)searchByIdpUserId.get(1)).getUsername());
        List searchByIdpAliasAndUserId = this.realm.users().search(null, null, null, null, null, "identity-provider-alias1", "idp1user1Id", null, null, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)searchByIdpAliasAndUserId.size());
        org.junit.Assert.assertEquals((Object)"idp1user1", (Object)((UserRepresentation)searchByIdpAliasAndUserId.get(0)).getUsername());
    }

    private void addFederatedIdentity(String keycloakUserId, String identityProviderAlias1, FederatedIdentityRepresentation link) {
        Response response1 = this.realm.users().get(keycloakUserId).addFederatedIdentity(identityProviderAlias1, link);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userFederatedIdentityLink(keycloakUserId, identityProviderAlias1), (Object)link, ResourceType.USER);
        org.junit.Assert.assertEquals((long)204L, (long)response1.getStatus());
    }

    @Test
    public void searchByIdpAndEnabled() {
        String identityProviderAlias = "identity-provider-alias";
        this.addSampleIdentityProvider("identity-provider-alias", 0);
        UserRepresentation disabledUser = new UserRepresentation();
        String disabledUsername = "disabled_username";
        disabledUser.setUsername("disabled_username");
        disabledUser.setEmail("disabled@localhost");
        disabledUser.setEnabled(Boolean.valueOf(false));
        String disabledUserKeycloakId = this.createUser(disabledUser);
        FederatedIdentityRepresentation disabledUserLink = new FederatedIdentityRepresentation();
        String disabledUserId = "disabledUserId";
        disabledUserLink.setUserId("disabledUserId");
        disabledUserLink.setUserName("disabled_username");
        this.addFederatedIdentity(disabledUserKeycloakId, "identity-provider-alias", disabledUserLink);
        UserRepresentation enabledUser = new UserRepresentation();
        String enabledUsername = "enabled_username";
        enabledUser.setUsername("enabled_username");
        enabledUser.setEmail("enabled@localhost");
        enabledUser.setEnabled(Boolean.valueOf(true));
        String enabledUserKeycloakId = this.createUser(enabledUser);
        FederatedIdentityRepresentation enabledUserLink = new FederatedIdentityRepresentation();
        String enabledUserId = "enabledUserId";
        enabledUserLink.setUserId("enabledUserId");
        enabledUserLink.setUserName("enabled_username");
        this.addFederatedIdentity(enabledUserKeycloakId, "identity-provider-alias", enabledUserLink);
        List searchByIdpAliasAndEnabled = this.realm.users().search(null, null, null, null, null, "identity-provider-alias", null, null, null, Boolean.valueOf(true), null);
        org.junit.Assert.assertEquals((long)1L, (long)searchByIdpAliasAndEnabled.size());
        org.junit.Assert.assertEquals((Object)"enabled_username", (Object)((UserRepresentation)searchByIdpAliasAndEnabled.get(0)).getUsername());
        List searchByIdpAliasAndDisabled = this.realm.users().search(null, null, null, null, null, "identity-provider-alias", null, null, null, Boolean.valueOf(false), null);
        org.junit.Assert.assertEquals((long)1L, (long)searchByIdpAliasAndDisabled.size());
        org.junit.Assert.assertEquals((Object)"disabled_username", (Object)((UserRepresentation)searchByIdpAliasAndDisabled.get(0)).getUsername());
        List searchByIdpAliasWithoutEnabledFlag = this.realm.users().search(null, null, null, null, null, "identity-provider-alias", null, null, null, null, null);
        org.junit.Assert.assertEquals((long)2L, (long)searchByIdpAliasWithoutEnabledFlag.size());
        org.junit.Assert.assertEquals((Object)"disabled_username", (Object)((UserRepresentation)searchByIdpAliasWithoutEnabledFlag.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"enabled_username", (Object)((UserRepresentation)searchByIdpAliasWithoutEnabledFlag.get(1)).getUsername());
    }

    @Test
    public void searchById() {
        String expectedUserId = this.createUsers().get(0);
        List users = this.realm.users().search("id:" + expectedUserId, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        org.junit.Assert.assertEquals((Object)expectedUserId, (Object)((UserRepresentation)users.get(0)).getId());
        users = this.realm.users().search("id:   " + expectedUserId + "     ", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        org.junit.Assert.assertEquals((Object)expectedUserId, (Object)((UserRepresentation)users.get(0)).getId());
    }

    @Test
    public void search() {
        this.createUsers();
        List users = this.realm.users().search("username1", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("first1", null, null);
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        users = this.realm.users().search("last", null, null);
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void count() {
        this.createUsers();
        Integer count = this.realm.users().count();
        org.junit.Assert.assertEquals((long)9L, (long)count.intValue());
    }

    @Test
    public void countUsersNotServiceAccount() {
        this.createUsers();
        Integer count = this.realm.users().count();
        org.junit.Assert.assertEquals((long)9L, (long)count.intValue());
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-client");
        client.setPublicClient(Boolean.valueOf(false));
        client.setSecret("secret");
        client.setServiceAccountsEnabled(Boolean.valueOf(true));
        client.setEnabled(Boolean.valueOf(true));
        client.setRedirectUris(Arrays.asList("http://url"));
        this.getAdminClient().realm("admin-client-test").clients().create(client);
        org.junit.Assert.assertEquals((long)9L, (long)this.realm.users().count().intValue());
    }

    @Test
    public void delete() {
        String userId = this.createUser();
        Response response = this.realm.users().delete(userId);
        org.junit.Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userResourcePath(userId), ResourceType.USER);
    }

    @Test
    public void deleteNonExistent() {
        Response response = this.realm.users().delete("does-not-exist");
        org.junit.Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
        this.assertAdminEvents.assertEmpty();
    }

    @Test
    public void searchPaginated() {
        this.createUsers();
        List users = this.realm.users().search("username", Integer.valueOf(0), Integer.valueOf(1));
        org.junit.Assert.assertEquals((long)1L, (long)users.size());
        org.junit.Assert.assertEquals((Object)"username1", (Object)((UserRepresentation)users.get(0)).getUsername());
        users = this.realm.users().search("username", Integer.valueOf(5), Integer.valueOf(2));
        org.junit.Assert.assertEquals((long)2L, (long)users.size());
        org.junit.Assert.assertEquals((Object)"username6", (Object)((UserRepresentation)users.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"username7", (Object)((UserRepresentation)users.get(1)).getUsername());
        users = this.realm.users().search("username", Integer.valueOf(7), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)2L, (long)users.size());
        org.junit.Assert.assertEquals((Object)"username8", (Object)((UserRepresentation)users.get(0)).getUsername());
        org.junit.Assert.assertEquals((Object)"username9", (Object)((UserRepresentation)users.get(1)).getUsername());
        users = this.realm.users().search("username", Integer.valueOf(0), Integer.valueOf(20));
        org.junit.Assert.assertEquals((long)9L, (long)users.size());
    }

    @Test
    public void getFederatedIdentities() {
        this.addSampleIdentityProvider();
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        org.junit.Assert.assertEquals((long)0L, (long)user.getFederatedIdentity().size());
        FederatedIdentityRepresentation link = new FederatedIdentityRepresentation();
        link.setUserId("social-user-id");
        link.setUserName("social-username");
        this.addFederatedIdentity(id, "social-provider-id", link);
        user = this.realm.users().get(id);
        List federatedIdentities = user.getFederatedIdentity();
        org.junit.Assert.assertEquals((long)1L, (long)federatedIdentities.size());
        link = (FederatedIdentityRepresentation)federatedIdentities.get(0);
        org.junit.Assert.assertEquals((Object)"social-provider-id", (Object)link.getIdentityProvider());
        org.junit.Assert.assertEquals((Object)"social-user-id", (Object)link.getUserId());
        org.junit.Assert.assertEquals((Object)"social-username", (Object)link.getUserName());
        user.removeFederatedIdentity("social-provider-id");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.userFederatedIdentityLink(id, "social-provider-id"), ResourceType.USER);
        org.junit.Assert.assertEquals((long)0L, (long)user.getFederatedIdentity().size());
        this.removeSampleIdentityProvider();
    }

    private void addSampleIdentityProvider() {
        this.addSampleIdentityProvider("social-provider-id", 0);
    }

    private void addSampleIdentityProvider(String alias, int expectedInitialIdpCount) {
        List providers = this.realm.identityProviders().findAll();
        org.junit.Assert.assertEquals((long)expectedInitialIdpCount, (long)providers.size());
        IdentityProviderRepresentation rep = new IdentityProviderRepresentation();
        rep.setAlias(alias);
        rep.setProviderId("oidc");
        this.realm.identityProviders().create(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.identityProviderPath(rep.getAlias()), (Object)rep, ResourceType.IDENTITY_PROVIDER);
    }

    private void removeSampleIdentityProvider() {
        IdentityProviderResource resource = this.realm.identityProviders().get("social-provider-id");
        org.junit.Assert.assertNotNull((Object)resource);
        resource.remove();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.identityProviderPath("social-provider-id"), ResourceType.IDENTITY_PROVIDER);
    }

    @Test
    public void addRequiredAction() {
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        org.junit.Assert.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
        UserRepresentation userRep = user.toRepresentation();
        userRep.getRequiredActions().add("UPDATE_PASSWORD");
        this.updateUser(user, userRep);
        org.junit.Assert.assertEquals((long)1L, (long)user.toRepresentation().getRequiredActions().size());
        org.junit.Assert.assertEquals((Object)"UPDATE_PASSWORD", user.toRepresentation().getRequiredActions().get(0));
    }

    @Test
    public void removeRequiredAction() {
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        org.junit.Assert.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
        UserRepresentation userRep = user.toRepresentation();
        userRep.getRequiredActions().add("UPDATE_PASSWORD");
        this.updateUser(user, userRep);
        user = this.realm.users().get(id);
        userRep = user.toRepresentation();
        userRep.getRequiredActions().clear();
        this.updateUser(user, userRep);
        org.junit.Assert.assertTrue((boolean)user.toRepresentation().getRequiredActions().isEmpty());
    }

    @Test
    public void attributes() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "value1user1");
        user1.singleAttribute("attr2", "value2user1");
        String user1Id = this.createUser(user1);
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername("user2");
        user2.singleAttribute("attr1", "value1user2");
        List vals = new ArrayList<String>();
        vals.add("value2user2");
        vals.add("value2user2_2");
        user2.getAttributes().put("attr2", vals);
        String user2Id = this.createUser(user2);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((long)2L, (long)user1.getAttributes().size());
        this.assertAttributeValue("value1user1", (List)user1.getAttributes().get("attr1"));
        this.assertAttributeValue("value2user1", (List)user1.getAttributes().get("attr2"));
        user2 = this.realm.users().get(user2Id).toRepresentation();
        org.junit.Assert.assertEquals((long)2L, (long)user2.getAttributes().size());
        this.assertAttributeValue("value1user2", (List)user2.getAttributes().get("attr1"));
        vals = (List)user2.getAttributes().get("attr2");
        org.junit.Assert.assertEquals((long)2L, (long)vals.size());
        org.junit.Assert.assertTrue((vals.contains("value2user2") && vals.contains("value2user2_2") ? 1 : 0) != 0);
        user1.singleAttribute("attr1", "value3user1");
        user1.singleAttribute("attr3", "value4user1");
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((long)3L, (long)user1.getAttributes().size());
        this.assertAttributeValue("value3user1", (List)user1.getAttributes().get("attr1"));
        this.assertAttributeValue("value2user1", (List)user1.getAttributes().get("attr2"));
        this.assertAttributeValue("value4user1", (List)user1.getAttributes().get("attr3"));
        user1.getAttributes().remove("attr1");
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((long)2L, (long)user1.getAttributes().size());
        this.assertAttributeValue("value2user1", (List)user1.getAttributes().get("attr2"));
        this.assertAttributeValue("value4user1", (List)user1.getAttributes().get("attr3"));
        user1.setAttributes(null);
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertNotNull((Object)user1.getAttributes());
        org.junit.Assert.assertEquals((long)2L, (long)user1.getAttributes().size());
        user1.setAttributes(Collections.emptyMap());
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertNull((Object)user1.getAttributes());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void updateUserWithReadOnlyAttributes() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("usercertificate", "foo1");
        String user1Id = this.createUser(user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        try {
            user1.singleAttribute("usercertificate", "foo");
            user1.singleAttribute("saml.persistent.name.id.for.foo", "bar");
            user1.singleAttribute("LDAP_ID", "baz");
            this.updateUser(this.realm.users().get(user1Id), user1);
            org.junit.Assert.fail((String)"Not supposed to successfully update user");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        try {
            user1.getAttributes().remove("LDAP_ID");
            user1.singleAttribute("LDap_Id", "baz");
            this.updateUser(this.realm.users().get(user1Id), user1);
            org.junit.Assert.fail((String)"Not supposed to successfully update user");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        try {
            user1.getAttributes().remove("LDap_Id");
            user1.singleAttribute("deniedSomeAdmin", "baz");
            this.updateUser(this.realm.users().get(user1Id), user1);
            org.junit.Assert.fail((String)"Not supposed to successfully update user");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        user1.getAttributes().remove("deniedSomeAdmin");
        this.updateUser(this.realm.users().get(user1Id), user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"foo", ((List)user1.getAttributes().get("usercertificate")).get(0));
        org.junit.Assert.assertEquals((Object)"bar", ((List)user1.getAttributes().get("saml.persistent.name.id.for.foo")).get(0));
        org.junit.Assert.assertFalse((boolean)user1.getAttributes().containsKey("LDAP_ID"));
    }

    @Test
    public void testImportUserWithNullAttribute() {
        RealmRepresentation rep = UserTest.loadJson(this.getClass().getResourceAsStream("/import/testrealm-user-null-attr.json"), RealmRepresentation.class);
        try (Creator c = Creator.create((Keycloak)this.adminClient, (RealmRepresentation)rep);){
            List users = ((RealmResource)c.resource()).users().list();
            MatcherAssert.assertThat((Object)users, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((UserRepresentation)users.get(0)).getAttributes().size(), (Matcher)Matchers.equalTo((Object)2));
        }
    }

    private void assertAttributeValue(String expectedValue, List<String> attrValues) {
        org.junit.Assert.assertEquals((long)1L, (long)attrValues.size());
        org.junit.Assert.assertEquals((Object)expectedValue, (Object)attrValues.get(0));
    }

    @Test
    public void sendResetPasswordEmail() {
        ErrorRepresentation error;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user1");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList actions = new LinkedList();
        try {
            user.executeActionsEmail(actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User email missing", (Object)error.getErrorMessage());
        }
        try {
            userRep = user.toRepresentation();
            userRep.setEmail("user1@localhost");
            userRep.setEnabled(Boolean.valueOf(false));
            this.updateUser(user, userRep);
            user.executeActionsEmail(actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User is disabled", (Object)error.getErrorMessage());
        }
        try {
            userRep.setEnabled(Boolean.valueOf(true));
            this.updateUser(user, userRep);
            user.executeActionsEmail("invalidClientId", "invalidUri", actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"Client doesn't exist", (Object)error.getErrorMessage());
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailSuccess() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        org.junit.Assert.assertTrue((boolean)body.getText().contains("Update Password"));
        org.junit.Assert.assertTrue((boolean)body.getText().contains("your Admin-client-test account"));
        org.junit.Assert.assertTrue((boolean)body.getText().contains("This link will expire within 12 hours"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("Update Password"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("your Admin-client-test account"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("This link will expire within 12 hours"));
        String link = MailUtils.getPasswordResetEmailLink((MailUtils.EmailBody)body);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.driver.navigate().to(link);
        org.junit.Assert.assertEquals((Object)"We are sorry...", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailWithCustomLifespan() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        int lifespan = (int)TimeUnit.HOURS.toSeconds(5L);
        user.executeActionsEmail(actions, Integer.valueOf(lifespan));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        org.junit.Assert.assertTrue((boolean)body.getText().contains("Update Password"));
        org.junit.Assert.assertTrue((boolean)body.getText().contains("your Admin-client-test account"));
        org.junit.Assert.assertTrue((boolean)body.getText().contains("This link will expire within 5 hours"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("Update Password"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("your Admin-client-test account"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("This link will expire within 5 hours"));
        String link = MailUtils.getPasswordResetEmailLink((MailUtils.EmailBody)body);
        String token = link.substring(link.indexOf("key=") + "key=".length());
        try {
            AccessToken accessToken = (AccessToken)TokenVerifier.create((String)token, AccessToken.class).getToken();
            org.junit.Assert.assertEquals((long)lifespan, (long)(accessToken.getExpiration() - accessToken.getIssuedAt()));
        }
        catch (VerificationException e) {
            throw new IOException(e);
        }
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.driver.navigate().to(link);
        org.junit.Assert.assertEquals((Object)"We are sorry...", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailSuccessTwoLinks() throws IOException {
        String link;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        user.executeActionsEmail(actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        int i = 1;
        for (MimeMessage message : this.greenMail.getReceivedMessages()) {
            link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.proceedPage.assertCurrent();
            org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
            this.proceedPage.clickProceedLink();
            this.passwordUpdatePage.assertCurrent();
            this.passwordUpdatePage.changePassword("new-pass" + i, "new-pass" + i);
            ++i;
            org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        }
        for (MimeMessage message : this.greenMail.getReceivedMessages()) {
            link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailSuccessTwoLinksReverse() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        user.executeActionsEmail(actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        int i = 1;
        for (int j = this.greenMail.getReceivedMessages().length - 1; j >= 0; --j) {
            MimeMessage message = this.greenMail.getReceivedMessages()[j];
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.proceedPage.assertCurrent();
            org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
            this.proceedPage.clickProceedLink();
            this.passwordUpdatePage.assertCurrent();
            this.passwordUpdatePage.changePassword("new-pass" + i, "new-pass" + i);
            ++i;
            org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        }
        for (MimeMessage message : this.greenMail.getReceivedMessages()) {
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailSuccessLinkOpenDoesNotExpireWhenOpenedOnly() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        user.executeActionsEmail(actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.driver.manage().deleteAllCookies();
        this.driver.navigate().to("about:blank");
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailSuccessTokenShortLifespan() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        AtomicInteger originalValue = new AtomicInteger();
        RealmRepresentation realmRep = this.realm.toRepresentation();
        originalValue.set(realmRep.getActionTokenGeneratedByAdminLifespan());
        realmRep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(60));
        this.realm.update(realmRep);
        try {
            UserResource user = this.realm.users().get(id);
            LinkedList<String> actions = new LinkedList<String>();
            actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
            user.executeActionsEmail(actions);
            org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getReceivedMessages()[0];
            String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
            this.setTimeOffset(70);
            this.driver.navigate().to(link);
            this.errorPage.assertCurrent();
            org.junit.Assert.assertEquals((Object)"Action expired.", (Object)this.errorPage.getError());
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setActionTokenGeneratedByAdminLifespan(Integer.valueOf(originalValue.get()));
            this.realm.update(realmRep);
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailSuccessWithRecycledAuthSession() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("myclient2");
        client.setRedirectUris(new LinkedList());
        client.getRedirectUris().add("http://myclient.com/*");
        client.setName("myclient2");
        client.setEnabled(Boolean.valueOf(true));
        Response response = this.realm.clients().create(client);
        String createdId = ApiUtil.getCreatedId((Response)response);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(createdId), (Object)client, ResourceType.CLIENT);
        user.executeActionsEmail("myclient2", "http://myclient.com/home.html", actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        user.executeActionsEmail(actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message2 = this.greenMail.getReceivedMessages()[this.greenMail.getReceivedMessages().length - 1];
        String link2 = MailUtils.getPasswordResetEmailLink((MimeMessage)message2);
        this.driver.navigate().to(link2);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.driver.navigate().to(link2);
        org.junit.Assert.assertEquals((Object)"We are sorry...", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailWithRedirect() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("myclient");
        client.setRedirectUris(new LinkedList());
        client.getRedirectUris().add("http://myclient.com/*");
        client.setName("myclient");
        client.setEnabled(Boolean.valueOf(true));
        Response response = this.realm.clients().create(client);
        String createdId = ApiUtil.getCreatedId((Response)response);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(createdId), (Object)client, ResourceType.CLIENT);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        try {
            user.executeActionsEmail("myclient", "http://unregistered-uri.com/", actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"Invalid redirect uri.", (Object)error.getErrorMessage());
        }
        user.executeActionsEmail("myclient", "http://myclient.com/home.html", actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)this.driver.findElement(By.id((String)"kc-page-title")).getText());
        String pageSource = this.driver.getPageSource();
        org.junit.Assert.assertTrue((boolean)pageSource.contains("http://myclient.com/home.html"));
        this.driver.navigate().to(link);
        org.junit.Assert.assertEquals((Object)"We are sorry...", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendResetPasswordEmailWithRedirectAndCustomLifespan() throws IOException {
        UserRepresentation userRep = new UserRepresentation();
        userRep.setEnabled(Boolean.valueOf(true));
        userRep.setUsername("user1");
        userRep.setEmail("user1@test.com");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("myclient");
        client.setRedirectUris(new LinkedList());
        client.getRedirectUris().add("http://myclient.com/*");
        client.setName("myclient");
        client.setEnabled(Boolean.valueOf(true));
        Response response = this.realm.clients().create(client);
        String createdId = ApiUtil.getCreatedId((Response)response);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(createdId), (Object)client, ResourceType.CLIENT);
        LinkedList<String> actions = new LinkedList<String>();
        actions.add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        int lifespan = (int)TimeUnit.DAYS.toSeconds(128L);
        try {
            user.executeActionsEmail("myclient", "http://unregistered-uri.com/", Integer.valueOf(lifespan), actions);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            ErrorRepresentation error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"Invalid redirect uri.", (Object)error.getErrorMessage());
        }
        user.executeActionsEmail("myclient", "http://myclient.com/home.html", Integer.valueOf(lifespan), actions);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/execute-actions-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        MailUtils.EmailBody body = MailUtils.getBody((MimeMessage)message);
        org.junit.Assert.assertTrue((boolean)body.getText().contains("This link will expire within 128 days"));
        org.junit.Assert.assertTrue((boolean)body.getHtml().contains("This link will expire within 128 days"));
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)message);
        String token = link.substring(link.indexOf("key=") + "key=".length());
        try {
            AccessToken accessToken = (AccessToken)TokenVerifier.create((String)token, AccessToken.class).getToken();
            org.junit.Assert.assertEquals((long)lifespan, (long)(accessToken.getExpiration() - accessToken.getIssuedAt()));
        }
        catch (VerificationException e) {
            throw new IOException(e);
        }
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Update Password"));
        this.proceedPage.clickProceedLink();
        this.passwordUpdatePage.assertCurrent();
        this.passwordUpdatePage.changePassword("new-pass", "new-pass");
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)this.driver.findElement(By.id((String)"kc-page-title")).getText());
        String pageSource = this.driver.getPageSource();
        org.junit.Assert.assertTrue((boolean)pageSource.contains("http://myclient.com/home.html"));
        this.driver.navigate().to(link);
        org.junit.Assert.assertEquals((Object)"We are sorry...", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void sendVerifyEmail() throws IOException {
        ErrorRepresentation error;
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user1");
        String id = this.createUser(userRep);
        UserResource user = this.realm.users().get(id);
        try {
            user.sendVerifyEmail();
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User email missing", (Object)error.getErrorMessage());
        }
        try {
            userRep = user.toRepresentation();
            userRep.setEmail("user1@localhost");
            userRep.setEnabled(Boolean.valueOf(false));
            this.updateUser(user, userRep);
            user.sendVerifyEmail();
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"User is disabled", (Object)error.getErrorMessage());
        }
        try {
            userRep.setEnabled(Boolean.valueOf(true));
            this.updateUser(user, userRep);
            user.sendVerifyEmail("invalidClientId");
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            error = (ErrorRepresentation)e.getResponse().readEntity(ErrorRepresentation.class);
            org.junit.Assert.assertEquals((Object)"Client doesn't exist", (Object)error.getErrorMessage());
        }
        user.sendVerifyEmail();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResourcePath(id) + "/send-verify-email", ResourceType.USER);
        org.junit.Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        String link = MailUtils.getPasswordResetEmailLink((MimeMessage)this.greenMail.getReceivedMessages()[0]);
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Verify Email"));
        this.proceedPage.clickProceedLink();
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
        this.driver.navigate().to("about:blank");
        this.driver.navigate().to(link);
        this.proceedPage.assertCurrent();
        org.junit.Assert.assertThat((Object)this.proceedPage.getInfo(), (Matcher)Matchers.containsString((String)"Verify Email"));
        this.proceedPage.clickProceedLink();
        org.junit.Assert.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
    }

    @Test
    public void updateUserWithNewUsername() {
        this.switchEditUsernameAllowedOn(true);
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setUsername("user11");
        this.updateUser(user, userRep);
        userRep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user11", (Object)userRep.getUsername());
        this.switchEditUsernameAllowedOn(false);
    }

    @Test
    public void updateUserWithoutUsername() {
        this.switchEditUsernameAllowedOn(true);
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation rep = new UserRepresentation();
        rep.setFirstName("Firstname");
        user.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userResourcePath(id), (Object)rep, ResourceType.USER);
        rep = new UserRepresentation();
        rep.setLastName("Lastname");
        user.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.userResourcePath(id), (Object)rep, ResourceType.USER);
        rep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user1", (Object)rep.getUsername());
        org.junit.Assert.assertEquals((Object)"user1@localhost", (Object)rep.getEmail());
        org.junit.Assert.assertEquals((Object)"Firstname", (Object)rep.getFirstName());
        org.junit.Assert.assertEquals((Object)"Lastname", (Object)rep.getLastName());
        this.switchEditUsernameAllowedOn(false);
    }

    @Test
    public void updateUserWithEmailAsUsername() {
        this.switchRegistrationEmailAsUsername(true);
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        org.junit.Assert.assertEquals((Object)"user1@localhost", (Object)userRep.getUsername());
        userRep.setEmail("user11@localhost");
        this.updateUser(user, userRep);
        userRep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user11@localhost", (Object)userRep.getUsername());
        this.switchRegistrationEmailAsUsername(false);
    }

    @Test
    public void updateUserWithNewUsernameNotPossible() {
        String id = this.createUser();
        UserResource user = this.realm.users().get(id);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setUsername("user11");
        this.updateUser(user, userRep);
        userRep = this.realm.users().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)"user1", (Object)userRep.getUsername());
    }

    @Test
    public void updateUserWithNewUsernameAccessingViaOldUsername() {
        this.switchEditUsernameAllowedOn(true);
        this.createUser();
        try {
            UserResource user = this.realm.users().get("user1");
            UserRepresentation userRep = user.toRepresentation();
            userRep.setUsername("user1");
            this.updateUser(user, userRep);
            this.realm.users().get("user11").toRepresentation();
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)404L, (long)e.getResponse().getStatus());
        }
        finally {
            this.switchEditUsernameAllowedOn(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateUserWithExistingUsername() {
        this.switchEditUsernameAllowedOn(true);
        this.enableBruteForce(true);
        this.createUser();
        UserRepresentation userRep = new UserRepresentation();
        userRep.setUsername("user2");
        String createdId = this.createUser(userRep);
        try {
            UserResource user = this.realm.users().get(createdId);
            userRep = user.toRepresentation();
            userRep.setUsername("user1");
            user.update(userRep);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)409L, (long)e.getResponse().getStatus());
            this.assertAdminEvents.assertEmpty();
        }
        finally {
            this.enableBruteForce(false);
            this.switchEditUsernameAllowedOn(false);
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void updateUserWithRawCredentials() {
        UserRepresentation user = new UserRepresentation();
        user.setUsername("user_rawpw");
        user.setEmail("email.raw@localhost");
        CredentialRepresentation rawPassword = new CredentialRepresentation();
        rawPassword.setValue("ABCD");
        rawPassword.setType("password");
        user.setCredentials(Arrays.asList(rawPassword));
        String id = this.createUser(user);
        PasswordCredentialModel credential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials("user_rawpw"));
        org.junit.Assert.assertNotNull((String)"Expecting credential", (Object)credential);
        org.junit.Assert.assertEquals((Object)"pbkdf2-sha256", (Object)credential.getPasswordCredentialData().getAlgorithm());
        org.junit.Assert.assertEquals((long)27500L, (long)credential.getPasswordCredentialData().getHashIterations());
        org.junit.Assert.assertNotEquals((Object)"ABCD", (Object)credential.getPasswordSecretData().getValue());
        org.junit.Assert.assertEquals((Object)"password", (Object)credential.getType());
        UserResource userResource = this.realm.users().get(id);
        UserRepresentation userRep = userResource.toRepresentation();
        CredentialRepresentation rawPasswordForUpdate = new CredentialRepresentation();
        rawPasswordForUpdate.setValue("EFGH");
        rawPasswordForUpdate.setType("password");
        userRep.setCredentials(Arrays.asList(rawPasswordForUpdate));
        this.updateUser(userResource, userRep);
        PasswordCredentialModel updatedCredential = PasswordCredentialModel.createFromCredentialModel((CredentialModel)this.fetchCredentials("user_rawpw"));
        org.junit.Assert.assertNotNull((String)"Expecting credential", (Object)updatedCredential);
        org.junit.Assert.assertEquals((Object)"pbkdf2-sha256", (Object)updatedCredential.getPasswordCredentialData().getAlgorithm());
        org.junit.Assert.assertEquals((long)27500L, (long)updatedCredential.getPasswordCredentialData().getHashIterations());
        org.junit.Assert.assertNotEquals((Object)"EFGH", (Object)updatedCredential.getPasswordSecretData().getValue());
        org.junit.Assert.assertEquals((Object)"password", (Object)updatedCredential.getType());
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void resetUserPassword() {
        String userId = this.createUser("user1", "user1@localhost");
        CredentialRepresentation cred = new CredentialRepresentation();
        cred.setType("password");
        cred.setValue("password");
        cred.setTemporary(Boolean.valueOf(false));
        this.realm.users().get(userId).resetPassword(cred);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.userResetPasswordPath(userId), ResourceType.USER);
        String accountUrl = RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"admin-client-test"}).toString();
        this.driver.navigate().to(accountUrl);
        org.junit.Assert.assertEquals((Object)"Sign in to your account", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.loginPage.login("user1", "password");
        org.junit.Assert.assertTrue((boolean)this.driver.getTitle().contains("Account Management"));
    }

    @Test
    public void resetUserInvalidPassword() {
        String userId = this.createUser("user1", "user1@localhost");
        try {
            CredentialRepresentation cred = new CredentialRepresentation();
            cred.setType("password");
            cred.setValue(" ");
            cred.setTemporary(Boolean.valueOf(false));
            this.realm.users().get(userId).resetPassword(cred);
            org.junit.Assert.fail((String)"Expected failure");
        }
        catch (ClientErrorException e) {
            org.junit.Assert.assertEquals((long)400L, (long)e.getResponse().getStatus());
            e.getResponse().close();
            this.assertAdminEvents.assertEmpty();
        }
    }

    @Test
    public void testDefaultRequiredActionAdded() {
        RequiredActionProviderRepresentation updatePasswordReqAction = this.realm.flows().getRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        updatePasswordReqAction.setDefaultAction(true);
        this.realm.flows().updateRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString(), updatePasswordReqAction);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authRequiredActionPath(UserModel.RequiredAction.UPDATE_PASSWORD.toString()), (Object)updatePasswordReqAction, ResourceType.REQUIRED_ACTION);
        String userId = this.createUser("user1", "user1@localhost");
        UserRepresentation userRep = this.realm.users().get(userId).toRepresentation();
        org.junit.Assert.assertEquals((long)1L, (long)userRep.getRequiredActions().size());
        org.junit.Assert.assertEquals((Object)UserModel.RequiredAction.UPDATE_PASSWORD.toString(), userRep.getRequiredActions().get(0));
        updatePasswordReqAction = this.realm.flows().getRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
        updatePasswordReqAction.setDefaultAction(false);
        this.realm.flows().updateRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD.toString(), updatePasswordReqAction);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authRequiredActionPath(UserModel.RequiredAction.UPDATE_PASSWORD.toString()), (Object)updatePasswordReqAction, ResourceType.REQUIRED_ACTION);
    }

    private RoleRepresentation getRoleByName(String name, List<RoleRepresentation> roles) {
        for (RoleRepresentation role : roles) {
            if (!role.getName().equalsIgnoreCase(name)) continue;
            return role;
        }
        return null;
    }

    @Test
    public void roleMappings() {
        RealmResource realm = this.adminClient.realms().realm("test");
        RealmRepresentation realmRep = RealmBuilder.edit(realm.toRepresentation()).testEventListener().build();
        realm.update(realmRep);
        RoleRepresentation realmCompositeRole = RoleBuilder.create().name("realm-composite").singleAttribute("attribute1", "value1").build();
        realm.roles().create(RoleBuilder.create().name("realm-role").build());
        realm.roles().create(realmCompositeRole);
        realm.roles().create(RoleBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        Response response = realm.clients().create(ClientBuilder.create().clientId("myclient").build());
        String clientUuid = ApiUtil.getCreatedId((Response)response);
        response.close();
        RoleRepresentation clientCompositeRole = RoleBuilder.create().name("client-composite").singleAttribute("attribute1", "value1").build();
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-role").build());
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-role2").build());
        realm.clients().get(clientUuid).roles().create(clientCompositeRole);
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-child").build());
        realm.clients().get(clientUuid).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        response = realm.users().create(UserBuilder.create().username("myuser").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.assertAdminEvents.clear();
        RoleMappingResource roles = realm.users().get(userId).roles();
        Assert.assertNames(roles.realmLevel().listAll(), "default-roles-test");
        Assert.assertNames(roles.realmLevel().listEffective(), "user", "offline_access", "uma_authorization", "default-roles-test");
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(realm.roles().get("realm-role").toRepresentation());
        l.add(realm.roles().get("realm-composite").toRepresentation());
        roles.realmLevel().add(l);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userRealmRoleMappingsPath(userId), l, ResourceType.REALM_ROLE_MAPPING);
        List<RoleRepresentation> list = Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role").toRepresentation());
        roles.clientLevel(clientUuid).add(list);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userClientRoleMappingsPath(userId, clientUuid), list, ResourceType.CLIENT_ROLE_MAPPING);
        list = Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-composite").toRepresentation());
        roles.clientLevel(clientUuid).add(list);
        this.assertAdminEvents.assertEvent("test", OperationType.CREATE, AdminEventPaths.userClientRoleMappingsPath(userId, clientUuid), ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames(roles.realmLevel().listAll(), "realm-role", "realm-composite", "default-roles-test");
        Assert.assertNames(roles.realmLevel().listAvailable(), "realm-child", "admin", "customer-user-premium", "realm-composite-role", "sample-realm-role", "attribute-role", "user", "offline_access", "uma_authorization");
        Assert.assertNames(roles.realmLevel().listEffective(), "realm-role", "realm-composite", "realm-child", "user", "offline_access", "uma_authorization", "default-roles-test");
        List realmRolesFullRepresentations = roles.realmLevel().listEffective(false);
        RoleRepresentation realmCompositeRoleFromList = this.getRoleByName("realm-composite", realmRolesFullRepresentations);
        org.junit.Assert.assertNotNull((Object)realmCompositeRoleFromList);
        org.junit.Assert.assertTrue((boolean)realmCompositeRoleFromList.getAttributes().containsKey("attribute1"));
        Assert.assertNames(roles.clientLevel(clientUuid).listAll(), "client-role", "client-composite");
        Assert.assertNames(roles.clientLevel(clientUuid).listAvailable(), "client-role2", "client-child");
        Assert.assertNames(roles.clientLevel(clientUuid).listEffective(), "client-role", "client-composite", "client-child");
        List rolesFullRepresentations = roles.clientLevel(clientUuid).listEffective(false);
        RoleRepresentation clientCompositeRoleFromList = this.getRoleByName("client-composite", rolesFullRepresentations);
        org.junit.Assert.assertNotNull((Object)clientCompositeRoleFromList);
        org.junit.Assert.assertTrue((boolean)clientCompositeRoleFromList.getAttributes().containsKey("attribute1"));
        MappingsRepresentation all = roles.getAll();
        Assert.assertNames(all.getRealmMappings(), "realm-role", "realm-composite", "default-roles-test");
        org.junit.Assert.assertEquals((long)1L, (long)all.getClientMappings().size());
        Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), "client-role", "client-composite");
        RoleRepresentation realmRoleRep = realm.roles().get("realm-role").toRepresentation();
        roles.realmLevel().remove(Collections.singletonList(realmRoleRep));
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.userRealmRoleMappingsPath(userId), Collections.singletonList(realmRoleRep), ResourceType.REALM_ROLE_MAPPING);
        Assert.assertNames(roles.realmLevel().listAll(), "realm-composite", "default-roles-test");
        RoleRepresentation clientRoleRep = realm.clients().get(clientUuid).roles().get("client-role").toRepresentation();
        roles.clientLevel(clientUuid).remove(Collections.singletonList(clientRoleRep));
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.userClientRoleMappingsPath(userId, clientUuid), Collections.singletonList(clientRoleRep), ResourceType.CLIENT_ROLE_MAPPING);
        Assert.assertNames(roles.clientLevel(clientUuid).listAll(), "client-composite");
    }

    @Test
    public void rolesCanBeAssignedEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        RealmResource realm = this.adminClient.realms().realm("test");
        RoleRepresentation realmCompositeRole = RoleBuilder.create().name("realm-composite").build();
        realm.roles().create(realmCompositeRole);
        realm.roles().create(RoleBuilder.create().name("realm-child").build());
        realm.roles().get("realm-composite").addComposites(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        realm.roles().create(RoleBuilder.create().name("realm-role-in-group").build());
        Response response = realm.clients().create(ClientBuilder.create().clientId("myclient").build());
        String clientUuid = ApiUtil.getCreatedId((Response)response);
        response.close();
        RoleRepresentation clientCompositeRole = RoleBuilder.create().name("client-composite").build();
        realm.clients().get(clientUuid).roles().create(clientCompositeRole);
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-child").build());
        realm.clients().get(clientUuid).roles().get("client-composite").addComposites(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        realm.clients().get(clientUuid).roles().create(RoleBuilder.create().name("client-role-in-group").build());
        GroupRepresentation group = GroupBuilder.create().name("mygroup").build();
        response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        response.close();
        response = realm.users().create(UserBuilder.create().username("myuser").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        realm.groups().group(groupId).roles().realmLevel().add(Collections.singletonList(realm.roles().get("realm-role-in-group").toRepresentation()));
        realm.groups().group(groupId).roles().clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role-in-group").toRepresentation()));
        realm.users().get(userId).joinGroup(groupId);
        RoleMappingResource userRoles = realm.users().get(userId).roles();
        userRoles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-composite").toRepresentation()));
        userRoles.clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-composite").toRepresentation()));
        Assert.assertNames(userRoles.realmLevel().listAll(), "realm-composite", "default-roles-test");
        Assert.assertNames(userRoles.realmLevel().listAvailable(), "realm-child", "realm-role-in-group", "admin", "customer-user-premium", "realm-composite-role", "sample-realm-role", "attribute-role", "user", "offline_access", "uma_authorization");
        Assert.assertNames(userRoles.realmLevel().listEffective(), "realm-composite", "realm-child", "realm-role-in-group", "user", "offline_access", "uma_authorization", "default-roles-test");
        Assert.assertNames(userRoles.clientLevel(clientUuid).listAll(), "client-composite");
        Assert.assertNames(userRoles.clientLevel(clientUuid).listAvailable(), "client-child", "client-role-in-group");
        Assert.assertNames(userRoles.clientLevel(clientUuid).listEffective(), "client-composite", "client-child", "client-role-in-group");
        userRoles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-child").toRepresentation()));
        userRoles.realmLevel().add(Collections.singletonList(realm.roles().get("realm-role-in-group").toRepresentation()));
        userRoles.clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-child").toRepresentation()));
        userRoles.clientLevel(clientUuid).add(Collections.singletonList(realm.clients().get(clientUuid).roles().get("client-role-in-group").toRepresentation()));
        Assert.assertNames(userRoles.realmLevel().listAll(), "realm-composite", "realm-child", "realm-role-in-group", "default-roles-test");
        Assert.assertNames(userRoles.realmLevel().listAvailable(), "admin", "customer-user-premium", "realm-composite-role", "sample-realm-role", "attribute-role", "user", "offline_access", "uma_authorization");
        Assert.assertNames(userRoles.realmLevel().listEffective(), "realm-composite", "realm-child", "realm-role-in-group", "user", "offline_access", "uma_authorization", "default-roles-test");
        Assert.assertNames(userRoles.clientLevel(clientUuid).listAll(), "client-composite", "client-child", "client-role-in-group");
        Assert.assertNames(userRoles.clientLevel(clientUuid).listAvailable(), new String[0]);
        Assert.assertNames(userRoles.clientLevel(clientUuid).listEffective(), "client-composite", "client-child", "client-role-in-group");
        MappingsRepresentation all = userRoles.getAll();
        Assert.assertNames(all.getRealmMappings(), "realm-composite", "realm-child", "realm-role-in-group", "default-roles-test");
        org.junit.Assert.assertEquals((long)1L, (long)all.getClientMappings().size());
        Assert.assertNames(((ClientMappingsRepresentation)all.getClientMappings().get("myclient")).getMappings(), "client-composite", "client-child", "client-role-in-group");
    }

    @Test
    public void defaultMaxResults() {
        UsersResource users = this.adminClient.realms().realm("test").users();
        for (int i = 0; i < 110; ++i) {
            users.create(UserBuilder.create().username("test-" + i).addAttribute("aName", "aValue").build()).close();
        }
        List result = users.search("test", null, null);
        org.junit.Assert.assertEquals((long)100L, (long)result.size());
        for (UserRepresentation user : result) {
            MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat(user.getAttributes().keySet(), (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"aName"), (Matcher)Matchers.contains((Object[])new String[]{"aValue"})));
        }
        org.junit.Assert.assertEquals((long)105L, (long)users.search("test", Integer.valueOf(0), Integer.valueOf(105)).size());
        org.junit.Assert.assertEquals((long)111L, (long)users.search("test", Integer.valueOf(0), Integer.valueOf(1000)).size());
    }

    @Test
    public void defaultMaxResultsBrief() {
        UsersResource users = this.adminClient.realms().realm("test").users();
        for (int i = 0; i < 110; ++i) {
            users.create(UserBuilder.create().username("test-" + i).addAttribute("aName", "aValue").build()).close();
        }
        List result = users.search("test", null, null, Boolean.valueOf(true));
        org.junit.Assert.assertEquals((long)100L, (long)result.size());
        for (UserRepresentation user : result) {
            MatcherAssert.assertThat((Object)user.getAttributes(), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testAccessUserFromOtherRealm() {
        RealmRepresentation firstRealm = new RealmRepresentation();
        firstRealm.setRealm("first-realm");
        this.adminClient.realms().create(firstRealm);
        this.realm = this.adminClient.realm(firstRealm.getRealm());
        this.realmId = this.realm.toRepresentation().getId();
        UserRepresentation firstUser = new UserRepresentation();
        firstUser.setUsername("first");
        firstUser.setEmail("first@first-realm.org");
        firstUser.setId(this.createUser(firstUser, false));
        RealmRepresentation secondRealm = new RealmRepresentation();
        secondRealm.setRealm("second-realm");
        this.adminClient.realms().create(secondRealm);
        this.adminClient.realm(firstRealm.getRealm()).users().get(firstUser.getId()).update(firstUser);
        try {
            this.adminClient.realm(secondRealm.getRealm()).users().get(firstUser.getId()).toRepresentation();
            org.junit.Assert.fail((String)"Should not have access to firstUser from another realm");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void switchEditUsernameAllowedOn(boolean enable) {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setEditUsernameAllowed(Boolean.valueOf(enable));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
    }

    private void switchRegistrationEmailAsUsername(boolean enable) {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setRegistrationEmailAsUsername(Boolean.valueOf(enable));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
    }

    private void enableBruteForce(boolean enable) {
        RealmRepresentation rep = this.realm.toRepresentation();
        rep.setBruteForceProtected(Boolean.valueOf(enable));
        this.realm.update(rep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, (Matcher<String>)Matchers.nullValue(String.class), (Object)rep, ResourceType.REALM);
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void loginShouldFailAfterPasswordDeleted() {
        String userName = "credential-tester";
        String userPass = "s3cr37";
        String userId = this.createUser("admin-client-test", userName, userPass, new String[0]);
        this.getCleanup("admin-client-test").addUserId(userId);
        String accountUrl = RealmsResource.accountUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{"admin-client-test"}).toString();
        this.driver.navigate().to(accountUrl);
        org.junit.Assert.assertEquals((String)"Test user should be on the login page.", (Object)"Sign in to your account", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.loginPage.login(userName, userPass);
        org.junit.Assert.assertTrue((String)"Test user should be successfully logged in.", (boolean)this.driver.getTitle().contains("Account Management"));
        this.accountPage.logOut();
        Optional<CredentialRepresentation> passwordCredential = this.realm.users().get(userId).credentials().stream().filter(c -> "password".equals(c.getType())).findFirst();
        org.junit.Assert.assertTrue((String)"Test user should have a password credential set.", (boolean)passwordCredential.isPresent());
        this.realm.users().get(userId).removeCredential(passwordCredential.get().getId());
        this.driver.navigate().to(accountUrl);
        org.junit.Assert.assertEquals((String)"Test user should be on the login page.", (Object)"Sign in to your account", (Object)PageUtils.getPageTitle((WebDriver)this.driver));
        this.loginPage.login(userName, userPass);
        org.junit.Assert.assertTrue((String)"Test user should fail to log in after password was deleted.", (boolean)this.driver.getCurrentUrl().contains(String.format("/realms/%s/login-actions/authenticate", "admin-client-test")));
    }

    @Test
    public void testGetAndMoveCredentials() {
        this.importTestRealms();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-two-configured-otp");
        List creds = user.credentials();
        List<String> expectedCredIds = Arrays.asList(((CredentialRepresentation)creds.get(0)).getId(), ((CredentialRepresentation)creds.get(1)).getId(), ((CredentialRepresentation)creds.get(2)).getId());
        this.assertSameIds(expectedCredIds, user.credentials());
        user.moveCredentialAfter(expectedCredIds.get(0), expectedCredIds.get(1));
        List<String> newOrderCredIds = Arrays.asList(expectedCredIds.get(1), expectedCredIds.get(0), expectedCredIds.get(2));
        this.assertSameIds(newOrderCredIds, user.credentials());
        user.moveCredentialToFirst(expectedCredIds.get(2));
        newOrderCredIds = Arrays.asList(expectedCredIds.get(2), expectedCredIds.get(1), expectedCredIds.get(0));
        this.assertSameIds(newOrderCredIds, user.credentials());
        user.moveCredentialToFirst(expectedCredIds.get(1));
        user.moveCredentialToFirst(expectedCredIds.get(0));
        this.assertSameIds(expectedCredIds, user.credentials());
    }

    private void assertSameIds(List<String> expectedIds, List<CredentialRepresentation> actual) {
        org.junit.Assert.assertEquals((long)expectedIds.size(), (long)actual.size());
        for (int i = 0; i < expectedIds.size(); ++i) {
            org.junit.Assert.assertEquals((Object)expectedIds.get(i), (Object)actual.get(i).getId());
        }
    }

    @Test
    public void testUpdateCredentials() {
        this.importTestRealms();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-one-configured-otp");
        CredentialRepresentation otpCred = (CredentialRepresentation)user.credentials().get(0);
        org.junit.Assert.assertNull((Object)otpCred.getUserLabel());
        String newLabel = "the label";
        user.setCredentialUserLabel(otpCred.getId(), newLabel);
        org.junit.Assert.assertEquals((Object)newLabel, (Object)((CredentialRepresentation)user.credentials().get(0)).getUserLabel());
    }

    @Test
    public void testDeleteCredentials() {
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"john-doh@localhost");
        List creds = user.credentials();
        org.junit.Assert.assertEquals((long)1L, (long)creds.size());
        CredentialRepresentation credPasswd = (CredentialRepresentation)creds.get(0);
        org.junit.Assert.assertEquals((Object)"password", (Object)credPasswd.getType());
        user.removeCredential(credPasswd.getId());
        org.junit.Assert.assertEquals((long)0L, (long)user.credentials().size());
        credPasswd.setValue("password");
        user.resetPassword(credPasswd);
        org.junit.Assert.assertEquals((long)1L, (long)user.credentials().size());
    }

    @Test
    public void testCRUDCredentialsOfDifferentUser() {
        UserResource user1 = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"user-with-one-configured-otp");
        CredentialRepresentation otpCredential = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        UserResource user2 = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)"test-user@localhost");
        try {
            user2.setCredentialUserLabel(otpCredential.getId(), "new-label");
            org.junit.Assert.fail((String)"Not expected to successfully update user label");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            user2.moveCredentialToFirst(otpCredential.getId());
            org.junit.Assert.fail((String)"Not expected to successfully move credential");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            user2.removeCredential(otpCredential.getId());
            org.junit.Assert.fail((String)"Not expected to successfully remove credential");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        CredentialRepresentation otpCredentialLoaded = user1.credentials().stream().filter(credentialRep -> "otp".equals(credentialRep.getType())).findFirst().get();
        org.junit.Assert.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getUserLabel(), (Object)otpCredentialLoaded.getUserLabel()));
        org.junit.Assert.assertTrue((boolean)ObjectUtil.isEqualOrBothNull((Object)otpCredential.getPriority(), (Object)otpCredentialLoaded.getPriority()));
    }

    @Test
    public void testGetGroupsForUserFullRepresentation() {
        RealmResource realm = this.adminClient.realms().realm("test");
        String userName = "averagejoe";
        String groupName = "groupWithAttribute";
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        attributes.put("attribute1", Arrays.asList("attribute1", "attribute2"));
        UserRepresentation userRepresentation = UserBuilder.edit(UserTest.createUserRepresentation(userName, "joe@average.com", "average", "joe", true)).addPassword("password").build();
        try (Creator u = Creator.create((RealmResource)realm, (UserRepresentation)userRepresentation);
             Creator g = Creator.create((RealmResource)realm, (GroupRepresentation)GroupBuilder.create().name(groupName).attributes(attributes).build());){
            String groupId = g.id();
            UserResource user = (UserResource)u.resource();
            user.joinGroup(groupId);
            List userGroups = user.groups(Integer.valueOf(0), Integer.valueOf(100), false);
            org.junit.Assert.assertFalse((boolean)userGroups.isEmpty());
            org.junit.Assert.assertTrue((boolean)((GroupRepresentation)userGroups.get(0)).getAttributes().containsKey("attribute1"));
        }
    }

    @Test
    public void groupMembershipPaginated() {
        String userId = this.createUser(UserBuilder.create().username("user-a").build());
        for (int i = 1; i <= 10; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group-" + i);
            String groupId = this.createGroup(this.realm, group).getId();
            this.realm.users().get(userId).joinGroup(groupId);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userGroupPath(userId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        }
        List groups = this.realm.users().get(userId).groups(Integer.valueOf(5), Integer.valueOf(6));
        org.junit.Assert.assertEquals((long)groups.size(), (long)5L);
        Assert.assertNames(groups, "group-5", "group-6", "group-7", "group-8", "group-9");
    }

    @Test
    public void groupMembershipSearch() {
        String userId = this.createUser(UserBuilder.create().username("user-b").build());
        for (int i = 1; i <= 10; ++i) {
            GroupRepresentation group = new GroupRepresentation();
            group.setName("group-" + i);
            String groupId = this.createGroup(this.realm, group).getId();
            this.realm.users().get(userId).joinGroup(groupId);
            this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.userGroupPath(userId, groupId), (Object)group, ResourceType.GROUP_MEMBERSHIP);
        }
        List groups = this.realm.users().get(userId).groups("-3", Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat(this.realm.users().get(userId).groupsCount("-3").get("count"), (Matcher)Matchers.is((Object)1L));
        org.junit.Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertNames(groups, "group-3");
        List groups2 = this.realm.users().get(userId).groups("1", Integer.valueOf(0), Integer.valueOf(10));
        MatcherAssert.assertThat(this.realm.users().get(userId).groupsCount("1").get("count"), (Matcher)Matchers.is((Object)2L));
        org.junit.Assert.assertEquals((long)2L, (long)groups2.size());
        Assert.assertNames(groups2, "group-1", "group-10");
        List groups3 = this.realm.users().get(userId).groups("1", Integer.valueOf(2), Integer.valueOf(10));
        org.junit.Assert.assertEquals((long)0L, (long)groups3.size());
        List groups4 = this.realm.users().get(userId).groups("gr", Integer.valueOf(2), Integer.valueOf(10));
        MatcherAssert.assertThat(this.realm.users().get(userId).groupsCount("gr").get("count"), (Matcher)Matchers.is((Object)10L));
        org.junit.Assert.assertEquals((long)8L, (long)groups4.size());
        List groups5 = this.realm.users().get(userId).groups("Gr", Integer.valueOf(2), Integer.valueOf(10));
        org.junit.Assert.assertEquals((long)8L, (long)groups5.size());
    }

    @Test
    public void createFederatedIdentities() {
        String identityProviderAlias = "social-provider-id";
        String username = "federated-identities";
        String federatedUserId = "federated-user-id";
        this.addSampleIdentityProvider();
        UserRepresentation build = UserBuilder.create().username(username).federatedLink(identityProviderAlias, federatedUserId).build();
        String userId = this.createUser(build, false);
        List obtainedFederatedIdentities = this.realm.users().get(userId).getFederatedIdentity();
        org.junit.Assert.assertEquals((long)1L, (long)obtainedFederatedIdentities.size());
        org.junit.Assert.assertEquals((Object)federatedUserId, (Object)((FederatedIdentityRepresentation)obtainedFederatedIdentities.get(0)).getUserId());
        org.junit.Assert.assertEquals((Object)username, (Object)((FederatedIdentityRepresentation)obtainedFederatedIdentities.get(0)).getUserName());
        org.junit.Assert.assertEquals((Object)identityProviderAlias, (Object)((FederatedIdentityRepresentation)obtainedFederatedIdentities.get(0)).getIdentityProvider());
    }

    @Test
    public void createUserWithGroups() {
        String username = "user-with-groups";
        String groupToBeAdded = "test-group";
        this.createGroup(this.realm, GroupBuilder.create().name(groupToBeAdded).build());
        UserRepresentation build = UserBuilder.create().username(username).addGroups(groupToBeAdded).build();
        String userId = this.createUser(build);
        List obtainedGroups = this.realm.users().get(userId).groups();
        org.junit.Assert.assertEquals((long)1L, (long)obtainedGroups.size());
        org.junit.Assert.assertEquals((Object)groupToBeAdded, (Object)((GroupRepresentation)obtainedGroups.get(0)).getName());
    }

    private GroupRepresentation createGroup(RealmResource realm, GroupRepresentation group) {
        Response response = realm.groups().add(group);
        String groupId = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addGroupId(groupId);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.groupPath(groupId), (Object)group, ResourceType.GROUP);
        group.setId(groupId);
        return group;
    }

    @Test
    public void failCreateUserUsingRegularUser() throws Exception {
        String regularUserId = ApiUtil.getCreatedId((Response)this.testRealm().users().create(UserBuilder.create().username("regular-user").password("password").build()));
        UserResource regularUser = this.testRealm().users().get(regularUserId);
        UserRepresentation regularUserRep = regularUser.toRepresentation();
        try (Keycloak adminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)regularUserRep.getUsername(), (String)"password", (String)"admin-cli", null);){
            UserRepresentation invalidUser = UserBuilder.create().username("do-not-create-me").build();
            Response response = adminClient.realm("test").users().create(invalidUser);
            org.junit.Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatus());
            invalidUser.setGroups(Collections.emptyList());
            response = adminClient.realm("test").users().create(invalidUser);
            org.junit.Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUserDoNotGrantRole() {
        this.testRealm().roles().create(RoleBuilder.create().name("realm-role").build());
        try {
            UserRepresentation userRep = UserBuilder.create().username("alice").password("password").addRoles("realm-role").build();
            String userId = ApiUtil.getCreatedId((Response)this.testRealm().users().create(userRep));
            UserResource user = this.testRealm().users().get(userId);
            List realmMappings = user.roles().getAll().getRealmMappings();
            org.junit.Assert.assertFalse((boolean)realmMappings.stream().map(RoleRepresentation::getName).anyMatch("realm-role"::equals));
        }
        finally {
            this.testRealm().roles().get("realm-role").remove();
        }
    }
}

