/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.junit.Test;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ComponentTypeRepresentation;
import org.keycloak.representations.idm.ConfigPropertyRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.authentication.AbstractAuthenticationTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminEventPaths;

public class UserStorageRestTest
extends AbstractAdminTest {
    private AuthenticationExecutionInfoRepresentation findKerberosExecution() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = null;
        List executionReps = this.realm.flows().getExecutions("browser");
        kerberosExecution = AbstractAuthenticationTest.findExecutionByProvider("auth-spnego", executionReps);
        Assert.assertNotNull((Object)kerberosExecution);
        return kerberosExecution;
    }

    private String createComponent(ComponentRepresentation rep) {
        Response resp = this.realm.components().add(rep);
        Assert.assertEquals((long)201L, (long)resp.getStatus());
        resp.close();
        String id = ApiUtil.getCreatedId((Response)resp);
        this.assertAdminEvents.clear();
        return id;
    }

    private void removeComponent(String id) {
        this.realm.components().component(id).remove();
        this.assertAdminEvents.clear();
    }

    private void assertFederationProvider(ComponentRepresentation rep, String id, String displayName, String providerId, String ... config) {
        Assert.assertEquals((Object)id, (Object)rep.getId());
        Assert.assertEquals((Object)displayName, (Object)rep.getName());
        Assert.assertEquals((Object)providerId, (Object)rep.getProviderId());
        Assert.assertMultivaluedMap((MultivaluedHashMap<String, String>)rep.getConfig(), config);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testKerberosAuthenticatorEnabledAutomatically() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        String id = this.createComponent(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        ldapRep = this.realm.components().component(id).toRepresentation();
        this.realm.components().component(id).update(ldapRep);
        this.assertAdminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ldapRep = this.realm.components().component(id).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"false");
        this.realm.components().component(id).update(ldapRep);
        this.assertAdminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ldapRep = this.realm.components().component(id).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        this.realm.components().component(id).update(ldapRep);
        this.assertAdminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        this.removeComponent(id);
    }

    @Test
    public void testKerberosAuthenticatorChangedOnlyIfDisabled() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        String id = this.createComponent(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        ldapRep = this.realm.components().component(id).toRepresentation();
        this.realm.components().component(id).update(ldapRep);
        this.assertAdminEvents.clear();
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.DISABLED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.authUpdateExecutionPath("browser"), (Object)kerberosExecution, ResourceType.AUTH_EXECUTION);
        this.removeComponent(id);
    }

    @Test
    public void testKerberosAuthenticatorDisabledWhenProviderRemoved() {
        AuthenticationExecutionInfoRepresentation kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"allowKerberosAuthentication", (Object)"true");
        String id = this.createComponent(ldapRep);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        this.realm.components().component(id).remove();
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
        ComponentRepresentation kerberosRep = new ComponentRepresentation();
        kerberosRep.setName("kerberos");
        kerberosRep.setProviderId("kerberos");
        kerberosRep.setProviderType(UserStorageProvider.class.getName());
        kerberosRep.setConfig(new MultivaluedHashMap());
        kerberosRep.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        id = this.createComponent(kerberosRep);
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.ALTERNATIVE.toString());
        kerberosExecution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.toString());
        this.realm.flows().updateExecutions("browser", kerberosExecution);
        this.realm.components().component(id).remove();
        kerberosExecution = this.findKerberosExecution();
        Assert.assertEquals((Object)kerberosExecution.getRequirement(), (Object)AuthenticationExecutionModel.Requirement.DISABLED.toString());
    }

    @Test
    public void testValidateAndCreateLdapProviderCustomSearchFilter() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"dc=something");
        Response resp = this.realm.components().add(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something");
        resp = this.realm.components().add(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"dc=something)");
        resp = this.realm.components().add(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        Assert.assertTrue((boolean)this.realm.components().query(this.realmId, UserStorageProvider.class.getName()).isEmpty());
        this.assertAdminEvents.assertEmpty();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something)");
        String id1 = this.createComponent(ldapRep);
        ComponentRepresentation ldapRep2 = new ComponentRepresentation();
        ldapRep2.setName("ldap3");
        ldapRep2.setProviderId("ldap");
        ldapRep2.setProviderType(UserStorageProvider.class.getName());
        ldapRep2.setConfig(new MultivaluedHashMap());
        ldapRep2.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        ldapRep2.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.name());
        ldapRep2.getConfig().putSingle((Object)"bindDn", (Object)"cn=manager");
        ldapRep2.getConfig().putSingle((Object)"bindCredential", (Object)"password");
        String id2 = this.createComponent(ldapRep2);
        List providerInstances = this.realm.components().query(this.realmId, UserStorageProvider.class.getName());
        Assert.assertEquals((long)providerInstances.size(), (long)2L);
        this.removeComponent(id1);
        this.removeComponent(id2);
    }

    @Test
    public void testValidateAndCreateLdapProviderEditMode() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().remove((Object)"editMode");
        Response resp = this.realm.components().add(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.READ_ONLY.name());
        ldapRep.getConfig().putSingle((Object)"validatePasswordPolicy", (Object)"true");
        resp = this.realm.components().add(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.UNSYNCED.name());
        ldapRep.getConfig().putSingle((Object)"validatePasswordPolicy", (Object)"true");
        resp = this.realm.components().add(ldapRep);
        Assert.assertEquals((long)400L, (long)resp.getStatus());
        resp.close();
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.name());
        ldapRep.getConfig().putSingle((Object)"syncRegistrations", (Object)"true");
        String id1 = this.createComponent(ldapRep);
        this.removeComponent(id1);
    }

    @Test
    public void testUpdateProvider() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"bindDn", (Object)"cn=manager");
        ldapRep.getConfig().putSingle((Object)"bindCredential", (Object)"password");
        String id = this.createComponent(ldapRep);
        ldapRep = this.realm.components().component(id).toRepresentation();
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something2");
        ldapRep.getConfig().putSingle((Object)"bindDn", (Object)"cn=manager-updated");
        try {
            this.realm.components().component(id).update(ldapRep);
            Assert.fail((String)"Not expected to successfull update");
        }
        catch (BadRequestException badRequestException) {
            // empty catch block
        }
        this.assertFederationProvider(this.realm.components().component(id).toRepresentation(), id, "ldap2", "ldap", "bindDn", "cn=manager", "bindCredential", "**********");
        ldapRep.getConfig().putSingle((Object)"customUserSearchFilter", (Object)"(dc=something2)");
        this.realm.components().component(id).update(ldapRep);
        this.assertAdminEvents.clear();
        ldapRep = this.realm.components().component(id).toRepresentation();
        this.assertFederationProvider(ldapRep, id, "ldap2", "ldap", "bindDn", "cn=manager-updated", "bindCredential", "**********", "customUserSearchFilter", "(dc=something2)");
        ldapRep.setName("ldap2");
        this.realm.components().component(id).update(ldapRep);
        this.assertFederationProvider(this.realm.components().component(id).toRepresentation(), id, "ldap2", "ldap", "bindDn", "cn=manager-updated", "bindCredential", "**********", "customUserSearchFilter", "(dc=something2)");
        this.removeComponent(id);
    }

    @Test
    public void testLDAPMapperProviderConfigurationForVendorOther() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"vendor", (Object)"other");
        String ldapModelId = this.createComponent(ldapRep);
        ComponentTypeRepresentation groupLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "group-ldap-mapper");
        ConfigPropertyRepresentation groupRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(groupLDAPMapperType, "user.roles.retrieve.strategy");
        List options = groupRetrieverConfigProperty.getOptions();
        Assert.assertNames(options, "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE", "GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE");
        Assert.assertFalse((boolean)groupRetrieverConfigProperty.getHelpText().contains("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        ComponentTypeRepresentation roleLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "role-ldap-mapper");
        ConfigPropertyRepresentation roleRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(roleLDAPMapperType, "user.roles.retrieve.strategy");
        options = roleRetrieverConfigProperty.getOptions();
        Assert.assertNames(options, "LOAD_ROLES_BY_MEMBER_ATTRIBUTE", "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE");
        Assert.assertFalse((boolean)roleRetrieverConfigProperty.getHelpText().contains("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        this.removeComponent(ldapModelId);
    }

    @Test
    public void testLDAPMapperProviderConfigurationForVendorMSAD() {
        ComponentRepresentation ldapRep = this.createBasicLDAPProviderRep();
        ldapRep.getConfig().putSingle((Object)"vendor", (Object)"ad");
        String ldapModelId = this.createComponent(ldapRep);
        ComponentTypeRepresentation groupLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "group-ldap-mapper");
        ConfigPropertyRepresentation groupRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(groupLDAPMapperType, "user.roles.retrieve.strategy");
        List options = groupRetrieverConfigProperty.getOptions();
        Assert.assertNames(options, "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE", "GET_GROUPS_FROM_USER_MEMBEROF_ATTRIBUTE", "LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY");
        Assert.assertTrue((boolean)groupRetrieverConfigProperty.getHelpText().contains("LOAD_GROUPS_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        ComponentTypeRepresentation roleLDAPMapperType = this.findMapperTypeConfiguration(ldapModelId, "role-ldap-mapper");
        ConfigPropertyRepresentation roleRetrieverConfigProperty = this.getUserRolesRetrieveStrategyConfigProperty(roleLDAPMapperType, "user.roles.retrieve.strategy");
        options = roleRetrieverConfigProperty.getOptions();
        Assert.assertNames(options, "LOAD_ROLES_BY_MEMBER_ATTRIBUTE", "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE", "LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY");
        Assert.assertTrue((boolean)roleRetrieverConfigProperty.getHelpText().contains("LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY"));
        this.removeComponent(ldapModelId);
    }

    private ComponentRepresentation createBasicLDAPProviderRep() {
        ComponentRepresentation ldapRep = new ComponentRepresentation();
        ldapRep.setName("ldap2");
        ldapRep.setProviderId("ldap");
        ldapRep.setProviderType(UserStorageProvider.class.getName());
        ldapRep.setConfig(new MultivaluedHashMap());
        ldapRep.getConfig().putSingle((Object)"priority", (Object)Integer.toString(2));
        ldapRep.getConfig().putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.name());
        return ldapRep;
    }

    private ComponentTypeRepresentation findMapperTypeConfiguration(String ldapModelId, String mapperProviderId) {
        ComponentResource ldapProvider = this.realm.components().component(ldapModelId);
        List componentTypes = ldapProvider.getSubcomponentConfig(LDAPStorageMapper.class.getName());
        return componentTypes.stream().filter(componentType -> mapperProviderId.equals(componentType.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Not able to find mapper with provider id: " + mapperProviderId));
    }

    private ConfigPropertyRepresentation getUserRolesRetrieveStrategyConfigProperty(ComponentTypeRepresentation componentType, String propertyName) {
        return componentType.getProperties().stream().filter(configPropertyRep -> propertyName.equals(configPropertyRep.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Not able to find config property with name: " + propertyName));
    }
}

