/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RoleByIdResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.RoleBuilder;

public class RoleByIdResourceTest
extends AbstractAdminTest {
    private RoleByIdResource resource;
    private Map<String, String> ids = new HashMap<String, String>();
    private String clientId;
    private String clientUuid;

    @Before
    public void before() {
        this.adminClient.realm("admin-client-test").roles().create(RoleBuilder.create().name("role-a").description("Role A").build());
        this.adminClient.realm("admin-client-test").roles().create(RoleBuilder.create().name("role-b").description("Role B").build());
        this.clientId = "client-a";
        Response response = this.adminClient.realm("admin-client-test").clients().create(ClientBuilder.create().clientId(this.clientId).build());
        this.clientUuid = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(this.clientUuid);
        response.close();
        this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().create(RoleBuilder.create().name("role-c").description("Role C").build());
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        for (RoleRepresentation r : this.adminClient.realm("admin-client-test").clients().get(this.clientUuid).roles().list()) {
            this.ids.put(r.getName(), r.getId());
        }
        this.getCleanup().addRoleId(this.ids.get("role-a"));
        this.getCleanup().addRoleId(this.ids.get("role-b"));
        this.getCleanup().addRoleId(this.ids.get("role-c"));
        this.resource = this.adminClient.realm("admin-client-test").rolesById();
        this.assertAdminEvents.clear();
    }

    @Test
    public void getRole() {
        RoleRepresentation role = this.resource.getRole(this.ids.get("role-a"));
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A", (Object)role.getDescription());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void updateRole() {
        RoleRepresentation role = this.resource.getRole(this.ids.get("role-a"));
        role.setName("role-a-new");
        role.setDescription("Role A New");
        this.resource.updateRole(this.ids.get("role-a"), role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.roleByIdResourcePath(this.ids.get("role-a")), (Object)role, ResourceType.REALM_ROLE);
        role = this.resource.getRole(this.ids.get("role-a"));
        org.junit.Assert.assertNotNull((Object)role);
        org.junit.Assert.assertEquals((Object)"role-a-new", (Object)role.getName());
        org.junit.Assert.assertEquals((Object)"Role A New", (Object)role.getDescription());
        org.junit.Assert.assertFalse((boolean)role.isComposite());
    }

    @Test
    public void deleteRole() {
        org.junit.Assert.assertNotNull((Object)this.resource.getRole(this.ids.get("role-a")));
        this.resource.deleteRole(this.ids.get("role-a"));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleByIdResourcePath(this.ids.get("role-a")), ResourceType.REALM_ROLE);
        try {
            this.resource.getRole(this.ids.get("role-a"));
            org.junit.Assert.fail((String)"Expected 404");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void composites() {
        org.junit.Assert.assertFalse((boolean)this.resource.getRole(this.ids.get("role-a")).isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.getRoleComposites(this.ids.get("role-a")).size());
        LinkedList<RoleRepresentation> l = new LinkedList<RoleRepresentation>();
        l.add(RoleBuilder.create().id(this.ids.get("role-b")).build());
        l.add(RoleBuilder.create().id(this.ids.get("role-c")).build());
        this.resource.addComposites(this.ids.get("role-a"), l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleByIdResourceCompositesPath(this.ids.get("role-a")), l, ResourceType.REALM_ROLE);
        Set composites = this.resource.getRoleComposites(this.ids.get("role-a"));
        org.junit.Assert.assertTrue((boolean)this.resource.getRole(this.ids.get("role-a")).isComposite());
        Assert.assertNames(composites, "role-b", "role-c");
        Set realmComposites = this.resource.getRealmRoleComposites(this.ids.get("role-a"));
        Assert.assertNames(realmComposites, "role-b");
        Set clientComposites = this.resource.getClientRoleComposites(this.ids.get("role-a"), this.clientUuid);
        Assert.assertNames(clientComposites, "role-c");
        composites = this.resource.searchRoleComposites(this.ids.get("role-a"), null, null, null);
        Assert.assertNames(composites, "role-b", "role-c");
        composites = this.resource.searchRoleComposites(this.ids.get("role-a"), "b", null, null);
        Assert.assertNames(composites, "role-b");
        composites = this.resource.searchRoleComposites(this.ids.get("role-a"), null, Integer.valueOf(0), Integer.valueOf(0));
        MatcherAssert.assertThat((Object)composites, (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        composites = this.resource.searchRoleComposites(this.ids.get("role-a"), null, Integer.valueOf(0), Integer.valueOf(1));
        Assert.assertNames(composites, "role-b");
        composites = this.resource.searchRoleComposites(this.ids.get("role-a"), null, Integer.valueOf(1), Integer.valueOf(1));
        Assert.assertNames(composites, "role-c");
        this.resource.deleteComposites(this.ids.get("role-a"), l);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleByIdResourceCompositesPath(this.ids.get("role-a")), l, ResourceType.REALM_ROLE);
        org.junit.Assert.assertFalse((boolean)this.resource.getRole(this.ids.get("role-a")).isComposite());
        org.junit.Assert.assertEquals((long)0L, (long)this.resource.getRoleComposites(this.ids.get("role-a")).size());
    }

    @Test
    public void createNewMixedRealmCompositeRole() {
        RoleRepresentation newRoleComp = RoleBuilder.create().name("role-mixed-comp").composite().realmComposite("role-a").clientComposite(this.clientId, "role-c").build();
        this.adminClient.realm("admin-client-test").roles().create(newRoleComp);
        RoleRepresentation roleMixedComp = this.adminClient.realm("admin-client-test").roles().get(newRoleComp.getName()).toRepresentation();
        org.junit.Assert.assertTrue((boolean)roleMixedComp.isComposite());
        Predicate<RoleRepresentation> isClientRole = RoleRepresentation::getClientRole;
        Set roleComposites = this.resource.getRoleComposites(roleMixedComp.getId());
        Set containedRealmRoles = roleComposites.stream().filter(isClientRole.negate()).collect(Collectors.toSet());
        org.junit.Assert.assertFalse((boolean)containedRealmRoles.isEmpty());
        org.junit.Assert.assertTrue((boolean)containedRealmRoles.stream().anyMatch(r -> r.getName().equals("role-a")));
        Set containedClientRoles = roleComposites.stream().filter(isClientRole).collect(Collectors.toSet());
        org.junit.Assert.assertFalse((boolean)containedClientRoles.isEmpty());
        org.junit.Assert.assertTrue((boolean)containedClientRoles.stream().anyMatch(r -> r.getContainerId().equals(this.clientUuid) && r.getName().equals("role-c")));
    }

    @Test(expected=NotFoundException.class)
    public void createNewMixedRealmCompositeRoleWithUnknownRealmRoleShouldThrow() {
        String unknownRealmRole = "realm-role-unknown";
        RoleRepresentation newRoleComp = RoleBuilder.create().name("role-broken-comp1").composite().realmComposite(unknownRealmRole).clientComposite(this.clientId, "role-c").build();
        this.adminClient.realm("admin-client-test").roles().create(newRoleComp);
    }

    @Test(expected=NotFoundException.class)
    public void createNewMixedRealmCompositeRoleWithUnknownClientRoleShouldThrow() {
        String unknownClientRole = "client-role-unknown";
        RoleRepresentation newRoleComp = RoleBuilder.create().name("role-broken-comp2").composite().realmComposite("role-a").clientComposite(this.clientId, unknownClientRole).build();
        this.adminClient.realm("admin-client-test").roles().create(newRoleComp);
    }

    @Test
    public void attributes() {
        for (String id : this.ids.values()) {
            RoleRepresentation role = this.resource.getRole(id);
            org.junit.Assert.assertNotNull((Object)role.getAttributes());
            org.junit.Assert.assertTrue((boolean)role.getAttributes().isEmpty());
            HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
            ArrayList<String> attributeValues = new ArrayList<String>();
            attributeValues.add("value1");
            attributes.put("key1", attributeValues);
            attributeValues = new ArrayList();
            attributeValues.add("value2.1");
            attributeValues.add("value2.2");
            attributes.put("key2", attributeValues);
            role.setAttributes(attributes);
            this.resource.updateRole(id, role);
            role = this.resource.getRole(id);
            org.junit.Assert.assertNotNull((Object)role);
            Map roleAttributes = role.getAttributes();
            org.junit.Assert.assertNotNull((Object)roleAttributes);
            Assert.assertRoleAttributes(attributes, roleAttributes);
            attributes.remove("key2");
            role.setAttributes(attributes);
            this.resource.updateRole(id, role);
            role = this.resource.getRole(id);
            org.junit.Assert.assertNotNull((Object)role);
            roleAttributes = role.getAttributes();
            org.junit.Assert.assertNotNull((Object)roleAttributes);
            Assert.assertRoleAttributes(attributes, roleAttributes);
        }
    }

    @Test(expected=BadRequestException.class)
    public void deleteDefaultRole() {
        this.resource.deleteRole(this.adminClient.realm("admin-client-test").roles().get("default-roles-admin-client-test").toRepresentation().getId());
    }
}

