/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmLocalizationResource;
import org.keycloak.testsuite.admin.AbstractAdminTest;

public class RealmLocalizationResourceTest
extends AbstractAdminTest {
    private RealmLocalizationResource resource;

    @Before
    public void before() {
        this.adminClient.realm("admin-client-test").localization().saveRealmLocalizationText("en", "key-a", "text-a_en");
        this.adminClient.realm("admin-client-test").localization().saveRealmLocalizationText("en", "key-b", "text-b_en");
        this.adminClient.realm("admin-client-test").localization().saveRealmLocalizationText("de", "key-a", "text-a_de");
        this.getCleanup().addLocalization("en");
        this.getCleanup().addLocalization("de");
        this.getCleanup().addLocalization("es");
        this.resource = this.adminClient.realm("admin-client-test").localization();
    }

    @Test
    public void getRealmSpecificLocales() {
        List languages = this.resource.getRealmSpecificLocales();
        Assert.assertEquals((long)2L, (long)languages.size());
        MatcherAssert.assertThat((Object)languages, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"en", "de"}));
    }

    @Test
    public void getRealmLocalizationTexts() {
        Map localizations = this.resource.getRealmLocalizationTexts("en");
        Assert.assertNotNull((Object)localizations);
        Assert.assertEquals((long)2L, (long)localizations.size());
        Assert.assertEquals((Object)"text-a_en", localizations.get("key-a"));
        Assert.assertEquals((Object)"text-b_en", localizations.get("key-b"));
    }

    @Test
    public void getRealmLocalizationsNotExists() {
        Map localizations = this.resource.getRealmLocalizationTexts("zz");
        Assert.assertNotNull((Object)localizations);
        Assert.assertEquals((long)0L, (long)localizations.size());
    }

    @Test
    public void getRealmLocalizationText() {
        String localizationText = this.resource.getRealmLocalizationText("en", "key-a");
        Assert.assertNotNull((Object)localizationText);
        Assert.assertEquals((Object)"text-a_en", (Object)localizationText);
    }

    @Test(expected=NotFoundException.class)
    public void getRealmLocalizationTextNotExists() {
        this.resource.getRealmLocalizationText("en", "key-zz");
    }

    @Test
    public void addRealmLocalizationText() {
        this.resource.saveRealmLocalizationText("en", "key-c", "text-c");
        String localizationText = this.resource.getRealmLocalizationText("en", "key-c");
        Assert.assertNotNull((Object)localizationText);
        Assert.assertEquals((Object)"text-c", (Object)localizationText);
    }

    @Test
    public void updateRealmLocalizationText() {
        this.resource.saveRealmLocalizationText("en", "key-b", "text-b-new");
        String localizationText = this.resource.getRealmLocalizationText("en", "key-b");
        Assert.assertNotNull((Object)localizationText);
        Assert.assertEquals((Object)"text-b-new", (Object)localizationText);
    }

    @Test
    public void deleteRealmLocalizationText() {
        this.resource.deleteRealmLocalizationText("en", "key-a");
        Map localizations = this.resource.getRealmLocalizationTexts("en");
        Assert.assertEquals((long)1L, (long)localizations.size());
        Assert.assertEquals((Object)"text-b_en", localizations.get("key-b"));
    }

    @Test(expected=NotFoundException.class)
    public void deleteRealmLocalizationTextNotExists() {
        this.resource.deleteRealmLocalizationText("en", "zz");
    }

    @Test
    public void deleteRealmLocalizationTexts() {
        this.resource.deleteRealmLocalizationTexts("en");
        List localizations = this.resource.getRealmSpecificLocales();
        Assert.assertEquals((long)1L, (long)localizations.size());
        MatcherAssert.assertThat((Object)localizations, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"de"}));
    }

    @Test
    public void createOrUpdateRealmLocalizationWhenLocaleDoesNotYetExist() {
        HashMap<String, String> newLocalizationTexts = new HashMap<String, String>();
        newLocalizationTexts.put("key-a", "text-a_es");
        newLocalizationTexts.put("key-b", "text-b_es");
        this.resource.createOrUpdateRealmLocalizationTexts("es", newLocalizationTexts);
        Map persistedLocalizationTexts = this.resource.getRealmLocalizationTexts("es");
        Assert.assertEquals(newLocalizationTexts, (Object)persistedLocalizationTexts);
    }

    @Test
    public void createOrUpdateRealmLocalizationWhenLocaleAlreadyExists() {
        HashMap<String, String> newLocalizationTexts = new HashMap<String, String>();
        newLocalizationTexts.put("key-b", "text-b_changed_en");
        newLocalizationTexts.put("key-c", "text-c_en");
        this.resource.createOrUpdateRealmLocalizationTexts("en", newLocalizationTexts);
        HashMap<String, String> expectedLocalizationTexts = new HashMap<String, String>();
        expectedLocalizationTexts.put("key-a", "text-a_en");
        expectedLocalizationTexts.putAll(newLocalizationTexts);
        Map persistedLocalizationTexts = this.resource.getRealmLocalizationTexts("en");
        Assert.assertEquals(expectedLocalizationTexts, (Object)persistedLocalizationTexts);
    }
}

