/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jgroups.util.UUID;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.KeyStoreConfig;
import org.keycloak.representations.idm.AuthenticationExecutionInfoRepresentation;
import org.keycloak.representations.idm.AuthenticationExecutionRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.AuthenticatorConfigRepresentation;
import org.keycloak.representations.idm.ClientInitialAccessCreatePresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RealmEventsConfigRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderSimpleRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ResourceServerRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.FederatedIdentityBuilder;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.utils.tls.TLSUtils;

public class PermissionsTest
extends AbstractKeycloakTest {
    private static final String REALM_NAME = "permissions-test";
    private Map<String, Keycloak> clients = new HashMap<String, Keycloak>();
    @Rule
    public GreenMailRule greenMailRule = new GreenMailRule();

    @Override
    public void beforeAbstractKeycloakTestRealmImport() {
        if (this.testContext.isInitialized()) {
            return;
        }
        this.removeAllRealmsDespiteMaster();
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder builder = RealmBuilder.create().name(REALM_NAME).testMail();
        builder.client(ClientBuilder.create().clientId("test-client").publicClient().directAccessGrants());
        builder.user(UserBuilder.create().username(AdminRoles.REALM_ADMIN).role("realm-management", AdminRoles.REALM_ADMIN).addPassword("password"));
        builder.user(UserBuilder.create().username("multi").role("realm-management", AdminRoles.QUERY_GROUPS).role("realm-management", AdminRoles.VIEW_REALM).role("realm-management", AdminRoles.VIEW_CLIENTS).addPassword("password"));
        builder.user(UserBuilder.create().username("none").addPassword("password"));
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            builder.user(UserBuilder.create().username(role).role("realm-management", role).addPassword("password"));
        }
        testRealms.add(builder.build());
        RealmBuilder builder2 = RealmBuilder.create().name("realm2");
        builder2.client(ClientBuilder.create().clientId("test-client").publicClient().directAccessGrants());
        builder2.user(UserBuilder.create().username("admin").role("realm-management", AdminRoles.REALM_ADMIN).addPassword("password"));
        testRealms.add(builder2.build());
    }

    @Before
    public void beforeClazz() {
        if (this.testContext.isInitialized()) {
            return;
        }
        this.createTestUsers();
        this.testContext.setInitialized(true);
    }

    private void createTestUsers() {
        RealmResource master = this.adminClient.realm("master");
        Response response = master.users().create(UserBuilder.create().username("permissions-test-master-none").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        master.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            response = master.users().create(UserBuilder.create().username("permissions-test-master-" + role).build());
            userId = ApiUtil.getCreatedId((Response)response);
            response.close();
            master.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
            String clientId = ((ClientRepresentation)master.clients().findByClientId("permissions-test-realm").get(0)).getId();
            RoleRepresentation roleRep = master.clients().get(clientId).roles().get(role).toRepresentation();
            master.users().get(userId).roles().clientLevel(clientId).add(Collections.singletonList(roleRep));
        }
    }

    @AfterClass
    public static void removeTestUsers() throws Exception {
        try (Keycloak adminClient = AdminClientUtil.createAdminClient();){
            for (UserRepresentation u : adminClient.realm("master").users().search("permissions-test-master-", Integer.valueOf(0), Integer.valueOf(100))) {
                adminClient.realm("master").users().get(u.getId()).remove();
            }
        }
    }

    private void recreatePermissionRealm() throws Exception {
        RealmRepresentation permissionRealm = this.testContext.getTestRealmReps().stream().filter(realm -> realm.getRealm().equals(REALM_NAME)).findFirst().get();
        this.adminClient.realms().create(permissionRealm);
        PermissionsTest.removeTestUsers();
        this.createTestUsers();
    }

    @Override
    public void beforeAbstractKeycloakTest() throws Exception {
        super.beforeAbstractKeycloakTest();
        this.clients.put(AdminRoles.REALM_ADMIN, Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)AdminRoles.REALM_ADMIN, (String)"password", (String)"test-client", (String)"secret", (SSLContext)TLSUtils.initializeTLS()));
        this.clients.put("none", Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)"none", (String)"password", (String)"test-client", (String)"secret", (SSLContext)TLSUtils.initializeTLS()));
        this.clients.put("multi", Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)"multi", (String)"password", (String)"test-client", (String)"secret", (SSLContext)TLSUtils.initializeTLS()));
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            this.clients.put(role, Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)REALM_NAME, (String)role, (String)"password", (String)"test-client", (SSLContext)TLSUtils.initializeTLS()));
        }
        this.clients.put("REALM2", Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"realm2", (String)"admin", (String)"password", (String)"test-client", (SSLContext)TLSUtils.initializeTLS()));
        this.clients.put("master-admin", this.adminClient);
        this.clients.put("master-none", Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"permissions-test-master-none", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS()));
        for (String role : AdminRoles.ALL_REALM_ROLES) {
            this.clients.put("master-" + role, Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)("permissions-test-master-" + role), (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS()));
        }
    }

    @Override
    public void afterAbstractKeycloakTest() {
        this.clients.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("master-admin")).forEach(consumer -> ((Keycloak)consumer.getValue()).close());
        this.clients.clear();
    }

    @Test
    public void realms() throws Exception {
        this.invoke((RealmResource realm) -> this.clients.get("master-none").realms().findAll(), this.clients.get("none"), false);
        this.invoke((RealmResource realm) -> this.clients.get("none").realms().findAll(), this.clients.get("none"), false);
        Assert.assertNames(this.clients.get("master-admin").realms().findAll(), "master", REALM_NAME, "realm2");
        Assert.assertNames(this.clients.get(AdminRoles.REALM_ADMIN).realms().findAll(), REALM_NAME);
        Assert.assertNames(this.clients.get("REALM2").realms().findAll(), "realm2");
        List realms = this.clients.get(AdminRoles.VIEW_USERS).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        this.assertGettersEmpty((RealmRepresentation)realms.get(0));
        realms = this.clients.get(AdminRoles.VIEW_REALM).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        org.junit.Assert.assertNotNull((Object)((RealmRepresentation)realms.get(0)).getAccessTokenLifespan());
        realms = this.clients.get("master-" + AdminRoles.VIEW_USERS).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        this.assertGettersEmpty((RealmRepresentation)realms.get(0));
        realms = this.clients.get("master-" + AdminRoles.VIEW_REALM).realms().findAll();
        Assert.assertNames(realms, REALM_NAME);
        org.junit.Assert.assertNotNull((Object)((RealmRepresentation)realms.get(0)).getAccessTokenLifespan());
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-admin")).realms().create(RealmBuilder.create().name("master").build());
            }
        }, this.adminClient, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-" + AdminRoles.MANAGE_USERS)).realms().create(RealmBuilder.create().name("master").build());
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.REALM_ADMIN)).realms().create(RealmBuilder.create().name("master").build());
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.toRepresentation();
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.assertGettersEmpty(this.clients.get(AdminRoles.QUERY_REALMS).realm(REALM_NAME).toRepresentation());
        for (String role : AdminRoles.ALL_QUERY_ROLES) {
            this.invoke((RealmResource realm) -> this.clients.get(role).realms().realm(REALM_NAME).toRepresentation(), this.clients.get(role), true);
        }
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.update(new RealmRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.pushRevocation();
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.deleteSession("nosuch");
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getClientSessionStats();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getDefaultGroups();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.addDefaultGroup("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.removeDefaultGroup("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        GroupRepresentation newGroup = new GroupRepresentation();
        newGroup.setName("sample");
        this.adminClient.realm(REALM_NAME).groups().add(newGroup);
        GroupRepresentation group = this.adminClient.realms().realm(REALM_NAME).getGroupByPath("sample");
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getGroupByPath("sample");
            }
        }, AdminAuth.Resource.USER, false);
        this.adminClient.realms().realm(REALM_NAME).groups().group(group.getId()).remove();
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.testLDAPConnection("nosuch", "nosuch", "nosuch", "nosuch", "nosuch", "nosuch"));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.partialImport(new PartialImportRepresentation()));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearRealmCache();
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearUserCache();
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("master-admin")).realms().realm("nosuch").remove();
            }
        }, this.adminClient, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get("REALM2")).realms().realm(PermissionsTest.REALM_NAME).remove();
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.MANAGE_USERS)).realms().realm(PermissionsTest.REALM_NAME).remove();
            }
        }, this.adminClient, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.REALM_ADMIN)).realms().realm(PermissionsTest.REALM_NAME).remove();
            }
        }, this.adminClient, true);
        this.recreatePermissionRealm();
    }

    @Test
    public void realmLogoutAll() {
        Invocation invocation = new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.logoutAll();
            }
        };
        this.invoke(invocation, this.clients.get("master-none"), false);
        this.invoke(invocation, this.clients.get("master-view-realm"), false);
        this.invoke(invocation, this.clients.get("REALM2"), false);
        this.invoke(invocation, this.clients.get("none"), false);
        this.invoke(invocation, this.clients.get("view-users"), false);
        this.invoke(invocation, this.clients.get("manage-realm"), false);
        this.invoke(invocation, this.clients.get("master-manage-realm"), false);
        this.invoke(invocation, this.clients.get("manage-users"), true);
        this.invoke(invocation, this.clients.get("master-manage-users"), true);
    }

    @Test
    public void events() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getRealmEventsConfig();
            }
        }, AdminAuth.Resource.EVENTS, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.updateRealmEventsConfig(new RealmEventsConfigRepresentation());
            }
        }, AdminAuth.Resource.EVENTS, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getEvents();
            }
        }, AdminAuth.Resource.EVENTS, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.getAdminEvents();
            }
        }, AdminAuth.Resource.EVENTS, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearEvents();
            }
        }, AdminAuth.Resource.EVENTS, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clearAdminEvents();
            }
        }, AdminAuth.Resource.EVENTS, true);
    }

    @Test
    public void attackDetection() {
        UserRepresentation newUser = new UserRepresentation();
        newUser.setUsername("attacked");
        newUser.setEnabled(Boolean.valueOf(true));
        this.adminClient.realms().realm(REALM_NAME).users().create(newUser);
        final UserRepresentation user = (UserRepresentation)this.adminClient.realms().realm(REALM_NAME).users().search("attacked").get(0);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.attackDetection().bruteForceUserStatus(user.getId());
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.attackDetection().clearBruteForceForUser(user.getId());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.attackDetection().clearAllBruteForce();
            }
        }, AdminAuth.Resource.USER, true);
        this.adminClient.realms().realm(REALM_NAME).users().get(user.getId()).remove();
    }

    @Test
    public void clients() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().findAll();
            }
        }, AdminAuth.Resource.CLIENT, false, true);
        List l = this.clients.get(AdminRoles.QUERY_CLIENTS).realm(REALM_NAME).clients().findAll();
        Assert.assertThat((Object)l, (Matcher)Matchers.empty());
        l = this.clients.get(AdminRoles.VIEW_CLIENTS).realm(REALM_NAME).clients().findAll();
        Assert.assertThat((Object)l, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        final ClientRepresentation client = (ClientRepresentation)l.get(0);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_USERS)).realm(PermissionsTest.REALM_NAME).clients().create(client));
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_USERS)).realm(PermissionsTest.REALM_NAME).clients().get(client.getId()).toRepresentation();
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_USERS)).realm(PermissionsTest.REALM_NAME).clients().get(client.getId()).update(client);
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_USERS)).realm(PermissionsTest.REALM_NAME).clients().get(client.getId()).remove();
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.convertClientDescription("blahblah");
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.clients().create(ClientBuilder.create().clientId("foo").build()));
            }
        }, AdminAuth.Resource.CLIENT, true);
        final ClientRepresentation foo = (ClientRepresentation)this.adminClient.realms().realm(REALM_NAME).clients().findByClientId("foo").get(0);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).toRepresentation();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getInstallationProvider("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).update(foo);
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).remove();
                realm.clients().create(foo);
                ClientRepresentation temp = (ClientRepresentation)realm.clients().findByClientId("foo").get(0);
                foo.setId(temp.getId());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).generateNewSecret();
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).regenerateRegistrationAccessToken();
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getSecret();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getServiceAccountUser();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).pushRevocation();
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getApplicationSessionCount();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getUserSessions(Integer.valueOf(0), Integer.valueOf(100));
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getOfflineSessionCount();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(100));
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).registerNode(Collections.emptyMap());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).unregisterNode("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).testNodesAvailable();
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getCertficateResource("nosuch").generate();
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getCertficateResource("nosuch").generateAndGetKeystore(new KeyStoreConfig());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getCertficateResource("nosuch").getKeyInfo();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getCertficateResource("nosuch").getKeystore(new KeyStoreConfig());
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getCertficateResource("nosuch").uploadJks(new MultipartFormDataOutput());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getCertficateResource("nosuch").uploadJksCertificate(new MultipartFormDataOutput());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getProtocolMappers().createMapper(Collections.EMPTY_LIST);
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.clients().get(foo.getId()).getProtocolMappers().createMapper(new ProtocolMapperRepresentation()));
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getProtocolMappers().getMapperById("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getProtocolMappers().getMappers();
            }
        }, AdminAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getProtocolMappers().getMappersPerProtocol("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getProtocolMappers().update("nosuch", new ProtocolMapperRepresentation());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getProtocolMappers().delete("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getScopeMappings().getAll();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getScopeMappings().realmLevel().listAll();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getScopeMappings().realmLevel().listEffective();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getScopeMappings().realmLevel().listAvailable();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getScopeMappings().realmLevel().add(Collections.emptyList());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).getScopeMappings().realmLevel().remove(Collections.emptyList());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(UUID.randomUUID().toString()).roles().list();
            }
        }, AdminAuth.Resource.CLIENT, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().create(new RoleRepresentation());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").toRepresentation();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().deleteRole("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").update(new RoleRepresentation());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").addComposites(Collections.emptyList());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").deleteComposites(Collections.emptyList());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").getRoleComposites();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").getRealmRoleComposites();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).roles().get("nosuch").getClientRoleComposites("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFlows();
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getClientAuthenticatorProviders();
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getClientAuthenticatorProviders();
            }
        }, this.clients.get(AdminRoles.VIEW_CLIENTS), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getClientAuthenticatorProviders();
            }
        }, this.clients.get(AdminRoles.MANAGE_CLIENTS), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getClientAuthenticatorProviders();
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getPerClientConfigDescription();
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), true);
    }

    @Test
    public void clientScopes() {
        this.invoke((RealmResource realm) -> realm.clientScopes().findAll(), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> {
            ClientScopeRepresentation scope = new ClientScopeRepresentation();
            scope.setName("scope");
            response.set(realm.clientScopes().create(scope));
        }, AdminAuth.Resource.CLIENT, true);
        ClientScopeRepresentation scope = (ClientScopeRepresentation)this.adminClient.realms().realm(REALM_NAME).clientScopes().findAll().get(0);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).toRepresentation(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).update(scope), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> {
            realm.clientScopes().get(scope.getId()).remove();
            realm.clientScopes().create(scope);
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().getMappers(), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().getMappersPerProtocol("nosuch"), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().getMapperById("nosuch"), AdminAuth.Resource.CLIENT, false, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().update("nosuch", new ProtocolMapperRepresentation()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm, AtomicReference<Response> response) -> response.set(realm.clientScopes().get(scope.getId()).getProtocolMappers().createMapper(new ProtocolMapperRepresentation())), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().createMapper(Collections.emptyList()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getProtocolMappers().delete("nosuch"), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().getAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().listAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().listAvailable(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().listEffective(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().add(Collections.emptyList()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().realmLevel().remove(Collections.emptyList()), AdminAuth.Resource.CLIENT, true);
        ClientRepresentation realmAccessClient = (ClientRepresentation)this.adminClient.realms().realm(REALM_NAME).clients().findByClientId("realm-management").get(0);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).listAll(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).listAvailable(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).listEffective(), AdminAuth.Resource.CLIENT, false);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).add(Collections.emptyList()), AdminAuth.Resource.CLIENT, true);
        this.invoke((RealmResource realm) -> realm.clientScopes().get(scope.getId()).getScopeMappings().clientLevel(realmAccessClient.getId()).remove(Collections.emptyList()), AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_USERS)).realm(PermissionsTest.REALM_NAME).clientScopes().findAll();
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), false);
    }

    @Test
    public void clientInitialAccess() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientInitialAccess().list();
            }
        }, AdminAuth.Resource.CLIENT, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientInitialAccess().create(new ClientInitialAccessCreatePresentation());
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clientInitialAccess().delete("nosuch");
            }
        }, AdminAuth.Resource.CLIENT, true);
    }

    @Test
    public void clientAuthorization() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setClientId("foo-authz");
        this.adminClient.realms().realm(REALM_NAME).clients().create(newClient);
        final ClientRepresentation foo = (ClientRepresentation)this.adminClient.realms().realm(REALM_NAME).clients().findByClientId("foo-authz").get(0);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                foo.setServiceAccountsEnabled(Boolean.valueOf(true));
                foo.setAuthorizationServicesEnabled(Boolean.valueOf(true));
                realm.clients().get(foo.getId()).update(foo);
            }
        }, AdminAuth.Resource.CLIENT, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.clients().get(foo.getId()).authorization().getSettings();
            }
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                ResourceServerRepresentation settings = authorization.getSettings();
                authorization.update(settings);
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.resources().resources();
            }
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.scopes().scopes();
            }
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.policies().policies();
            }
        }, AdminAuth.Resource.AUTHORIZATION, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                response.set(authorization.resources().create(new ResourceRepresentation("Test", Collections.emptySet())));
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                response.set(authorization.scopes().create(new ScopeRepresentation("Test")));
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                ResourcePermissionRepresentation representation = new ResourcePermissionRepresentation();
                representation.setName("Test PermissionsTest");
                representation.addResource("Default Resource");
                response.set(authorization.permissions().resource().create(representation));
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.resources().resource("nosuch").update(new ResourceRepresentation());
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.scopes().scope("nosuch").update(new ScopeRepresentation());
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.policies().policy("nosuch").update(new PolicyRepresentation());
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.resources().resource("nosuch").remove();
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.scopes().scope("nosuch").remove();
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                AuthorizationResource authorization = realm.clients().get(foo.getId()).authorization();
                authorization.policies().policy("nosuch").remove();
            }
        }, AdminAuth.Resource.AUTHORIZATION, true);
    }

    @Test
    public void roles() {
        final RoleRepresentation newRole = new RoleRepresentation();
        newRole.setName("sample-role");
        this.adminClient.realm(REALM_NAME).roles().create(newRole);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().list();
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.CREATE_CLIENT)).realm(PermissionsTest.REALM_NAME).roles().list();
            }
        }, this.clients.get(AdminRoles.CREATE_CLIENT), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").toRepresentation();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").update(newRole);
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().create(new RoleRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().deleteRole("sample-role");
                realm.roles().create(newRole);
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").getRoleComposites();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").addComposites(Collections.emptyList());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").deleteComposites(Collections.emptyList());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").getRoleComposites();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").getRealmRoleComposites();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.roles().get("sample-role").getClientRoleComposites(KeycloakModelUtils.generateId());
            }
        }, AdminAuth.Resource.REALM, false);
        this.adminClient.realms().realm(REALM_NAME).roles().deleteRole("sample-role");
    }

    @Test
    public void flows() throws Exception {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFormProviders();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorProviders();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getClientAuthenticatorProviders();
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFormActionProviders();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFlows();
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.flows().createFlow(new AuthenticationFlowRepresentation()));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getFlow("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().deleteFlow("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.flows().copy("nosuch", Collections.emptyMap()));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().addExecutionFlow("nosuch", Collections.emptyMap());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().addExecution("nosuch", Collections.emptyMap());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getExecutions("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().updateExecutions("nosuch", new AuthenticationExecutionInfoRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                AuthenticationExecutionRepresentation rep = new AuthenticationExecutionRepresentation();
                rep.setAuthenticator("auth-cookie");
                rep.setRequirement("CONDITIONAL");
                response.set(realm.flows().addExecution(rep));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().raisePriority("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().lowerPriority("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().removeExecution("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.flows().newExecutionConfig("nosuch", new AuthenticatorConfigRepresentation()));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorConfig("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getUnregisteredRequiredActions();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().registerRequiredAction(new RequiredActionProviderSimpleRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getRequiredActions();
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getRequiredAction("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().removeRequiredAction("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().updateRequiredAction("nosuch", new RequiredActionProviderRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorConfigDescription("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getPerClientConfigDescription();
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getAuthenticatorConfig("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().removeAuthenticatorConfig("nosuch");
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().updateAuthenticatorConfig("nosuch", new AuthenticatorConfigRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.VIEW_REALM)).realm(PermissionsTest.REALM_NAME).flows().getPerClientConfigDescription();
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.VIEW_REALM)).realm(PermissionsTest.REALM_NAME).flows().getClientAuthenticatorProviders();
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.VIEW_REALM)).realm(PermissionsTest.REALM_NAME).flows().getRequiredActions();
            }
        }, this.adminClient, true);
        this.adminClient.realm(REALM_NAME).remove();
        this.recreatePermissionRealm();
    }

    @Test
    public void rolesById() {
        final RoleRepresentation newRole = new RoleRepresentation();
        newRole.setName("role-by-id");
        this.adminClient.realm(REALM_NAME).roles().create(newRole);
        final RoleRepresentation role = this.adminClient.realm(REALM_NAME).roles().get("role-by-id").toRepresentation();
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRole(role.getId());
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().updateRole(role.getId(), role);
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().deleteRole(role.getId());
                realm.roles().create(newRole);
                RoleRepresentation temp = realm.roles().get("role-by-id").toRepresentation();
                role.setId(temp.getId());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRoleComposites(role.getId());
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().addComposites(role.getId(), Collections.emptyList());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().deleteComposites(role.getId(), Collections.emptyList());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRoleComposites(role.getId());
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getRealmRoleComposites(role.getId());
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.rolesById().getClientRoleComposites(role.getId(), KeycloakModelUtils.generateId());
            }
        }, AdminAuth.Resource.REALM, false, true);
        this.adminClient.realm(REALM_NAME).roles().deleteRole("role-by-id");
    }

    @Test
    public void groups() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().groups();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                GroupRepresentation group = new GroupRepresentation();
                group.setName("mygroup");
                response.set(realm.groups().add(group));
            }
        }, AdminAuth.Resource.USER, true);
        final GroupRepresentation group = this.adminClient.realms().realm(REALM_NAME).getGroupByPath("mygroup");
        final ClientRepresentation realmAccessClient = (ClientRepresentation)this.adminClient.realms().realm(REALM_NAME).clients().findByClientId("realm-management").get(0);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.CREATE_CLIENT)).realm(PermissionsTest.REALM_NAME).groups().groups();
            }
        }, this.clients.get(AdminRoles.CREATE_CLIENT), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).toRepresentation();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).update(group);
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).members(Integer.valueOf(0), Integer.valueOf(100));
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                GroupRepresentation subgroup = new GroupRepresentation();
                subgroup.setName("sub");
                response.set(realm.groups().group(group.getId()).subGroup(subgroup));
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().getAll();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().realmLevel().listAll();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().realmLevel().listEffective();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().realmLevel().listAvailable();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().realmLevel().add(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().realmLevel().remove(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).listAll();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).listEffective();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).listAvailable();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).add(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).roles().clientLevel(realmAccessClient.getId()).remove(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.groups().group(group.getId()).remove();
                group.setId(null);
                realm.groups().add(group);
                GroupRepresentation temp = realm.getGroupByPath("mygroup");
                group.setId(temp.getId());
            }
        }, AdminAuth.Resource.USER, true);
    }

    @Test
    public void users() {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.users().create(UserBuilder.create().username("testuser").build()));
            }
        }, AdminAuth.Resource.USER, true);
        final UserRepresentation user = (UserRepresentation)this.adminClient.realms().realm(REALM_NAME).users().search("testuser").get(0);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).remove();
                realm.users().create(user);
                UserRepresentation temp = (UserRepresentation)realm.users().search("testuser").get(0);
                user.setId(temp.getId());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).toRepresentation();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).update(user);
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().count();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).getUserSessions();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).getOfflineSessions(KeycloakModelUtils.generateId());
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).getFederatedIdentity();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.users().get(user.getId()).addFederatedIdentity("nosuch", FederatedIdentityBuilder.create().identityProvider("nosuch").userId("nosuch").userName("nosuch").build()));
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).removeFederatedIdentity("nosuch");
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).getConsents();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).revokeConsent("testclient");
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).logout();
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).resetPassword(CredentialBuilder.create().password("password").build());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                CredentialRepresentation totpCredential = realm.users().get(user.getId()).credentials().stream().filter(c -> "otp".equals(c.getType())).findFirst().orElse(null);
                if (totpCredential != null) {
                    realm.users().get(user.getId()).removeCredential(totpCredential.getId());
                } else {
                    realm.users().get(user.getId()).removeCredential("123");
                }
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).resetPasswordEmail();
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).executeActionsEmail(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).sendVerifyEmail();
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).groups();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).leaveGroup("nosuch");
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).joinGroup("nosuch");
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().getAll();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().realmLevel().listAll();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().realmLevel().listAvailable();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().realmLevel().listEffective();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().realmLevel().add(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().realmLevel().remove(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        final ClientRepresentation realmAccessClient = (ClientRepresentation)this.adminClient.realms().realm(REALM_NAME).clients().findByClientId("realm-management").get(0);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).listAll();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).listAvailable();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).listEffective();
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).add(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).roles().clientLevel(realmAccessClient.getId()).remove(Collections.emptyList());
            }
        }, AdminAuth.Resource.USER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().search("foo", Integer.valueOf(0), Integer.valueOf(1));
            }
        }, AdminAuth.Resource.USER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_CLIENTS)).realm(PermissionsTest.REALM_NAME).users().list();
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_CLIENTS)).realm(PermissionsTest.REALM_NAME).users().create(user));
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_CLIENTS)).realm(PermissionsTest.REALM_NAME).users().search("test");
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).toRepresentation();
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).remove();
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.users().get(user.getId()).update(user);
            }
        }, this.clients.get(AdminRoles.QUERY_CLIENTS), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.flows().getRequiredActions();
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                ((Keycloak)PermissionsTest.this.clients.get(AdminRoles.QUERY_USERS)).realm(PermissionsTest.REALM_NAME).clients().findAll();
            }
        }, this.clients.get(AdminRoles.QUERY_USERS), true);
    }

    @Test
    public void identityProviders() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().findAll();
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.identityProviders().create(IdentityProviderBuilder.create().providerId("oidc").displayName("nosuch-foo").alias("foo").setAttribute("clientId", "foo").setAttribute("clientSecret", "foo").build()));
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").toRepresentation();
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").update(new IdentityProviderRepresentation());
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.identityProviders().get("nosuch").export("saml"));
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").remove();
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.identityProviders().get("nosuch").addMapper(new IdentityProviderMapperRepresentation()));
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").delete("nosuch");
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").getMappers();
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").getMapperById("nosuch");
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().get("nosuch").getMapperTypes();
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().importFrom(Collections.emptyMap());
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.identityProviders().importFrom(new MultipartFormDataOutput());
            }
        }, AdminAuth.Resource.IDENTITY_PROVIDER, true);
    }

    @Test
    public void components() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.components().query();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.components().query("nosuch");
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                response.set(realm.components().add(new ComponentRepresentation()));
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.components().component("nosuch").toRepresentation();
            }
        }, AdminAuth.Resource.REALM, false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.components().component("nosuch").update(new ComponentRepresentation());
            }
        }, AdminAuth.Resource.REALM, true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.components().component("nosuch").remove();
            }
        }, AdminAuth.Resource.REALM, true);
    }

    @Test
    public void partialExport() {
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(false));
            }
        }, this.clients.get("view-realm"), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.partialExport(Boolean.valueOf(true), Boolean.valueOf(true));
            }
        }, this.clients.get("multi"), true);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.partialExport(Boolean.valueOf(true), Boolean.valueOf(false));
            }
        }, this.clients.get("view-realm"), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(true));
            }
        }, this.clients.get("view-realm"), false);
        this.invoke(new Invocation(){

            @Override
            public void invoke(RealmResource realm) {
                realm.partialExport(Boolean.valueOf(false), Boolean.valueOf(false));
            }
        }, this.clients.get("none"), false);
    }

    private void invoke(final Invocation invocation, AdminAuth.Resource resource, boolean manage) {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, resource, manage);
    }

    private void invoke(final Invocation invocation, AdminAuth.Resource resource, boolean manage, boolean skipDifferentRole) {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, resource, manage, skipDifferentRole);
    }

    private void invoke(InvocationWithResponse invocation, AdminAuth.Resource resource, boolean manage) {
        this.invoke(invocation, resource, manage, false);
    }

    private void invoke(InvocationWithResponse invocation, AdminAuth.Resource resource, boolean manage, boolean skipDifferentRole) {
        String viewRole = this.getViewRole(resource);
        String manageRole = this.getManageRole(resource);
        String differentViewRole = this.getDifferentViewRole(resource);
        String differentManageRole = this.getDifferentManageRole(resource);
        this.invoke(invocation, this.clients.get("master-none"), false);
        this.invoke(invocation, this.clients.get("master-admin"), true);
        this.invoke(invocation, this.clients.get("master-" + viewRole), !manage);
        this.invoke(invocation, this.clients.get("master-" + manageRole), true);
        if (!skipDifferentRole) {
            this.invoke(invocation, this.clients.get("master-" + differentViewRole), false);
            this.invoke(invocation, this.clients.get("master-" + differentManageRole), false);
        }
        this.invoke(invocation, this.clients.get("none"), false);
        this.invoke(invocation, this.clients.get(AdminRoles.REALM_ADMIN), true);
        this.invoke(invocation, this.clients.get(viewRole), !manage);
        this.invoke(invocation, this.clients.get(manageRole), true);
        if (!skipDifferentRole) {
            this.invoke(invocation, this.clients.get(differentViewRole), false);
            this.invoke(invocation, this.clients.get(differentManageRole), false);
        }
        this.invoke(invocation, this.clients.get("REALM2"), false);
    }

    private void invoke(final Invocation invocation, Keycloak client, boolean expectSuccess) {
        this.invoke(new InvocationWithResponse(){

            @Override
            public void invoke(RealmResource realm, AtomicReference<Response> response) {
                invocation.invoke(realm);
            }
        }, client, expectSuccess);
    }

    private void invoke(InvocationWithResponse invocation, Keycloak client, boolean expectSuccess) {
        int statusCode;
        try {
            AtomicReference<Response> responseReference = new AtomicReference<Response>();
            invocation.invoke(client.realm(REALM_NAME), responseReference);
            Response response = responseReference.get();
            statusCode = response != null ? response.getStatus() : 200;
        }
        catch (ClientErrorException e) {
            statusCode = e.getResponse().getStatus();
        }
        if (expectSuccess) {
            if (statusCode != 200 && statusCode != 201 && statusCode != 204 && statusCode != 404 && statusCode != 409 && statusCode != 400) {
                org.junit.Assert.fail((String)("Expected permitted, but was " + statusCode));
            }
        } else if (statusCode != 403) {
            org.junit.Assert.fail((String)("Expected 403, but was " + statusCode));
        }
    }

    private String getViewRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.VIEW_CLIENTS;
            }
            case USER: {
                return AdminRoles.VIEW_USERS;
            }
            case REALM: {
                return AdminRoles.VIEW_REALM;
            }
            case EVENTS: {
                return AdminRoles.VIEW_EVENTS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.VIEW_IDENTITY_PROVIDERS;
            }
            case AUTHORIZATION: {
                return AdminRoles.VIEW_AUTHORIZATION;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private String getManageRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.MANAGE_CLIENTS;
            }
            case USER: {
                return AdminRoles.MANAGE_USERS;
            }
            case REALM: {
                return AdminRoles.MANAGE_REALM;
            }
            case EVENTS: {
                return AdminRoles.MANAGE_EVENTS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.MANAGE_IDENTITY_PROVIDERS;
            }
            case AUTHORIZATION: {
                return AdminRoles.MANAGE_AUTHORIZATION;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private String getDifferentViewRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.VIEW_USERS;
            }
            case USER: {
                return AdminRoles.VIEW_CLIENTS;
            }
            case REALM: {
                return AdminRoles.VIEW_EVENTS;
            }
            case EVENTS: {
                return AdminRoles.VIEW_IDENTITY_PROVIDERS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.VIEW_REALM;
            }
            case AUTHORIZATION: {
                return AdminRoles.VIEW_IDENTITY_PROVIDERS;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private String getDifferentManageRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return AdminRoles.MANAGE_USERS;
            }
            case USER: {
                return AdminRoles.MANAGE_CLIENTS;
            }
            case REALM: {
                return AdminRoles.MANAGE_EVENTS;
            }
            case EVENTS: {
                return AdminRoles.MANAGE_IDENTITY_PROVIDERS;
            }
            case IDENTITY_PROVIDER: {
                return AdminRoles.MANAGE_REALM;
            }
            case AUTHORIZATION: {
                return AdminRoles.MANAGE_IDENTITY_PROVIDERS;
            }
        }
        throw new RuntimeException("Unexpected resouce");
    }

    private void assertGettersEmpty(RealmRepresentation rep) {
        this.assertGettersEmpty(rep, "getRealm", "getAttributesOrEmpty");
    }

    private void assertGettersEmpty(ClientRepresentation rep) {
        this.assertGettersEmpty(rep, "getId", "getClientId", "getDescription");
    }

    private void assertGettersEmpty(Object rep, String ... ignore) {
        List<String> ignoreList = Arrays.asList(ignore);
        for (Method m : rep.getClass().getDeclaredMethods()) {
            if (m.getParameters().length != 0 || !m.getName().startsWith("get") || ignoreList.contains(m.getName())) continue;
            try {
                Object o = m.invoke(rep, new Object[0]);
                org.junit.Assert.assertNull((String)("Expected " + m.getName() + " to be null"), (Object)o);
            }
            catch (Exception e) {
                org.junit.Assert.fail((String)e.getMessage());
            }
        }
    }

    public static interface InvocationWithResponse {
        public void invoke(RealmResource var1, AtomicReference<Response> var2);
    }

    public static interface Invocation {
        public void invoke(RealmResource var1);
    }
}

