/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.ClientManager;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.Cookie;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ImpersonationTest
extends AbstractKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    private String impersonatedUserId;

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name("test").testEventListener();
        realm.client(ClientBuilder.create().clientId("myclient").publicClient().directAccessGrants());
        this.impersonatedUserId = KeycloakModelUtils.generateId();
        realm.user(UserBuilder.create().id(this.impersonatedUserId).username("test-user@localhost"));
        realm.user(UserBuilder.create().username("realm-admin").password("password").role("realm-management", AdminRoles.REALM_ADMIN));
        realm.user(UserBuilder.create().username("impersonator").password("password").role("realm-management", ImpersonationConstants.IMPERSONATION_ROLE).role("realm-management", AdminRoles.VIEW_USERS));
        realm.user(UserBuilder.create().username("bad-impersonator").password("password").role("realm-management", AdminRoles.MANAGE_USERS));
        testRealms.add(realm.build());
    }

    @BeforeClass
    public static void enabled() {
        Assume.assumeFalse(("impersonation".equals(System.getProperty("feature.name")) && "disabled".equals(System.getProperty("feature.value")) ? 1 : 0) != 0);
    }

    @Before
    public void beforeTest() {
        this.impersonatedUserId = ApiUtil.findUserByUsername((RealmResource)this.adminClient.realm("test"), (String)"test-user@localhost").getId();
    }

    @Test
    public void testImpersonateByMasterAdmin() {
        this.testSuccessfulImpersonation("admin", Config.getAdminRealm());
    }

    @Test
    public void testImpersonateByMasterImpersonator() {
        String userId;
        try (Response response = this.adminClient.realm("master").users().create(UserBuilder.create().username("master-impersonator").build());){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        UserResource user = this.adminClient.realm("master").users().get(userId);
        user.resetPassword(CredentialBuilder.create().password("password").build());
        ClientResource testRealmClient = ApiUtil.findClientResourceByClientId((RealmResource)this.adminClient.realm("master"), (String)"test-realm");
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(ApiUtil.findClientRoleByName((ClientResource)testRealmClient, (String)AdminRoles.VIEW_USERS).toRepresentation());
        roles.add(ApiUtil.findClientRoleByName((ClientResource)testRealmClient, (String)ImpersonationConstants.IMPERSONATION_ROLE).toRepresentation());
        user.roles().clientLevel(testRealmClient.toRepresentation().getId()).add(roles);
        this.testSuccessfulImpersonation("master-impersonator", Config.getAdminRealm());
        this.adminClient.realm("master").users().get(userId).remove();
    }

    @Test
    public void testImpersonateByTestImpersonator() {
        this.testSuccessfulImpersonation("impersonator", "test");
    }

    @Test
    public void testImpersonateByTestAdmin() {
        this.testSuccessfulImpersonation("realm-admin", "test");
    }

    @Test
    public void testImpersonateByTestBadImpersonator() {
        this.testForbiddenImpersonation("bad-impersonator", "test");
    }

    @Test
    public void testImpersonateByMastertBadImpersonator() {
        String userId;
        try (Response response = this.adminClient.realm("master").users().create(UserBuilder.create().username("master-bad-impersonator").build());){
            userId = ApiUtil.getCreatedId((Response)response);
        }
        this.adminClient.realm("master").users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        this.testForbiddenImpersonation("master-bad-impersonator", Config.getAdminRealm());
        this.adminClient.realm("master").users().get(userId).remove();
    }

    @Test
    public void testImpersonationWorksWhenAuthenticationSessionExists() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        Response resp = realm.clients().create(ClientBuilder.create().clientId("test-app").addRedirectUri(OAuthClient.APP_ROOT + "/*").build());
        resp.close();
        String loginFormUrl = this.oauth.getLoginFormUrl();
        this.driver.navigate().to(loginFormUrl);
        this.loginPage.assertCurrent();
        for (Cookie cookie : this.testSuccessfulImpersonation("realm-admin", "test")) {
            this.driver.manage().addCookie(cookie);
        }
        this.driver.navigate().to(loginFormUrl);
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)"/auth/realms/master/app/auth", (Object)new URL(DroneUtils.getCurrentDriver().getCurrentUrl()).getPath());
        ApiUtil.findClientByClientId((RealmResource)realm, (String)"test-app").remove();
    }

    @Test
    public void testImpersonationBySameRealmServiceAccount() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("test");
        ClientRepresentation clientApp = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-cl").secret("password").serviceAccountsEnabled(true).build();
        clientApp.setServiceAccountsEnabled(Boolean.valueOf(true));
        realm.clients().create(clientApp);
        UserRepresentation user = ClientManager.realm(this.adminClient.realm("test")).clientId("service-account-cl").getServiceAccountUser();
        user.setServiceAccountClientId("service-account-cl");
        ApiUtil.assignClientRoles((RealmResource)realm, (String)user.getId(), (String)"realm-management", (String[])new String[]{ImpersonationConstants.IMPERSONATION_ROLE});
        this.testSuccessfulServiceAccountImpersonation(user, "test");
        ApiUtil.findClientByClientId((RealmResource)realm, (String)"service-account-cl").remove();
    }

    @Test
    public void testImpersonationByMasterRealmServiceAccount() throws Exception {
        RealmResource realm = this.adminClient.realms().realm("master");
        ClientRepresentation clientApp = ClientBuilder.create().id(KeycloakModelUtils.generateId()).clientId("service-account-cl").secret("password").serviceAccountsEnabled(true).build();
        clientApp.setServiceAccountsEnabled(Boolean.valueOf(true));
        realm.clients().create(clientApp);
        UserRepresentation user = ClientManager.realm(this.adminClient.realm("master")).clientId("service-account-cl").getServiceAccountUser();
        user.setServiceAccountClientId("service-account-cl");
        ApiUtil.assignRealmRoles((RealmResource)realm, (String)user.getId(), (String[])new String[]{"admin"});
        this.testSuccessfulServiceAccountImpersonation(user, "master");
        ApiUtil.findClientByClientId((RealmResource)realm, (String)"service-account-cl").remove();
    }

    protected Set<Cookie> testSuccessfulImpersonation(String admin, String adminRealm) {
        ResteasyClientBuilder resteasyClientBuilder = new ResteasyClientBuilder();
        resteasyClientBuilder.connectionPoolSize(10);
        resteasyClientBuilder.httpEngine(AdminClientUtil.getCustomClientHttpEngine((ResteasyClientBuilder)resteasyClientBuilder, (int)10, null));
        ResteasyClient resteasyClient = resteasyClientBuilder.build();
        try (Keycloak client = this.login(admin, adminRealm, resteasyClient);){
            Set<Cookie> set = this.impersonate(client, admin, adminRealm);
            return set;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Cookie> impersonate(Keycloak adminClient, String admin, String adminRealm) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();){
            HttpUriRequest req = RequestBuilder.post().setUri(OAuthClient.AUTH_SERVER_ROOT + "/admin/realms/test/users/" + this.impersonatedUserId + "/impersonation").addHeader("Authorization", "Bearer " + adminClient.tokenManager().getAccessTokenString()).build();
            CloseableHttpResponse res = httpClient.execute(req);
            String resBody = EntityUtils.toString((HttpEntity)res.getEntity());
            Assert.assertNotNull((Object)resBody);
            Assert.assertTrue((boolean)resBody.contains("redirect"));
            this.events.expect(EventType.IMPERSONATE).session(AssertEvents.isUUID()).user(this.impersonatedUserId).detail("impersonator", admin).detail("impersonator_realm", adminRealm).client((String)null).assertEvent();
            String userId = this.impersonatedUserId;
            UserSessionNotesHolder notesHolder = (UserSessionNotesHolder)this.testingClient.server("test").fetch((FetchOnServer & Serializable)session -> {
                RealmModel realm = session.realms().getRealmByName("test");
                UserModel user = session.users().getUserById(realm, userId);
                UserSessionModel userSession = (UserSessionModel)session.sessions().getUserSessionsStream(realm, user).findFirst().get();
                return new UserSessionNotesHolder(userSession.getNotes());
            }, UserSessionNotesHolder.class);
            Map<String, String> notes = notesHolder.getNotes();
            Assert.assertNotNull((Object)notes.get(ImpersonationSessionNote.IMPERSONATOR_ID.toString()));
            Assert.assertEquals((Object)admin, (Object)notes.get(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString()));
            Set<Cookie> cookies = cookieStore.getCookies().stream().filter(c -> c.getName().startsWith("KEYCLOAK_IDENTITY")).map(c -> new Cookie(c.getName(), c.getValue(), c.getDomain(), c.getPath(), c.getExpiryDate(), c.isSecure(), true)).collect(Collectors.toSet());
            Assert.assertNotNull(cookies);
            Assert.assertThat(cookies, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
            Set<Cookie> set = cookies;
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void testForbiddenImpersonation(String admin, String adminRealm) {
        try (Keycloak client = this.createAdminClient(adminRealm, this.establishClientId(adminRealm), admin);){
            client.realms().realm("test").users().get(this.impersonatedUserId).impersonate();
            Assert.fail((String)"Expected ClientErrorException wasn't thrown.");
        }
        catch (ClientErrorException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"403 Forbidden"));
        }
    }

    Keycloak createAdminClient(String realm, String clientId, String username) {
        return this.createAdminClient(realm, clientId, username, null, null);
    }

    String establishClientId(String realm) {
        return realm.equals("master") ? "admin-cli" : "myclient";
    }

    Keycloak createAdminClient(String realm, String clientId, String username, String password, ResteasyClient resteasyClient) {
        if (password == null) {
            password = username.equals("admin") ? "admin" : "password";
        }
        return KeycloakBuilder.builder().serverUrl(ServerURLs.getAuthServerContextRoot() + "/auth").realm(realm).username(username).password(password).clientId(clientId).resteasyClient(resteasyClient).build();
    }

    private Keycloak login(String username, String realm, ResteasyClient resteasyClient) {
        String clientId = this.establishClientId(realm);
        Keycloak client = this.createAdminClient(realm, clientId, username, null, resteasyClient);
        client.tokenManager().grantToken();
        if (!"master".equals(realm)) {
            EventRepresentation e = this.events.poll();
            Assert.assertEquals((String)"Event type", (Object)EventType.LOGIN.toString(), (Object)e.getType());
            Assert.assertEquals((String)"Client ID", (Object)clientId, (Object)e.getClientId());
            Assert.assertEquals((String)"Username", (Object)username, e.getDetails().get("username"));
        }
        return client;
    }

    protected Set<Cookie> testSuccessfulServiceAccountImpersonation(UserRepresentation serviceAccount, String serviceAccountRealm) {
        ResteasyClientBuilder resteasyClientBuilder = new ResteasyClientBuilder();
        resteasyClientBuilder.connectionPoolSize(10);
        resteasyClientBuilder.httpEngine(AdminClientUtil.getCustomClientHttpEngine((ResteasyClientBuilder)resteasyClientBuilder, (int)10, null));
        ResteasyClient resteasyClient = resteasyClientBuilder.build();
        try (Keycloak client = this.loginServiceAccount(serviceAccount, serviceAccountRealm, resteasyClient);){
            Set<Cookie> set = this.impersonateServiceAccount(client);
            return set;
        }
    }

    private Keycloak loginServiceAccount(UserRepresentation serviceAccount, String serviceAccountRealm, ResteasyClient resteasyClient) {
        Keycloak client = this.createServiceAccountClient(serviceAccountRealm, serviceAccount, resteasyClient);
        client.tokenManager().getAccessToken();
        return client;
    }

    Keycloak createServiceAccountClient(String serviceAccountRealm, UserRepresentation serviceAccount, ResteasyClient resteasyClient) {
        return KeycloakBuilder.builder().serverUrl(ServerURLs.getAuthServerContextRoot() + "/auth").realm(serviceAccountRealm).clientId(serviceAccount.getServiceAccountClientId()).clientSecret("password").grantType("client_credentials").resteasyClient(resteasyClient).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<Cookie> impersonateServiceAccount(Keycloak adminClient) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();){
            HttpUriRequest req = RequestBuilder.post().setUri(OAuthClient.AUTH_SERVER_ROOT + "/admin/realms/test/users/" + this.impersonatedUserId + "/impersonation").addHeader("Authorization", "Bearer " + adminClient.tokenManager().getAccessTokenString()).build();
            CloseableHttpResponse res = httpClient.execute(req);
            String resBody = EntityUtils.toString((HttpEntity)res.getEntity());
            Assert.assertNotNull((Object)resBody);
            Assert.assertTrue((boolean)resBody.contains("redirect"));
            Set<Cookie> cookies = cookieStore.getCookies().stream().filter(c -> c.getName().startsWith("KEYCLOAK_IDENTITY")).map(c -> new Cookie(c.getName(), c.getValue(), c.getDomain(), c.getPath(), c.getExpiryDate(), c.isSecure(), true)).collect(Collectors.toSet());
            Assert.assertNotNull(cookies);
            Assert.assertThat(cookies, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
            Set<Cookie> set = cookies;
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class UserSessionNotesHolder {
        private Map<String, String> notes = new HashMap<String, String>();

        public UserSessionNotesHolder() {
        }

        public UserSessionNotesHolder(Map<String, String> notes) {
            this.notes = notes;
        }

        public void setNotes(Map<String, String> notes) {
            this.notes = notes;
        }

        public Map<String, String> getNotes() {
            return this.notes;
        }
    }
}

