/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import javax.ws.rs.ServerErrorException;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;

public class ImpersonationDisabledTest
extends AbstractAdminTest {
    public static boolean IMPERSONATION_DISABLED = "impersonation".equals(System.getProperty("feature.name")) && "disabled".equals(System.getProperty("feature.value"));

    @BeforeClass
    public static void enabled() {
        Assume.assumeTrue((boolean)IMPERSONATION_DISABLED);
    }

    @Test
    public void testImpersonationDisabled() {
        String impersonatedUserId = ((UserRepresentation)this.adminClient.realm("test").users().search("test-user@localhost", Integer.valueOf(0), Integer.valueOf(1)).get(0)).getId();
        try {
            this.log.debug((Object)"--Expected javax.ws.rs.WebApplicationException--");
            this.adminClient.realms().realm("test").users().get(impersonatedUserId).impersonate();
        }
        catch (ServerErrorException e) {
            Assert.assertEquals((long)Response.Status.NOT_IMPLEMENTED.getStatusCode(), (long)e.getResponse().getStatus());
            return;
        }
        Assert.fail((String)"Feature impersonation should be disabled.");
    }
}

