/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationConstants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminClientUtil;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class IllegalAdminUpgradeTest
extends AbstractKeycloakTest {
    public static final String CLIENT_NAME = "application";

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setId("test");
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealms.add(testRealmRep);
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    public static void setupUsers(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        RealmModel master = session.realms().getRealmByName("master");
        ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
        ClientModel realmMasterAdminClient = realm.getMasterAdminClient();
        RoleModel realmManageUsers = realmAdminClient.getRole(AdminRoles.MANAGE_USERS);
        RoleModel masterManageUsers = realmMasterAdminClient.getRole(AdminRoles.MANAGE_USERS);
        RoleModel masterMasterManageUSers = master.getMasterAdminClient().getRole(AdminRoles.MANAGE_USERS);
        UserModel realmUser = session.users().addUser(realm, "userAdmin");
        realmUser.grantRole(realmManageUsers);
        realmUser.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, realmUser, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel masterUser = session.users().addUser(master, "userAdmin");
        masterUser.grantRole(masterManageUsers);
        masterUser.setEnabled(true);
        session.userCredentialManager().updateCredential(master, masterUser, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel masterAdmin = session.users().addUser(master, "masterAdmin");
        masterAdmin.grantRole(masterMasterManageUSers);
        masterAdmin.setEnabled(true);
        session.userCredentialManager().updateCredential(master, masterAdmin, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel user = session.users().addUser(master, "user");
        user.grantRole(masterManageUsers);
        user.setEnabled(true);
        session.userCredentialManager().updateCredential(master, user, (CredentialInput)UserCredentialModel.password((String)"password"));
        user = session.users().addUser(realm, "user");
        user.grantRole(realmManageUsers);
        user.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, user, (CredentialInput)UserCredentialModel.password((String)"password"));
    }

    public void testConsole() throws Exception {
        this.testingClient.server().run(IllegalAdminUpgradeTest::setupUsers);
        Thread.sleep(10000000L);
    }

    @Test
    public void testRestEvaluation() throws Exception {
        this.testingClient.server().run(IllegalAdminUpgradeTest::setupUsers);
        UserRepresentation realmUserAdmin = (UserRepresentation)this.adminClient.realm("test").users().search("userAdmin").get(0);
        UserRepresentation masterUserAdmin = (UserRepresentation)this.adminClient.realm("master").users().search("userAdmin").get(0);
        UserRepresentation realmUser = (UserRepresentation)this.adminClient.realm("test").users().search("user").get(0);
        UserRepresentation masterUser = (UserRepresentation)this.adminClient.realm("master").users().search("user").get(0);
        ClientRepresentation realmAdminClient = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId("realm-management").get(0);
        RoleRepresentation realmManageAuthorization = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.MANAGE_AUTHORIZATION).toRepresentation();
        RoleRepresentation realmViewAuthorization = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.VIEW_AUTHORIZATION).toRepresentation();
        RoleRepresentation realmManageClients = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.MANAGE_CLIENTS).toRepresentation();
        RoleRepresentation realmViewClients = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.VIEW_CLIENTS).toRepresentation();
        RoleRepresentation realmManageEvents = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.MANAGE_EVENTS).toRepresentation();
        RoleRepresentation realmViewEvents = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.VIEW_EVENTS).toRepresentation();
        RoleRepresentation realmManageIdentityProviders = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.MANAGE_IDENTITY_PROVIDERS).toRepresentation();
        RoleRepresentation realmViewIdentityProviders = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.VIEW_IDENTITY_PROVIDERS).toRepresentation();
        RoleRepresentation realmManageRealm = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.MANAGE_REALM).toRepresentation();
        RoleRepresentation realmViewRealm = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.VIEW_REALM).toRepresentation();
        RoleRepresentation realmImpersonate = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(ImpersonationConstants.IMPERSONATION_ROLE).toRepresentation();
        RoleRepresentation realmManageUsers = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.MANAGE_USERS).toRepresentation();
        RoleRepresentation realmViewUsers = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.VIEW_USERS).toRepresentation();
        RoleRepresentation realmQueryUsers = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.QUERY_USERS).toRepresentation();
        RoleRepresentation realmQueryClients = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.QUERY_CLIENTS).toRepresentation();
        RoleRepresentation realmQueryGroups = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.QUERY_GROUPS).toRepresentation();
        RoleRepresentation realmAdmin = this.adminClient.realm("test").clients().get(realmAdminClient.getId()).roles().get(AdminRoles.REALM_ADMIN).toRepresentation();
        ClientRepresentation masterClient = (ClientRepresentation)this.adminClient.realm("master").clients().findByClientId("test-realm").get(0);
        RoleRepresentation masterManageAuthorization = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.MANAGE_AUTHORIZATION).toRepresentation();
        RoleRepresentation masterViewAuthorization = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.VIEW_AUTHORIZATION).toRepresentation();
        RoleRepresentation masterManageClients = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.MANAGE_CLIENTS).toRepresentation();
        RoleRepresentation masterViewClients = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.VIEW_CLIENTS).toRepresentation();
        RoleRepresentation masterManageEvents = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.MANAGE_EVENTS).toRepresentation();
        RoleRepresentation masterViewEvents = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.VIEW_EVENTS).toRepresentation();
        RoleRepresentation masterManageIdentityProviders = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.MANAGE_IDENTITY_PROVIDERS).toRepresentation();
        RoleRepresentation masterViewIdentityProviders = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.VIEW_IDENTITY_PROVIDERS).toRepresentation();
        RoleRepresentation masterManageRealm = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.MANAGE_REALM).toRepresentation();
        RoleRepresentation masterViewRealm = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.VIEW_REALM).toRepresentation();
        RoleRepresentation masterImpersonate = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(ImpersonationConstants.IMPERSONATION_ROLE).toRepresentation();
        RoleRepresentation masterManageUsers = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.MANAGE_USERS).toRepresentation();
        RoleRepresentation masterViewUsers = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.VIEW_USERS).toRepresentation();
        RoleRepresentation masterQueryUsers = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.QUERY_USERS).toRepresentation();
        RoleRepresentation masterQueryClients = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.QUERY_CLIENTS).toRepresentation();
        RoleRepresentation masterQueryGroups = this.adminClient.realm("master").clients().get(masterClient.getId()).roles().get(AdminRoles.QUERY_GROUPS).toRepresentation();
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        ClientRepresentation client = realmAdminClient;
        try (Keycloak realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"userAdmin", (String)"password", (String)"admin-cli", null);){
            roles.clear();
            roles.add(realmManageAuthorization);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewAuthorization);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmAdmin);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageClients);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewClients);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageEvents);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewEvents);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageIdentityProviders);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewIdentityProviders);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageRealm);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewRealm);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmImpersonate);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryGroups);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryClients);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        client = realmAdminClient;
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"master", (String)"userAdmin", (String)"password", (String)"admin-cli", null);
        var43_43 = null;
        try {
            roles.clear();
            roles.add(realmManageAuthorization);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewAuthorization);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmAdmin);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageClients);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewClients);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageEvents);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewEvents);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageIdentityProviders);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewIdentityProviders);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageRealm);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmViewRealm);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmImpersonate);
            try {
                realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(realmManageUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryGroups);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryClients);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        catch (Throwable e) {
            var43_43 = e;
            throw e;
        }
        finally {
            if (realmClient != null) {
                if (var43_43 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable e) {
                        var43_43.addSuppressed(e);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        client = masterClient;
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"master", (String)"masterAdmin", (String)"password", (String)"admin-cli", null);
        var43_43 = null;
        try {
            roles.clear();
            roles.add(masterManageAuthorization);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewAuthorization);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageClients);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewClients);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageEvents);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewEvents);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageIdentityProviders);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewIdentityProviders);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageRealm);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewRealm);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterImpersonate);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterManageUsers);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterViewUsers);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterQueryUsers);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterQueryGroups);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
            roles.clear();
            roles.add(masterQueryClients);
            try {
                realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertThat((Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Response.Status.FORBIDDEN)));
            }
        }
        catch (Throwable throwable) {
            var43_43 = throwable;
            throw throwable;
        }
        finally {
            if (realmClient != null) {
                if (var43_43 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable throwable) {
                        var43_43.addSuppressed(throwable);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        client = realmAdminClient;
        realmClient = AdminClientUtil.createAdminClient();
        var43_43 = null;
        try {
            roles.clear();
            roles.add(realmManageAuthorization);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewAuthorization);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageClients);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewClients);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageEvents);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewEvents);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageIdentityProviders);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewIdentityProviders);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageRealm);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewRealm);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmImpersonate);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmManageUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmViewUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryUsers);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryGroups);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(realmQueryClients);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("test").users().get(realmUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        catch (Throwable throwable) {
            var43_43 = throwable;
            throw throwable;
        }
        finally {
            if (realmClient != null) {
                if (var43_43 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable throwable) {
                        var43_43.addSuppressed(throwable);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        client = masterClient;
        realmClient = AdminClientUtil.createAdminClient();
        var43_43 = null;
        try {
            roles.clear();
            roles.add(masterManageAuthorization);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewAuthorization);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageClients);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewClients);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageEvents);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewEvents);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageIdentityProviders);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewIdentityProviders);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageRealm);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewRealm);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterImpersonate);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterManageUsers);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterViewUsers);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterQueryUsers);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterQueryGroups);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
            roles.clear();
            roles.add(masterQueryClients);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).add(roles);
            realmClient.realm("master").users().get(masterUser.getId()).roles().clientLevel(client.getId()).remove(roles);
        }
        catch (Throwable throwable) {
            var43_43 = throwable;
            throw throwable;
        }
        finally {
            if (realmClient != null) {
                if (var43_43 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable throwable) {
                        var43_43.addSuppressed(throwable);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
    }
}

