/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.common.Profile;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.services.resources.admin.permissions.ClientPermissionManagement;
import org.keycloak.services.resources.admin.permissions.GroupPermissionManagement;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.ImpersonationDisabledTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.GroupBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.utils.tls.TLSUtils;

@EnableFeature(value=Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)
public class FineGrainAdminUnitTest
extends AbstractKeycloakTest {
    public static final String CLIENT_NAME = "application";

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation testRealmRep = new RealmRepresentation();
        testRealmRep.setId("test");
        testRealmRep.setRealm("test");
        testRealmRep.setEnabled(Boolean.valueOf(true));
        testRealms.add(testRealmRep);
        testRealmRep.setGroups(Arrays.asList(GroupBuilder.create().name("restricted-group").build()));
    }

    public static void setupDemo(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        realm.addRole("realm-role");
        ClientModel client = realm.addClient("sales-application");
        RoleModel clientAdmin = client.addRole("admin");
        client.addRole("leader-creator");
        client.addRole("viewLeads");
        GroupModel sales = realm.createGroup("sales");
        UserModel admin = session.users().addUser(realm, "salesManager");
        admin.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, admin, (CredentialInput)UserCredentialModel.password((String)"password"));
        admin = session.users().addUser(realm, "sales-admin");
        admin.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, admin, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel user = session.users().addUser(realm, "salesman");
        user.setEnabled(true);
        user.joinGroup(sales);
        user = session.users().addUser(realm, "saleswoman");
        user.setEnabled(true);
    }

    public static void setupPolices(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        AdminPermissionManagement permissions = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        RoleModel realmRole = realm.addRole("realm-role");
        RoleModel realmRole2 = realm.addRole("realm-role2");
        ClientModel client1 = realm.addClient(CLIENT_NAME);
        realm.addClientScope("scope");
        client1.setFullScopeAllowed(false);
        RoleModel client1Role = client1.addRole("client-role");
        GroupModel group = realm.createGroup("top");
        RoleModel mapperRole = realm.addRole("mapper");
        RoleModel managerRole = realm.addRole("manager");
        RoleModel compositeRole = realm.addRole("composite-role");
        compositeRole.addCompositeRole(mapperRole);
        compositeRole.addCompositeRole(managerRole);
        permissions.roles().setPermissionsEnabled(client1Role, true);
        Policy mapRolePermission = permissions.roles().mapRolePermission(client1Role);
        ResourceServer server = permissions.roles().resourceServer(client1Role);
        Policy mapperPolicy = permissions.roles().rolePolicy(server, mapperRole);
        mapRolePermission.addAssociatedPolicy(mapperPolicy);
        permissions.roles().setPermissionsEnabled(realmRole, true);
        mapRolePermission = permissions.roles().mapRolePermission(realmRole);
        server = permissions.roles().resourceServer(realmRole);
        mapperPolicy = permissions.roles().rolePolicy(server, mapperRole);
        mapRolePermission.addAssociatedPolicy(mapperPolicy);
        permissions.roles().setPermissionsEnabled(realmRole2, true);
        permissions.users().setPermissionsEnabled(true);
        ResourceServer server2 = permissions.realmResourceServer();
        Policy managerPolicy = permissions.roles().rolePolicy(server2, managerRole);
        Policy permission = permissions.users().managePermission();
        permission.addAssociatedPolicy(managerPolicy);
        permission.setDecisionStrategy(DecisionStrategy.AFFIRMATIVE);
        permissions.groups().setPermissionsEnabled(group, true);
        permissions.clients().setPermissionsEnabled(client1, true);
        ClientModel realmManagementClient = realm.getClientByClientId("realm-management");
        RoleModel adminRole = realmManagementClient.getRole(AdminRoles.REALM_ADMIN);
        permissions.users().setPermissionsEnabled(true);
        ResourceServer server3 = permissions.realmResourceServer();
        Policy adminPolicy = permissions.roles().rolePolicy(server3, adminRole);
        adminPolicy.setLogic(Logic.NEGATIVE);
        Policy permission2 = permissions.users().userImpersonatedPermission();
        permission2.addAssociatedPolicy(adminPolicy);
        permission2.setDecisionStrategy(DecisionStrategy.UNANIMOUS);
    }

    public static void setupUsers(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        ClientModel client = realm.getClientByClientId(CLIENT_NAME);
        RoleModel realmRole = realm.getRole("realm-role");
        RoleModel realmRole2 = realm.getRole("realm-role2");
        RoleModel clientRole = client.getRole("client-role");
        RoleModel mapperRole = realm.getRole("mapper");
        RoleModel managerRole = realm.getRole("manager");
        RoleModel compositeRole = realm.getRole("composite-role");
        ClientModel realmManagementClient = realm.getClientByClientId("realm-management");
        RoleModel adminRole = realmManagementClient.getRole(AdminRoles.REALM_ADMIN);
        RoleModel queryGroupsRole = realmManagementClient.getRole(AdminRoles.QUERY_GROUPS);
        RoleModel queryUsersRole = realmManagementClient.getRole(AdminRoles.QUERY_USERS);
        RoleModel queryClientsRole = realmManagementClient.getRole(AdminRoles.QUERY_CLIENTS);
        UserModel nomapAdmin = session.users().addUser(realm, "nomap-admin");
        nomapAdmin.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, nomapAdmin, (CredentialInput)UserCredentialModel.password((String)"password"));
        nomapAdmin.grantRole(adminRole);
        UserModel anotherAdmin = session.users().addUser(realm, "anotherAdmin");
        anotherAdmin.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, anotherAdmin, (CredentialInput)UserCredentialModel.password((String)"password"));
        anotherAdmin.grantRole(adminRole);
        UserModel authorizedUser = session.users().addUser(realm, "authorized");
        authorizedUser.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, authorizedUser, (CredentialInput)UserCredentialModel.password((String)"password"));
        authorizedUser.grantRole(mapperRole);
        authorizedUser.grantRole(managerRole);
        UserModel authorizedComposite = session.users().addUser(realm, "authorizedComposite");
        authorizedComposite.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, authorizedComposite, (CredentialInput)UserCredentialModel.password((String)"password"));
        authorizedComposite.grantRole(compositeRole);
        UserModel unauthorizedUser = session.users().addUser(realm, "unauthorized");
        unauthorizedUser.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, unauthorizedUser, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel unauthorizedMapper = session.users().addUser(realm, "unauthorizedMapper");
        unauthorizedMapper.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, unauthorizedMapper, (CredentialInput)UserCredentialModel.password((String)"password"));
        unauthorizedMapper.grantRole(managerRole);
        UserModel user1 = session.users().addUser(realm, "user1");
        user1.setEnabled(true);
        AdminPermissionManagement permissions = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        GroupModel group = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"top");
        UserModel groupMember = session.users().addUser(realm, "groupMember");
        groupMember.joinGroup(group);
        groupMember.setEnabled(true);
        UserModel groupManager = session.users().addUser(realm, "groupManager");
        groupManager.grantRole(queryGroupsRole);
        groupManager.grantRole(queryUsersRole);
        groupManager.setEnabled(true);
        groupManager.grantRole(mapperRole);
        session.userCredentialManager().updateCredential(realm, groupManager, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserModel groupManagerNoMapper = session.users().addUser(realm, "noMapperGroupManager");
        groupManagerNoMapper.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, groupManagerNoMapper, (CredentialInput)UserCredentialModel.password((String)"password"));
        groupManagerNoMapper.grantRole(queryGroupsRole);
        groupManagerNoMapper.grantRole(queryUsersRole);
        UserPolicyRepresentation groupManagerRep = new UserPolicyRepresentation();
        groupManagerRep.setName("groupManagers");
        groupManagerRep.addUser("groupManager");
        groupManagerRep.addUser("noMapperGroupManager");
        ResourceServer server = permissions.realmResourceServer();
        Policy groupManagerPolicy = permissions.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)groupManagerRep, server);
        permissions.groups().manageMembersPermission(group).addAssociatedPolicy(groupManagerPolicy);
        permissions.groups().manageMembershipPermission(group).addAssociatedPolicy(groupManagerPolicy);
        permissions.groups().viewPermission(group).addAssociatedPolicy(groupManagerPolicy);
        UserModel clientMapper = session.users().addUser(realm, "clientMapper");
        clientMapper.setEnabled(true);
        clientMapper.grantRole(managerRole);
        clientMapper.grantRole(queryUsersRole);
        session.userCredentialManager().updateCredential(realm, clientMapper, (CredentialInput)UserCredentialModel.password((String)"password"));
        Policy clientMapperPolicy = permissions.clients().mapRolesPermission(client);
        UserPolicyRepresentation userRep = new UserPolicyRepresentation();
        userRep.setName("userClientMapper");
        userRep.addUser("clientMapper");
        Policy userPolicy = permissions.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)userRep, permissions.clients().resourceServer(client));
        clientMapperPolicy.addAssociatedPolicy(userPolicy);
        UserModel clientManager = session.users().addUser(realm, "clientManager");
        clientManager.setEnabled(true);
        clientManager.grantRole(queryClientsRole);
        session.userCredentialManager().updateCredential(realm, clientManager, (CredentialInput)UserCredentialModel.password((String)"password"));
        Policy clientManagerPolicy = permissions.clients().managePermission(client);
        userRep = new UserPolicyRepresentation();
        userRep.setName("clientManager");
        userRep.addUser("clientManager");
        userPolicy = permissions.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)userRep, permissions.clients().resourceServer(client));
        clientManagerPolicy.addAssociatedPolicy(userPolicy);
        UserModel clientConfigurer = session.users().addUser(realm, "clientConfigurer");
        clientConfigurer.setEnabled(true);
        clientConfigurer.grantRole(queryClientsRole);
        session.userCredentialManager().updateCredential(realm, clientConfigurer, (CredentialInput)UserCredentialModel.password((String)"password"));
        Policy clientConfigurePolicy = permissions.clients().configurePermission(client);
        userRep = new UserPolicyRepresentation();
        userRep.setName("clientConfigure");
        userRep.addUser("clientConfigurer");
        userPolicy = permissions.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)userRep, permissions.clients().resourceServer(client));
        clientConfigurePolicy.addAssociatedPolicy(userPolicy);
        UserModel groupViewer = session.users().addUser(realm, "groupViewer");
        groupViewer.grantRole(queryGroupsRole);
        groupViewer.grantRole(queryUsersRole);
        groupViewer.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, groupViewer, (CredentialInput)UserCredentialModel.password((String)"password"));
        UserPolicyRepresentation groupViewMembersRep = new UserPolicyRepresentation();
        groupViewMembersRep.setName("groupMemberViewers");
        groupViewMembersRep.addUser("groupViewer");
        Policy groupViewMembersPolicy = permissions.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)groupViewMembersRep, server);
        Policy groupViewMembersPermission = permissions.groups().viewMembersPermission(group);
        groupViewMembersPermission.addAssociatedPolicy(groupViewMembersPolicy);
    }

    public static void evaluateLocally(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        RoleModel realmRole = realm.getRole("realm-role");
        RoleModel realmRole2 = realm.getRole("realm-role2");
        ClientModel client = realm.getClientByClientId(CLIENT_NAME);
        RoleModel clientRole = client.getRole("client-role");
        UserModel user = session.users().getUserByUsername(realm, "authorized");
        AdminPermissionEvaluator permissionsForAdmin = AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)realm, (UserModel)user);
        Assert.assertTrue((boolean)permissionsForAdmin.users().canManage());
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(realmRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole2));
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(clientRole));
        user = session.users().getUserByUsername(realm, "authorizedComposite");
        permissionsForAdmin = AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)realm, (UserModel)user);
        Assert.assertTrue((boolean)permissionsForAdmin.users().canManage());
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(realmRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole2));
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(clientRole));
        user = session.users().getUserByUsername(realm, "unauthorized");
        permissionsForAdmin = AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)realm, (UserModel)user);
        Assert.assertFalse((boolean)permissionsForAdmin.users().canManage());
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(clientRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole2));
        user = session.users().getUserByUsername(realm, "unauthorizedMapper");
        permissionsForAdmin = AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)realm, (UserModel)user);
        Assert.assertTrue((boolean)permissionsForAdmin.users().canManage());
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(clientRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole2));
        UserModel admin = session.users().getUserByUsername(realm, "groupManager");
        permissionsForAdmin = AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)realm, (UserModel)admin);
        UserModel user2 = session.users().getUserByUsername(realm, "authorized");
        Assert.assertFalse((boolean)permissionsForAdmin.users().canManage(user2));
        Assert.assertFalse((boolean)permissionsForAdmin.users().canView(user2));
        UserModel member = session.users().getUserByUsername(realm, "groupMember");
        Assert.assertTrue((boolean)permissionsForAdmin.users().canManage(member));
        Assert.assertTrue((boolean)permissionsForAdmin.users().canManageGroupMembership(member));
        Assert.assertTrue((boolean)permissionsForAdmin.users().canView(member));
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(realmRole));
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(clientRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole2));
        admin = session.users().getUserByUsername(realm, "clientMapper");
        permissionsForAdmin = AdminPermissions.evaluator((KeycloakSession)session, (RealmModel)realm, (RealmModel)realm, (UserModel)admin);
        user2 = session.users().getUserByUsername(realm, "authorized");
        Assert.assertTrue((boolean)permissionsForAdmin.users().canManage(user2));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole));
        Assert.assertTrue((boolean)permissionsForAdmin.roles().canMapRole(clientRole));
        Assert.assertFalse((boolean)permissionsForAdmin.roles().canMapRole(realmRole2));
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return true;
    }

    public void testDemo() throws Exception {
        this.testingClient.server().run(FineGrainAdminUnitTest::setupDemo);
        Thread.sleep(1000000000L);
    }

    public void testEvaluationLocal() throws Exception {
        this.testingClient.server().run(FineGrainAdminUnitTest::setupPolices);
        this.testingClient.server().run(FineGrainAdminUnitTest::setupUsers);
        this.testingClient.server().run(FineGrainAdminUnitTest::evaluateLocally);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testRestEvaluation() throws Exception {
        List queryUsers2;
        List roles2;
        this.testingClient.server().run(FineGrainAdminUnitTest::setupPolices);
        this.testingClient.server().run(FineGrainAdminUnitTest::setupUsers);
        UserRepresentation user1 = (UserRepresentation)this.adminClient.realm("test").users().search("user1").get(0);
        UserRepresentation anotherAdmin = (UserRepresentation)this.adminClient.realm("test").users().search("anotherAdmin").get(0);
        UserRepresentation groupMember = (UserRepresentation)this.adminClient.realm("test").users().search("groupMember").get(0);
        RoleRepresentation realmRole = this.adminClient.realm("test").roles().get("realm-role").toRepresentation();
        LinkedList<RoleRepresentation> realmRoleSet = new LinkedList<RoleRepresentation>();
        realmRoleSet.add(realmRole);
        RoleRepresentation realmRole2 = this.adminClient.realm("test").roles().get("realm-role2").toRepresentation();
        LinkedList<RoleRepresentation> realmRole2Set = new LinkedList<RoleRepresentation>();
        realmRole2Set.add(realmRole2);
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId(CLIENT_NAME).get(0);
        ClientScopeRepresentation scope = (ClientScopeRepresentation)this.adminClient.realm("test").clientScopes().findAll().get(0);
        RoleRepresentation clientRole = this.adminClient.realm("test").clients().get(client.getId()).roles().get("client-role").toRepresentation();
        LinkedList<RoleRepresentation> clientRoleSet = new LinkedList<RoleRepresentation>();
        clientRoleSet.add(clientRole);
        try (Keycloak realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"clientConfigurer", (String)"password", (String)"admin-cli", null);){
            client.setAdminUrl("http://nowhere");
            realmClient.realm("test").clients().get(client.getId()).update(client);
            client.setFullScopeAllowed(Boolean.valueOf(true));
            try {
                realmClient.realm("test").clients().get(client.getId()).update(client);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            client.setFullScopeAllowed(Boolean.valueOf(false));
            realmClient.realm("test").clients().get(client.getId()).update(client);
            try {
                realmClient.realm("test").clients().get(client.getId()).addDefaultClientScope(scope.getId());
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            try {
                realmClient.realm("test").clients().get(client.getId()).getScopeMappings().realmLevel().add(realmRoleSet);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
        }
        if (!ImpersonationDisabledTest.IMPERSONATION_DISABLED) {
            realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"nomap-admin", (String)"password", (String)"admin-cli", null);
            try {
                realmClient.realm("test").users().get(user1.getId()).impersonate();
                realmClient.close();
                realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"nomap-admin", (String)"password", (String)"admin-cli", null);
                try {
                    realmClient.realm("test").users().get(anotherAdmin.getId()).impersonate();
                    Assert.fail((String)"should fail with forbidden exception");
                }
                catch (ClientErrorException e) {
                    Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
                }
            }
            finally {
                realmClient.close();
            }
        }
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"authorized", (String)"password", (String)"admin-cli", null);
        var13_15 = null;
        try {
            realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAll();
            Assert.assertTrue((boolean)roles2.stream().anyMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().remove(realmRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAll();
            Assert.assertTrue((boolean)roles2.stream().noneMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.stream().noneMatch(r -> r.getName().equals("client-role")));
        }
        catch (Throwable roles2) {
            var13_15 = roles2;
            throw roles2;
        }
        finally {
            if (realmClient != null) {
                if (var13_15 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable roles2) {
                        var13_15.addSuppressed(roles2);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"authorizedComposite", (String)"password", (String)"admin-cli", null);
        var13_15 = null;
        try {
            realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAll();
            Assert.assertTrue((boolean)roles2.stream().anyMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().remove(realmRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAll();
            Assert.assertTrue((boolean)roles2.stream().noneMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles2 = this.adminClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.stream().noneMatch(r -> r.getName().equals("client-role")));
        }
        catch (Throwable roles3) {
            var13_15 = roles3;
            throw roles3;
        }
        finally {
            if (realmClient != null) {
                if (var13_15 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable roles3) {
                        var13_15.addSuppressed(roles3);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        try {
            realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"unauthorized", (String)"password", (String)"admin-cli", null);
            var13_15 = null;
            try {
                realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (Throwable roles3) {
                var13_15 = roles3;
                throw roles3;
            }
            finally {
                if (realmClient != null) {
                    if (var13_15 != null) {
                        try {
                            realmClient.close();
                        }
                        catch (Throwable roles3) {
                            var13_15.addSuppressed(roles3);
                        }
                    } else {
                        realmClient.close();
                    }
                }
            }
        }
        catch (ClientErrorException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        try {
            realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"unauthorizedMapper", (String)"password", (String)"admin-cli", null);
            var13_15 = null;
            try {
                realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (Throwable roles3) {
                var13_15 = roles3;
                throw roles3;
            }
            finally {
                if (realmClient != null) {
                    if (var13_15 != null) {
                        try {
                            realmClient.close();
                        }
                        catch (Throwable roles3) {
                            var13_15.addSuppressed(roles3);
                        }
                    } else {
                        realmClient.close();
                    }
                }
            }
        }
        catch (ClientErrorException e) {
            Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
        }
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"groupManager", (String)"password", (String)"admin-cli", null);
        var13_15 = null;
        try {
            realmClient.realm("test").users().get(groupMember.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles2 = realmClient.realm("test").users().get(groupMember.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("test").users().get(groupMember.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles2 = realmClient.realm("test").users().get(groupMember.getId()).roles().realmLevel().listAvailable();
            Assert.assertEquals((long)1L, (long)roles2.size());
            realmClient.realm("test").users().get(groupMember.getId()).roles().realmLevel().add(realmRoleSet);
            realmClient.realm("test").users().get(groupMember.getId()).roles().realmLevel().remove(realmRoleSet);
            try {
                realmClient.realm("test").users().get(groupMember.getId()).roles().realmLevel().add(realmRole2Set);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            try {
                realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
        }
        catch (Throwable roles4) {
            var13_15 = roles4;
            throw roles4;
        }
        finally {
            if (realmClient != null) {
                if (var13_15 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable roles4) {
                        var13_15.addSuppressed(roles4);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"clientMapper", (String)"password", (String)"admin-cli", null);
        var13_15 = null;
        try {
            roles2 = realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.isEmpty());
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles2 = realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles2.stream().anyMatch(r -> r.getName().equals("client-role")));
            roles2 = realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAvailable();
            Assert.assertTrue((boolean)roles2.isEmpty());
            try {
                realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
                Assert.fail((String)"should fail with forbidden exception");
            }
            catch (ClientErrorException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
        }
        catch (Throwable roles5) {
            var13_15 = roles5;
            throw roles5;
        }
        finally {
            if (realmClient != null) {
                if (var13_15 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable roles5) {
                        var13_15.addSuppressed(roles5);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"groupViewer", (String)"password", (String)"admin-cli", null);
        var13_15 = null;
        try {
            queryUsers2 = realmClient.realm("test").users().list();
            Assert.assertEquals((long)queryUsers2.size(), (long)1L);
            Assert.assertEquals((Object)"groupmember", (Object)((UserRepresentation)queryUsers2.get(0)).getUsername());
            for (UserRepresentation user : queryUsers2) {
                System.out.println(user.getUsername());
            }
        }
        catch (Throwable queryUsers2) {
            var13_15 = queryUsers2;
            throw queryUsers2;
        }
        finally {
            if (realmClient != null) {
                if (var13_15 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable queryUsers2) {
                        var13_15.addSuppressed(queryUsers2);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
        realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"noMapperGroupManager", (String)"password", (String)"admin-cli", null);
        var13_15 = null;
        try {
            queryUsers2 = realmClient.realm("test").users().list();
            Assert.assertEquals((long)1L, (long)queryUsers2.size());
            UserRepresentation newGroupMemberWithoutGroup = FineGrainAdminUnitTest.createUserRepresentation("new-group-member", "new-group-member@keycloak.org", "New", "Member", true);
            try {
                ApiUtil.createUserWithAdminClient((RealmResource)realmClient.realm("test"), (UserRepresentation)newGroupMemberWithoutGroup);
                Assert.fail((String)"should fail with HTTP response code 403 Forbidden");
            }
            catch (WebApplicationException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            UserRepresentation newEmptyGroupList = FineGrainAdminUnitTest.createUserRepresentation("new-group-member", "new-group-member@keycloak.org", "New", "Member", true);
            newEmptyGroupList.setGroups(Collections.emptyList());
            try {
                ApiUtil.createUserWithAdminClient((RealmResource)realmClient.realm("test"), (UserRepresentation)newEmptyGroupList);
                Assert.fail((String)"should fail with HTTP response code 403 Forbidden");
            }
            catch (WebApplicationException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            UserRepresentation newGroupMemberWithNonExistentGroup = FineGrainAdminUnitTest.createUserRepresentation("new-group-member", "new-group-member@keycloak.org", "New", "Member", Arrays.asList("wrong-group"), true);
            try {
                ApiUtil.createUserWithAdminClient((RealmResource)realmClient.realm("test"), (UserRepresentation)newGroupMemberWithNonExistentGroup);
                Assert.fail((String)"should fail with HTTP response code 403 Forbidden");
            }
            catch (WebApplicationException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            UserRepresentation newGroupMemberOfNotManagedGroup = FineGrainAdminUnitTest.createUserRepresentation("new-group-member", "new-group-member@keycloak.org", "New", "Member", Arrays.asList("restricted-group"), true);
            try {
                ApiUtil.createUserWithAdminClient((RealmResource)realmClient.realm("test"), (UserRepresentation)newGroupMemberOfNotManagedGroup);
                Assert.fail((String)"should fail with HTTP response code 403 Forbidden");
            }
            catch (WebApplicationException e) {
                Assert.assertEquals((long)403L, (long)e.getResponse().getStatus());
            }
            UserRepresentation newGroupMember = FineGrainAdminUnitTest.createUserRepresentation("new-group-member", "new-group-member@keycloak.org", "New", "Member", Arrays.asList("top"), true);
            ApiUtil.createUserWithAdminClient((RealmResource)realmClient.realm("test"), (UserRepresentation)newGroupMember);
            queryUsers2 = realmClient.realm("test").users().list();
            Assert.assertEquals((long)2L, (long)queryUsers2.size());
        }
        catch (Throwable throwable) {
            var13_15 = throwable;
            throw throwable;
        }
        finally {
            if (realmClient != null) {
                if (var13_15 != null) {
                    try {
                        realmClient.close();
                    }
                    catch (Throwable throwable) {
                        var13_15.addSuppressed(throwable);
                    }
                } else {
                    realmClient.close();
                }
            }
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testMasterRealm() throws Exception {
        this.testingClient.server().run(FineGrainAdminUnitTest::setupPolices);
        this.testingClient.server().run(FineGrainAdminUnitTest::setupUsers);
        UserRepresentation user1 = (UserRepresentation)this.adminClient.realm("test").users().search("user1").get(0);
        RoleRepresentation realmRole = this.adminClient.realm("test").roles().get("realm-role").toRepresentation();
        LinkedList<RoleRepresentation> realmRoleSet = new LinkedList<RoleRepresentation>();
        realmRoleSet.add(realmRole);
        RoleRepresentation realmRole2 = this.adminClient.realm("test").roles().get("realm-role2").toRepresentation();
        LinkedList<RoleRepresentation> realmRole2Set = new LinkedList<RoleRepresentation>();
        realmRole2Set.add(realmRole);
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId(CLIENT_NAME).get(0);
        RoleRepresentation clientRole = this.adminClient.realm("test").clients().get(client.getId()).roles().get("client-role").toRepresentation();
        LinkedList<RoleRepresentation> clientRoleSet = new LinkedList<RoleRepresentation>();
        clientRoleSet.add(clientRole);
        try (Keycloak realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting());){
            realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().add(realmRoleSet);
            List roles = this.adminClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAll();
            Assert.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().realmLevel().remove(realmRoleSet);
            roles = this.adminClient.realm("test").users().get(user1.getId()).roles().realmLevel().listAll();
            Assert.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("realm-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).add(clientRoleSet);
            roles = this.adminClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles.stream().anyMatch(r -> r.getName().equals("client-role")));
            realmClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).remove(clientRoleSet);
            roles = this.adminClient.realm("test").users().get(user1.getId()).roles().clientLevel(client.getId()).listAll();
            Assert.assertTrue((boolean)roles.stream().noneMatch(r -> r.getName().equals("client-role")));
        }
    }

    @Test
    public void testMasterRealmWithComposites() throws Exception {
        RoleRepresentation composite = new RoleRepresentation();
        composite.setName("composite");
        composite.setComposite(true);
        this.adminClient.realm("test").roles().create(composite);
        composite = this.adminClient.realm("test").roles().get("composite").toRepresentation();
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId("realm-management").get(0);
        RoleRepresentation createClient = this.adminClient.realm("test").clients().get(client.getId()).roles().get(AdminRoles.CREATE_CLIENT).toRepresentation();
        RoleRepresentation queryRealms = this.adminClient.realm("test").clients().get(client.getId()).roles().get(AdminRoles.QUERY_REALMS).toRepresentation();
        LinkedList<RoleRepresentation> composites = new LinkedList<RoleRepresentation>();
        composites.add(createClient);
        composites.add(queryRealms);
        this.adminClient.realm("test").rolesById().addComposites(composite.getId(), composites);
    }

    public static void setup5152(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
        RoleModel realmAdminRole = realmAdminClient.getRole(AdminRoles.REALM_ADMIN);
        UserModel realmUser = session.users().addUser(realm, "realm-admin");
        realmUser.grantRole(realmAdminRole);
        realmUser.setEnabled(true);
        session.userCredentialManager().updateCredential(realm, realmUser, (CredentialInput)UserCredentialModel.password((String)"password"));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testRealmWithComposites() throws Exception {
        this.testingClient.server().run(FineGrainAdminUnitTest::setup5152);
        try (Keycloak realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"test", (String)"realm-admin", (String)"password", (String)"admin-cli", null);){
            RoleRepresentation composite = new RoleRepresentation();
            composite.setName("composite");
            composite.setComposite(true);
            realmClient.realm("test").roles().create(composite);
            composite = this.adminClient.realm("test").roles().get("composite").toRepresentation();
            ClientRepresentation client = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId("realm-management").get(0);
            RoleRepresentation viewUsers = this.adminClient.realm("test").clients().get(client.getId()).roles().get(AdminRoles.CREATE_CLIENT).toRepresentation();
            LinkedList<RoleRepresentation> composites = new LinkedList<RoleRepresentation>();
            composites.add(viewUsers);
            realmClient.realm("test").rolesById().addComposites(composite.getId(), composites);
        }
    }

    public static void setupDeleteTest(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        RoleModel removedRole = realm.addRole("removedRole");
        ClientModel client = realm.addClient("removedClient");
        RoleModel removedClientRole = client.addRole("removedClientRole");
        GroupModel removedGroup = realm.createGroup("removedGroup");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        management.roles().setPermissionsEnabled(removedRole, true);
        management.roles().setPermissionsEnabled(removedClientRole, true);
        management.groups().setPermissionsEnabled(removedGroup, true);
        management.clients().setPermissionsEnabled(client, true);
        management.users().setPermissionsEnabled(true);
    }

    public static void invokeDelete(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("test");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        List byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer().getId());
        Assert.assertEquals((long)5L, (long)byResourceServer.size());
        RoleModel removedRole = realm.getRole("removedRole");
        realm.removeRole(removedRole);
        ClientModel client = realm.getClientByClientId("removedClient");
        RoleModel removedClientRole = client.getRole("removedClientRole");
        client.removeRole(removedClientRole);
        GroupModel group = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)"removedGroup");
        realm.removeGroup(group);
        byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer().getId());
        Assert.assertEquals((long)2L, (long)byResourceServer.size());
        realm.removeClient(client.getId());
        byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer().getId());
        Assert.assertEquals((long)1L, (long)byResourceServer.size());
        management.users().setPermissionsEnabled(false);
        Resource userResource = management.authz().getStoreFactory().getResourceStore().findByName("Users", management.realmResourceServer().getId());
        Assert.assertNull((Object)userResource);
        byResourceServer = management.authz().getStoreFactory().getResourceStore().findByResourceServer(management.realmResourceServer().getId());
        Assert.assertEquals((long)0L, (long)byResourceServer.size());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testRemoveCleanup() throws Exception {
        this.testingClient.server().run(FineGrainAdminUnitTest::setupDeleteTest);
        this.testingClient.server().run(FineGrainAdminUnitTest::invokeDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateRealmCreateClient() throws Exception {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setName("fullScopedClient");
        rep.setClientId("fullScopedClient");
        rep.setFullScopeAllowed(Boolean.valueOf(true));
        rep.setSecret("618268aa-51e6-4e64-93c4-3c0bc65b8171");
        rep.setProtocol("openid-connect");
        rep.setPublicClient(Boolean.valueOf(false));
        rep.setEnabled(Boolean.valueOf(true));
        this.adminClient.realm("master").clients().create(rep);
        Keycloak realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"master", (String)"admin", (String)"admin", (String)"fullScopedClient", (String)"618268aa-51e6-4e64-93c4-3c0bc65b8171");
        try {
            RealmRepresentation newRealm = new RealmRepresentation();
            newRealm.setRealm("anotherRealm");
            newRealm.setId("anotherRealm");
            newRealm.setEnabled(Boolean.valueOf(true));
            realmClient.realms().create(newRealm);
            ClientRepresentation newClient = new ClientRepresentation();
            newClient.setName("newClient");
            newClient.setClientId("newClient");
            newClient.setFullScopeAllowed(Boolean.valueOf(true));
            newClient.setSecret("secret");
            newClient.setProtocol("openid-connect");
            newClient.setPublicClient(Boolean.valueOf(false));
            newClient.setEnabled(Boolean.valueOf(true));
            Response response = realmClient.realm("anotherRealm").clients().create(newClient);
            Assert.assertEquals((long)403L, (long)response.getStatus());
            response.close();
            realmClient.close();
            realmClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)"master", (String)"admin", (String)"admin", (String)"fullScopedClient", (String)"618268aa-51e6-4e64-93c4-3c0bc65b8171");
            Assert.assertThat(realmClient.realms().findAll().stream().map(RealmRepresentation::getRealm).collect(Collectors.toSet()), (Matcher)Matchers.hasItem((Object)"anotherRealm"));
            response = realmClient.realm("anotherRealm").clients().create(newClient);
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response.close();
        }
        finally {
            this.adminClient.realm("anotherRealm").remove();
            realmClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateRealmCreateClientWithMaster() throws Exception {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setName("fullScopedClient");
        rep.setClientId("fullScopedClient");
        rep.setFullScopeAllowed(Boolean.valueOf(true));
        rep.setSecret("618268aa-51e6-4e64-93c4-3c0bc65b8171");
        rep.setProtocol("openid-connect");
        rep.setPublicClient(Boolean.valueOf(false));
        rep.setEnabled(Boolean.valueOf(true));
        this.adminClient.realm("master").clients().create(rep);
        RealmRepresentation newRealm = new RealmRepresentation();
        newRealm.setRealm("anotherRealm");
        newRealm.setId("anotherRealm");
        newRealm.setEnabled(Boolean.valueOf(true));
        this.adminClient.realms().create(newRealm);
        try {
            ClientRepresentation newClient = new ClientRepresentation();
            newClient.setName("newClient");
            newClient.setClientId("newClient");
            newClient.setFullScopeAllowed(Boolean.valueOf(true));
            newClient.setSecret("secret");
            newClient.setProtocol("openid-connect");
            newClient.setPublicClient(Boolean.valueOf(false));
            newClient.setEnabled(Boolean.valueOf(true));
            Response response = this.adminClient.realm("anotherRealm").clients().create(newClient);
            Assert.assertEquals((long)201L, (long)response.getStatus());
            response.close();
        }
        finally {
            this.adminClient.realm("anotherRealm").remove();
        }
    }

    @Test
    @UncaughtServerErrorExpected
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testTokenExchangeDisabled() throws Exception {
        this.checkTokenExchange(false);
    }

    @Test
    @UncaughtServerErrorExpected
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    @EnableFeature(value=Profile.Feature.TOKEN_EXCHANGE, skipRestart=true)
    public void testWithTokenExchange() throws Exception {
        String exchanged = this.checkTokenExchange(true);
        Assert.assertNotNull((Object)exchanged);
        try (Keycloak client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"master", (String)"admin-cli", (String)exchanged, (SSLContext)TLSUtils.initializeTLS());){
            Assert.assertNotNull((Object)client.realm("master").roles().get("offline_access"));
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testUserPagination() {
        List result;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            UserModel userModel;
            int i;
            RealmModel realm = session.realms().getRealmByName("test");
            session.getContext().setRealm(realm);
            GroupModel customerAGroup = session.groups().createGroup(realm, "Customer A");
            UserModel customerAManager = session.users().addUser(realm, "customer-a-manager");
            session.userCredentialManager().updateCredential(realm, customerAManager, (CredentialInput)UserCredentialModel.password((String)"password"));
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            customerAManager.grantRole(realmAdminClient.getRole(AdminRoles.QUERY_USERS));
            customerAManager.setEnabled(true);
            UserModel regularAdminUser = session.users().addUser(realm, "regular-admin-user");
            session.userCredentialManager().updateCredential(realm, regularAdminUser, (CredentialInput)UserCredentialModel.password((String)"password"));
            regularAdminUser.grantRole(realmAdminClient.getRole(AdminRoles.VIEW_USERS));
            regularAdminUser.setEnabled(true);
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            GroupPermissionManagement groupPermission = management.groups();
            groupPermission.setPermissionsEnabled(customerAGroup, true);
            UserPolicyRepresentation userPolicyRepresentation = new UserPolicyRepresentation();
            userPolicyRepresentation.setName("Only " + customerAManager.getUsername());
            userPolicyRepresentation.addUser(customerAManager.getId());
            Policy policy = groupPermission.viewMembersPermission(customerAGroup);
            AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            Policy userPolicy = provider.getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)userPolicyRepresentation, management.realmResourceServer());
            policy.addAssociatedPolicy(RepresentationToModel.toModel((AbstractPolicyRepresentation)userPolicyRepresentation, (AuthorizationProvider)provider, (Policy)userPolicy));
            for (i = 0; i < 20; ++i) {
                userModel = session.users().addUser(realm, "a" + i);
                userModel.setFirstName("test");
            }
            for (i = 20; i < 40; ++i) {
                userModel = session.users().addUser(realm, "b" + i);
                userModel.setFirstName("test");
                userModel.joinGroup(customerAGroup);
            }
        });
        try (Keycloak client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"customer-a-manager", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            result = client.realm("test").users().search(null, "test", null, null, Integer.valueOf(-1), Integer.valueOf(20));
            Assert.assertEquals((long)20L, (long)result.size());
            Assert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"b"))));
            result = client.realm("test").users().search(null, "test", null, null, Integer.valueOf(20), Integer.valueOf(40));
            Assert.assertEquals((long)0L, (long)result.size());
        }
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            result = client.realm("test").users().search(null, "test", null, null, Integer.valueOf(-1), Integer.valueOf(20));
            Assert.assertEquals((long)20L, (long)result.size());
            Assert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"a"))));
            client.realm("test").users().search(null, null, null, null, Integer.valueOf(-1), Integer.valueOf(-1));
            Assert.assertEquals((long)20L, (long)result.size());
            Assert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"a"))));
        }
        catch (Throwable result2) {
            var2_2 = result2;
            throw result2;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable result2) {
                        var2_2.addSuppressed(result2);
                    }
                } else {
                    client.close();
                }
            }
        }
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"customer-a-manager", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            result = client.realm("test").users().search(null, null, null, null, Integer.valueOf(-1), Integer.valueOf(20));
            Assert.assertEquals((long)20L, (long)result.size());
            Assert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"b"))));
            result = client.realm("test").users().search("test", Integer.valueOf(-1), Integer.valueOf(20), Boolean.valueOf(false));
            Assert.assertEquals((long)20L, (long)result.size());
            Assert.assertThat((Object)result, (Matcher)Matchers.everyItem((Matcher)Matchers.hasProperty((String)"username", (Matcher)Matchers.startsWith((String)"b"))));
            result = client.realm("test").users().search("a", Integer.valueOf(-1), Integer.valueOf(20), Boolean.valueOf(false));
            Assert.assertEquals((long)0L, (long)result.size());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testClientsSearch() {
        List result;
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.getContext().setRealm(realm);
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            UserModel regularAdminUser = session.users().addUser(realm, "regular-admin-user");
            session.userCredentialManager().updateCredential(realm, regularAdminUser, (CredentialInput)UserCredentialModel.password((String)"password"));
            regularAdminUser.grantRole(realmAdminClient.getRole(AdminRoles.QUERY_CLIENTS));
            regularAdminUser.setEnabled(true);
            UserPolicyRepresentation userPolicyRepresentation = new UserPolicyRepresentation();
            userPolicyRepresentation.setName("Only " + regularAdminUser.getUsername());
            userPolicyRepresentation.addUser(regularAdminUser.getId());
            for (int i = 0; i < 30; ++i) {
                realm.addClient("client-search-" + (i < 10 ? "0" + i : Integer.valueOf(i)));
            }
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            ClientModel clientModel = realm.getClientByClientId("client-search-09");
            clientPermission.setPermissionsEnabled(clientModel, true);
            Policy policy = clientPermission.viewPermission(clientModel);
            AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            Policy userPolicy = provider.getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)userPolicyRepresentation, management.realmResourceServer());
            policy.addAssociatedPolicy(RepresentationToModel.toModel((AbstractPolicyRepresentation)userPolicyRepresentation, (AuthorizationProvider)provider, (Policy)userPolicy));
        });
        try (Keycloak client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            result = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"client-search-09", (Object)((ClientRepresentation)result.get(0)).getClientId());
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.getContext().setRealm(realm);
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            ClientModel clientModel = realm.getClientByClientId("client-search-10");
            clientPermission.setPermissionsEnabled(clientModel, true);
            Policy policy = clientPermission.viewPermission(clientModel);
            AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            policy.addAssociatedPolicy(provider.getStoreFactory().getPolicyStore().findByName("Only regular-admin-user", realmAdminClient.getId()));
        });
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            result = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(-1), Integer.valueOf(-1));
            Assert.assertEquals((long)2L, (long)result.size());
        }
        catch (Throwable result2) {
            var2_2 = result2;
            throw result2;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable result2) {
                        var2_2.addSuppressed(result2);
                    }
                } else {
                    client.close();
                }
            }
        }
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            result = client.realm("test").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(5));
            Assert.assertEquals((long)2L, (long)result.size());
        }
        catch (Throwable result3) {
            var2_2 = result3;
            throw result3;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable result3) {
                        var2_2.addSuppressed(result3);
                    }
                } else {
                    client.close();
                }
            }
        }
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            result = client.realm("test").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(0), Integer.valueOf(1));
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertThat((Object)result, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientId", (Matcher)Matchers.is((Object)"client-search-09"))));
            result = client.realm("test").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(1), Integer.valueOf(1));
            Assert.assertThat((Object)result, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"clientId", (Matcher)Matchers.is((Object)"client-search-10"))));
            Assert.assertEquals((long)1L, (long)result.size());
            result = client.realm("test").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(2), Integer.valueOf(1));
            Assert.assertTrue((boolean)result.isEmpty());
        }
        catch (Throwable result4) {
            var2_2 = result4;
            throw result4;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable result4) {
                        var2_2.addSuppressed(result4);
                    }
                } else {
                    client.close();
                }
            }
        }
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            result = client.realm("test").clients().findAll(null, Boolean.valueOf(true), Boolean.valueOf(false), Integer.valueOf(-1), Integer.valueOf(-1));
            Assert.assertEquals((long)2L, (long)result.size());
        }
        catch (Throwable result5) {
            var2_2 = result5;
            throw result5;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable result5) {
                        var2_2.addSuppressed(result5);
                    }
                } else {
                    client.close();
                }
            }
        }
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.getContext().setRealm(realm);
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            for (int i = 11; i < 30; ++i) {
                ClientModel clientModel = realm.getClientByClientId("client-search-" + i);
                clientPermission.setPermissionsEnabled(clientModel, true);
                Policy policy = clientPermission.viewPermission(clientModel);
                AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
                ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
                policy.addAssociatedPolicy(provider.getStoreFactory().getPolicyStore().findByName("Only regular-admin-user", realmAdminClient.getId()));
            }
        });
        client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());
        var2_2 = null;
        try {
            ArrayList clients = new ArrayList();
            List result6 = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(10));
            clients.addAll(result6);
            Assert.assertEquals((long)10L, (long)result6.size());
            Assert.assertThat(result6.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-09", "client-search-10", "client-search-11", "client-search-12", "client-search-13", "client-search-14", "client-search-15", "client-search-16", "client-search-17", "client-search-18")));
            result6 = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(10));
            clients.addAll(result6);
            Assert.assertEquals((long)10L, (long)result6.size());
            Assert.assertThat(result6.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-19", "client-search-20", "client-search-21", "client-search-22", "client-search-23", "client-search-24", "client-search-25", "client-search-26", "client-search-27", "client-search-28")));
            result6 = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(20), Integer.valueOf(10));
            clients.addAll(result6);
            Assert.assertEquals((long)1L, (long)result6.size());
            Assert.assertThat((Object)result6, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.hasProperty((String)"clientId", (Matcher)Matchers.isOneOf((Object[])new String[]{"client-search-29"}))}));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (client != null) {
                if (var2_2 != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    client.close();
                }
            }
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testClientsSearchAfterFirstPage() {
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealmByName("test");
            session.getContext().setRealm(realm);
            ClientModel realmAdminClient = realm.getClientByClientId("realm-management");
            UserModel regularAdminUser = session.users().addUser(realm, "regular-admin-user");
            session.userCredentialManager().updateCredential(realm, regularAdminUser, (CredentialInput)UserCredentialModel.password((String)"password"));
            regularAdminUser.grantRole(realmAdminClient.getRole(AdminRoles.QUERY_CLIENTS));
            regularAdminUser.setEnabled(true);
            UserPolicyRepresentation userPolicyRepresentation = new UserPolicyRepresentation();
            userPolicyRepresentation.setName("Only " + regularAdminUser.getUsername());
            userPolicyRepresentation.addUser(regularAdminUser.getId());
            AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
            ClientPermissionManagement clientPermission = management.clients();
            for (int i = 15; i < 30; ++i) {
                ClientModel clientModel = realm.addClient("client-search-" + (i < 10 ? "0" + i : Integer.valueOf(i)));
                clientPermission.setPermissionsEnabled(clientModel, true);
                Policy policy = clientPermission.viewPermission(clientModel);
                AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
                if (i == 15) {
                    provider.getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)userPolicyRepresentation, management.realmResourceServer());
                }
                policy.addAssociatedPolicy(provider.getStoreFactory().getPolicyStore().findByName("Only regular-admin-user", realmAdminClient.getId()));
            }
        });
        try (Keycloak client = Keycloak.getInstance((String)(ServerURLs.getAuthServerContextRoot() + "/auth"), (String)"test", (String)"regular-admin-user", (String)"password", (String)"admin-cli", (SSLContext)TLSUtils.initializeTLS());){
            ArrayList clients = new ArrayList();
            List result = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(10));
            clients.addAll(result);
            Assert.assertEquals((long)10L, (long)result.size());
            Assert.assertThat(result.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-15", "client-search-16", "client-search-17", "client-search-18", "client-search-19", "client-search-20", "client-search-21", "client-search-22", "client-search-23", "client-search-24")));
            result = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(10), Integer.valueOf(10));
            clients.addAll(result);
            Assert.assertEquals((long)5L, (long)result.size());
            Assert.assertThat(result.stream().map(rep -> rep.getClientId()).collect(Collectors.toList()), (Matcher)Matchers.is(Arrays.asList("client-search-25", "client-search-26", "client-search-27", "client-search-28", "client-search-29")));
            result = client.realm("test").clients().findAll("client-search-", Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(20), Integer.valueOf(10));
            clients.addAll(result);
            Assert.assertTrue((boolean)result.isEmpty());
        }
    }

    private String checkTokenExchange(boolean shouldPass) throws Exception {
        this.testingClient.server().run(FineGrainAdminUnitTest::setupTokenExchange);
        this.oauth.realm("master");
        this.oauth.clientId("tokenexclient");
        String exchanged = null;
        String token = this.oauth.doGrantAccessTokenRequest("password", "admin", "admin").getAccessToken();
        Assert.assertNotNull((Object)token);
        try {
            exchanged = this.oauth.doTokenExchange("master", token, "admin-cli", "tokenexclient", "password").getAccessToken();
        }
        catch (AssertionError e) {
            this.log.info((Object)("Error message is expected from oauth: " + ((Throwable)((Object)e)).getMessage()));
        }
        if (shouldPass) {
            Assert.assertNotNull((Object)exchanged);
        } else {
            Assert.assertNull((Object)exchanged);
        }
        return exchanged;
    }

    private static void setupTokenExchange(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("master");
        ClientModel client = session.clients().getClientByClientId(realm, "tokenexclient");
        if (client != null) {
            return;
        }
        ClientModel tokenexclient = realm.addClient("tokenexclient");
        tokenexclient.setEnabled(true);
        tokenexclient.addRedirectUri("http://localhost:*");
        tokenexclient.setPublicClient(false);
        tokenexclient.setSecret("password");
        tokenexclient.setDirectAccessGrantsEnabled(true);
        ClientModel adminCli = realm.getClientByClientId("admin-cli");
        AdminPermissionManagement management = AdminPermissions.management((KeycloakSession)session, (RealmModel)realm);
        management.clients().setPermissionsEnabled(adminCli, true);
        ClientPolicyRepresentation clientRep = new ClientPolicyRepresentation();
        clientRep.setName("to");
        clientRep.addClient(new String[]{tokenexclient.getId()});
        ResourceServer server = management.realmResourceServer();
        Policy clientPolicy = management.authz().getStoreFactory().getPolicyStore().create((AbstractPolicyRepresentation)clientRep, server);
        management.clients().exchangeToPermission(adminCli).addAssociatedPolicy(clientPolicy);
    }
}

