/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.userprofile.DeclarativeUserProfileProvider;
import org.keycloak.userprofile.UserProfileProvider;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class DeclarativeUserTest
extends AbstractAdminTest {
    @Before
    public void onBefore() {
        RealmRepresentation realmRep = this.realm.toRepresentation();
        VerifyProfileTest.enableDynamicUserProfile(realmRep);
        this.realm.update(realmRep);
        VerifyProfileTest.setUserProfileConfiguration(this.realm, "{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"aName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-a\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-hidden\"},{\"name\": \"attr1\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
    }

    @Test
    public void testReturnAllConfiguredAttributesEvenIfNotSet() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "value1user1");
        user1.singleAttribute("attr2", "value2user1");
        String user1Id = this.createUser(user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        Map attributes = user1.getAttributes();
        Assert.assertEquals((long)4L, (long)attributes.size());
        List attr1 = (List)attributes.get("attr1");
        Assert.assertEquals((long)1L, (long)attr1.size());
        Assert.assertEquals((Object)"value1user1", attr1.get(0));
        List attr2 = (List)attributes.get("attr2");
        Assert.assertEquals((long)1L, (long)attr2.size());
        Assert.assertEquals((Object)"value2user1", attr2.get(0));
        List attrCustomA = (List)attributes.get("custom-a");
        Assert.assertTrue((boolean)attrCustomA.isEmpty());
        Assert.assertTrue((boolean)attributes.containsKey("custom-a"));
        Assert.assertTrue((boolean)attributes.containsKey("aName"));
    }

    @Test
    public void testDoNotReturnAttributeIfNotReadble() {
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "value1user1");
        user1.singleAttribute("attr2", "value2user1");
        String user1Id = this.createUser(user1);
        user1 = this.realm.users().get(user1Id).toRepresentation();
        Map attributes = user1.getAttributes();
        Assert.assertEquals((long)4L, (long)attributes.size());
        Assert.assertFalse((boolean)attributes.containsKey("custom-hidden"));
        VerifyProfileTest.setUserProfileConfiguration(this.realm, "{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"aName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-a\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"custom-hidden\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr1\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        user1 = this.realm.users().get(user1Id).toRepresentation();
        attributes = user1.getAttributes();
        Assert.assertEquals((long)5L, (long)attributes.size());
        Assert.assertTrue((boolean)attributes.containsKey("custom-hidden"));
    }

    @Test
    public void testUpdateUnsetAttributeWithEmptyValue() {
        VerifyProfileTest.setUserProfileConfiguration(this.realm, "{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr1\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\"}]}");
        UserRepresentation user1 = new UserRepresentation();
        user1.setUsername("user1");
        user1.singleAttribute("attr1", "some-value");
        String user1Id = this.createUser(user1);
        VerifyProfileTest.setUserProfileConfiguration(this.realm, "{\"attributes\": [{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"attr2\"}]}");
        UserResource userResource = this.realm.users().get(user1Id);
        user1 = userResource.toRepresentation();
        Map attributes = user1.getAttributes();
        attributes.put("attr2", Collections.singletonList(""));
        userResource.update(user1);
        attributes.put("attr2", null);
        userResource.update(user1);
    }

    @Test
    public void testDefaultUserProfileProviderIsActive() {
        this.getTestingClient().server("test").run((RunOnServer & Serializable)session -> {
            Set providers = session.getAllProviders(UserProfileProvider.class);
            MatcherAssert.assertThat((Object)providers, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)providers.isEmpty(), (Matcher)CoreMatchers.is((Object)false));
            UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
            MatcherAssert.assertThat((Object)provider, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)DeclarativeUserProfileProvider.class.getName(), (Matcher)CoreMatchers.is((Object)provider.getClass().getName()));
            MatcherAssert.assertThat((Object)provider, (Matcher)CoreMatchers.instanceOf(DeclarativeUserProfileProvider.class));
        });
    }

    private String createUser(UserRepresentation userRep) {
        Response response = this.realm.users().create(userRep);
        String createdId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.getCleanup().addUserId(createdId);
        return createdId;
    }
}

