/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ConsentPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.OAuthClient;
import org.openqa.selenium.By;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class ConsentsTest
extends AbstractKeycloakTest {
    static final String REALM_PROV_NAME = "provider";
    static final String REALM_CONS_NAME = "consumer";
    static final String IDP_OIDC_ALIAS = "kc-oidc-idp";
    static final String IDP_OIDC_PROVIDER_ID = "keycloak-oidc";
    static final String CLIENT_ID = "brokerapp";
    static final String CLIENT_SECRET = "secret";
    static final String USER_LOGIN = "testuser";
    static final String USER_EMAIL = "user@localhost.com";
    static final String USER_PASSWORD = "password";
    static final String USER_FIRSTNAME = "User";
    static final String USER_LASTNAME = "Tester";
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected LoginPage accountLoginPage;
    @Page
    protected ConsentPage consentPage;
    @Page
    protected AppPage appPage;
    @Page
    protected ErrorPage errorPage;

    protected RealmRepresentation createProviderRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(REALM_PROV_NAME);
        realm.setEnabled(Boolean.valueOf(true));
        return realm;
    }

    protected RealmRepresentation createConsumerRealm() {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(REALM_CONS_NAME);
        realm.setEnabled(Boolean.valueOf(true));
        return realm;
    }

    protected List<ClientRepresentation> createProviderClients() {
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId(CLIENT_ID);
        client.setName(CLIENT_ID);
        client.setSecret(CLIENT_SECRET);
        client.setEnabled(Boolean.valueOf(true));
        client.setConsentRequired(Boolean.valueOf(true));
        client.setRedirectUris(Collections.singletonList(this.getAuthRoot() + "/auth/realms/" + REALM_CONS_NAME + "/broker/" + IDP_OIDC_ALIAS + "/endpoint/*"));
        client.setAdminUrl(this.getAuthRoot() + "/auth/realms/" + REALM_CONS_NAME + "/broker/" + IDP_OIDC_ALIAS + "/endpoint");
        return Collections.singletonList(client);
    }

    protected IdentityProviderRepresentation setUpIdentityProvider() {
        IdentityProviderRepresentation idp = this.createIdentityProvider(IDP_OIDC_ALIAS, IDP_OIDC_PROVIDER_ID);
        Map config = idp.getConfig();
        config.put("clientId", CLIENT_ID);
        config.put("clientSecret", CLIENT_SECRET);
        config.put("prompt", "login");
        config.put("authorizationUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/auth");
        config.put("tokenUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/token");
        config.put("logoutUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/logout");
        config.put("userInfoUrl", this.getAuthRoot() + "/auth/realms/" + REALM_PROV_NAME + "/protocol/openid-connect/userinfo");
        config.put("defaultScope", "email profile");
        config.put("backchannelSupported", "true");
        return idp;
    }

    protected String getUserLogin() {
        return USER_LOGIN;
    }

    protected String getUserPassword() {
        return USER_PASSWORD;
    }

    protected String getUserEmail() {
        return USER_EMAIL;
    }

    protected String getUserFirstName() {
        return USER_FIRSTNAME;
    }

    protected String getUserLastName() {
        return USER_LASTNAME;
    }

    protected String providerRealmName() {
        return REALM_PROV_NAME;
    }

    protected String consumerRealmName() {
        return REALM_CONS_NAME;
    }

    protected String getIDPAlias() {
        return IDP_OIDC_ALIAS;
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation providerRealm = this.createProviderRealm();
        RealmRepresentation consumerRealm = this.createConsumerRealm();
        RealmRepresentation realmRepresentation = AbstractAdminTest.loadJson(this.getClass().getResourceAsStream("/testrealm.json"), RealmRepresentation.class);
        testRealms.add(providerRealm);
        testRealms.add(consumerRealm);
        testRealms.add(realmRepresentation);
    }

    @Before
    public void createUser() {
        this.log.debug((Object)("creating user for realm " + this.providerRealmName()));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(this.getUserLogin());
        user.setEmail(this.getUserEmail());
        user.setFirstName(this.getUserFirstName());
        user.setLastName(this.getUserLastName());
        user.setEmailVerified(Boolean.valueOf(true));
        user.setEnabled(Boolean.valueOf(true));
        RealmResource realmResource = this.adminClient.realm(this.providerRealmName());
        String userId = ApiUtil.createUserWithAdminClient((RealmResource)realmResource, (UserRepresentation)user);
        ApiUtil.resetUserPassword((UserResource)realmResource.users().get(userId), (String)this.getUserPassword(), (boolean)false);
    }

    @Before
    public void addIdentityProviderToProviderRealm() {
        this.log.debug((Object)("adding identity provider to realm " + this.consumerRealmName()));
        RealmResource realm = this.adminClient.realm(this.consumerRealmName());
        realm.identityProviders().create(this.setUpIdentityProvider());
    }

    @Before
    public void addClients() {
        List<ClientRepresentation> clients = this.createProviderClients();
        if (clients != null) {
            RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
            for (ClientRepresentation client : clients) {
                this.log.debug((Object)("adding client " + client.getName() + " to realm " + this.providerRealmName()));
                providerRealm.clients().create(client);
            }
        }
    }

    protected String getAuthRoot() {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString();
    }

    protected IdentityProviderRepresentation createIdentityProvider(String alias, String providerId) {
        IdentityProviderRepresentation identityProviderRepresentation = new IdentityProviderRepresentation();
        identityProviderRepresentation.setAlias(alias);
        identityProviderRepresentation.setDisplayName(providerId);
        identityProviderRepresentation.setProviderId(providerId);
        identityProviderRepresentation.setEnabled(true);
        return identityProviderRepresentation;
    }

    private void waitForPage(String title) {
        long startAt = System.currentTimeMillis();
        while (!this.driver.getTitle().toLowerCase().contains(title) && System.currentTimeMillis() - startAt < 200L) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @After
    public void cleanUser() {
        String userId = ((UserRepresentation)this.adminClient.realm(this.providerRealmName()).users().search(this.getUserLogin()).get(0)).getId();
        this.adminClient.realm(this.providerRealmName()).users().delete(userId);
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testConsents() {
        this.driver.navigate().to(this.getAccountUrl(this.consumerRealmName()));
        this.log.debug((Object)("Clicking social " + this.getIDPAlias()));
        this.accountLoginPage.clickSocial(this.getIDPAlias());
        if (!this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/")) {
            this.log.debug((Object)("Not on provider realm page, url: " + this.driver.getCurrentUrl()));
        }
        Assert.assertTrue((String)"Driver should be on the provider realm page right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.providerRealmName() + "/"));
        this.log.debug((Object)"Logging in");
        this.accountLoginPage.login(this.getUserLogin(), this.getUserPassword());
        this.waitForPage("grant access");
        Assert.assertTrue((boolean)this.consentPage.isCurrent());
        this.consentPage.confirm();
        Assert.assertTrue((String)"We must be on correct realm right now", (boolean)this.driver.getCurrentUrl().contains("/auth/realms/" + this.consumerRealmName() + "/"));
        UsersResource consumerUsers = this.adminClient.realm(this.consumerRealmName()).users();
        Assert.assertTrue((String)"There must be at least one user", (consumerUsers.count() > 0 ? 1 : 0) != 0);
        List users = consumerUsers.search("", Integer.valueOf(0), Integer.valueOf(5));
        UserRepresentation foundUser = null;
        for (UserRepresentation user : users) {
            if (!user.getUsername().equals(this.getUserLogin()) || !user.getEmail().equals(this.getUserEmail())) continue;
            foundUser = user;
            break;
        }
        Assert.assertNotNull((String)("There must be user " + this.getUserLogin() + " in realm " + this.consumerRealmName()), foundUser);
        RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
        users = providerRealm.users().search(null, foundUser.getFirstName(), foundUser.getLastName(), null, Integer.valueOf(0), Integer.valueOf(1));
        Assert.assertEquals((String)"Same user should be in provider realm", (long)1L, (long)users.size());
        String userId = ((UserRepresentation)users.get(0)).getId();
        UserResource userResource = providerRealm.users().get(userId);
        List consents = userResource.getConsents();
        Assert.assertEquals((String)"There should be one consent", (long)1L, (long)consents.size());
        Map consent = (Map)consents.get(0);
        Assert.assertEquals((String)"Consent should be given to brokerapp", (Object)CLIENT_ID, consent.get("clientId"));
        List sessions = userResource.getUserSessions();
        Assert.assertEquals((String)"There should be one active session", (long)1L, (long)sessions.size());
        Assert.assertEquals((String)"There should be one client in user session", (long)1L, (long)((UserSessionRepresentation)sessions.get(0)).getClients().size());
        userResource.revokeConsent(CLIENT_ID);
        consents = userResource.getConsents();
        Assert.assertEquals((String)"There should be no consents", (long)0L, (long)consents.size());
        sessions = userResource.getUserSessions();
        Assert.assertEquals((String)"There should be one active session", (long)1L, (long)sessions.size());
        Assert.assertEquals((String)"There should be no client in user session", (long)0L, (long)((UserSessionRepresentation)sessions.get(0)).getClients().size());
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testRetrieveConsentsForUserWithClientsWithGrantedOfflineAccess() throws Exception {
        RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
        RealmRepresentation providerRealmRep = providerRealm.toRepresentation();
        providerRealmRep.setAccountTheme("keycloak");
        providerRealm.update(providerRealmRep);
        ClientRepresentation providerAccountRep = (ClientRepresentation)providerRealm.clients().findByClientId("account").get(0);
        ClientScopeRepresentation offlineAccessScope = providerRealm.getDefaultOptionalClientScopes().stream().filter(csr -> csr.getName().equals("offline_access")).findFirst().get();
        providerRealm.clients().get(providerAccountRep.getId()).removeOptionalClientScope(offlineAccessScope.getId());
        providerRealm.clients().get(providerAccountRep.getId()).addDefaultClientScope(offlineAccessScope.getId());
        providerAccountRep.setConsentRequired(Boolean.valueOf(true));
        providerAccountRep.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        providerRealm.clients().get(providerAccountRep.getId()).update(providerAccountRep);
        List searchResult = providerRealm.users().search(this.getUserLogin());
        UserRepresentation user = (UserRepresentation)searchResult.get(0);
        this.driver.navigate().to(this.getAccountUrl(this.providerRealmName()));
        this.waitForPage("Sign in to provider");
        this.log.debug((Object)"Logging in");
        this.accountLoginPage.login(this.getUserLogin(), this.getUserPassword());
        this.waitForPage("grant access");
        this.log.debug((Object)"Grant consent for offline_access");
        Assert.assertTrue((boolean)this.consentPage.isCurrent());
        this.consentPage.confirm();
        this.waitForPage("keycloak account console");
        providerAccountRep.setConsentRequired(Boolean.valueOf(false));
        providerRealm.clients().get(providerAccountRep.getId()).update(providerAccountRep);
        this.log.debug((Object)"Obtain offline_token");
        OAuthClient.AccessTokenResponse response = this.oauth.realm(providerRealmRep.getRealm()).clientId(providerAccountRep.getClientId()).scope("openid profile offline_access").doGrantAccessTokenRequest(null, this.getUserLogin(), this.getUserPassword());
        org.junit.Assert.assertNotNull((Object)response.getRefreshToken());
        this.log.debug((Object)"Check for Offline Token in consents");
        List consents = providerRealm.users().get(user.getId()).getConsents();
        org.junit.Assert.assertFalse((String)"Consents should not be empty", (boolean)consents.isEmpty());
        org.junit.Assert.assertTrue((boolean)consents.toString().contains("Offline Token"));
    }

    @Test
    public void testConsentCancel() {
        RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
        ClientResource accountClient = ApiUtil.findClientByClientId((RealmResource)providerRealm, (String)"account");
        ClientRepresentation clientRepresentation = accountClient.toRepresentation();
        clientRepresentation.setConsentRequired(Boolean.valueOf(true));
        accountClient.update(clientRepresentation);
        this.accountPage.setAuthRealm(this.providerRealmName());
        this.accountPage.navigateTo();
        this.loginPage.form().login(this.getUserLogin(), this.getUserPassword());
        this.consentPage.assertCurrent();
        this.consentPage.cancel();
        this.errorPage.assertCurrent();
        org.junit.Assert.assertEquals((Object)"No access", (Object)this.errorPage.getError());
        this.errorPage.clickBackToApplication();
        this.loginPage.form().login(this.getUserLogin(), this.getUserPassword());
        this.consentPage.confirm();
        this.accountPage.assertCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void clientConsentRequiredAfterLogin() {
        this.oauth.realm("test").clientId("test-app");
        OAuthClient.AuthorizationEndpointResponse response = this.oauth.doLogin("test-user@localhost", USER_PASSWORD);
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest(response.getCode(), USER_PASSWORD);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        EventRepresentation loginEvent = this.events.expectLogin().detail("username", "test-user@localhost").assertEvent();
        String sessionId = loginEvent.getSessionId();
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.adminClient.realm("test").clients().findByClientId("test-app").get(0);
        try {
            clientRepresentation.setConsentRequired(Boolean.valueOf(true));
            this.adminClient.realm("test").clients().get(clientRepresentation.getId()).update(clientRepresentation);
            this.events.clear();
            OAuthClient.AccessTokenResponse refreshTokenResponse = this.oauth.doRefreshTokenRequest(accessTokenResponse.getRefreshToken(), USER_PASSWORD);
            Assert.assertEquals((Object)"invalid_scope", (Object)refreshTokenResponse.getError());
            Assert.assertEquals((Object)"Client no longer has requested consent from user", (Object)refreshTokenResponse.getErrorDescription());
            this.events.expectRefresh(accessTokenResponse.getRefreshToken(), sessionId).clearDetails().error("invalid_token").assertEvent();
        }
        finally {
            clientRepresentation.setConsentRequired(Boolean.valueOf(false));
            this.adminClient.realm("test").clients().get(clientRepresentation.getId()).update(clientRepresentation);
        }
    }

    @Test
    public void testConsentWithAdditionalClientAttributes() {
        RealmResource providerRealm = this.adminClient.realm(this.providerRealmName());
        ClientResource accountClient = ApiUtil.findClientByClientId((RealmResource)providerRealm, (String)"account");
        ClientRepresentation clientRepresentation = accountClient.toRepresentation();
        clientRepresentation.setConsentRequired(Boolean.valueOf(true));
        clientRepresentation.getAttributes().put("logoUri", "https://www.keycloak.org/resources/images/keycloak_logo_480x108.png");
        clientRepresentation.getAttributes().put("policyUri", "https://www.keycloak.org/policy");
        clientRepresentation.getAttributes().put("tosUri", "https://www.keycloak.org/tos");
        accountClient.update(clientRepresentation);
        this.accountPage.setAuthRealm(this.providerRealmName());
        this.accountPage.navigateTo();
        this.loginPage.form().login(this.getUserLogin(), this.getUserPassword());
        this.consentPage.assertCurrent();
        org.junit.Assert.assertTrue((String)"logoUri must be presented", (boolean)this.driver.findElement(By.xpath((String)"//img[@src='https://www.keycloak.org/resources/images/keycloak_logo_480x108.png']")).isDisplayed());
        org.junit.Assert.assertTrue((String)"policyUri must be presented", (boolean)this.driver.findElement(By.xpath((String)"//a[@href='https://www.keycloak.org/policy']")).isDisplayed());
        org.junit.Assert.assertTrue((String)"tosUri must be presented", (boolean)this.driver.findElement(By.xpath((String)"//a[@href='https://www.keycloak.org/tos']")).isDisplayed());
        this.consentPage.confirm();
        this.accountPage.assertCurrent();
    }

    private String getAccountUrl(String realmName) {
        return this.getAuthRoot() + "/auth/realms/" + realmName + "/account";
    }
}

