/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ComponentResource;
import org.keycloak.admin.client.resource.ComponentsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.components.TestProvider;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class ComponentsTest
extends AbstractAdminTest {
    private ComponentsResource components;
    private volatile CountDownLatch remainingDeleteSubmissions;
    private static final int NUMBER_OF_THREADS = 4;
    private static final int NUMBER_OF_TASKS = 20;
    private static final int NUMBER_OF_CHILDREN = 3;

    @Before
    public void before() throws Exception {
        this.components = this.adminClient.realm("admin-client-test").components();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrency(BiConsumer<ExecutorService, Integer> taskCreator) throws InterruptedException {
        ExecutorService s = Executors.newFixedThreadPool(4, (ThreadFactory)new BasicThreadFactory.Builder().daemon(true).uncaughtExceptionHandler((t, e) -> this.log.error((Object)e.getMessage(), e)).build());
        this.remainingDeleteSubmissions = new CountDownLatch(20);
        for (int i = 0; i < 20; ++i) {
            taskCreator.accept(s, i);
        }
        try {
            Assert.assertTrue((String)"Did not create all components in time", (boolean)this.remainingDeleteSubmissions.await(100L, TimeUnit.SECONDS));
            s.shutdown();
            Assert.assertTrue((String)"Did not finish before timeout", (boolean)s.awaitTermination(100L, TimeUnit.SECONDS));
        }
        finally {
            s.shutdownNow();
        }
    }

    @Test
    public void testConcurrencyWithoutChildren() throws InterruptedException {
        this.testConcurrency((s, i) -> s.submit(new CreateAndDeleteComponent((ExecutorService)s, (int)i)));
    }

    @Test
    public void testConcurrencyWithChildren() throws InterruptedException {
        this.testConcurrency((s, i) -> s.submit(new CreateAndDeleteComponentWithFlatChildren((ExecutorService)s, (int)i)));
    }

    @Test
    public void testNotDeadlocked() {
        for (int i = 0; i < 50; ++i) {
            ComponentRepresentation rep = this.createComponentRepresentation("test-" + i);
            rep.getConfig().putSingle((Object)"required", (Object)"required-value");
            this.createComponent(rep);
            List list = this.realm.components().query(this.realmId, TestProvider.class.getName());
            Assert.assertEquals((long)(i + 1), (long)list.size());
        }
    }

    @Test
    public void testCreateValidation() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        try {
            this.createComponent(rep);
        }
        catch (WebApplicationException e) {
            this.assertError(e.getResponse(), "'Required' is required");
        }
        rep.getConfig().putSingle((Object)"required", (Object)"Required");
        rep.getConfig().putSingle((Object)"number", (Object)"invalid");
        try {
            this.createComponent(rep);
        }
        catch (WebApplicationException e) {
            this.assertError(e.getResponse(), "'Number' should be a number");
        }
    }

    @Test
    public void testCreateEmptyValues() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)"");
        rep.getConfig().put((Object)"val2", null);
        rep.getConfig().put((Object)"val3", Collections.emptyList());
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)"foo", (Object)returned.getSubType());
        Assert.assertEquals((long)1L, (long)returned.getConfig().size());
        Assert.assertTrue((boolean)returned.getConfig().containsKey((Object)"required"));
    }

    @Test
    public void testCreateWithoutGivenId() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.setId(null);
        String id = this.createComponent(rep);
        Assert.assertNotNull((Object)id);
    }

    @Test
    public void testCreateWithGivenId() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.setId("fixed-id");
        String id = this.createComponent(rep);
        Assert.assertEquals((Object)"fixed-id", (Object)id);
    }

    @Test
    public void testUpdate() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)"one");
        rep.getConfig().addFirst((Object)"val2", (Object)"two");
        rep.getConfig().addFirst((Object)"val3", (Object)"three");
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((long)4L, (long)returned.getConfig().size());
        Assert.assertEquals((Object)"foo", (Object)returned.getConfig().getFirst((Object)"required"));
        Assert.assertEquals((Object)"one", (Object)returned.getConfig().getFirst((Object)"val1"));
        Assert.assertEquals((Object)"two", (Object)returned.getConfig().getFirst((Object)"val2"));
        Assert.assertEquals((Object)"three", (Object)returned.getConfig().getFirst((Object)"val3"));
        returned.getConfig().putSingle((Object)"val1", (Object)"one-updated");
        returned.getConfig().putSingle((Object)"val2", null);
        this.components.component(id).update(returned);
        returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((long)3L, (long)returned.getConfig().size());
        Assert.assertEquals((Object)"one-updated", (Object)returned.getConfig().getFirst((Object)"val1"));
        Assert.assertFalse((boolean)returned.getConfig().containsKey((Object)"val2"));
        returned.getConfig().addFirst((Object)"val1", (Object)"");
        this.components.component(id).update(returned);
        returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((long)2L, (long)returned.getConfig().size());
        returned.getConfig().put((Object)"val3", Collections.emptyList());
        this.components.component(id).update(returned);
        returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((long)1L, (long)returned.getConfig().size());
    }

    @Test
    public void testRename() {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)"mycomponent", (Object)returned.getName());
        rep.setName("myupdatedcomponent");
        this.components.component(id).update(rep);
        returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)"myupdatedcomponent", (Object)returned.getName());
    }

    @Test
    public void testSecretConfig() throws Exception {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        rep.getConfig().addFirst((Object)"secret", (Object)"some secret value!!");
        rep.getConfig().addFirst((Object)"required", (Object)"some required value");
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)"**********", (Object)returned.getConfig().getFirst((Object)"secret"));
        AdminEventRepresentation event = this.testingClient.testing().pollAdminEvent();
        Assert.assertFalse((boolean)event.getRepresentation().contains("some secret value!!"));
        Assert.assertTrue((boolean)event.getRepresentation().contains("**********"));
        Map details = this.testingClient.testing("admin-client-test").getTestComponentDetails();
        Assert.assertEquals((Object)"some secret value!!", ((List)((TestProvider.DetailsRepresentation)details.get("mycomponent")).getConfig().get("secret")).get(0));
        returned.getConfig().putSingle((Object)"priority", (Object)"200");
        this.components.component(id).update(returned);
        ComponentRepresentation returned2 = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)"**********", (Object)returned2.getConfig().getFirst((Object)"secret"));
        event = this.testingClient.testing().pollAdminEvent();
        Assert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"some secret value!!")));
        Assert.assertThat((Object)event.getRepresentation(), (Matcher)Matchers.containsString((String)"**********"));
        details = this.testingClient.testing("admin-client-test").getTestComponentDetails();
        Assert.assertEquals((Object)"some secret value!!", ((List)((TestProvider.DetailsRepresentation)details.get("mycomponent")).getConfig().get("secret")).get(0));
        returned2.getConfig().putSingle((Object)"secret", (Object)"updated secret value!!");
        this.components.component(id).update(returned2);
        details = this.testingClient.testing("admin-client-test").getTestComponentDetails();
        Assert.assertEquals((Object)"updated secret value!!", ((List)((TestProvider.DetailsRepresentation)details.get("mycomponent")).getConfig().get("secret")).get(0));
        ComponentRepresentation returned3 = this.components.query().stream().filter(c -> c.getId().equals(returned2.getId())).findFirst().get();
        Assert.assertEquals((Object)"**********", (Object)returned3.getConfig().getFirst((Object)"secret"));
        returned2.getConfig().putSingle((Object)"secret", (Object)"${vault.value}");
        this.components.component(id).update(returned2);
        details = this.testingClient.testing("admin-client-test").getTestComponentDetails();
        Assert.assertThat(((TestProvider.DetailsRepresentation)details.get("mycomponent")).getConfig().get("secret"), (Matcher)Matchers.contains((Object[])new String[]{"${vault.value}"}));
        ComponentRepresentation returned4 = this.components.query().stream().filter(c -> c.getId().equals(returned2.getId())).findFirst().get();
        Assert.assertThat((Object)returned4.getConfig().get((Object)"secret"), (Matcher)Matchers.contains((Object[])new String[]{"${vault.value}"}));
    }

    @Test
    public void testLongValueInComponentConfigAscii() throws Exception {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        String value = StringUtils.repeat((String)"0123456789", (int)400);
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)value);
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)value, (Object)returned.getConfig().getFirst((Object)"val1"));
    }

    @Test
    public void testLongValueInComponentConfigExtLatin() throws Exception {
        ComponentRepresentation rep = this.createComponentRepresentation("mycomponent");
        String value = StringUtils.repeat((String)"\u011b\u0161\u010d\u0159\u017e\u00fd\u00ed\u016e\u00cd\u00c1", (int)400);
        rep.getConfig().addFirst((Object)"required", (Object)"foo");
        rep.getConfig().addFirst((Object)"val1", (Object)value);
        String id = this.createComponent(rep);
        ComponentRepresentation returned = this.components.component(id).toRepresentation();
        Assert.assertEquals((Object)value, (Object)returned.getConfig().getFirst((Object)"val1"));
    }

    private String createComponent(ComponentRepresentation rep) {
        return this.createComponent(this.realm, rep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createComponent(RealmResource realm, ComponentRepresentation rep) {
        Response response = null;
        try {
            ComponentsResource components = realm.components();
            response = components.add(rep);
            String id = ApiUtil.getCreatedId((Response)response);
            this.getCleanup(realm.toRepresentation().getRealm()).addComponentId(id);
            String string = id;
            return string;
        }
        finally {
            if (response != null) {
                response.bufferEntity();
                response.close();
            }
        }
    }

    private void assertError(Response response, String error) {
        if (!response.hasEntity()) {
            Assert.fail((String)"No error message set");
        }
        ErrorRepresentation errorRepresentation = (ErrorRepresentation)response.readEntity(ErrorRepresentation.class);
        Assert.assertEquals((Object)error, (Object)errorRepresentation.getErrorMessage());
    }

    private ComponentRepresentation createComponentRepresentation(String name) {
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName(name);
        rep.setParentId(this.realmId);
        rep.setProviderId("test");
        rep.setProviderType(TestProvider.class.getName());
        rep.setSubType("foo");
        MultivaluedHashMap config = new MultivaluedHashMap();
        rep.setConfig(config);
        return rep;
    }

    private class DeleteComponent
    implements Runnable {
        private final String id;

        public DeleteComponent(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            ComponentsTest.this.log.debugf("Started, id=%s", (Object)this.id);
            ComponentResource c = ComponentsTest.this.realm.components().component(this.id);
            Assert.assertThat((Object)c.toRepresentation(), (Matcher)Matchers.notNullValue());
            c.remove();
            ComponentsTest.this.log.debugf("Finished, id=%s", (Object)this.id);
        }
    }

    private class CreateAndDeleteComponentWithFlatChildren
    extends CreateAndDeleteComponent {
        public CreateAndDeleteComponentWithFlatChildren(ExecutorService s, int i) {
            super(s, i);
        }

        @Override
        protected void createChildren(String id) {
            for (int j = 0; j < 3; ++j) {
                ComponentRepresentation rep = ComponentsTest.this.createComponentRepresentation("test-" + this.i + ":" + j);
                rep.setParentId(id);
                rep.getConfig().putSingle((Object)"required", (Object)"required-value");
                Assert.assertThat((Object)ComponentsTest.this.createComponent(this.realm, rep), (Matcher)Matchers.notNullValue());
            }
        }
    }

    private class CreateComponentWithFlatChildren
    extends CreateComponent {
        public CreateComponentWithFlatChildren(ExecutorService s, int i, RealmResource realm) {
            super(s, i, realm);
        }

        public CreateComponentWithFlatChildren(ExecutorService s, int i) {
            super(s, i);
        }

        @Override
        protected void createChildren(String id) {
            for (int j = 0; j < 3; ++j) {
                ComponentRepresentation rep = ComponentsTest.this.createComponentRepresentation("test-" + this.i + ":" + j);
                rep.setParentId(id);
                rep.getConfig().putSingle((Object)"required", (Object)"required-value");
                Assert.assertThat((Object)ComponentsTest.this.createComponent(this.realm, rep), (Matcher)Matchers.notNullValue());
            }
        }
    }

    private class CreateAndDeleteComponent
    extends CreateComponent {
        public CreateAndDeleteComponent(ExecutorService s, int i) {
            super(s, i);
        }

        @Override
        protected void scheduleDeleteComponent(String id) {
            this.s.submit(new DeleteComponent(id));
        }
    }

    private class CreateComponent
    implements Runnable {
        protected final ExecutorService s;
        protected final int i;
        protected final RealmResource realm;

        public CreateComponent(ExecutorService s, int i, RealmResource realm) {
            this.s = s;
            this.i = i;
            this.realm = realm;
        }

        public CreateComponent(ExecutorService s, int i) {
            this(s, i, componentsTest.realm);
        }

        @Override
        public void run() {
            ComponentsTest.this.log.debugf("Started for i=%d ", this.i);
            ComponentRepresentation rep = ComponentsTest.this.createComponentRepresentation("test-" + this.i);
            rep.getConfig().putSingle((Object)"required", (Object)"required-value");
            rep.setParentId(this.realm.toRepresentation().getId());
            String id = ComponentsTest.this.createComponent(this.realm, rep);
            Assert.assertThat((Object)id, (Matcher)Matchers.notNullValue());
            this.createChildren(id);
            ComponentsTest.this.log.debugf("Finished: i=%d, id=%s", this.i, (Object)id);
            this.scheduleDeleteComponent(id);
            ComponentsTest.this.remainingDeleteSubmissions.countDown();
        }

        protected void scheduleDeleteComponent(String id) {
        }

        protected void createChildren(String id) {
        }
    }
}

