/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.Constants;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.OAuth2ErrorRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.Assert;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class ClientTest
extends AbstractAdminTest {
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void getClients() {
        Assert.assertNames(this.realm.clients().findAll(), "account", "account-console", "realm-management", "security-admin-console", "broker", "admin-cli");
    }

    private ClientRepresentation createClient() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("my-app");
        rep.setDescription("my-app description");
        rep.setEnabled(Boolean.valueOf(true));
        Response response = this.realm.clients().create(rep);
        response.close();
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(id);
        ClientRepresentation found = ApiUtil.findClientResourceByClientId((RealmResource)this.realm, (String)"my-app").toRepresentation();
        org.junit.Assert.assertEquals((Object)"my-app", (Object)found.getClientId());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(id), (Object)rep, ResourceType.CLIENT);
        rep.setId(id);
        return rep;
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void createClientVerify() {
        String id = this.createClient().getId();
        ClientResource client = this.realm.clients().get(id);
        org.junit.Assert.assertNotNull((Object)client);
        org.junit.Assert.assertNull((Object)client.toRepresentation().getSecret());
        Assert.assertNames(this.realm.clients().findAll(), "account", "account-console", "realm-management", "security-admin-console", "broker", "my-app", "admin-cli");
    }

    @Test
    public void testInvalidUrlClientValidation() {
        this.testClientUriValidation("Root URL is not a valid URL", "Base URL is not a valid URL", "Backchannel logout URL is not a valid URL", null, "invalid", "myapp://some-fake-app");
    }

    @Test
    public void testIllegalSchemeClientValidation() {
        this.testClientUriValidation("Root URL uses an illegal scheme", "Base URL uses an illegal scheme", "Backchannel logout URL uses an illegal scheme", "A redirect URI uses an illegal scheme", "data:text/html;base64,PHNjcmlwdD5jb25maXJtKGRvY3VtZW50LmRvbWFpbik7PC9zY3JpcHQ+", "javascript:confirm(document.domain)/*");
    }

    @Test
    public void testFragmentProhibitedClientValidation() {
        this.testClientUriValidation("Root URL must not contain an URL fragment", null, null, "Redirect URIs must not contain an URI fragment", "http://redhat.com/abcd#someFragment");
    }

    private void testClientUriValidation(String expectedRootUrlError, String expectedBaseUrlError, String expectedBackchannelLogoutUrlError, String expectedRedirectUrisError, String ... testUrls) {
        this.testClientUriValidation(false, expectedRootUrlError, expectedBaseUrlError, expectedBackchannelLogoutUrlError, expectedRedirectUrisError, testUrls);
        this.testClientUriValidation(true, expectedRootUrlError, expectedBaseUrlError, expectedBackchannelLogoutUrlError, expectedRedirectUrisError, testUrls);
    }

    private void testClientUriValidation(boolean create, String expectedRootUrlError, String expectedBaseUrlError, String expectedBackchannelLogoutUrlError, String expectedRedirectUrisError, String ... testUrls) {
        ClientRepresentation rep;
        if (create) {
            rep = new ClientRepresentation();
            rep.setClientId("my-app2");
            rep.setEnabled(Boolean.valueOf(true));
        } else {
            rep = this.createClient();
        }
        for (String testUrl : testUrls) {
            if (expectedRootUrlError != null) {
                rep.setRootUrl(testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedRootUrlError);
            }
            rep.setRootUrl(null);
            if (expectedBaseUrlError != null) {
                rep.setBaseUrl(testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedBaseUrlError);
            }
            rep.setBaseUrl(null);
            if (expectedBackchannelLogoutUrlError != null) {
                OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)rep).setBackchannelLogoutUrl(testUrl);
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedBackchannelLogoutUrlError);
            }
            OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)rep).setBackchannelLogoutUrl(null);
            if (expectedRedirectUrisError != null) {
                rep.setRedirectUris(Collections.singletonList(testUrl));
                this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedRedirectUrisError);
            }
            rep.setRedirectUris(null);
            if (expectedRootUrlError != null) {
                rep.setRootUrl(testUrl);
            }
            if (expectedBaseUrlError != null) {
                rep.setBaseUrl(testUrl);
            }
            if (expectedRedirectUrisError != null) {
                rep.setRedirectUris(Collections.singletonList(testUrl));
            }
            this.createOrUpdateClientExpectingValidationErrors(rep, create, expectedRootUrlError, expectedBaseUrlError, expectedRedirectUrisError);
            rep.setRootUrl(null);
            rep.setBaseUrl(null);
            rep.setRedirectUris(null);
        }
    }

    private void createOrUpdateClientExpectingValidationErrors(ClientRepresentation rep, boolean create, String ... expectedErrors) {
        Response response = null;
        if (create) {
            response = this.realm.clients().create(rep);
        } else {
            try {
                this.realm.clients().get(rep.getId()).update(rep);
                org.junit.Assert.fail((String)"Expected exception");
            }
            catch (BadRequestException e) {
                response = e.getResponse();
            }
        }
        expectedErrors = (String[])Arrays.stream(expectedErrors).filter(Objects::nonNull).toArray(String[]::new);
        org.junit.Assert.assertEquals((long)response.getStatus(), (long)400L);
        OAuth2ErrorRepresentation errorRep = (OAuth2ErrorRepresentation)response.readEntity(OAuth2ErrorRepresentation.class);
        List<String> actualErrors = Arrays.asList(errorRep.getErrorDescription().split("; "));
        org.junit.Assert.assertThat(actualErrors, (Matcher)Matchers.containsInAnyOrder((Object[])expectedErrors));
        org.junit.Assert.assertEquals((Object)"invalid_input", (Object)errorRep.getError());
    }

    @Test
    public void removeClient() {
        String id = this.createClient().getId();
        org.junit.Assert.assertNotNull((Object)ApiUtil.findClientByClientId((RealmResource)this.realm, (String)"my-app"));
        this.realm.clients().get(id).remove();
        org.junit.Assert.assertNull((Object)ApiUtil.findClientResourceByClientId((RealmResource)this.realm, (String)"my-app"));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientResourcePath(id), ResourceType.CLIENT);
    }

    @Test
    public void removeInternalClientExpectingBadRequestException() {
        String testRealmClientId = ApiUtil.findClientByClientId((RealmResource)this.realmsResouce().realm("master"), (String)"test-realm").toRepresentation().getId();
        org.junit.Assert.assertThrows(BadRequestException.class, () -> this.realmsResouce().realm("master").clients().get(testRealmClientId).remove());
        Constants.defaultClients.forEach(defaultClient -> {
            String defaultClientId = ApiUtil.findClientByClientId((RealmResource)this.realm, (String)defaultClient).toRepresentation().getId();
            org.junit.Assert.assertThrows(BadRequestException.class, () -> this.realm.clients().get(defaultClientId).remove());
        });
    }

    @Test
    public void getClientRepresentation() {
        String id = this.createClient().getId();
        ClientRepresentation rep = this.realm.clients().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)id, (Object)rep.getId());
        org.junit.Assert.assertEquals((Object)"my-app", (Object)rep.getClientId());
        org.junit.Assert.assertTrue((boolean)rep.isEnabled());
    }

    @Test
    public void getClientDescription() {
        String id = this.createClient().getId();
        ClientRepresentation rep = this.realm.clients().get(id).toRepresentation();
        org.junit.Assert.assertEquals((Object)id, (Object)rep.getId());
        org.junit.Assert.assertEquals((Object)"my-app description", (Object)rep.getDescription());
    }

    @Test
    public void getClientSessions() throws Exception {
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest("password", "test-user@localhost", "password");
        org.junit.Assert.assertEquals((long)200L, (long)response.getStatusCode());
        OAuthClient.AuthorizationEndpointResponse codeResponse = this.oauth.doLogin("test-user@localhost", "password");
        OAuthClient.AccessTokenResponse response2 = this.oauth.doAccessTokenRequest(codeResponse.getCode(), "password");
        org.junit.Assert.assertEquals((long)200L, (long)response2.getStatusCode());
        ClientResource app = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app");
        org.junit.Assert.assertEquals((long)2L, (long)((Integer)app.getApplicationSessionCount().get("count")).intValue());
        List userSessions = app.getUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        org.junit.Assert.assertEquals((long)2L, (long)userSessions.size());
        org.junit.Assert.assertEquals((long)1L, (long)((UserSessionRepresentation)userSessions.get(0)).getClients().size());
    }

    @Test
    public void getAllClients() {
        List allClients = this.realm.clients().findAll();
        org.junit.Assert.assertNotNull((Object)allClients);
        org.junit.Assert.assertFalse((boolean)allClients.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void getAllClientsSearchAndPagination() {
        HashSet<String> ids = new HashSet<String>();
        try {
            for (int i = 1; i <= 10; ++i) {
                ClientRepresentation c = ClientBuilder.create().clientId("ccx-" + (i < 10 ? "0" + i : Integer.valueOf(i))).build();
                Response response = this.realm.clients().create(c);
                ids.add(ApiUtil.getCreatedId((Response)response));
                response.close();
            }
            this.assertPaginatedClients(1, 10, this.realm.clients().findAll("ccx-", null, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(100)));
            this.assertPaginatedClients(1, 5, this.realm.clients().findAll("ccx-", null, Boolean.valueOf(true), Integer.valueOf(0), Integer.valueOf(5)));
            this.assertPaginatedClients(6, 10, this.realm.clients().findAll("ccx-", null, Boolean.valueOf(true), Integer.valueOf(5), Integer.valueOf(5)));
        }
        finally {
            ids.stream().forEach(id -> this.realm.clients().get(id).remove());
        }
    }

    private void assertPaginatedClients(int start, int end, List<ClientRepresentation> actual) {
        LinkedList<String> expected = new LinkedList<String>();
        for (int i = start; i <= end; ++i) {
            expected.add("ccx-" + (i < 10 ? "0" + i : Integer.valueOf(i)));
        }
        List a = actual.stream().map(rep -> rep.getClientId()).collect(Collectors.toList());
        org.junit.Assert.assertThat(a, (Matcher)CoreMatchers.is(expected));
    }

    @Test
    public void getClientById() {
        this.createClient();
        ClientRepresentation rep = ApiUtil.findClientResourceByClientId((RealmResource)this.realm, (String)"my-app").toRepresentation();
        ClientRepresentation gotById = this.realm.clients().get(rep.getId()).toRepresentation();
        ClientTest.assertClient(rep, gotById);
    }

    @Test
    public void deleteDefaultRole() {
        ClientRepresentation rep = this.createClient();
        String id = rep.getId();
        RoleRepresentation role = new RoleRepresentation("test", "test", false);
        this.realm.clients().get(id).roles().create(role);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(id, "test"), (Object)role, ResourceType.CLIENT_ROLE);
        role = this.realm.clients().get(id).roles().get("test").toRepresentation();
        this.realm.roles().get("default-roles-admin-client-test").addComposites(Collections.singletonList(role));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("default-roles-admin-client-test"), Collections.singletonList(role), ResourceType.REALM_ROLE);
        org.junit.Assert.assertThat(this.realm.roles().get("default-roles-admin-client-test").getRoleComposites().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()), (Matcher)Matchers.hasItem((Object)role.getName()));
        this.realm.clients().get(id).roles().deleteRole("test");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientRoleResourcePath(id, "test"), ResourceType.CLIENT_ROLE);
        org.junit.Assert.assertThat(this.realm.roles().get("default-roles-admin-client-test").getRoleComposites().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)role)));
    }

    @Test
    public void testProtocolMappers() {
        String clientDbId = this.createClient().getId();
        ProtocolMappersResource mappersResource = ApiUtil.findClientByClientId((RealmResource)this.realm, (String)"my-app").getProtocolMappers();
        this.protocolMappersTest(clientDbId, mappersResource);
    }

    @Test
    public void updateClient() {
        ClientRepresentation client = this.createClient();
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setId(client.getId());
        newClient.setClientId(client.getClientId());
        newClient.setBaseUrl("http://baseurl");
        this.realm.clients().get(client.getId()).update(newClient);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientResourcePath(client.getId()), (Object)newClient, ResourceType.CLIENT);
        ClientRepresentation storedClient = this.realm.clients().get(client.getId()).toRepresentation();
        ClientTest.assertClient(client, storedClient);
        newClient.setSecret("new-secret");
        this.realm.clients().get(client.getId()).update(newClient);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientResourcePath(client.getId()), (Object)newClient, ResourceType.CLIENT);
        storedClient = this.realm.clients().get(client.getId()).toRepresentation();
        ClientTest.assertClient(client, storedClient);
        storedClient.getAttributes().put("backchannel.logout.url", "");
        this.realm.clients().get(storedClient.getId()).update(storedClient);
        storedClient = this.realm.clients().get(client.getId()).toRepresentation();
        org.junit.Assert.assertFalse((boolean)storedClient.getAttributes().containsKey("backchannel.logout.url"));
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void serviceAccount() {
        Response response = this.realm.clients().create(ClientBuilder.create().clientId("serviceClient").serviceAccount().build());
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(id);
        response.close();
        UserRepresentation userRep = this.realm.clients().get(id).getServiceAccountUser();
        org.junit.Assert.assertEquals((Object)"service-account-serviceclient", (Object)userRep.getUsername());
        org.junit.Assert.assertNull((Object)userRep.getEmail());
    }

    @Test
    public void pushRevocation() {
        this.testingClient.testApp().clearAdminActions();
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        this.realm.clients().get(id).pushRevocation();
        PushNotBeforeAction pushNotBefore = this.testingClient.testApp().getAdminPushNotBefore();
        org.junit.Assert.assertEquals((long)client.getNotBefore().intValue(), (long)pushNotBefore.getNotBefore());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.clientPushRevocationPath(id), ResourceType.CLIENT);
    }

    private ClientRepresentation createAppClient() {
        String redirectUri = this.oauth.getRedirectUri().replace("/master/", "/admin-client-test/");
        ClientRepresentation client = new ClientRepresentation();
        client.setClientId("test-app");
        client.setAdminUrl(this.suiteContext.getAuthServerInfo().getContextRoot() + "/auth/realms/master/app/admin");
        client.setRedirectUris(Collections.singletonList(redirectUri));
        client.setSecret("secret");
        client.setProtocol("openid-connect");
        int notBefore = Time.currentTime() - 60;
        client.setNotBefore(Integer.valueOf(notBefore));
        Response response = this.realm.clients().create(client);
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(id);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientResourcePath(id), (Object)client, ResourceType.CLIENT);
        client.setId(id);
        return client;
    }

    @Test(expected=BadRequestException.class)
    public void testAddNodeWithReservedCharacter() {
        this.testingClient.testApp().clearAdminActions();
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        this.realm.clients().get(id).registerNode(Collections.singletonMap("node", "foo#"));
    }

    @Test
    public void nodes() {
        this.testingClient.testApp().clearAdminActions();
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        String myhost = this.suiteContext.getAuthServerInfo().getContextRoot().getHost();
        this.realm.clients().get(id).registerNode(Collections.singletonMap("node", myhost));
        this.realm.clients().get(id).registerNode(Collections.singletonMap("node", "invalid"));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientNodePath(id, myhost), ResourceType.CLUSTER_NODE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientNodePath(id, "invalid"), ResourceType.CLUSTER_NODE);
        GlobalRequestResult result = this.realm.clients().get(id).testNodesAvailable();
        org.junit.Assert.assertEquals((long)1L, (long)result.getSuccessRequests().size());
        org.junit.Assert.assertEquals((long)1L, (long)result.getFailedRequests().size());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.ACTION, AdminEventPaths.clientTestNodesAvailablePath(id), (Object)result, ResourceType.CLUSTER_NODE);
        TestAvailabilityAction testAvailable = this.testingClient.testApp().getTestAvailable();
        org.junit.Assert.assertEquals((Object)"test-app", (Object)testAvailable.getResource());
        org.junit.Assert.assertEquals((long)2L, (long)this.realm.clients().get(id).toRepresentation().getRegisteredNodes().size());
        this.realm.clients().get(id).unregisterNode("invalid");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientNodePath(id, "invalid"), ResourceType.CLUSTER_NODE);
        org.junit.Assert.assertEquals((long)1L, (long)this.realm.clients().get(id).toRepresentation().getRegisteredNodes().size());
    }

    @Test
    public void offlineUserSessions() throws IOException {
        ClientRepresentation client = this.createAppClient();
        String id = client.getId();
        Response response = this.realm.users().create(UserBuilder.create().username("testuser").build());
        String userId = ApiUtil.getCreatedId((Response)response);
        response.close();
        this.realm.users().get(userId).resetPassword(CredentialBuilder.create().password("password").build());
        Map offlineSessionCount = this.realm.clients().get(id).getOfflineSessionCount();
        org.junit.Assert.assertEquals((Object)new Long(0L), offlineSessionCount.get("count"));
        List userSessions = this.realm.users().get(userId).getOfflineSessions(id);
        org.junit.Assert.assertEquals((String)"There should be no offline sessions", (long)0L, (long)userSessions.size());
        this.oauth.realm("admin-client-test");
        this.oauth.redirectUri((String)client.getRedirectUris().get(0));
        this.oauth.scope("offline_access");
        this.oauth.doLogin("testuser", "password");
        OAuthClient.AccessTokenResponse accessTokenResponse = this.oauth.doAccessTokenRequest((String)this.oauth.getCurrentQuery().get("code"), "secret");
        org.junit.Assert.assertEquals((long)200L, (long)accessTokenResponse.getStatusCode());
        offlineSessionCount = this.realm.clients().get(id).getOfflineSessionCount();
        org.junit.Assert.assertEquals((Object)new Long(1L), offlineSessionCount.get("count"));
        List offlineUserSessions = this.realm.clients().get(id).getOfflineUserSessions(Integer.valueOf(0), Integer.valueOf(100));
        org.junit.Assert.assertEquals((long)1L, (long)offlineUserSessions.size());
        org.junit.Assert.assertEquals((Object)"testuser", (Object)((UserSessionRepresentation)offlineUserSessions.get(0)).getUsername());
        MatcherAssert.assertThat((Object)((UserSessionRepresentation)offlineUserSessions.get(0)).getLastAccess(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(Time.currentTimeMillis() - 10000L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Time.currentTimeMillis()))));
        userSessions = this.realm.users().get(userId).getOfflineSessions(id);
        org.junit.Assert.assertEquals((String)"There should be one offline session", (long)1L, (long)userSessions.size());
        this.assertOfflineSession((UserSessionRepresentation)offlineUserSessions.get(0), (UserSessionRepresentation)userSessions.get(0));
    }

    private void assertOfflineSession(UserSessionRepresentation expected, UserSessionRepresentation actual) {
        org.junit.Assert.assertEquals((String)"id", (Object)expected.getId(), (Object)actual.getId());
        org.junit.Assert.assertEquals((String)"userId", (Object)expected.getUserId(), (Object)actual.getUserId());
        org.junit.Assert.assertEquals((String)"userName", (Object)expected.getUsername(), (Object)actual.getUsername());
        org.junit.Assert.assertEquals((String)"clients", (Object)expected.getClients(), (Object)actual.getClients());
    }

    @Test
    public void scopes() {
        Response response = this.realm.clients().create(ClientBuilder.create().clientId("client").fullScopeEnabled(false).build());
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(id);
        response.close();
        this.assertAdminEvents.poll();
        RoleMappingResource scopesResource = this.realm.clients().get(id).getScopeMappings();
        RoleRepresentation roleRep1 = this.createRealmRole("realm-composite");
        RoleRepresentation roleRep2 = this.createRealmRole("realm-child");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("realm-composite"), (Object)roleRep1, ResourceType.REALM_ROLE);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath("realm-child"), (Object)roleRep2, ResourceType.REALM_ROLE);
        roleRep1 = this.realm.roles().get("realm-composite").toRepresentation();
        roleRep2 = this.realm.roles().get("realm-child").toRepresentation();
        this.realm.roles().get("realm-composite").addComposites(Collections.singletonList(roleRep2));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourceCompositesPath("realm-composite"), Collections.singletonList(roleRep2), ResourceType.REALM_ROLE);
        String accountMgmtId = ((ClientRepresentation)this.realm.clients().findByClientId("account").get(0)).getId();
        RoleRepresentation viewAccountRoleRep = this.realm.clients().get(accountMgmtId).roles().get("view-profile").toRepresentation();
        scopesResource.realmLevel().add(Collections.singletonList(roleRep1));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientScopeMappingsRealmLevelPath(id), Collections.singletonList(roleRep1), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).add(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientScopeMappingsClientLevelPath(id, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames(scopesResource.realmLevel().listAll(), "realm-composite");
        Assert.assertNames(scopesResource.realmLevel().listEffective(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "realm-child", "offline_access", "uma_authorization", "default-roles-admin-client-test");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAll(), "view-profile");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listEffective(), "view-profile");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAvailable(), "manage-account", "manage-account-links", "view-applications", "view-consent", "manage-consent", "delete-account");
        Assert.assertNames(scopesResource.getAll().getRealmMappings(), "realm-composite");
        Assert.assertNames(((ClientMappingsRepresentation)scopesResource.getAll().getClientMappings().get("account")).getMappings(), "view-profile");
        scopesResource.realmLevel().remove(Collections.singletonList(roleRep1));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientScopeMappingsRealmLevelPath(id), Collections.singletonList(roleRep1), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(accountMgmtId).remove(Collections.singletonList(viewAccountRoleRep));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientScopeMappingsClientLevelPath(id, accountMgmtId), Collections.singletonList(viewAccountRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames(scopesResource.realmLevel().listAll(), new String[0]);
        Assert.assertNames(scopesResource.realmLevel().listEffective(), new String[0]);
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "offline_access", "uma_authorization", "realm-composite", "realm-child", "default-roles-admin-client-test");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAll(), new String[0]);
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listAvailable(), "view-profile", "manage-account", "manage-account-links", "view-applications", "view-consent", "manage-consent", "delete-account");
        Assert.assertNames(scopesResource.clientLevel(accountMgmtId).listEffective(), new String[0]);
    }

    @Test
    public void rolesCanBeAddedToScopeEvenWhenTheyAreAlreadyIndirectlyAssigned() {
        Response response = this.realm.clients().create(ClientBuilder.create().clientId("test-client").fullScopeEnabled(false).build());
        String testedClientUuid = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(testedClientUuid);
        response.close();
        this.createRealmRole("realm-composite");
        this.createRealmRole("realm-child");
        this.realm.roles().get("realm-composite").addComposites(Collections.singletonList(this.realm.roles().get("realm-child").toRepresentation()));
        response = this.realm.clients().create(ClientBuilder.create().clientId("role-container-client").build());
        String roleContainerClientUuid = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(roleContainerClientUuid);
        response.close();
        RoleRepresentation clientCompositeRole = RoleBuilder.create().name("client-composite").build();
        this.realm.clients().get(roleContainerClientUuid).roles().create(clientCompositeRole);
        this.realm.clients().get(roleContainerClientUuid).roles().create(RoleBuilder.create().name("client-child").build());
        this.realm.clients().get(roleContainerClientUuid).roles().get("client-composite").addComposites(Collections.singletonList(this.realm.clients().get(roleContainerClientUuid).roles().get("client-child").toRepresentation()));
        RoleMappingResource scopesResource = this.realm.clients().get(testedClientUuid).getScopeMappings();
        scopesResource.realmLevel().add(Collections.singletonList(this.realm.roles().get("realm-composite").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(Collections.singletonList(this.realm.clients().get(roleContainerClientUuid).roles().get("client-composite").toRepresentation()));
        Assert.assertNames(scopesResource.realmLevel().listAll(), "realm-composite");
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "realm-child", "offline_access", "uma_authorization", "default-roles-admin-client-test");
        Assert.assertNames(scopesResource.realmLevel().listEffective(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAll(), "client-composite");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), "client-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listEffective(), "client-composite", "client-child");
        scopesResource.realmLevel().add(Collections.singletonList(this.realm.roles().get("realm-child").toRepresentation()));
        scopesResource.clientLevel(roleContainerClientUuid).add(Collections.singletonList(this.realm.clients().get(roleContainerClientUuid).roles().get("client-child").toRepresentation()));
        Assert.assertNames(scopesResource.realmLevel().listAll(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.realmLevel().listAvailable(), "offline_access", "uma_authorization", "default-roles-admin-client-test");
        Assert.assertNames(scopesResource.realmLevel().listEffective(), "realm-composite", "realm-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAll(), "client-composite", "client-child");
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listAvailable(), new String[0]);
        Assert.assertNames(scopesResource.clientLevel(roleContainerClientUuid).listEffective(), "client-composite", "client-child");
    }

    @Test
    public void scopesRoleRemoval() {
        Response response = this.realm.clients().create(ClientBuilder.create().clientId("clientA").fullScopeEnabled(false).build());
        String idA = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(idA);
        response.close();
        this.assertAdminEvents.poll();
        response = this.realm.clients().create(ClientBuilder.create().clientId("clientB").fullScopeEnabled(false).build());
        String idB = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(idB);
        response.close();
        this.assertAdminEvents.poll();
        RoleMappingResource scopesResource = this.realm.clients().get(idA).getScopeMappings();
        RoleRepresentation realmRoleRep = this.createRealmRole("realm-role");
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.roleResourcePath(realmRoleRep.getName()), (Object)realmRoleRep, ResourceType.REALM_ROLE);
        RoleRepresentation clientBRoleRep = RoleBuilder.create().name("clientB-role").build();
        this.realm.clients().get(idB).roles().create(clientBRoleRep);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientRoleResourcePath(idB, clientBRoleRep.getName()), (Object)clientBRoleRep, ResourceType.CLIENT_ROLE);
        realmRoleRep = this.realm.roles().get(realmRoleRep.getName()).toRepresentation();
        clientBRoleRep = this.realm.clients().get(idB).roles().get(clientBRoleRep.getName()).toRepresentation();
        scopesResource.realmLevel().add(Collections.singletonList(realmRoleRep));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientScopeMappingsRealmLevelPath(idA), Collections.singletonList(realmRoleRep), ResourceType.REALM_SCOPE_MAPPING);
        scopesResource.clientLevel(idB).add(Collections.singletonList(clientBRoleRep));
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientScopeMappingsClientLevelPath(idA, idB), Collections.singletonList(clientBRoleRep), ResourceType.CLIENT_SCOPE_MAPPING);
        Assert.assertNames(scopesResource.realmLevel().listAll(), realmRoleRep.getName());
        Assert.assertNames(scopesResource.clientLevel(idB).listAll(), clientBRoleRep.getName());
        this.realm.roles().deleteRole(realmRoleRep.getName());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.roleResourcePath(realmRoleRep.getName()), ResourceType.REALM_ROLE);
        Assert.assertNames(scopesResource.realmLevel().listAll(), new String[0]);
        Assert.assertNames(scopesResource.clientLevel(idB).listAll(), clientBRoleRep.getName());
        this.realm.clients().get(idB).roles().deleteRole(clientBRoleRep.getName());
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientRoleResourcePath(idB, clientBRoleRep.getName()), ResourceType.CLIENT_ROLE);
        Assert.assertNames(scopesResource.realmLevel().listAll(), new String[0]);
        Assert.assertNames(scopesResource.clientLevel(idB).listAll(), new String[0]);
    }

    public void protocolMappersTest(String clientDbId, ProtocolMappersResource mappersResource) {
        List protocolMappers = mappersResource.getMappers();
        String emailMapperId = null;
        String usernameMapperId = null;
        String fooMapperId = null;
        for (ProtocolMapperRepresentation mapper : protocolMappers) {
            if (mapper.getName().equals("email")) {
                emailMapperId = mapper.getId();
                continue;
            }
            if (mapper.getName().equals("username")) {
                usernameMapperId = mapper.getId();
                continue;
            }
            if (!mapper.getName().equals("foo")) continue;
            fooMapperId = mapper.getId();
        }
        org.junit.Assert.assertNull(emailMapperId);
        org.junit.Assert.assertNull(usernameMapperId);
        org.junit.Assert.assertNull(fooMapperId);
        ProtocolMapperRepresentation fooMapper = new ProtocolMapperRepresentation();
        fooMapper.setName("foo");
        fooMapper.setProtocol("openid-connect");
        fooMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
        Response response = mappersResource.createMapper(fooMapper);
        String location = response.getLocation().toString();
        fooMapperId = location.substring(location.lastIndexOf("/") + 1);
        response.close();
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.CREATE, AdminEventPaths.clientProtocolMapperPath(clientDbId, fooMapperId), (Object)fooMapper, ResourceType.PROTOCOL_MAPPER);
        fooMapper = mappersResource.getMapperById(fooMapperId);
        org.junit.Assert.assertEquals((Object)fooMapper.getName(), (Object)"foo");
        mappersResource.update(fooMapperId, fooMapper);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.UPDATE, AdminEventPaths.clientProtocolMapperPath(clientDbId, fooMapperId), (Object)fooMapper, ResourceType.PROTOCOL_MAPPER);
        fooMapper = mappersResource.getMapperById(fooMapperId);
        mappersResource.delete(fooMapperId);
        this.assertAdminEvents.assertEvent(this.realmId, OperationType.DELETE, AdminEventPaths.clientProtocolMapperPath(clientDbId, fooMapperId), ResourceType.PROTOCOL_MAPPER);
        try {
            mappersResource.getMapperById(fooMapperId);
            org.junit.Assert.fail((String)"Not expected to find deleted mapper");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void updateClientWithProtocolMapper() {
        ClientRepresentation rep = new ClientRepresentation();
        rep.setClientId("my-app");
        ProtocolMapperRepresentation fooMapper = new ProtocolMapperRepresentation();
        fooMapper.setName("foo");
        fooMapper.setProtocol("openid-connect");
        fooMapper.setProtocolMapper("oidc-hardcoded-claim-mapper");
        rep.setProtocolMappers(Collections.singletonList(fooMapper));
        Response response = this.realm.clients().create(rep);
        response.close();
        String id = ApiUtil.getCreatedId((Response)response);
        this.getCleanup().addClientUuid(id);
        ClientResource clientResource = this.realm.clients().get(id);
        org.junit.Assert.assertNotNull((Object)clientResource);
        ClientRepresentation client = clientResource.toRepresentation();
        List protocolMappers = client.getProtocolMappers();
        org.junit.Assert.assertEquals((long)1L, (long)protocolMappers.size());
        ProtocolMapperRepresentation mapper = (ProtocolMapperRepresentation)protocolMappers.get(0);
        org.junit.Assert.assertEquals((Object)"foo", (Object)mapper.getName());
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setId(client.getId());
        newClient.setClientId(client.getClientId());
        ProtocolMapperRepresentation barMapper = new ProtocolMapperRepresentation();
        barMapper.setName("bar");
        barMapper.setProtocol("openid-connect");
        barMapper.setProtocolMapper("oidc-hardcoded-role-mapper");
        protocolMappers.add(barMapper);
        newClient.setProtocolMappers(protocolMappers);
        this.realm.clients().get(client.getId()).update(newClient);
        ClientRepresentation storedClient = this.realm.clients().get(client.getId()).toRepresentation();
        ClientTest.assertClient(client, storedClient);
    }

    public static void assertClient(ClientRepresentation client, ClientRepresentation storedClient) {
        List protocolMappers;
        List webOrigins;
        List redirectUris;
        if (client.getClientId() != null) {
            Assert.assertEquals((Object)client.getClientId(), (Object)storedClient.getClientId());
        }
        if (client.getName() != null) {
            Assert.assertEquals((Object)client.getName(), (Object)storedClient.getName());
        }
        if (client.isEnabled() != null) {
            Assert.assertEquals((Object)client.isEnabled(), (Object)storedClient.isEnabled());
        }
        if (client.isAlwaysDisplayInConsole() != null) {
            Assert.assertEquals((Object)client.isAlwaysDisplayInConsole(), (Object)storedClient.isAlwaysDisplayInConsole());
        }
        if (client.isBearerOnly() != null) {
            Assert.assertEquals((Object)client.isBearerOnly(), (Object)storedClient.isBearerOnly());
        }
        if (client.isPublicClient() != null) {
            Assert.assertEquals((Object)client.isPublicClient(), (Object)storedClient.isPublicClient());
        }
        if (client.isFullScopeAllowed() != null) {
            Assert.assertEquals((Object)client.isFullScopeAllowed(), (Object)storedClient.isFullScopeAllowed());
        }
        if (client.getRootUrl() != null) {
            Assert.assertEquals((Object)client.getRootUrl(), (Object)storedClient.getRootUrl());
        }
        if (client.getAdminUrl() != null) {
            Assert.assertEquals((Object)client.getAdminUrl(), (Object)storedClient.getAdminUrl());
        }
        if (client.getBaseUrl() != null) {
            Assert.assertEquals((Object)client.getBaseUrl(), (Object)storedClient.getBaseUrl());
        }
        if (client.isSurrogateAuthRequired() != null) {
            Assert.assertEquals((Object)client.isSurrogateAuthRequired(), (Object)storedClient.isSurrogateAuthRequired());
        }
        if (client.getClientAuthenticatorType() != null) {
            Assert.assertEquals((Object)client.getClientAuthenticatorType(), (Object)storedClient.getClientAuthenticatorType());
        }
        if (client.getNotBefore() != null) {
            Assert.assertEquals((Object)client.getNotBefore(), (Object)storedClient.getNotBefore());
        }
        if (client.getDefaultRoles() != null) {
            HashSet<String> set = new HashSet<String>();
            for (String val : client.getDefaultRoles()) {
                set.add(val);
            }
            HashSet<String> storedSet = new HashSet<String>();
            for (String val : storedClient.getDefaultRoles()) {
                storedSet.add(val);
            }
            Assert.assertEquals(set, storedSet);
        }
        if ((redirectUris = client.getRedirectUris()) != null) {
            HashSet<String> set = new HashSet<String>();
            for (String val : client.getRedirectUris()) {
                set.add(val);
            }
            HashSet<String> storedSet = new HashSet<String>();
            for (String val : storedClient.getRedirectUris()) {
                storedSet.add(val);
            }
            Assert.assertEquals(set, storedSet);
        }
        if ((webOrigins = client.getWebOrigins()) != null) {
            HashSet<String> set = new HashSet<String>();
            for (String val : client.getWebOrigins()) {
                set.add(val);
            }
            HashSet<String> storedSet = new HashSet<String>();
            for (String val : storedClient.getWebOrigins()) {
                storedSet.add(val);
            }
            Assert.assertEquals(set, storedSet);
        }
        if ((protocolMappers = client.getProtocolMappers()) != null) {
            Set set = protocolMappers.stream().map(ProtocolMapperRepresentation::getName).collect(Collectors.toSet());
            Set storedSet = storedClient.getProtocolMappers().stream().map(ProtocolMapperRepresentation::getName).collect(Collectors.toSet());
            Assert.assertEquals(set, storedSet);
        }
    }

    private RoleRepresentation createRealmRole(String roleName) {
        RoleRepresentation role = RoleBuilder.create().name(roleName).build();
        this.realm.roles().create(role);
        String createdId = this.realm.roles().get(role.getName()).toRepresentation().getId();
        this.getCleanup().addRoleId(createdId);
        return role;
    }
}

