/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import java.util.Map;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AttackDetectionResource;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.admin.AbstractAdminTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.AdminEventPaths;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.UserBuilder;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AttackDetectionResourceTest
extends AbstractAdminTest {
    @ArquillianResource
    private OAuthClient oauthClient;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setBruteForceProtected(Boolean.valueOf(true));
        testRealm.setFailureFactor(Integer.valueOf(2));
        testRealm.getUsers().add(UserBuilder.create().username("test-user2").password("password").build());
    }

    @Test
    public void test() {
        AttackDetectionResource detection = this.adminClient.realm("test").attackDetection();
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user@localhost").getId()), 0, false, false);
        this.oauthClient.doLogin("test-user@localhost", "invalid");
        this.oauthClient.doLogin("test-user@localhost", "invalid");
        this.oauthClient.doLogin("test-user@localhost", "invalid");
        this.oauthClient.doLogin("test-user2", "invalid");
        this.oauthClient.doLogin("test-user2", "invalid");
        this.oauthClient.doLogin("nosuchuser", "invalid");
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user@localhost").getId()), 2, true, true);
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user2").getId()), 2, true, true);
        this.assertBruteForce(detection.bruteForceUserStatus("nosuchuser"), 0, false, false);
        detection.clearBruteForceForUser(this.findUser("test-user@localhost").getId());
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.attackDetectionClearBruteForceForUserPath(this.findUser("test-user@localhost").getId()), ResourceType.USER_LOGIN_FAILURE);
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user@localhost").getId()), 0, false, false);
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user2").getId()), 2, true, true);
        detection.clearAllBruteForce();
        this.assertAdminEvents.assertEvent("test", OperationType.DELETE, AdminEventPaths.attackDetectionClearAllBruteForcePath(), ResourceType.USER_LOGIN_FAILURE);
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user@localhost").getId()), 0, false, false);
        this.assertBruteForce(detection.bruteForceUserStatus(this.findUser("test-user2").getId()), 0, false, false);
    }

    private void assertBruteForce(Map<String, Object> status, Integer expectedNumFailures, Boolean expectedFailure, Boolean expectedDisabled) {
        Assert.assertEquals((long)4L, (long)status.size());
        Assert.assertEquals((Object)expectedNumFailures, (Object)status.get("numFailures"));
        Assert.assertEquals((Object)expectedDisabled, (Object)status.get("disabled"));
        if (expectedFailure.booleanValue()) {
            Assert.assertEquals((Object)"127.0.0.1", (Object)status.get("lastIPFailure"));
            Long lastFailure = (Long)status.get("lastFailure");
            Assert.assertTrue((lastFailure < System.currentTimeMillis() + 1L && lastFailure > System.currentTimeMillis() - 10000L ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((Object)"n/a", (Object)status.get("lastIPFailure"));
            Assert.assertEquals((Object)"0", (Object)status.get("lastFailure").toString());
        }
    }
}

