/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.models.AdminRoles;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;

public class AdminConsoleWhoAmILocaleTest
extends AbstractKeycloakTest {
    private static final String REALM_I18N_OFF = "realm-i18n-off";
    private static final String REALM_I18N_ON = "realm-i18n-on";
    private static final String USER_WITHOUT_LOCALE = "user-without-locale";
    private static final String USER_WITH_LOCALE = "user-with-locale";
    private static final String PASSWORD = "password";
    private static final String DEFAULT_LOCALE = "en";
    private static final String REALM_LOCALE = "no";
    private static final String USER_LOCALE = "de";
    private static final String EXTRA_LOCALE = "zh-CN";
    private CloseableHttpClient client;

    @Before
    public void createHttpClient() throws Exception {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void closeHttpClient() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
        RealmBuilder realm = RealmBuilder.create().name(REALM_I18N_OFF).internationalizationEnabled(false);
        realm.user(UserBuilder.create().username(USER_WITHOUT_LOCALE).password(PASSWORD).role("realm-management", AdminRoles.REALM_ADMIN));
        realm.user(UserBuilder.create().username(USER_WITH_LOCALE).password(PASSWORD).addAttribute("locale", USER_LOCALE).role("realm-management", AdminRoles.REALM_ADMIN));
        testRealms.add(realm.build());
        realm = RealmBuilder.create().name(REALM_I18N_ON).internationalizationEnabled(true).supportedLocales(new HashSet<String>(Arrays.asList(REALM_LOCALE, USER_LOCALE, EXTRA_LOCALE))).defaultLocale(REALM_LOCALE);
        realm.user(UserBuilder.create().username(USER_WITHOUT_LOCALE).password(PASSWORD).role("realm-management", AdminRoles.REALM_ADMIN));
        realm.user(UserBuilder.create().username(USER_WITH_LOCALE).password(PASSWORD).addAttribute("locale", USER_LOCALE).role("realm-management", AdminRoles.REALM_ADMIN));
        testRealms.add(realm.build());
    }

    private String accessToken(String realmName, String username) throws Exception {
        try (Keycloak adminClient = AdminClientUtil.createAdminClient((boolean)true, (String)realmName, (String)username, (String)PASSWORD, (String)"admin-cli", null);){
            AccessTokenResponse accessToken = adminClient.tokenManager().getAccessToken();
            Assert.assertNotNull((Object)accessToken);
            String string = accessToken.getToken();
            return string;
        }
    }

    private String whoAmiUrl(String realmName) {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/admin/" + realmName + "/console/whoami";
    }

    @Test
    public void testLocaleRealmI18nDisabledUserWithoutLocale() throws Exception {
        JsonNode whoAmI = SimpleHttp.doGet((String)this.whoAmiUrl(REALM_I18N_OFF), (HttpClient)this.client).header("Accept", "application/json").auth(this.accessToken(REALM_I18N_OFF, USER_WITHOUT_LOCALE)).asJson();
        Assert.assertEquals((Object)REALM_I18N_OFF, (Object)whoAmI.get("realm").asText());
        Assert.assertEquals((Object)DEFAULT_LOCALE, (Object)whoAmI.get("locale").asText());
    }

    @Test
    public void testLocaleRealmI18nDisabledUserWithLocale() throws Exception {
        JsonNode whoAmI = SimpleHttp.doGet((String)this.whoAmiUrl(REALM_I18N_OFF), (HttpClient)this.client).header("Accept", "application/json").auth(this.accessToken(REALM_I18N_OFF, USER_WITH_LOCALE)).asJson();
        Assert.assertEquals((Object)REALM_I18N_OFF, (Object)whoAmI.get("realm").asText());
        Assert.assertEquals((Object)DEFAULT_LOCALE, (Object)whoAmI.get("locale").asText());
    }

    @Test
    public void testLocaleRealmI18nEnabledUserWithoutLocale() throws Exception {
        JsonNode whoAmI = SimpleHttp.doGet((String)this.whoAmiUrl(REALM_I18N_ON), (HttpClient)this.client).header("Accept", "application/json").auth(this.accessToken(REALM_I18N_ON, USER_WITHOUT_LOCALE)).asJson();
        Assert.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assert.assertEquals((Object)REALM_LOCALE, (Object)whoAmI.get("locale").asText());
    }

    @Test
    public void testLocaleRealmI18nEnabledUserWithLocale() throws Exception {
        JsonNode whoAmI = SimpleHttp.doGet((String)this.whoAmiUrl(REALM_I18N_ON), (HttpClient)this.client).header("Accept", "application/json").auth(this.accessToken(REALM_I18N_ON, USER_WITH_LOCALE)).asJson();
        Assert.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assert.assertEquals((Object)USER_LOCALE, (Object)whoAmI.get("locale").asText());
    }

    @Test
    public void testLocaleRealmI18nEnabledAcceptLanguageHeader() throws Exception {
        JsonNode whoAmI = SimpleHttp.doGet((String)this.whoAmiUrl(REALM_I18N_ON), (HttpClient)this.client).header("Accept", "application/json").auth(this.accessToken(REALM_I18N_ON, USER_WITHOUT_LOCALE)).header("Accept-Language", EXTRA_LOCALE).asJson();
        Assert.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assert.assertEquals((Object)EXTRA_LOCALE, (Object)whoAmI.get("locale").asText());
    }

    @Test
    public void testLocaleRealmI18nEnabledKeycloakLocaleCookie() throws Exception {
        JsonNode whoAmI = SimpleHttp.doGet((String)this.whoAmiUrl(REALM_I18N_ON), (HttpClient)this.client).header("Accept", "application/json").auth(this.accessToken(REALM_I18N_ON, USER_WITHOUT_LOCALE)).header("Cookie", "KEYCLOAK_LOCALE=zh-CN").asJson();
        Assert.assertEquals((Object)REALM_I18N_ON, (Object)whoAmI.get("realm").asText());
        Assert.assertEquals((Object)EXTRA_LOCALE, (Object)whoAmI.get("locale").asText());
    }
}

