/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.admin;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.RealmBuilder;

public class AdminConsolePermissionsCalculatedTest
extends AbstractKeycloakTest {
    private static final String REALM_NAME = "realm-name";
    private CloseableHttpClient client;

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }

    @Test
    public void changeRealmTokenAlgorithm() throws Exception {
        try (Keycloak adminClient = AdminClientUtil.createAdminClient((boolean)this.suiteContext.isAdapterCompatTesting(), (String)this.suiteContext.getAuthServerInfo().getContextRoot().toString());
             Creator c = Creator.create((Keycloak)adminClient, (RealmRepresentation)RealmBuilder.create().name(REALM_NAME).build());){
            AccessTokenResponse accessToken = adminClient.tokenManager().getAccessToken();
            Assert.assertNotNull((Object)adminClient.realms().findAll());
            String whoAmiUrl = this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/admin/master/console/whoami";
            JsonNode jsonNode = SimpleHttp.doGet((String)whoAmiUrl, (HttpClient)this.client).auth(accessToken.getToken()).asJson();
            Assert.assertTrue((String)("Permissions for " + Config.getAdminRealm() + " realm."), (boolean)jsonNode.at("/realm_access/" + Config.getAdminRealm()).isArray());
            Assert.assertTrue((String)"Permissions for realm-name realm.", (boolean)jsonNode.at("/realm_access/realm-name").isArray());
        }
    }
}

