/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adduser;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.text.IsEmptyString;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractKeycloakTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.util.JsonSerialization;
import org.keycloak.wildfly.adduser.AddUser;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AddUserTest
extends AbstractKeycloakTest {
    @ArquillianResource
    private ContainerController controller;

    @BeforeClass
    public static void enabled() {
        ContainerAssume.assumeNotAuthServerUndertow();
        ContainerAssume.assumeNotAuthServerRemote();
        ContainerAssume.assumeNotAuthServerQuarkus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addUserTest() throws Exception {
        String username = "addusertest-admin";
        String realmName = "master";
        String configDir = System.getProperty("auth.server.config.dir");
        Assert.assertThat((String)"AuthServer config directory is NULL !!", (Object)configDir, (Matcher)IsNull.notNullValue());
        String authServerQualifier = this.suiteContext.getAuthServerInfo().getQualifier();
        Assert.assertThat((String)"Qualifier of AuthServer is empty or NULL !!", (Object)authServerQualifier, (Matcher)IsNot.not((Matcher)IsEmptyString.isEmptyOrNullString()));
        Assert.assertThat((String)"Controller isn't running.", (Object)this.controller.isStarted(authServerQualifier), (Matcher)Is.is((Object)true));
        AddUser.main((String[])new String[]{"-u", "addusertest-admin", "-p", "password", "--sc", configDir});
        List realms = (List)JsonSerialization.readValue((InputStream)new FileInputStream(new File(configDir, "keycloak-add-user.json")), (TypeReference)new TypeReference<List<RealmRepresentation>>(){});
        Assert.assertThat((String)"File 'keycloak-add-user.json' is empty.", (Object)realms, (Matcher)IsNot.not((Matcher)Matchers.empty()));
        int realmIndex = this.getRealmIndex("master", realms);
        Assert.assertThat((String)"Realm master not found.", (Object)realmIndex, (Matcher)Is.is((Matcher)IsNot.not((Object)-1)));
        int userIndex = this.getUserIndex("addusertest-admin", ((RealmRepresentation)realms.get(realmIndex)).getUsers());
        Assert.assertThat((String)"User addusertest-admin not found", (Object)userIndex, (Matcher)Is.is((Matcher)IsNot.not((Object)-1)));
        UserRepresentation user = (UserRepresentation)((RealmRepresentation)realms.get(realmIndex)).getUsers().get(userIndex);
        Assert.assertThat((String)"Username from Json file is wrong.", (Object)user.getUsername(), (Matcher)Is.is((Object)"addusertest-admin"));
        Assert.assertThat((String)"User Credentials are NULL", user.getCredentials().get(0), (Matcher)IsNull.notNullValue());
        CredentialRepresentation credentials = (CredentialRepresentation)user.getCredentials().get(0);
        PasswordCredentialModel pcm = PasswordCredentialModel.createFromCredentialModel((CredentialModel)RepresentationToModel.toModel((CredentialRepresentation)credentials));
        Assert.assertThat((String)"User Credentials have wrong Algorithm.", (Object)pcm.getPasswordCredentialData().getAlgorithm(), (Matcher)Is.is((Object)"pbkdf2-sha256"));
        Assert.assertThat((String)"User Credentials have wrong Hash Iterations", (Object)pcm.getPasswordCredentialData().getHashIterations(), (Matcher)Is.is((Object)100000));
        this.controller.stop(authServerQualifier);
        this.controller.start(authServerQualifier);
        RealmResource realmResource = this.getAdminClient().realm("master");
        Assert.assertThat((String)"Realm resource is NULL !!", (Object)realmResource, (Matcher)IsNull.notNullValue());
        user = (UserRepresentation)realmResource.users().search("addusertest-admin").get(0);
        Assert.assertThat((String)"Username is wrong.", (Object)user.getUsername(), (Matcher)Is.is((Object)"addusertest-admin"));
        UserResource userResource = realmResource.users().get(user.getId());
        Assert.assertThat((String)"User resource is NULL !!", (Object)userResource, (Matcher)IsNull.notNullValue());
        try {
            this.assertRoles(userResource.roles().realmLevel().listAll(), "admin", "default-roles-master");
            this.assertRoles(userResource.roles().realmLevel().listEffective(), "create-realm", "uma_authorization", "default-roles-master", "offline_access", "admin");
            List clients = realmResource.clients().findAll();
            String accountId = null;
            for (ClientRepresentation c : clients) {
                if (!c.getClientId().equals("account")) continue;
                accountId = c.getId();
            }
            Assert.assertTrue((boolean)userResource.roles().clientLevel(accountId).listAll().isEmpty());
            List accountRoles = userResource.roles().clientLevel(accountId).listEffective();
            this.assertRoles(accountRoles, "view-profile", "manage-account", "manage-account-links");
        }
        finally {
            userResource.remove();
        }
    }

    private int getUserIndex(String userName, List<UserRepresentation> list) {
        Assert.assertThat((String)"Parameter 'list' is NULL.", list, (Matcher)IsNull.notNullValue());
        Assert.assertThat((String)"List is empty.", (Object)list.isEmpty(), (Matcher)Is.is((Object)false));
        for (UserRepresentation u : list) {
            if (!u.getUsername().equals(userName)) continue;
            return list.indexOf(u);
        }
        return -1;
    }

    private int getRealmIndex(String realmName, List<RealmRepresentation> list) {
        Assert.assertThat((String)"Parameter 'list' is NULL.", list, (Matcher)IsNull.notNullValue());
        Assert.assertThat((String)"List is empty.", (Object)list.isEmpty(), (Matcher)Is.is((Object)false));
        for (RealmRepresentation u : list) {
            if (!u.getRealm().equals(realmName)) continue;
            return list.indexOf(u);
        }
        return -1;
    }

    private void assertRoles(List<RoleRepresentation> actual, String ... expected) {
        Assert.assertThat((String)"Actual and expected size of Roles are different.", (Object)actual.size(), (Matcher)Is.is((Object)expected.length));
        for (String e : expected) {
            boolean found = false;
            for (RoleRepresentation r : actual) {
                if (!r.getName().equals(e)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Role " + e + " not found"));
        }
    }

    @Override
    public void addTestRealms(List<RealmRepresentation> testRealms) {
    }
}

