/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.undertow.servlet;

import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.CustomerPortal;
import org.keycloak.testsuite.adapter.page.ProductPortal;
import org.keycloak.testsuite.adapter.servlet.CustomerDatabaseServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerServlet;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.ProductServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.utils.io.IOUtil;

@AppServerContainer(value="auth-server-undertow")
@Ignore(value="Need to resolve default relative scenario when running on non-undertow")
public class UndertowRelaviteUriAdapterTest
extends AbstractServletsAdapterTest {
    @Page
    private CustomerPortal customerPortal;
    @Page
    private ProductPortal productPortal;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/demorealm-relative.json"));
    }

    @Deployment(name="customer-portal")
    protected static WebArchive customerPortal() {
        return UndertowRelaviteUriAdapterTest.servletDeployment("customer-portal", "keycloak-relative.json", CustomerServlet.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="customer-db")
    protected static WebArchive customerDb() {
        return UndertowRelaviteUriAdapterTest.servletDeployment("customer-db", "keycloak-relative.json", AdapterActionsFilter.class, CustomerDatabaseServlet.class);
    }

    @Deployment(name="product-portal")
    protected static WebArchive productPortal() {
        return UndertowRelaviteUriAdapterTest.servletDeployment("product-portal", "keycloak-relative.json", ProductServlet.class);
    }

    @Test
    public void testLoginSSOAndLogout() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("iPhone") && pageSource.contains("iPad") ? 1 : 0) != 0);
        List stats = this.adminClient.realm("demo").getClientSessionStats();
        Map customerPortalStats = null;
        Map productPortalStats = null;
        for (Map s : stats) {
            switch ((String)s.get("clientId")) {
                case "customer-portal": {
                    customerPortalStats = s;
                    break;
                }
                case "product-portal": {
                    productPortalStats = s;
                }
            }
        }
        Assert.assertEquals((long)1L, (long)Integer.parseInt((String)customerPortalStats.get("active")));
        Assert.assertEquals((long)1L, (long)Integer.parseInt((String)productPortalStats.get("active")));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testServletRequestLogout() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Bill Burke"));
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("iPhone"));
        this.driver.navigate().to(this.customerPortal.logout().toASCIIString());
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("servlet logout ok"));
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }
}

