/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.ProductPortal;
import org.keycloak.testsuite.adapter.servlet.ProductServlet;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.pages.ConsentPage;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
public class UserStorageConsentTest
extends AbstractServletsAdapterTest {
    @Page
    private ProductPortal productPortal;
    @Page
    protected ConsentPage consentPage;

    @Deployment(name="product-portal")
    protected static WebArchive productPortal() {
        return UserStorageConsentTest.servletDeployment("product-portal", ProductServlet.class);
    }

    @Before
    public void addProvidersBeforeTest() throws URISyntaxException, IOException {
        ComponentRepresentation memProvider = new ComponentRepresentation();
        memProvider.setName("memory");
        memProvider.setProviderId("user-password-map-arq");
        memProvider.setProviderType(UserStorageProvider.class.getName());
        memProvider.setConfig(new MultivaluedHashMap());
        memProvider.getConfig().putSingle((Object)"priority", (Object)Integer.toString(0));
        memProvider.getConfig().putSingle((Object)"importEnabled", (Object)Boolean.toString(false));
        this.addComponent(memProvider);
    }

    protected String addComponent(ComponentRepresentation component) {
        Response resp = this.testRealmResource().components().add(component);
        resp.close();
        String id = ApiUtil.getCreatedId((Response)resp);
        this.getCleanup().addComponentId(id);
        return id;
    }

    public static void setupConsent(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("demo");
        ClientModel product = session.clients().getClientByClientId(realm, "product-portal");
        product.setConsentRequired(true);
        ClientScopeModel clientScope = realm.addClientScope("clientScope");
        clientScope.setProtocol("openid-connect");
        System.err.println("client scope protocol mappers size: " + clientScope.getProtocolMappersStream().count());
        for (ProtocolMapperModel mapper : product.getProtocolMappersStream().collect(Collectors.toList())) {
            if (mapper.getProtocol().equals("openid-connect") && (mapper.getName().equals("username") || mapper.getName().equals("email") || mapper.getName().equals("given name"))) {
                ProtocolMapperModel copy = new ProtocolMapperModel();
                copy.setName(mapper.getName());
                copy.setProtocol(mapper.getProtocol());
                HashMap config = new HashMap();
                config.putAll(mapper.getConfig());
                copy.setConfig(config);
                copy.setProtocolMapper(mapper.getProtocolMapper());
                clientScope.addProtocolMapper(copy);
            }
            product.removeProtocolMapper(mapper);
        }
        product.addClientScope(clientScope, true);
    }

    public static void setupDisplayClientOnConsentScreen(KeycloakSession session) {
        RealmModel realm = session.realms().getRealmByName("demo");
        ClientModel product = session.clients().getClientByClientId(realm, "product-portal");
        product.setDisplayOnConsentScreen(true);
    }

    @Test
    public void testLogin() throws Exception {
        this.assertLogin();
    }

    @Test
    public void testLoginDisplayClientOnConsentScreen() throws Exception {
        this.testingClient.server().run(UserStorageConsentTest::setupDisplayClientOnConsentScreen);
        this.assertLogin();
    }

    private void assertLogin() throws InterruptedException {
        this.testingClient.server().run(UserStorageConsentTest::setupConsent);
        UserRepresentation memuser = new UserRepresentation();
        memuser.setUsername("memuser");
        String uid = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealmResource(), (UserRepresentation)memuser, (String)"password");
        System.out.println("uid: " + uid);
        Assert.assertTrue((boolean)uid.startsWith("f:"));
        RoleRepresentation roleRep = this.adminClient.realm("demo").roles().get("user").toRepresentation();
        ArrayList<RoleRepresentation> roleList = new ArrayList<RoleRepresentation>();
        roleList.add(roleRep);
        this.adminClient.realm("demo").users().get(uid).roles().realmLevel().add(roleList);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("memuser", "password");
        Assert.assertTrue((boolean)this.consentPage.isCurrent());
        this.consentPage.confirm();
        URLAssert.assertCurrentUrlEquals(this.productPortal.toString());
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("iPhone"));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.productPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("memuser", "password");
        URLAssert.assertCurrentUrlEquals(this.productPortal.toString());
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("iPhone"));
        this.driver.navigate().to(logoutUri);
        this.adminClient.realm("demo").users().delete(uid).close();
    }
}

