/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.testsuite.adapter.AbstractAdapterTest;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.SalesPostAssertionAndResponseSig;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.util.ClientBuilder;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.RoleBuilder;
import org.keycloak.testsuite.util.RolesBuilder;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class SamlSignatureTest
extends AbstractAdapterTest {
    private static final String REQUIRED_ROLE_NAME = "manager";
    private static final RoleRepresentation REQUIRED_ROLE = RoleBuilder.create().name("manager").build();
    private static final String BROKER = "broker";
    private static final String APP_CLIENT_ID = "http://localhost:8280/sales-post-assertion-and-response-sig/";
    @Page
    private SalesPostAssertionAndResponseSig salesPostAssertionAndResponseSigPage;
    private UserRepresentation user;

    @Deployment(name="sales-post-assertion-and-response-sig")
    protected static WebArchive salesPostAssertionAndResponseSig() {
        return AbstractServletsAdapterTest.samlServletDeployment("sales-post-assertion-and-response-sig", SendUsernameServlet.class);
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return false;
    }

    private static ClientBuilder signingSamlClient(String clientId) {
        return ClientBuilder.create().protocol("saml").enabled(true).attribute("saml.assertion.signature", "true").attribute("saml_name_id_format", "username").attribute("saml.server.signature", "true").attribute("saml.signature.algorithm", "RSA_SHA256").attribute("saml.authnstatement", "true").clientId(clientId);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        ClientBuilder salesPostClient = SamlSignatureTest.signingSamlClient(APP_CLIENT_ID).baseUrl("http://localhost:8080/sales-post-assertion-and-response-sig").redirectUris("http://localhost:8080/sales-post-assertion-and-response-sig/*");
        String brokerBaseUrl = this.getAuthServerRoot() + "realms/" + BROKER;
        ClientBuilder brokerRealmIdPClient = SamlSignatureTest.signingSamlClient(brokerBaseUrl).baseUrl(brokerBaseUrl + "/broker/" + "demo" + "/endpoint").redirectUris(brokerBaseUrl + "/broker/" + "demo" + "/endpoint");
        testRealms.add(RealmBuilder.create().name("demo").publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").client(salesPostClient).client(brokerRealmIdPClient).roles(RolesBuilder.create().realmRole(REQUIRED_ROLE)).build());
        testRealms.add(RealmBuilder.create().name(BROKER).publicKey("MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQAB").privateKey("MIICXAIBAAKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABAoGAfmO8gVhyBxdqlxmIuglbz8bcjQbhXJLR2EoS8ngTXmN1bo2L90M0mUKSdc7qF10LgETBzqL8jYlQIbt+e6TH8fcEpKCjUlyq0Mf/vVbfZSNaVycY13nTzo27iPyWQHK5NLuJzn1xvxxrUeXI6A2WFpGEBLbHjwpx5WQG9A+2scECQQDvdn9NE75HPTVPxBqsEd2z10TKkl9CZxu10Qby3iQQmWLEJ9LNmy3acvKrE3gMiYNWb6xHPKiIqOR1as7L24aTAkEAtyvQOlCvr5kAjVqrEKXalj0Tzewjweuxc0pskvArTI2Oo070h65GpoIKLc9jf+UA69cRtquwP93aZKtW06U8dQJAF2Y44ks/mK5+eyDqik3koCI08qaC8HYq2wVl7G2QkJ6sbAaILtcvD92ToOvyGyeE0flvmDZxMYlvaZnaQ0lcSQJBAKZU6umJi3/xeEbkJqMfeLclD27XGEFoPeNrmdx0q10Azp4NfJAY+Z8KRyQCR2BEG+oNitBOZ+YXF9KCpH3cdmECQHEigJhYg+ykOvr1aiZUMFT72HU0jnmQe2FVekuG+LJUt2Tm7GtMjTFoGpf0JwrVuZN39fOYAlo+nTixgeW7X8Y=").client(salesPostClient).identityProvider(IdentityProviderBuilder.create().alias("demo").providerId("saml").setAttribute("singleSignOnServiceUrl", this.getAuthServerRoot() + "realms/" + "demo" + "/protocol/saml").setAttribute("postBindingAuthnRequest", "true").setAttribute("postBindingResponse", "true").setAttribute("signingCertificate", "MIIBkTCB+wIGAUkZB1wLMA0GCSqGSIb3DQEBCwUAMA8xDTALBgNVBAMTBGRlbW8wHhcNMTQxMDE2MTI1NDEzWhcNMjQxMDE2MTI1NTUzWjAPMQ0wCwYDVQQDEwRkZW1vMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCrVrCuTtArbgaZzL1hvh0xtL5mc7o0NqPVnYXkLvgcwiC3BjLGw1tGEGoJaXDuSaRllobm53JBhjx33UNv+5z/UMG4kytBWxheNVKnL6GgqlNabMaFfPLPCF8kAgKnsi79NMo+n6KnSY8YeUmec/p2vjO2NjsSAVcWEQMVhJ31LwIDAQABMA0GCSqGSIb3DQEBCwUAA4GBAI9moVwZxiEvzfvyL0zqyzRP4qnEdYQ/l/Nl78OAed25hdKpVpNv8i7DwM1QscWQhrtfGImD0480eoOUfe1rU9k6gNdNpR6kYAz17A/OsovpTFF0cIQE7HPqumpHfdbeW0jEjLNT2Od/PXdaIijVOdbJn8iF//nnItrwPbNUBU75").setAttribute("wantAssertionsSigned", "true").setAttribute("validateSignature", "true")).roles(RolesBuilder.create().realmRole(REQUIRED_ROLE)).build());
    }

    @Before
    public void addFreshUserToDemoRealm() {
        this.user = UserBuilder.edit(SamlSignatureTest.createUserRepresentation(("U-" + UUID.randomUUID().toString()).toLowerCase(), "a@b.c", "A", "B", true)).password("password").build();
        Creator c = Creator.create((RealmResource)this.adminClient.realm("demo"), (UserRepresentation)this.user);
        this.getCleanup("demo").addCleanup((AutoCloseable)c);
        List reqRoleToJoin = ((UserResource)c.resource()).roles().realmLevel().listAvailable().stream().filter(r -> r.getName().equals(REQUIRED_ROLE_NAME)).collect(Collectors.toList());
        ((UserResource)c.resource()).roles().realmLevel().add(reqRoleToJoin);
    }

    private void testSamlResponseModifications(Consumer<Document> samlResponseModifier, boolean shouldPass) throws Exception {
        Consumer<CloseableHttpResponse> clientAssertions = shouldPass ? this::assertCorrectUserLoggedIn : SamlSignatureTest::assertUserAccessDenied;
        Consumer<CloseableHttpResponse> brokerAssertions = shouldPass ? SamlSignatureTest::assertUpdateProfilePage : SamlSignatureTest::assertNotUpdateProfilePage;
        this.testSamlResponseModificationsClient(samlResponseModifier, clientAssertions);
        this.testSamlResponseModificationsBroker(samlResponseModifier, brokerAssertions);
    }

    private void testSamlResponseModificationsBroker(Consumer<Document> samlResponseModifier, Consumer<CloseableHttpResponse> assertions) throws Exception {
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(new URI(this.getAuthServerRoot() + "realms/" + BROKER + "/protocol/saml"), APP_CLIENT_ID, this.salesPostAssertionAndResponseSigPage.toString(), SamlClient.Binding.POST).build().login().idp("demo").build().processSamlResponse(SamlClient.Binding.POST).build().login().user(this.user).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(d -> {
            samlResponseModifier.accept(d);
            return d;
        })).build().executeAndTransform(r -> {
            assertions.accept(r);
            return null;
        });
    }

    private void testSamlResponseModificationsClient(Consumer<Document> samlResponseModifier, Consumer<CloseableHttpResponse> assertions) {
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo((AbstractPage)this.salesPostAssertionAndResponseSigPage).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.user).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(d -> {
            samlResponseModifier.accept(d);
            return d;
        })).build().executeAndTransform(r -> {
            assertions.accept(r);
            return null;
        });
    }

    private void assertCorrectUserLoggedIn(CloseableHttpResponse response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeHC((Matcher)org.hamcrest.Matchers.is((Object)Response.Status.OK.getStatusCode())));
        Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)this.user.getUsername())));
    }

    private static void assertUpdateProfilePage(CloseableHttpResponse response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
        Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"Update Account Information")));
    }

    private static void assertNotUpdateProfilePage(CloseableHttpResponse response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeHC((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(400))));
        Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.containsString((String)"Update Account Information"))));
    }

    private static void assertUserAccessDenied(CloseableHttpResponse response) {
        Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.containsString((String)"INVALID_SIGNATURE"), (Matcher)org.hamcrest.Matchers.containsString((String)"EXTRACTION_FAILURE"), (Matcher)org.hamcrest.Matchers.containsString((String)"There was an error"))));
    }

    private static void removeAllSignatures(Document doc) throws DOMException {
        NodeList signatures;
        while ((signatures = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature")).getLength() > 0) {
            Node s = signatures.item(0);
            s.getParentNode().removeChild(s);
        }
    }

    @Test
    public void testNoChange() throws Exception {
        this.testSamlResponseModifications(r -> {}, true);
    }

    @Test
    public void testRemoveSignatures() throws Exception {
        this.testSamlResponseModifications(SamlSignatureTest::removeAllSignatures, false);
    }

    @Test
    public void testXSW1() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW1, false);
    }

    @Test
    public void testXSW2() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW2, false);
    }

    @Test
    public void testXSW3() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW3, false);
    }

    @Test
    public void testXSW4() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW4, false);
    }

    @Test
    public void testXSW5() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW5, false);
    }

    @Test
    public void testXSW6() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW6, false);
    }

    @Test
    public void testXSW7() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW7, false);
    }

    @Test
    public void testXSW8() throws Exception {
        this.testSamlResponseModifications(XSWHelpers::applyXSW8, false);
    }

    public static class XSWHelpers {
        public static void applyXSW1(Document document) {
            Element response = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.PROTOCOL_NSURI.get(), "Response").item(0);
            Element clonedResponse = (Element)response.cloneNode(true);
            Element clonedSignature = (Element)clonedResponse.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Response needs to be signed", (Object)clonedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            clonedResponse.removeChild(clonedSignature);
            Element signature = (Element)response.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            signature.appendChild(clonedResponse);
            response.setAttribute("ID", "_evil_response_ID");
        }

        public static void applyXSW2(Document document) {
            Element response = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.PROTOCOL_NSURI.get(), "Response").item(0);
            Element clonedResponse = (Element)response.cloneNode(true);
            Element clonedSignature = (Element)clonedResponse.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Response needs to be signed", (Object)clonedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            clonedResponse.removeChild(clonedSignature);
            Element signature = (Element)response.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            response.insertBefore(clonedResponse, signature);
            response.setAttribute("ID", "_evil_response_ID");
        }

        public static void applyXSW3(Document document) {
            Element assertion = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion").item(0);
            Element evilAssertion = (Element)assertion.cloneNode(true);
            Element copiedSignature = (Element)evilAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Assertion needs to be signed", (Object)copiedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            evilAssertion.setAttribute("ID", "_evil_assertion_ID");
            evilAssertion.removeChild(copiedSignature);
            document.getDocumentElement().insertBefore(evilAssertion, assertion);
        }

        public static void applyXSW4(Document document) {
            Element assertion = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion").item(0);
            Element evilAssertion = (Element)assertion.cloneNode(true);
            Element copiedSignature = (Element)evilAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Assertion needs to be signed", (Object)copiedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            evilAssertion.setAttribute("ID", "_evil_assertion_ID");
            evilAssertion.removeChild(copiedSignature);
            document.getDocumentElement().appendChild(evilAssertion);
            evilAssertion.appendChild(assertion);
        }

        public static void applyXSW5(Document document) {
            Element evilAssertion = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion").item(0);
            Element assertion = (Element)evilAssertion.cloneNode(true);
            Element copiedSignature = (Element)assertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Assertion needs to be signed", (Object)copiedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            assertion.removeChild(copiedSignature);
            document.getDocumentElement().appendChild(assertion);
            evilAssertion.setAttribute("ID", "_evil_assertion_ID");
        }

        public static void applyXSW6(Document document) {
            Element evilAssertion = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion").item(0);
            Element originalSignature = (Element)evilAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Element assertion = (Element)evilAssertion.cloneNode(true);
            Element copiedSignature = (Element)assertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Assertion needs to be signed", (Object)copiedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            assertion.removeChild(copiedSignature);
            originalSignature.appendChild(assertion);
            evilAssertion.setAttribute("ID", "_evil_assertion_ID");
        }

        public static void applyXSW7(Document document) {
            Element assertion = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion").item(0);
            Element extensions = document.createElement("Extensions");
            document.getDocumentElement().insertBefore(extensions, assertion);
            Element evilAssertion = (Element)assertion.cloneNode(true);
            Element copiedSignature = (Element)evilAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Assertion needs to be signed", (Object)copiedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            evilAssertion.removeChild(copiedSignature);
            extensions.appendChild(evilAssertion);
        }

        public static void applyXSW8(Document document) {
            Element evilAssertion = (Element)document.getElementsByTagNameNS(JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion").item(0);
            Element originalSignature = (Element)evilAssertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Element assertion = (Element)evilAssertion.cloneNode(true);
            Element copiedSignature = (Element)assertion.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
            Assume.assumeThat((String)"Assertion needs to be signed", (Object)copiedSignature, (Matcher)org.hamcrest.Matchers.notNullValue());
            assertion.removeChild(copiedSignature);
            Element object = document.createElement("Object");
            originalSignature.appendChild(object);
            object.appendChild(assertion);
        }
    }
}

