/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.Employee2Servlet;
import org.keycloak.testsuite.adapter.servlet.AbstractSAMLServletAdapterTest;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.updaters.RealmAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9"), @AppServerContainer(value="app-server-jetty92"), @AppServerContainer(value="app-server-jetty93"), @AppServerContainer(value="app-server-jetty94")})
public class SAMLServletSessionTimeoutTest
extends AbstractSAMLServletAdapterTest {
    @Page
    protected Employee2Servlet employee2ServletPage;
    private static final int SESSION_LENGTH_IN_SECONDS = 120;
    private static final int KEYCLOAK_SESSION_TIMEOUT = 1922;
    private AtomicReference<String> sessionNotOnOrAfter = new AtomicReference();

    @Deployment(name="employee2")
    protected static WebArchive employee2() {
        return SAMLServletSessionTimeoutTest.samlServletDeployment("employee2", "web-with-action-filter.xml", SendUsernameServlet.class, AdapterActionsFilter.class, PublicKeyLocator.class);
    }

    private SAML2Object addSessionNotOnOrAfter(SAML2Object ob) {
        Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType resp = (ResponseType)ob;
        Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
        AuthnStatementType authType = (AuthnStatementType)statements.stream().filter(statement -> statement instanceof AuthnStatementType).findFirst().orElse((StatementAbstractType)new AuthnStatementType(XMLTimeUtil.getIssueInstant()));
        XMLGregorianCalendar sessionTimeout = XMLTimeUtil.add((XMLGregorianCalendar)XMLTimeUtil.getIssueInstant(), (long)120000L);
        this.sessionNotOnOrAfter.set(sessionTimeout.toString());
        authType.setSessionNotOnOrAfter(sessionTimeout);
        ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().addStatement((StatementAbstractType)authType);
        return ob;
    }

    @Test
    public void employee2TestSAMLRefreshingSession() {
        this.sessionNotOnOrAfter.set(null);
        ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)this.beginAuthenticationAndLogin((AbstractPage)this.employee2ServletPage, SamlClient.Binding.POST).processSamlResponse(SamlClient.Binding.POST).transformObject(this::addSessionNotOnOrAfter)).build().addStep(() -> this.setAdapterAndServerTimeOffset(100, this.employee2ServletPage.toString())).navigateTo(this.employee2ServletPage.buildUri()).assertResponse(response -> Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"), (Matcher)org.hamcrest.Matchers.containsString((String)("SessionNotOnOrAfter: " + this.sessionNotOnOrAfter.get())))))).addStep(() -> this.setAdapterAndServerTimeOffset(120, this.employee2ServletPage.toString())).navigateTo(this.employee2ServletPage.buildUri()).processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlAuthnRequest());
            return ob;
        })).build().followOneRedirect().processSamlResponse(SamlClient.Binding.POST).build().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"))).execute();
        this.setAdapterAndServerTimeOffset(0, this.employee2ServletPage.toString());
    }

    @Test
    public void employee2TestSAMLSessionTimeoutOnBothSides() {
        this.sessionNotOnOrAfter.set(null);
        ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)this.beginAuthenticationAndLogin((AbstractPage)this.employee2ServletPage, SamlClient.Binding.POST).processSamlResponse(SamlClient.Binding.POST).transformObject(this::addSessionNotOnOrAfter)).build().navigateTo(this.employee2ServletPage.buildUri()).assertResponse(response -> Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"), (Matcher)org.hamcrest.Matchers.containsString((String)("SessionNotOnOrAfter: " + this.sessionNotOnOrAfter.get())))))).addStep(() -> this.setAdapterAndServerTimeOffset(1922, this.employee2ServletPage.toString())).navigateTo(this.employee2ServletPage.buildUri()).processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
            Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlAuthnRequest());
            return ob;
        })).build().followOneRedirect().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"form id=\"kc-form-login\""))).execute();
        this.setAdapterAndServerTimeOffset(0, this.employee2ServletPage.toString());
    }

    @Test
    public void testKeycloakReturnsSessionNotOnOrAfter() throws Exception {
        this.sessionNotOnOrAfter.set(null);
        try (ServerResourceUpdater c = ((RealmAttributeUpdater)new RealmAttributeUpdater(this.adminClient.realm("demo")).updateWith(r -> r.setSsoSessionMaxLifespan(Integer.valueOf(120)))).update();){
            ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)this.beginAuthenticationAndLogin((AbstractPage)this.employee2ServletPage, SamlClient.Binding.POST).processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
                Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
                ResponseType resp = (ResponseType)ob;
                Set statements = ((ResponseType.RTChoiceType)resp.getAssertions().get(0)).getAssertion().getStatements();
                AuthnStatementType authType = (AuthnStatementType)statements.stream().filter(statement -> statement instanceof AuthnStatementType).findFirst().orElseThrow(() -> new RuntimeException("SamlReponse doesn't contain AuthStatement"));
                Assert.assertThat((Object)authType.getSessionNotOnOrAfter(), (Matcher)org.hamcrest.Matchers.notNullValue());
                XMLGregorianCalendar expectedSessionTimeout = XMLTimeUtil.add((XMLGregorianCalendar)authType.getAuthnInstant(), (long)120000L);
                Assert.assertThat((Object)authType.getSessionNotOnOrAfter(), (Matcher)org.hamcrest.Matchers.is((Object)expectedSessionTimeout));
                this.sessionNotOnOrAfter.set(expectedSessionTimeout.toString());
                return ob;
            })).build().navigateTo(this.employee2ServletPage.buildUri()).assertResponse(response -> Assert.assertThat((Object)response, (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke"), (Matcher)org.hamcrest.Matchers.containsString((String)("SessionNotOnOrAfter: " + this.sessionNotOnOrAfter.get())))))).addStep(() -> this.setAdapterAndServerTimeOffset(1922, this.employee2ServletPage.toString())).navigateTo(this.employee2ServletPage.buildUri()).processSamlResponse(SamlClient.Binding.POST).transformObject(ob -> {
                Assert.assertThat((Object)ob, (Matcher)Matchers.isSamlAuthnRequest());
                return ob;
            })).build().followOneRedirect().assertResponse(Matchers.bodyHC((Matcher)org.hamcrest.Matchers.containsString((String)"form id=\"kc-form-login\""))).execute();
            this.setAdapterAndServerTimeOffset(0, this.employee2ServletPage.toString());
        }
    }
}

