/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleScopeResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.protocol.AuthnRequestType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.keys.KeyProvider;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.XmlKeyInfoKeyNameTransformer;
import org.keycloak.saml.processing.core.parsers.saml.SAMLParser;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.adapter.page.AdapterLogoutPage;
import org.keycloak.testsuite.adapter.page.BadAssertionSalesPostSig;
import org.keycloak.testsuite.adapter.page.BadClientSalesPostSigServlet;
import org.keycloak.testsuite.adapter.page.BadRealmSalesPostSigServlet;
import org.keycloak.testsuite.adapter.page.DifferentCookieNameServlet;
import org.keycloak.testsuite.adapter.page.EcpSP;
import org.keycloak.testsuite.adapter.page.Employee2Servlet;
import org.keycloak.testsuite.adapter.page.EmployeeAcsServlet;
import org.keycloak.testsuite.adapter.page.EmployeeDomServlet;
import org.keycloak.testsuite.adapter.page.EmployeeRoleMappingServlet;
import org.keycloak.testsuite.adapter.page.EmployeeServlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigFrontServlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigPostNoIdpKeyServlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigRedirNoIdpKeyServlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigRedirOptNoIdpKeyServlet;
import org.keycloak.testsuite.adapter.page.EmployeeSigServlet;
import org.keycloak.testsuite.adapter.page.InputPortal;
import org.keycloak.testsuite.adapter.page.MissingAssertionSig;
import org.keycloak.testsuite.adapter.page.MultiTenant1Saml;
import org.keycloak.testsuite.adapter.page.MultiTenant2Saml;
import org.keycloak.testsuite.adapter.page.SAMLServlet;
import org.keycloak.testsuite.adapter.page.SalesMetadataServlet;
import org.keycloak.testsuite.adapter.page.SalesPost2Servlet;
import org.keycloak.testsuite.adapter.page.SalesPostAssertionAndResponseSig;
import org.keycloak.testsuite.adapter.page.SalesPostAutodetectServlet;
import org.keycloak.testsuite.adapter.page.SalesPostEncServlet;
import org.keycloak.testsuite.adapter.page.SalesPostEncSignAssertionsOnlyServlet;
import org.keycloak.testsuite.adapter.page.SalesPostPassiveServlet;
import org.keycloak.testsuite.adapter.page.SalesPostServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigEmailServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigPersistentServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigServlet;
import org.keycloak.testsuite.adapter.page.SalesPostSigTransientServlet;
import org.keycloak.testsuite.adapter.servlet.AbstractSAMLServletAdapterTest;
import org.keycloak.testsuite.adapter.servlet.InputServlet;
import org.keycloak.testsuite.adapter.servlet.SamlMultiTenantResolver;
import org.keycloak.testsuite.adapter.servlet.SamlSPFacade;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.admin.Users;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.auth.page.login.Login;
import org.keycloak.testsuite.auth.page.login.SAMLIDPInitiatedLogin;
import org.keycloak.testsuite.auth.page.login.SAMLPostLoginTenant1;
import org.keycloak.testsuite.auth.page.login.SAMLPostLoginTenant2;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.Creator;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.updaters.UserAttributeUpdater;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.By;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class SAMLServletAdapterTest
extends AbstractSAMLServletAdapterTest {
    @Page
    protected BadClientSalesPostSigServlet badClientSalesPostSigServletPage;
    @Page
    protected BadRealmSalesPostSigServlet badRealmSalesPostSigServletPage;
    @Page
    protected EmployeeAcsServlet employeeAcsServletPage;
    @Page
    protected Employee2Servlet employee2ServletPage;
    @Page
    protected EmployeeDomServlet employeeDomServletPage;
    @Page
    protected EmployeeSigServlet employeeSigServletPage;
    @Page
    protected EmployeeSigPostNoIdpKeyServlet employeeSigPostNoIdpKeyServletPage;
    @Page
    protected EmployeeSigRedirNoIdpKeyServlet employeeSigRedirNoIdpKeyServletPage;
    @Page
    protected EmployeeSigRedirOptNoIdpKeyServlet employeeSigRedirOptNoIdpKeyServletPage;
    @Page
    protected EmployeeSigFrontServlet employeeSigFrontServletPage;
    @Page
    protected EmployeeRoleMappingServlet employeeRoleMappingPage;
    @Page
    protected SalesMetadataServlet salesMetadataServletPage;
    @Page
    protected SalesPostServlet salesPostServletPage;
    @Page
    private SalesPost2Servlet salesPost2ServletPage;
    @Page
    protected SalesPostEncServlet salesPostEncServletPage;
    @Page
    protected SalesPostEncSignAssertionsOnlyServlet salesPostEncSignAssertionsOnlyServletPage;
    @Page
    protected SalesPostPassiveServlet salesPostPassiveServletPage;
    @Page
    protected SalesPostSigServlet salesPostSigServletPage;
    @Page
    protected SalesPostSigEmailServlet salesPostSigEmailServletPage;
    @Page
    protected SalesPostSigPersistentServlet salesPostSigPersistentServletPage;
    @Page
    protected SalesPostSigTransientServlet salesPostSigTransientServletPage;
    @Page
    protected SAMLIDPInitiatedLogin samlidpInitiatedLogin;
    protected boolean forbiddenIfNotAuthenticated = true;
    @Page
    protected SalesPostAssertionAndResponseSig salesPostAssertionAndResponseSigPage;
    @Page
    protected BadAssertionSalesPostSig badAssertionSalesPostSigPage;
    @Page
    protected MissingAssertionSig missingAssertionSigPage;
    @Page
    protected EmployeeServlet employeeServletPage;
    @Page
    protected DifferentCookieNameServlet differentCookieNameServletPage;
    @Page
    private InputPortal inputPortalPage;
    @Page
    private SAMLIDPInitiatedLogin samlidpInitiatedLoginPage;
    @Page
    protected SalesPostAutodetectServlet salesPostAutodetectServletPage;
    @Page
    protected AdapterLogoutPage adapterLogoutPage;
    @Page
    protected EcpSP ecpSPPage;
    @Page
    protected MultiTenant1Saml multiTenant1SamlPage;
    @Page
    protected MultiTenant2Saml multiTenant2SamlPage;
    @Page
    protected SAMLPostLoginTenant1 tenant1RealmSAMLPostLoginPage;
    @Page
    protected SAMLPostLoginTenant2 tenant2RealmSAMLPostLoginPage;
    public static final String FORBIDDEN_TEXT = "HTTP status code: 403";
    public static final String WEBSPHERE_FORBIDDEN_TEXT = "Error reported: 403";
    private static final KeyPair NEW_KEY_PAIR = KeyUtils.generateRsaKeyPair((int)1024);
    private static final String NEW_KEY_PRIVATE_KEY_PEM = PemUtils.encodeKey((Key)NEW_KEY_PAIR.getPrivate());

    @Deployment(name="bad-client-sales-post-sig")
    protected static WebArchive badClientSalesPostSig() {
        return SAMLServletAdapterTest.samlServletDeployment("bad-client-sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="bad-realm-sales-post-sig")
    protected static WebArchive badRealmSalesPostSig() {
        return SAMLServletAdapterTest.samlServletDeployment("bad-realm-sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="employee-acs")
    protected static WebArchive employeeAssertionConsumerServiceUrlSet() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-acs", SendUsernameServlet.class);
    }

    @Deployment(name="employee2")
    protected static WebArchive employee2() {
        return SAMLServletAdapterTest.samlServletDeployment("employee2", SendUsernameServlet.class);
    }

    @Deployment(name="employee-dom")
    protected static WebArchive employeedom() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-dom", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig")
    protected static WebArchive employeeSig() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-sig", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig-post-noidpkey")
    protected static WebArchive employeeSigPostNoIdpKeyServlet() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-sig-post-noidpkey", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig-redir-noidpkey")
    protected static WebArchive employeeSigRedirNoIdpKeyServlet() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-sig-redir-noidpkey", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig-redir-opt-noidpkey")
    protected static WebArchive employeeSigRedirOptNoIdpKeyServlet() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-sig-redir-opt-noidpkey", SendUsernameServlet.class);
    }

    @Deployment(name="employee-sig-front")
    protected static WebArchive employeeSigFront() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-sig-front", SendUsernameServlet.class);
    }

    @Deployment(name="employee-role-mapping")
    protected static WebArchive employeeRoleMapping() {
        return SAMLServletAdapterTest.samlServletDeployment("employee-role-mapping", "employee-role-mapping/WEB-INF/web.xml", SendUsernameServlet.class);
    }

    @Deployment(name="sales-metadata")
    protected static WebArchive salesMetadata() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-metadata", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post")
    protected static WebArchive salesPost() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-enc")
    protected static WebArchive salesPostEnc() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-enc", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-enc-sign-assertions-only")
    protected static WebArchive salesPostEncSignAssertionsOnly() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-enc-sign-assertions-only", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-passive")
    protected static WebArchive salesPostPassive() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-passive", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig")
    protected static WebArchive salesPostSig() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig-email")
    protected static WebArchive salesPostSigEmail() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-sig-email", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig-persistent")
    protected static WebArchive salesPostSigPersistent() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-sig-persistent", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-sig-transient")
    protected static WebArchive salesPostSigTransient() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-sig-transient", SendUsernameServlet.class);
    }

    @Deployment(name="input-portal")
    protected static WebArchive inputPortal() {
        return SAMLServletAdapterTest.samlServletDeployment("input-portal", "input-portal/WEB-INF/web.xml", InputServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="sales-post2")
    protected static WebArchive salesPost2() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post2", SendUsernameServlet.class);
    }

    @Deployment(name="different-cookie-name")
    protected static WebArchive differentCokieName() {
        return SAMLServletAdapterTest.samlServletDeployment("different-cookie-name", "different-cookie-name/WEB-INF/web.xml", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post-assertion-and-response-sig")
    protected static WebArchive salesPostAssertionAndResponseSig() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-assertion-and-response-sig", SendUsernameServlet.class);
    }

    @Deployment(name="bad-assertion-sales-post-sig")
    protected static WebArchive badAssertionSalesPostSig() {
        return SAMLServletAdapterTest.samlServletDeployment("bad-assertion-sales-post-sig", SendUsernameServlet.class);
    }

    @Deployment(name="missing-assertion-sig")
    protected static WebArchive missingAssertionSig() {
        return SAMLServletAdapterTest.samlServletDeployment("missing-assertion-sig", SendUsernameServlet.class);
    }

    @Deployment(name="employee")
    protected static WebArchive employeeServlet() {
        return (WebArchive)SAMLServletAdapterTest.samlServletDeployment("employee", "employee/WEB-INF/web.xml", SamlSPFacade.class, ServletTestUtils.class).add((Asset)new StringAsset("<html><body>Logged out</body></html>"), "/logout.jsp");
    }

    @Deployment(name="logout")
    protected static WebArchive logoutWar() {
        return AdapterLogoutPage.createDeployment();
    }

    @Deployment(name="sales-post-autodetect")
    protected static WebArchive salesPostAutodetect() {
        return SAMLServletAdapterTest.samlServletDeployment("sales-post-autodetect", "sales-post-autodetect/WEB-INF/web.xml", SendUsernameServlet.class);
    }

    @Deployment(name="ecp-sp")
    protected static WebArchive ecpSp() {
        return SAMLServletAdapterTest.samlServletDeployment("ecp-sp", SendUsernameServlet.class);
    }

    @Deployment(name="multi-tenant-saml")
    protected static WebArchive multiTenant() {
        return SAMLServletAdapterTest.samlServletDeploymentMultiTenant("multi-tenant-saml", "multi-tenant-saml/WEB-INF/web.xml", "tenant1-keycloak-saml.xml", "tenant2-keycloak-saml.xml", "keystore-tenant1.jks", "keystore-tenant2.jks", SendUsernameServlet.class, SamlMultiTenantResolver.class);
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return false;
    }

    private void assertForbidden(AbstractPage page, String expectedNotContains) {
        page.navigateTo();
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains(expectedNotContains);
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains(FORBIDDEN_TEXT) || this.driver.getPageSource().contains(WEBSPHERE_FORBIDDEN_TEXT) ? 1 : 0) != 0);
    }

    private void assertSuccessfullyLoggedIn(AbstractPage page, String expectedText) {
        page.navigateTo();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains(expectedText);
    }

    private void assertForbiddenLogin(AbstractPage page, String username, String password, Login loginPage, String expectedNotContains) {
        page.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
        loginPage.form().login(username, password);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains(expectedNotContains);
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains(FORBIDDEN_TEXT) || this.driver.getPageSource().contains(WEBSPHERE_FORBIDDEN_TEXT) ? 1 : 0) != 0);
    }

    private void assertFailedLogin(AbstractPage page, UserRepresentation user, Login loginPage) {
        page.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
        loginPage.form().login(user);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
    }

    private void assertSuccessfulLogin(AbstractPage page, UserRepresentation user, Login loginPage, String expectedString) {
        page.navigateTo();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)loginPage);
        loginPage.form().login(user);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains(expectedString);
    }

    private void testSuccessfulAndUnauthorizedLogin(SAMLServlet page, Login loginPage) {
        this.testSuccessfulAndUnauthorizedLogin(page, loginPage, "principal=bburke");
    }

    private void testSuccessfulAndUnauthorizedLogin(SAMLServlet page, Login loginPage, String expectedText) {
        this.testSuccessfulAndUnauthorizedLogin(page, loginPage, expectedText, "principal=");
    }

    private void testSuccessfulAndUnauthorizedLogin(SAMLServlet page, Login loginPage, String expectedText, String expectedNotContains) {
        this.assertSuccessfulLogin((AbstractPage)page, this.bburkeUser, loginPage, expectedText);
        page.logout();
        this.checkLoggedOut((AbstractPage)page, loginPage);
        this.assertForbiddenLogin((AbstractPage)page, "unauthorized", "password", loginPage, expectedNotContains);
        page.logout();
        this.checkLoggedOut((AbstractPage)page, loginPage);
    }

    @Test
    public void disabledClientTest() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/sales-post-sig/");
        ClientRepresentation client = clientResource.toRepresentation();
        client.setEnabled(Boolean.valueOf(false));
        clientResource.update(client);
        this.salesPostSigServletPage.navigateTo();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Login requester not enabled");
        client.setEnabled(Boolean.valueOf(true));
        clientResource.update(client);
    }

    @Test
    public void unauthorizedSSOTest() {
        this.assertForbiddenLogin((AbstractPage)this.salesPostServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage, "principal=");
        this.assertForbidden((AbstractPage)this.employee2ServletPage, "principal=");
        this.assertForbidden((AbstractPage)this.employeeSigFrontServletPage, "principal=");
        this.assertForbidden((AbstractPage)this.salesPostSigPersistentServletPage, "principal=");
        this.salesPostServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPostServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void singleLoginAndLogoutSAMLTest() {
        this.assertSuccessfulLogin((AbstractPage)this.salesPostServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage, "principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostSigServletPage, "principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.employee2ServletPage, "principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostEncServletPage, "principal=bburke");
        this.employeeSigFrontServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employeeSigFrontServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
        this.checkLoggedOut((AbstractPage)this.employeeSigServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
        this.salesPostPassiveServletPage.navigateTo();
        if (this.forbiddenIfNotAuthenticated) {
            this.assertOnForbiddenPage();
        } else {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=null");
        }
        this.checkLoggedOut((AbstractPage)this.salesPostSigEmailServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void badClientSalesPostSigTest() {
        this.badClientSalesPostSigServletPage.navigateTo();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Invalid requester");
    }

    @Test
    public void badRealmSalesPostSigTest() {
        this.badRealmSalesPostSigServletPage.navigateTo();
        this.testRealmSAMLRedirectLoginPage.form().login(this.bburkeUser);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("principal=");
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains(FORBIDDEN_TEXT) || this.driver.getPageSource().contains(WEBSPHERE_FORBIDDEN_TEXT) ? 1 : 0) != 0);
    }

    @Test
    public void employee2Test() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void employeeSigTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.employeeSigServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeAcsTest() {
        SAMLDocumentHolder samlResponse = new SamlClientBuilder().navigateTo(this.employeeAcsServletPage.buildUri()).getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)samlResponse.getSamlObject(), (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(AuthnRequestType.class));
        Assert.assertThat((Object)((AuthnRequestType)samlResponse.getSamlObject()).getAssertionConsumerServiceURL(), (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)((AuthnRequestType)samlResponse.getSamlObject()).getAssertionConsumerServiceURL().getPath(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)"/employee-acs/a/different/endpoint/for/saml"));
        this.assertSuccessfulLogin((AbstractPage)this.employeeAcsServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage, "principal=bburke");
    }

    @Test
    public void multiTenant1SamlTest() throws Exception {
        this.multiTenant1SamlPage.setRolesToCheck("user");
        try {
            UserRepresentation user1 = SAMLServletAdapterTest.createUserRepresentation("user-tenant1", "user-tenant1@redhat.com", "Bill", "Burke", true);
            Users.setPasswordFor((UserRepresentation)user1, (String)"user-tenant1");
            this.assertSuccessfulLogin((AbstractPage)this.multiTenant1SamlPage, user1, (Login)this.tenant1RealmSAMLPostLoginPage, "principal=user-tenant1");
            this.driver.navigate().to(this.multiTenant1SamlPage.getUriBuilder().clone().path("getAssertionIssuer").build(new Object[0]).toASCIIString());
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("/auth/realms/tenant1");
            this.multiTenant1SamlPage.logout();
            this.checkLoggedOut((AbstractPage)this.multiTenant1SamlPage, (Login)this.tenant1RealmSAMLPostLoginPage);
            UserRepresentation user2 = SAMLServletAdapterTest.createUserRepresentation("user-tenant2", "user-tenant2@redhat.com", "Bill", "Burke", true);
            Users.setPasswordFor((UserRepresentation)user2, (String)"user-tenant2");
            this.assertFailedLogin((AbstractPage)this.multiTenant1SamlPage, user2, (Login)this.tenant1RealmSAMLPostLoginPage);
        }
        finally {
            this.multiTenant1SamlPage.checkRolesEndPoint(false);
        }
    }

    @Test
    public void multiTenant2SamlTest() throws Exception {
        this.multiTenant2SamlPage.setRolesToCheck("user");
        try {
            UserRepresentation user2 = SAMLServletAdapterTest.createUserRepresentation("user-tenant2", "user-tenant2@redhat.com", "Bill", "Burke", true);
            Users.setPasswordFor((UserRepresentation)user2, (String)"user-tenant2");
            this.assertSuccessfulLogin((AbstractPage)this.multiTenant2SamlPage, user2, (Login)this.tenant2RealmSAMLPostLoginPage, "principal=user-tenant2");
            this.driver.navigate().to(this.multiTenant2SamlPage.getUriBuilder().clone().path("getAssertionIssuer").build(new Object[0]).toASCIIString());
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("/auth/realms/tenant2");
            this.multiTenant2SamlPage.logout();
            this.checkLoggedOut((AbstractPage)this.multiTenant2SamlPage, (Login)this.tenant2RealmSAMLPostLoginPage);
            UserRepresentation user1 = SAMLServletAdapterTest.createUserRepresentation("user-tenant1", "user-tenant1@redhat.com", "Bill", "Burke", true);
            Users.setPasswordFor((UserRepresentation)user1, (String)"user-tenant1");
            this.assertFailedLogin((AbstractPage)this.multiTenant2SamlPage, user1, (Login)this.tenant2RealmSAMLPostLoginPage);
        }
        finally {
            this.multiTenant2SamlPage.checkRolesEndPoint(false);
        }
    }

    private PublicKey createKeys(String priority) throws Exception {
        PublicKey publicKey = NEW_KEY_PAIR.getPublic();
        ComponentRepresentation rep = new ComponentRepresentation();
        rep.setName("mycomponent");
        rep.setParentId("demo");
        rep.setProviderId("rsa");
        rep.setProviderType(KeyProvider.class.getName());
        MultivaluedHashMap config = new MultivaluedHashMap();
        config.addFirst((Object)"priority", (Object)priority);
        config.addFirst((Object)"privateKey", (Object)NEW_KEY_PRIVATE_KEY_PEM);
        rep.setConfig(config);
        this.testRealmResource().components().add(rep);
        return publicKey;
    }

    private void dropKeys(String priority) {
        for (ComponentRepresentation c : this.testRealmResource().components().query("demo", KeyProvider.class.getName())) {
            if (!((String)c.getConfig().getFirst((Object)"priority")).equals(priority)) continue;
            this.testRealmResource().components().component(c.getId()).remove();
            return;
        }
        throw new RuntimeException("Failed to find keys");
    }

    private void testRotatedKeysPropagated(SAMLServlet servletPage, Login loginPage) throws Exception {
        this.testRotatedKeysPropagated(servletPage, loginPage, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRotatedKeysPropagated(SAMLServlet servletPage, Login loginPage, boolean shouldLogout) throws Exception {
        boolean keyDropped = false;
        try {
            this.log.info((Object)"Creating new key");
            this.createKeys("1000");
            this.testSuccessfulAndUnauthorizedLogin(servletPage, loginPage);
            this.log.info((Object)"Dropping new key");
            this.dropKeys("1000");
            keyDropped = true;
            this.testSuccessfulAndUnauthorizedLogin(servletPage, loginPage);
        }
        finally {
            if (!keyDropped) {
                this.dropKeys("1000");
            }
            if (shouldLogout) {
                servletPage.logout();
            }
        }
    }

    @Test
    public void employeeSigPostNoIdpKeyTest() throws Exception {
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigPostNoIdpKeyServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void employeeSigPostNoIdpKeyTestNoKeyNameInKeyInfo() throws Exception {
        RealmRepresentation r = this.testRealmResource().toRepresentation();
        r.getAttributes().put("saml.server.signature.keyinfo.xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.NONE.name());
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigPostNoIdpKeyServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void employeeSigPostNoIdpKeyTestCertSubjectAsKeyNameInKeyInfo() throws Exception {
        RealmRepresentation r = this.testRealmResource().toRepresentation();
        r.getAttributes().put("saml.server.signature.keyinfo.xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.CERT_SUBJECT.name());
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigPostNoIdpKeyServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void employeeSigPostNoIdpKeyTestKeyIdAsKeyNameInKeyInfo() throws Exception {
        RealmRepresentation r = this.testRealmResource().toRepresentation();
        r.getAttributes().put("saml.server.signature.keyinfo.xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.KEY_ID.name());
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigPostNoIdpKeyServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void employeeSigRedirNoIdpKeyTest() throws Exception {
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigRedirNoIdpKeyServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeSigRedirNoIdpKeyTestNoKeyNameInKeyInfo() throws Exception {
        RealmRepresentation r = this.testRealmResource().toRepresentation();
        r.getAttributes().put("saml.server.signature.keyinfo.xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.NONE.name());
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigRedirNoIdpKeyServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeSigRedirNoIdpKeyTestCertSubjectAsKeyNameInKeyInfo() throws Exception {
        RealmRepresentation r = this.testRealmResource().toRepresentation();
        r.getAttributes().put("saml.server.signature.keyinfo.xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.CERT_SUBJECT.name());
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigRedirNoIdpKeyServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeSigRedirNoIdpKeyTestKeyIdAsKeyNameInKeyInfo() throws Exception {
        RealmRepresentation r = this.testRealmResource().toRepresentation();
        r.getAttributes().put("saml.server.signature.keyinfo.xmlSigKeyInfoKeyNameTransformer", XmlKeyInfoKeyNameTransformer.KEY_ID.name());
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigRedirNoIdpKeyServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeSigRedirOptNoIdpKeyTest() throws Exception {
        this.testRotatedKeysPropagated((SAMLServlet)this.employeeSigRedirOptNoIdpKeyServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void employeeSigFrontTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.employeeSigFrontServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
    }

    @Test
    public void testLogoutRedirectToExternalPage() throws Exception {
        this.employeeServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.employeeServletPage);
        WaitUtils.waitForPageToLoad();
        this.employeeServletPage.logout();
        this.adapterLogoutPage.assertCurrent();
    }

    @Test
    public void salesMetadataTest() throws Exception {
        Document doc = IOUtil.loadXML((InputStream)SAMLServletAdapterTest.class.getResourceAsStream("/adapter-test/keycloak-saml/sp-metadata.xml"));
        IOUtil.modifyDocElementAttribute((Document)doc, (String)"SingleLogoutService", (String)"Location", (String)"8080", (String)System.getProperty("app.server.http.port", null));
        IOUtil.modifyDocElementAttribute((Document)doc, (String)"AssertionConsumerService", (String)"Location", (String)"8080", (String)System.getProperty("app.server.http.port", null));
        ClientRepresentation clientRep = this.testRealmResource().convertClientDescription(IOUtil.documentToString((Document)doc));
        clientRep.setAdminUrl(ServerURLs.getAppServerContextRoot() + "/sales-metadata/saml");
        try (Response response = this.testRealmResource().clients().create(clientRep);){
            Assert.assertEquals((long)201L, (long)response.getStatus());
        }
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesMetadataServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostTestCompositeRoleForUser() {
        UserRepresentation topGroupUser = SAMLServletAdapterTest.createUserRepresentation("topGroupUser", "top@redhat.com", "", "", true);
        Users.setPasswordFor((UserRepresentation)topGroupUser, (String)"password");
        this.assertSuccessfulLogin((AbstractPage)this.salesPostServletPage, topGroupUser, (Login)this.testRealmSAMLPostLoginPage, "principal=topgroupuser");
        this.salesPostServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPostServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void salesPostEmptyConsumerPostURL() throws Exception {
        try (ServerResourceUpdater client = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.testRealmPage.getAuthRealm(), (String)"http://localhost:8280/sales-post/").setAttribute("saml_assertion_consumer_url_post", "").update();){
            this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
        finally {
            this.salesPostEncServletPage.logout();
        }
    }

    @Test
    public void salesPostEncTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostEncServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostEncSignedAssertionsOnlyTest() throws Exception {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostEncSignAssertionsOnlyServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void salesPostEncSignedAssertionsAndDocumentTest() throws Exception {
        try (ServerResourceUpdater client = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.testRealmPage.getAuthRealm(), (String)"http://localhost:8280/sales-post-enc/").setAttribute("saml.assertion.signature", "true").setAttribute("saml.server.signature", "true").update();){
            this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostEncServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
        finally {
            this.salesPostEncServletPage.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void salesPostEncRejectConsent() throws Exception {
        try (ServerResourceUpdater client = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.testRealmPage.getAuthRealm(), (String)"http://localhost:8280/sales-post-enc/").setConsentRequired(Boolean.valueOf(true)).update();){
            new SamlClientBuilder().navigateTo(this.salesPostEncServletPage.toString()).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().consentRequired().approveConsent(false).build().processSamlResponse(SamlClient.Binding.POST).build().execute(r -> {
                Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
                Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"urn:oasis:names:tc:SAML:2.0:status:RequestDenied")));
            });
        }
        finally {
            this.salesPostEncServletPage.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void salesPostRejectConsent() throws Exception {
        try (ServerResourceUpdater client = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)this.testRealmPage.getAuthRealm(), (String)"http://localhost:8280/sales-post/").setConsentRequired(Boolean.valueOf(true)).update();){
            new SamlClientBuilder().navigateTo(this.salesPostServletPage.toString()).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().consentRequired().approveConsent(false).build().processSamlResponse(SamlClient.Binding.POST).build().execute(r -> {
                Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
                Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"urn:oasis:names:tc:SAML:2.0:status:RequestDenied")));
            });
        }
        finally {
            this.salesPostServletPage.logout();
        }
    }

    @Test
    public void salesPostPassiveTest() {
        this.salesPostPassiveServletPage.navigateTo();
        if (this.forbiddenIfNotAuthenticated) {
            this.assertOnForbiddenPage();
        } else {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=null");
        }
        this.assertSuccessfulLogin((AbstractPage)this.salesPostServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage, "principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostPassiveServletPage, "principal=bburke");
        this.salesPostPassiveServletPage.logout();
        this.salesPostPassiveServletPage.navigateTo();
        if (this.forbiddenIfNotAuthenticated) {
            this.assertOnForbiddenPage();
        } else {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=null");
        }
        this.assertForbiddenLogin((AbstractPage)this.salesPostServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage, "principal=");
        this.assertForbidden((AbstractPage)this.salesPostPassiveServletPage, "principal=");
        this.salesPostPassiveServletPage.logout();
    }

    @Test
    public void salesPostSigTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostSigServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostSigTestUnicodeCharacters() {
        String username = "\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00edRo\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc";
        UserRepresentation user = UserBuilder.edit(SAMLServletAdapterTest.createUserRepresentation("\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00edRo\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc", "xyz@redhat.com", "\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed", "Ro\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc", true)).addPassword("password").build();
        try (Creator u = Creator.create((RealmResource)this.testRealmResource(), (UserRepresentation)user);){
            RoleScopeResource realmRoleRes = ((UserResource)u.resource()).roles().realmLevel();
            List availableRoles = realmRoleRes.listAvailable();
            realmRoleRes.add(availableRoles.stream().filter(r -> r.getName().equalsIgnoreCase("manager")).collect(Collectors.toList()));
            UserRepresentation storedUser = ((UserResource)u.resource()).toRepresentation();
            Assert.assertThat((Object)storedUser, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
            Assert.assertThat((String)"Database seems to be unable to store Unicode for username. Refer to KEYCLOAK-3439 and related issues.", (Object)storedUser.getUsername(), (org.hamcrest.Matcher)org.hamcrest.Matchers.equalToIgnoringCase((String)"\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00edRo\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc"));
            this.assertSuccessfulLogin((AbstractPage)this.salesPostSigServletPage, user, (Login)this.testRealmSAMLPostLoginPage, "principal=" + storedUser.getUsername());
            this.salesPostSigServletPage.logout();
            this.checkLoggedOut((AbstractPage)this.salesPostSigServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
    }

    @Test
    public void employeeSigTestUnicodeCharacters() {
        String username = "\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00edRo\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc";
        UserRepresentation user = UserBuilder.edit(SAMLServletAdapterTest.createUserRepresentation("\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00edRo\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc", "xyz@redhat.com", "\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00ed", "Ro\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc", true)).addPassword("password").build();
        try (Creator u = Creator.create((RealmResource)this.testRealmResource(), (UserRepresentation)user);){
            RoleScopeResource realmRoleRes = ((UserResource)u.resource()).roles().realmLevel();
            List availableRoles = realmRoleRes.listAvailable();
            realmRoleRes.add(availableRoles.stream().filter(r -> r.getName().equalsIgnoreCase("manager")).collect(Collectors.toList()));
            UserRepresentation storedUser = ((UserResource)u.resource()).toRepresentation();
            Assert.assertThat((Object)storedUser, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
            Assert.assertThat((String)"Database seems to be unable to store Unicode for username. Refer to KEYCLOAK-3439 and related issues.", (Object)storedUser.getUsername(), (org.hamcrest.Matcher)org.hamcrest.Matchers.equalToIgnoringCase((String)"\u011b\u0161\u010d\u0159\u017e\u00fd\u00e1\u00edRo\u00e0\u00e5\u00e9\u00e8\u00ed\u00f1\u00f2\u00f8\u00f6\u00f9\u00fc\u00df\u00c5\u00c4\u00d6\u00dc"));
            this.assertSuccessfulLogin((AbstractPage)this.employeeSigServletPage, user, (Login)this.testRealmSAMLRedirectLoginPage, "principal=" + storedUser.getUsername());
            this.employeeSigServletPage.logout();
            this.checkLoggedOut((AbstractPage)this.employeeSigServletPage, (Login)this.testRealmSAMLRedirectLoginPage);
        }
    }

    @Test
    public void salesPostSigEmailTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostSigEmailServletPage, (Login)this.testRealmSAMLPostLoginPage, "principal=bburke@redhat.com");
    }

    @Test
    public void salesPostSigStaxParsingFlawEmailTest() {
        UserRepresentation user = SAMLServletAdapterTest.createUserRepresentation("bburke-additional-domain", "bburke@redhat.com.additional.domain", "Bill", "Burke", true);
        Users.setPasswordFor((UserRepresentation)user, (String)"password");
        String resultPage = (String)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.salesPostSigEmailServletPage.buildUri()).processSamlResponse(SamlClient.Binding.POST).build().login().user(user).build().processSamlResponse(SamlClient.Binding.POST).transformString(s -> {
            Assert.assertThat((Object)s, (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)">bburke@redhat.com.additional.domain<"));
            s = s.replaceAll("bburke@redhat.com.additional.domain", "bburke@redhat.com<!-- comment -->.additional.domain");
            return s;
        })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        Assert.assertThat((Object)resultPage, (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke@redhat.com.additional.domain"));
    }

    @Test
    public void salesPostSigChangeContents() {
        UserRepresentation user = SAMLServletAdapterTest.createUserRepresentation("bburke-additional-domain", "bburke@redhat.com.additional.domain", "Bill", "Burke", true);
        Users.setPasswordFor((UserRepresentation)user, (String)"password");
        String resultPage = (String)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.salesPostSigEmailServletPage.buildUri()).processSamlResponse(SamlClient.Binding.POST).build().login().user(user).build().processSamlResponse(SamlClient.Binding.POST).transformString(s -> {
            Assert.assertThat((Object)s, (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)">bburke@redhat.com.additional.domain<"));
            s = s.replaceAll("bburke@redhat.com.additional.domain", "bburke@redhat.com");
            return s;
        })).build().executeAndTransform(resp -> EntityUtils.toString((HttpEntity)resp.getEntity()));
        Assert.assertThat((Object)resultPage, (org.hamcrest.Matcher)org.hamcrest.Matchers.anyOf((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"INVALID_SIGNATURE"), (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"Error 403: SRVE0295E: Error reported: 403")));
    }

    @Test
    public void salesPostSigPersistentTest() {
        this.salesPostSigPersistentServletPage.navigateTo();
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("bburke");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=G-");
        this.salesPostSigPersistentServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPostSigPersistentServletPage, (Login)this.testRealmSAMLPostLoginPage);
        this.assertForbiddenLogin((AbstractPage)this.salesPostSigPersistentServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage, "principal=");
        this.salesPostSigPersistentServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPostSigPersistentServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostSigTransientTest() {
        this.salesPostSigTransientServletPage.navigateTo();
        this.testRealmSAMLPostLoginPage.form().login(this.bburkeUser);
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("bburke");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=G-");
        this.salesPostSigTransientServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPostSigTransientServletPage, (Login)this.testRealmSAMLPostLoginPage);
        this.assertForbiddenLogin((AbstractPage)this.salesPostSigTransientServletPage, "unauthorized", "password", (Login)this.testRealmSAMLPostLoginPage, "principal=");
        this.salesPostSigTransientServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPostSigTransientServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void idpInitiatedLoginTest() {
        this.samlidpInitiatedLoginPage.setAuthRealm("demo");
        this.samlidpInitiatedLoginPage.setUrlName("employee2");
        this.samlidpInitiatedLoginPage.navigateTo();
        this.samlidpInitiatedLoginPage.form().login(this.bburkeUser);
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.salesPostSigServletPage, "principal=bburke");
        this.employee2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void idpInitiatedUnauthorizedLoginTest() {
        this.samlidpInitiatedLoginPage.setAuthRealm("demo");
        this.samlidpInitiatedLoginPage.setUrlName("employee2");
        this.samlidpInitiatedLoginPage.navigateTo();
        this.samlidpInitiatedLoginPage.form().login("unauthorized", "password");
        ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("bburke");
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains(FORBIDDEN_TEXT) || this.driver.getPageSource().contains(WEBSPHERE_FORBIDDEN_TEXT) ? 1 : 0) != 0);
        this.assertForbidden((AbstractPage)this.employee2ServletPage, "principal=");
        this.employee2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void testSavedPostRequest() {
        this.inputPortalPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.inputPortalPage);
        this.inputPortalPage.execute("hello");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        Assert.assertThat((Object)URI.create(this.driver.getCurrentUrl()).getPath(), (org.hamcrest.Matcher)org.hamcrest.Matchers.endsWith((String)"secured/post"));
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("parameter=hello");
        this.driver.navigate().to(this.inputPortalPage + "/insecure");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Insecure Page");
        if (System.getProperty("insecure.user.principal.unsupported") == null) {
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("UserPrincipal");
        }
        this.inputPortalPage.logout();
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        Form form = new Form();
        form.param("parameter", "hello");
        String text = (String)client.target(this.inputPortalPage + "/unsecured").request().post(Entity.form((Form)form), String.class);
        Assert.assertTrue((boolean)text.contains("parameter=hello"));
        client.close();
    }

    @Test
    public void testPostSimpleLoginLogoutIdpInitiatedRedirectTo() {
        this.samlidpInitiatedLoginPage.setAuthRealm("demo");
        this.samlidpInitiatedLoginPage.setUrlName("sales-post2");
        this.samlidpInitiatedLoginPage.navigateTo();
        this.samlidpInitiatedLoginPage.form().login(this.bburkeUser);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.salesPost2ServletPage);
        Assert.assertThat((Object)URI.create(this.driver.getCurrentUrl()).getPath(), (org.hamcrest.Matcher)org.hamcrest.Matchers.endsWith((String)"foo"));
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("principal=bburke");
        this.salesPost2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.salesPost2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void salesPostAssertionAndResponseSigTest() {
        this.testSuccessfulAndUnauthorizedLogin((SAMLServlet)this.salesPostAssertionAndResponseSigPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void testPostBadAssertionSignature() {
        this.badAssertionSalesPostSigPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Error info: SamlAuthenticationError [reason=INVALID_SIGNATURE");
        Assert.assertEquals((Object)this.driver.getCurrentUrl(), (Object)this.badAssertionSalesPostSigPage.getUriBuilder().clone().path("saml").build(new Object[0]).toASCIIString());
    }

    @Test
    public void testMissingAssertionSignature() {
        this.missingAssertionSigPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Error info: SamlAuthenticationError [reason=INVALID_SIGNATURE");
        Assert.assertEquals((Object)this.driver.getCurrentUrl(), (Object)this.missingAssertionSigPage.getUriBuilder().clone().path("saml").build(new Object[0]).toASCIIString());
    }

    @Test
    public void testRelayStateEncoding() throws Exception {
        this.employeeServletPage.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
        this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.employeeServletPage);
        WaitUtils.waitForPageToLoad();
        String pageSource = this.driver.getPageSource();
        Assert.assertThat((Object)pageSource, (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)("Relay state: " + SamlSPFacade.RELAY_STATE)));
        Assert.assertThat((Object)pageSource, (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"SAML response: null")));
    }

    private static String[] parseCommaSeparatedAttributes(String body, String attribute) {
        Pattern pattern = Pattern.compile(Pattern.quote(attribute) + ":\\s*(.*)");
        Matcher matcher = pattern.matcher(body);
        if (matcher.find()) {
            return matcher.group(1).split(",");
        }
        return new String[0];
    }

    @Test
    public void testUserAttributeStatementMapperUserGroupsAggregate() throws Exception {
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/employee2/");
        ProtocolMappersResource protocolMappersResource = clientResource.getProtocolMappers();
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("attribute.nameformat", "Basic");
        config.put("user.attribute", "group-value");
        config.put("attribute.name", "group-attribute");
        config.put("aggregate.attrs", "true");
        try (Creator g1 = Creator.create((RealmResource)this.testRealmResource(), (GroupRepresentation)group1);
             ServerResourceUpdater uau = UserAttributeUpdater.forUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke").setAttribute("group-value", new String[]{"user-value1"}).setGroups(new String[]{"/group1"}).update();
             AutoCloseable c = this.createProtocolMapper(protocolMappersResource, "group-value", "saml", "saml-user-attribute-mapper", config);){
            this.employee2ServletPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
            this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
            this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
            WaitUtils.waitForPageToLoad();
            String body = this.driver.findElement(By.xpath((String)"//body")).getText();
            String[] values = SAMLServletAdapterTest.parseCommaSeparatedAttributes(body, "group-attribute");
            MatcherAssert.assertThat((Object)values, (org.hamcrest.Matcher)org.hamcrest.Matchers.arrayContainingInAnyOrder((Object[])new String[]{"user-value1", "value1", "value2"}));
            this.employee2ServletPage.logout();
            this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
    }

    @Test
    public void testUserAttributeStatementMapperUserGroupsNoAggregate() throws Exception {
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/employee2/");
        ProtocolMappersResource protocolMappersResource = clientResource.getProtocolMappers();
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("attribute.nameformat", "Basic");
        config.put("user.attribute", "group-value");
        config.put("attribute.name", "group-attribute");
        try (Creator g1 = Creator.create((RealmResource)this.testRealmResource(), (GroupRepresentation)group1);
             ServerResourceUpdater uau = UserAttributeUpdater.forUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke").setAttribute("group-value", new String[]{"user-value1"}).setGroups(new String[]{"/group1"}).update();
             AutoCloseable c = this.createProtocolMapper(protocolMappersResource, "group-value", "saml", "saml-user-attribute-mapper", config);){
            this.employee2ServletPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
            this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
            this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
            WaitUtils.waitForPageToLoad();
            String body = this.driver.findElement(By.xpath((String)"//body")).getText();
            String[] values = SAMLServletAdapterTest.parseCommaSeparatedAttributes(body, "group-attribute");
            MatcherAssert.assertThat((Object)values, (org.hamcrest.Matcher)org.hamcrest.Matchers.arrayContaining((Object[])new String[]{"user-value1"}));
            this.employee2ServletPage.logout();
            this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
    }

    @Test
    public void testUserAttributeStatementMapperGroupsAggregate() throws Exception {
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("group2");
        group2.setAttributes(new HashMap());
        group2.getAttributes().put("group-value", Arrays.asList("value2", "value3"));
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/employee2/");
        ProtocolMappersResource protocolMappersResource = clientResource.getProtocolMappers();
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("attribute.nameformat", "Basic");
        config.put("user.attribute", "group-value");
        config.put("attribute.name", "group-attribute");
        config.put("aggregate.attrs", "true");
        try (Creator g1 = Creator.create((RealmResource)this.testRealmResource(), (GroupRepresentation)group1);
             Creator g2 = Creator.create((RealmResource)this.testRealmResource(), (GroupRepresentation)group2);
             ServerResourceUpdater uau = UserAttributeUpdater.forUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke").setGroups(new String[]{"/group1", "/group2"}).update();
             AutoCloseable c = this.createProtocolMapper(protocolMappersResource, "group-value", "saml", "saml-user-attribute-mapper", config);){
            this.employee2ServletPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
            this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
            this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
            WaitUtils.waitForPageToLoad();
            String body = this.driver.findElement(By.xpath((String)"//body")).getText();
            String[] values = SAMLServletAdapterTest.parseCommaSeparatedAttributes(body, "group-attribute");
            MatcherAssert.assertThat((Object)values, (org.hamcrest.Matcher)org.hamcrest.Matchers.arrayContainingInAnyOrder((Object[])new String[]{"value1", "value2", "value3"}));
            this.employee2ServletPage.logout();
            this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
    }

    @Test
    public void testUserAttributeStatementMapperGroupsNoAggregate() throws Exception {
        GroupRepresentation group1 = new GroupRepresentation();
        group1.setName("group1");
        group1.setAttributes(new HashMap());
        group1.getAttributes().put("group-value", Arrays.asList("value1", "value2"));
        GroupRepresentation group2 = new GroupRepresentation();
        group2.setName("group2");
        group2.setAttributes(new HashMap());
        group2.getAttributes().put("group-value", Arrays.asList("value2", "value3"));
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/employee2/");
        ProtocolMappersResource protocolMappersResource = clientResource.getProtocolMappers();
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        config.put("attribute.nameformat", "Basic");
        config.put("user.attribute", "group-value");
        config.put("attribute.name", "group-attribute");
        try (Creator g1 = Creator.create((RealmResource)this.testRealmResource(), (GroupRepresentation)group1);
             Creator g2 = Creator.create((RealmResource)this.testRealmResource(), (GroupRepresentation)group2);
             ServerResourceUpdater uau = UserAttributeUpdater.forUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke").setGroups(new String[]{"/group1", "/group2"}).update();
             AutoCloseable c = this.createProtocolMapper(protocolMappersResource, "group-value", "saml", "saml-user-attribute-mapper", config);){
            this.employee2ServletPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmSAMLPostLoginPage);
            this.testRealmSAMLPostLoginPage.form().login("bburke", "password");
            this.driver.navigate().to(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0]).toURL());
            WaitUtils.waitForPageToLoad();
            String body = this.driver.findElement(By.xpath((String)"//body")).getText();
            String[] values = SAMLServletAdapterTest.parseCommaSeparatedAttributes(body, "group-attribute");
            MatcherAssert.assertThat((Object)values, (org.hamcrest.Matcher)org.hamcrest.Matchers.anyOf((org.hamcrest.Matcher)org.hamcrest.Matchers.arrayContainingInAnyOrder((Object[])new String[]{"value1", "value2"}), (org.hamcrest.Matcher)org.hamcrest.Matchers.arrayContainingInAnyOrder((Object[])new String[]{"value2", "value3"})));
            this.employee2ServletPage.logout();
            this.checkLoggedOut((AbstractPage)this.employee2ServletPage, (Login)this.testRealmSAMLPostLoginPage);
        }
    }

    @Test
    public void idpMetadataValidation() throws Exception {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpGet httpGet = new HttpGet(this.authServerPage.toString() + "/realms/" + "demo" + "/protocol/saml/descriptor");
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpGet);){
                String stringResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                this.validateXMLWithSchema(stringResponse, "/adapter-test/keycloak-saml/metadata-schema/saml-schema-metadata-2.0.xsd");
                Object descriptor = SAMLParser.getInstance().parse((InputStream)new ByteArrayInputStream(stringResponse.getBytes(GeneralConstants.SAML_CHARSET)));
                MatcherAssert.assertThat((Object)descriptor, (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(EntityDescriptorType.class));
            }
        }
    }

    @Test
    public void testDOMAssertion() throws Exception {
        this.assertSuccessfulLogin((AbstractPage)this.employeeDomServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage, "principal=bburke");
        this.assertSuccessfullyLoggedIn((AbstractPage)this.employeeDomServletPage, "principal=bburke");
        this.driver.navigate().to(this.employeeDomServletPage.getUriBuilder().clone().path("getAssertionFromDocument").build(new Object[0]).toURL());
        WaitUtils.waitForPageToLoad();
        String xml = UIUtils.getRawPageSource();
        Assert.assertNotEquals((Object)"", (Object)xml);
        Document doc = DocumentUtil.getDocument((Reader)new StringReader(xml));
        String certBase64 = DocumentUtil.getElement((Document)doc, (QName)new QName("http://www.w3.org/2000/09/xmldsig#", "X509Certificate")).getTextContent();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(new ByteArrayInputStream(Base64.decode((String)certBase64)));
        PublicKey pubkey = cert.getPublicKey();
        Assert.assertTrue((boolean)AssertionUtil.isSignatureValid((Element)doc.getDocumentElement(), (PublicKey)pubkey));
        this.employeeDomServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.employeeDomServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void spMetadataValidation() throws Exception {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"http://localhost:8280/sales-post-sig/");
        ClientRepresentation representation = clientResource.toRepresentation();
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        WebTarget target = client.target(this.authServerPage.toString() + "/admin/realms/" + "demo" + "/clients/" + representation.getId() + "/installation/providers/saml-sp-descriptor");
        try (Response response = target.request().header("Authorization", (Object)("Bearer " + this.adminClient.tokenManager().getAccessToken().getToken())).get();){
            String stringResponse = (String)response.readEntity(String.class);
            this.validateXMLWithSchema(stringResponse, "/adapter-test/keycloak-saml/metadata-schema/saml-schema-metadata-2.0.xsd");
            Object descriptor = SAMLParser.getInstance().parse((InputStream)new ByteArrayInputStream(stringResponse.getBytes(GeneralConstants.SAML_CHARSET)));
            MatcherAssert.assertThat((Object)descriptor, (org.hamcrest.Matcher)org.hamcrest.Matchers.instanceOf(EntityDescriptorType.class));
        }
    }

    @Test
    public void testBooleanAttribute() throws Exception {
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().authnRequest(this.getAuthServerSamlEndpoint("demo"), "http://localhost:8280/employee2/", this.getAppServerSamlEndpoint((SAMLServlet)this.employee2ServletPage).toString(), SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(responseDoc -> {
            Element attribute = responseDoc.createElement("saml:Attribute");
            attribute.setAttribute("Name", "boolean-attribute");
            attribute.setAttribute("NameFormat", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
            Element attributeValue = responseDoc.createElement("saml:AttributeValue");
            attributeValue.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            attributeValue.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            attributeValue.setAttribute("xsi:type", "xs:boolean");
            attributeValue.setTextContent("true");
            attribute.appendChild(attributeValue);
            IOUtil.appendChildInDocument((Document)responseDoc, (String)"samlp:Response/saml:Assertion/saml:AttributeStatement", (Element)attribute);
            return responseDoc;
        })).build().navigateTo(this.employee2ServletPage.getUriBuilder().clone().path("getAttributes").build(new Object[0])).execute(r -> {
            Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"boolean-attribute: true")));
        });
    }

    @Test
    public void testNameIDUnset() throws Exception {
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.employee2ServletPage.toString()).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(responseDoc -> {
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//*[local-name()='NameID']");
            NodeList nodeList = (NodeList)expr.evaluate(responseDoc, XPathConstants.NODESET);
            Assert.assertThat((Object)nodeList.getLength(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
            org.w3c.dom.Node nameIdNode = nodeList.item(0);
            nameIdNode.getParentNode().removeChild(nameIdNode);
            return responseDoc;
        })).build().navigateTo(this.employee2ServletPage.toString()).execute(r -> {
            Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"principal=")));
        });
    }

    @Test
    public void testDestinationUnset() throws Exception {
        ((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo(this.employee2ServletPage.toString()).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).transformDocument(responseDoc -> {
            responseDoc.getDocumentElement().removeAttribute("Destination");
            return responseDoc;
        })).build().navigateTo(this.employee2ServletPage.toString()).execute(r -> {
            Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            Assert.assertThat((Object)r, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"principal=")));
        });
    }

    @Test
    public void testEmptyKeyInfoElement() {
        this.log.debug((Object)"Log in using idp initiated login");
        SAMLDocumentHolder documentHolder = new SamlClientBuilder().idpInitiatedLogin(this.getAuthServerSamlEndpoint("demo"), "sales-post-sig-email").build().login().user(this.bburkeUser).build().getSamlResponse(SamlClient.Binding.POST);
        this.log.debug((Object)"Removing KeyInfo from Keycloak response");
        Document responseDoc = documentHolder.getSamlDocument();
        IOUtil.removeElementFromDoc((Document)responseDoc, (String)"samlp:Response/dsig:Signature/dsig:KeyInfo");
        CloseableHttpResponse response = null;
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpClientContext context = HttpClientContext.create();
            this.log.debug((Object)"Sending response to SP");
            HttpUriRequest post = SamlClient.Binding.POST.createSamlUnsignedResponse(this.getAppServerSamlEndpoint((SAMLServlet)this.salesPostSigEmailServletPage), null, responseDoc);
            response = client.execute(post, (HttpContext)context);
            System.out.println(EntityUtils.toString((HttpEntity)response.getEntity()));
            Assert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FOUND));
            response.close();
            HttpGet get = new HttpGet(this.salesPostSigEmailServletPage.toString());
            response = client.execute((HttpUriRequest)get);
            Assert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.OK));
            Assert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.bodyHC((org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"principal=bburke")));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Test
    public void testDifferentCookieName() {
        this.assertSuccessfulLogin((AbstractPage)this.differentCookieNameServletPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage, "principal=bburke");
        Assert.assertThat((Object)this.driver.manage().getCookieNamed("DIFFERENT_SESSION_ID"), (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)this.driver.manage().getCookieNamed("JSESSIONID"), (org.hamcrest.Matcher)org.hamcrest.Matchers.nullValue());
        this.salesPost2ServletPage.logout();
        this.checkLoggedOut((AbstractPage)this.differentCookieNameServletPage, (Login)this.testRealmSAMLPostLoginPage);
    }

    @Test
    public void testAutodetectBearerOnly() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient();
        WebTarget target = client.target(this.salesPostAutodetectServletPage.toString() + "/");
        Response response = target.request().header("X-Requested-With", (Object)"XMLHttpRequest").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("Faces-Request", (Object)"partial/ajax").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("SOAPAction", (Object)"").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("Accept", (Object)"application/json,text/xml").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("X-Requested-With", (Object)"Dont-Know").header("Accept", (Object)"*/*").get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = target.request().header("Accept", (Object)"text/html,application/xhtml+xml,application/xml;q=0.9").get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        response = target.request().header("Accept", (Object)"*/*").get();
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
        client.close();
    }

    @Test
    public void testSuccessfulEcpFlow() throws Exception {
        Response authnRequestResponse = AdminClientUtil.createResteasyClient().target(this.ecpSPPage.toString()).request().header("Accept", (Object)"text/html; application/vnd.paos+xml").header("PAOS", (Object)"ver='urn:liberty:paos:2003-08' ;'urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp'").get();
        SOAPMessage authnRequestMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream((byte[])authnRequestResponse.readEntity(byte[].class)));
        Iterator it = authnRequestMessage.getSOAPHeader().getChildElements(new QName("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", "Request"));
        SOAPHeaderElement ecpRequestHeader = (SOAPHeaderElement)it.next();
        NodeList idpList = ecpRequestHeader.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "IDPList");
        Assert.assertThat((String)"No IDPList returned from Service Provider", (Object)idpList.getLength(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
        NodeList idpEntries = idpList.item(0).getChildNodes();
        Assert.assertThat((String)"No IDPEntry returned from Service Provider", (Object)idpEntries.getLength(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
        String singleSignOnService = null;
        for (int i = 0; i < idpEntries.getLength(); ++i) {
            org.w3c.dom.Node item = idpEntries.item(i);
            NamedNodeMap attributes = item.getAttributes();
            org.w3c.dom.Node location = attributes.getNamedItem("Loc");
            singleSignOnService = location.getNodeValue();
        }
        Assert.assertThat((String)"Could not obtain SSO Service URL", singleSignOnService, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        Document authenticationRequest = authnRequestMessage.getSOAPBody().getFirstChild().getOwnerDocument();
        String username = "pedroigor";
        String password = "password";
        String pair = username + ":" + password;
        String authHeader = "Basic " + Base64.encodeBytes((byte[])pair.getBytes());
        Response authenticationResponse = AdminClientUtil.createResteasyClient().target(singleSignOnService).request().header("Authorization", (Object)authHeader).post(Entity.entity((Object)DocumentUtil.asString((Document)authenticationRequest), (String)"text/xml"));
        Assert.assertThat((Object)authenticationResponse.getStatus(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)Response.Status.OK.getStatusCode()));
        SOAPMessage responseMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream((byte[])authenticationResponse.readEntity(byte[].class)));
        SOAPHeader responseMessageHeaders = responseMessage.getSOAPHeader();
        NodeList ecpResponse = responseMessageHeaders.getElementsByTagNameNS(JBossSAMLURIConstants.ECP_PROFILE.get(), JBossSAMLConstants.RESPONSE__ECP.get());
        Assert.assertThat((String)"No ECP Response", (Object)ecpResponse.getLength(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
        org.w3c.dom.Node samlResponse = responseMessage.getSOAPBody().getFirstChild();
        Assert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        ResponseType responseType = (ResponseType)SAMLParser.getInstance().parse(samlResponse);
        StatusCodeType statusCode = responseType.getStatus().getStatusCode();
        Assert.assertThat((Object)statusCode.getValue().toString(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)JBossSAMLURIConstants.STATUS_SUCCESS.get()));
        Assert.assertThat((Object)responseType.getDestination(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)this.ecpSPPage.toString()));
        Assert.assertThat((Object)responseType.getSignature(), (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)responseType.getAssertions().size(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
        SOAPMessage samlResponseRequest = MessageFactory.newInstance().createMessage();
        samlResponseRequest.getSOAPBody().addDocument(responseMessage.getSOAPBody().extractContentAsDocument());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        samlResponseRequest.writeTo((OutputStream)os);
        Response serviceProviderFinalResponse = AdminClientUtil.createResteasyClient().target(responseType.getDestination()).request().post(Entity.entity((Object)os.toByteArray(), (String)"application/vnd.paos+xml"));
        Map cookies = serviceProviderFinalResponse.getCookies();
        Invocation.Builder resourceRequest = AdminClientUtil.createResteasyClient().target(responseType.getDestination()).request();
        for (NewCookie cookie : cookies.values()) {
            resourceRequest.cookie((Cookie)cookie);
        }
        Response resourceResponse = resourceRequest.get();
        Assert.assertThat((Object)resourceResponse.readEntity(String.class), (org.hamcrest.Matcher)org.hamcrest.Matchers.containsString((String)"pedroigor"));
    }

    @Test
    public void testInvalidCredentialsEcpFlow() throws Exception {
        Response authnRequestResponse = AdminClientUtil.createResteasyClient().target(this.ecpSPPage.toString()).request().header("Accept", (Object)"text/html; application/vnd.paos+xml").header("PAOS", (Object)"ver='urn:liberty:paos:2003-08' ;'urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp'").get();
        SOAPMessage authnRequestMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream((byte[])authnRequestResponse.readEntity(byte[].class)));
        Iterator it = authnRequestMessage.getSOAPHeader().getChildElements(new QName("urn:liberty:paos:2003-08", "Request"));
        it.next();
        it = authnRequestMessage.getSOAPHeader().getChildElements(new QName("urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp", "Request"));
        Node ecpRequestHeader = (Node)it.next();
        NodeList idpList = ((SOAPHeaderElement)ecpRequestHeader).getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "IDPList");
        Assert.assertThat((String)"No IDPList returned from Service Provider", (Object)idpList.getLength(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
        NodeList idpEntries = idpList.item(0).getChildNodes();
        Assert.assertThat((String)"No IDPEntry returned from Service Provider", (Object)idpEntries.getLength(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)1));
        String singleSignOnService = null;
        for (int i = 0; i < idpEntries.getLength(); ++i) {
            org.w3c.dom.Node item = idpEntries.item(i);
            NamedNodeMap attributes = item.getAttributes();
            org.w3c.dom.Node location = attributes.getNamedItem("Loc");
            singleSignOnService = location.getNodeValue();
        }
        Assert.assertThat((String)"Could not obtain SSO Service URL", singleSignOnService, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        Document authenticationRequest = authnRequestMessage.getSOAPBody().getFirstChild().getOwnerDocument();
        String username = "pedroigor";
        String password = "baspassword";
        String pair = username + ":" + password;
        String authHeader = "Basic " + Base64.encodeBytes((byte[])pair.getBytes());
        Response authenticationResponse = AdminClientUtil.createResteasyClient().target(singleSignOnService).request().header("Authorization", (Object)authHeader).post(Entity.entity((Object)DocumentUtil.asString((Document)authenticationRequest), (String)"application/soap+xml"));
        Assert.assertThat((Object)authenticationResponse.getStatus(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((Object)Response.Status.OK.getStatusCode()));
        SOAPMessage responseMessage = MessageFactory.newInstance().createMessage(null, (InputStream)new ByteArrayInputStream((byte[])authenticationResponse.readEntity(byte[].class)));
        org.w3c.dom.Node samlResponse = responseMessage.getSOAPBody().getFirstChild();
        Assert.assertThat((Object)samlResponse, (org.hamcrest.Matcher)org.hamcrest.Matchers.notNullValue());
        StatusResponseType responseType = (StatusResponseType)SAMLParser.getInstance().parse(samlResponse);
        StatusCodeType statusCode = responseType.getStatus().getStatusCode();
        Assert.assertThat((Object)statusCode.getStatusCode().getValue().toString(), (org.hamcrest.Matcher)org.hamcrest.Matchers.is((org.hamcrest.Matcher)org.hamcrest.Matchers.not((Object)JBossSAMLURIConstants.STATUS_SUCCESS.get())));
    }

    @Test
    public void testAdapterRoleMappings() throws Exception {
        this.assertForbiddenLogin((AbstractPage)this.employeeRoleMappingPage, this.bburkeUser.getUsername(), Users.getPasswordOf((UserRepresentation)this.bburkeUser), (Login)this.testRealmSAMLPostLoginPage, "bburke@redhat.com");
        this.employeeRoleMappingPage.logout();
        this.checkLoggedOut((AbstractPage)this.employeeRoleMappingPage, (Login)this.testRealmSAMLPostLoginPage);
        UserRepresentation bburke = (UserRepresentation)this.adminClient.realm("demo").users().search("bburke", Integer.valueOf(0), Integer.valueOf(1)).get(0);
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.adminClient.realm("demo").clients().findByClientId("http://localhost:8280/employee-role-mapping/").get(0);
        RoleRepresentation role = this.adminClient.realm("demo").clients().get(clientRepresentation.getId()).roles().get("supervisor").toRepresentation();
        this.adminClient.realm("demo").users().get(bburke.getId()).roles().clientLevel(clientRepresentation.getId()).add(Collections.singletonList(role));
        this.assertSuccessfulLogin((AbstractPage)this.employeeRoleMappingPage, this.bburkeUser, (Login)this.testRealmSAMLPostLoginPage, "bburke@redhat.com");
        MatcherAssert.assertThat((Object)this.employeeRoleMappingPage.rolesList(), (org.hamcrest.Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"manager", "coordinator", "team-lead", "employee"}));
        MatcherAssert.assertThat((Object)this.employeeRoleMappingPage.rolesList(), (org.hamcrest.Matcher)org.hamcrest.Matchers.not((org.hamcrest.Matcher)org.hamcrest.Matchers.hasItems((Object[])new String[]{"supervisor", "user"})));
        this.employeeRoleMappingPage.logout();
        this.checkLoggedOut((AbstractPage)this.employeeRoleMappingPage, (Login)this.testRealmSAMLPostLoginPage);
        this.adminClient.realm("demo").users().get(bburke.getId()).roles().clientLevel(clientRepresentation.getId()).remove(Collections.singletonList(role));
    }

    public static void printDocument(Source doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(doc, new StreamResult(new OutputStreamWriter(out, "UTF-8")));
    }

    private URI getAuthServerSamlEndpoint(String realm) throws IllegalArgumentException, UriBuilderException {
        return RealmsResource.protocolUrl((UriBuilder)UriBuilder.fromUri((URI)this.getAuthServerRoot())).build(new Object[]{realm, "saml"});
    }

    private URI getAppServerSamlEndpoint(SAMLServlet page) throws IllegalArgumentException, UriBuilderException {
        return UriBuilder.fromPath((String)page.toString()).path("/saml").build(new Object[0]);
    }

    private void validateXMLWithSchema(String xml, String schemaFileName) throws SAXException, IOException {
        URL schemaFile = this.getClass().getResource(schemaFileName);
        StreamSource xmlFile = new StreamSource(new ByteArrayInputStream(xml.getBytes()), xml);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaFile);
        Validator validator = schema.newValidator();
        try {
            validator.validate(xmlFile);
            System.out.println(xmlFile.getSystemId() + " is valid");
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            Assert.fail();
        }
    }

    private void assertOnForbiddenPage() {
        WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).is().present();
        Assert.assertTrue((this.driver.getPageSource().contains("Forbidden") || this.driver.getPageSource().contains(FORBIDDEN_TEXT) || this.driver.getPageSource().contains(WEBSPHERE_FORBIDDEN_TEXT) ? 1 : 0) != 0);
    }
}

