/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.ws.rs.core.Response;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.EmployeeServlet;
import org.keycloak.testsuite.adapter.page.SalesPostServlet;
import org.keycloak.testsuite.adapter.servlet.SendUsernameServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.SamlClient;
import org.keycloak.testsuite.util.SamlClientBuilder;
import org.keycloak.testsuite.util.saml.CreateLogoutRequestStepBuilder;
import org.keycloak.testsuite.util.saml.ModifySamlResponseStepBuilder;
import org.keycloak.testsuite.utils.io.IOUtil;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class SAMLLogoutAdapterTest
extends AbstractServletsAdapterTest {
    private static final String SP_PROVIDED_ID = "spProvidedId";
    private static final String SP_NAME_QUALIFIER = "spNameQualifier";
    private static final String NAME_QUALIFIER = "nameQualifier";
    @Page
    private EmployeeServlet employeeServletPage;
    @Page
    private SalesPostServlet salesPostServlet;
    private final AtomicReference<NameIDType> nameIdRef = new AtomicReference();
    private final AtomicReference<String> sessionIndexRef = new AtomicReference();

    @Deployment(name="employee")
    protected static WebArchive employee() {
        return SAMLLogoutAdapterTest.samlServletDeployment("employee", SendUsernameServlet.class);
    }

    @Deployment(name="sales-post")
    protected static WebArchive sales() {
        return SAMLLogoutAdapterTest.samlServletDeployment("sales-post", SendUsernameServlet.class);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/keycloak-saml/testsaml.json"));
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return false;
    }

    private SAML2Object extractNameId(SAML2Object so) {
        Assert.assertThat((Object)so, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
        ResponseType loginResp1 = (ResponseType)so;
        AssertionType firstAssertion = ((ResponseType.RTChoiceType)loginResp1.getAssertions().get(0)).getAssertion();
        Assert.assertThat((Object)firstAssertion, (Matcher)org.hamcrest.Matchers.notNullValue());
        Assert.assertThat((Object)firstAssertion.getSubject().getSubType().getBaseID(), (Matcher)org.hamcrest.Matchers.instanceOf(NameIDType.class));
        NameIDType nameId = (NameIDType)firstAssertion.getSubject().getSubType().getBaseID();
        AuthnStatementType firstAssertionStatement = (AuthnStatementType)firstAssertion.getStatements().iterator().next();
        this.nameIdRef.set(nameId);
        this.sessionIndexRef.set(firstAssertionStatement.getSessionIndex());
        return so;
    }

    @Test
    public void employeeGlobalLogoutTest() {
        SAMLDocumentHolder b = ((ModifySamlResponseStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo((AbstractPage)this.employeeServletPage).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlResponse().transformObject(this::extractNameId)).transformObject(o -> {
            Assert.assertThat((Object)o, (Matcher)Matchers.isSamlResponse((JBossSAMLURIConstants)JBossSAMLURIConstants.STATUS_SUCCESS));
            ResponseType rt = (ResponseType)o;
            NameIDType t = (NameIDType)((ResponseType.RTChoiceType)rt.getAssertions().get(0)).getAssertion().getSubject().getSubType().getBaseID();
            t.setNameQualifier(NAME_QUALIFIER);
            t.setSPNameQualifier(SP_NAME_QUALIFIER);
            t.setSPProvidedID(SP_PROVIDED_ID);
        })).build().navigateTo(this.employeeServletPage.getUriBuilder().clone().queryParam("GLO", new Object[]{"true"}).build(new Object[0])).getSamlResponse(SamlClient.Binding.POST);
        Assert.assertThat((Object)b.getSamlObject(), (Matcher)org.hamcrest.Matchers.instanceOf(LogoutRequestType.class));
        LogoutRequestType lr = (LogoutRequestType)b.getSamlObject();
        NameIDType logoutRequestNameID = lr.getNameID();
        Assert.assertThat((Object)logoutRequestNameID.getFormat(), (Matcher)org.hamcrest.Matchers.is((Object)this.nameIdRef.get().getFormat()));
        Assert.assertThat((Object)logoutRequestNameID.getValue(), (Matcher)org.hamcrest.Matchers.is((Object)this.nameIdRef.get().getValue()));
        Assert.assertThat((Object)logoutRequestNameID.getNameQualifier(), (Matcher)org.hamcrest.Matchers.is((Object)NAME_QUALIFIER));
        Assert.assertThat((Object)logoutRequestNameID.getSPProvidedID(), (Matcher)org.hamcrest.Matchers.is((Object)SP_PROVIDED_ID));
        Assert.assertThat((Object)logoutRequestNameID.getSPNameQualifier(), (Matcher)org.hamcrest.Matchers.is((Object)SP_NAME_QUALIFIER));
    }

    @Test
    public void testLogoutDestinationOptionalIfUnsignedRedirect() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.REDIRECT, builder -> {
            CreateLogoutRequestStepBuilder cfr_ignored_0 = (CreateLogoutRequestStepBuilder)builder.transformObject(logoutReq -> logoutReq.setDestination(null));
        }, SAMLLogoutAdapterTest::assertSamlLogoutResponse);
    }

    @Test
    public void testLogoutMandatoryDestinationUnsetRedirect() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.REDIRECT, builder -> ((CreateLogoutRequestStepBuilder)builder.transformObject(logoutReq -> logoutReq.setDestination(null))).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), SAMLLogoutAdapterTest::assertBadRequest);
    }

    @Test
    public void testLogoutMandatoryDestinationSetRedirect() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.REDIRECT, builder -> builder.signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), SAMLLogoutAdapterTest::assertSamlLogoutResponse);
    }

    @Test
    public void testLogoutDestinationOptionalIfUnsignedPost() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.POST, builder -> {
            CreateLogoutRequestStepBuilder cfr_ignored_0 = (CreateLogoutRequestStepBuilder)builder.transformObject(logoutReq -> logoutReq.setDestination(null));
        }, SAMLLogoutAdapterTest::assertSamlLogoutResponse);
    }

    @Test
    public void testLogoutMandatoryDestinationUnsetPost() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.POST, builder -> ((CreateLogoutRequestStepBuilder)builder.transformObject(logoutReq -> logoutReq.setDestination(null))).signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), SAMLLogoutAdapterTest::assertBadRequest);
    }

    @Test
    public void testLogoutMandatoryDestinationSetPost() throws IOException {
        this.testLogoutDestination(SamlClient.Binding.POST, builder -> builder.signWith("MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANUbxrvEY3pkiQNt55zJLKBwN+zKmNQw08ThAmOKzwHfXoK+xlDSFxNMtTKJGkeUdnKzaTfESEcEfKYULUA41y/NnOlvjS0CEsc7Wq0Ce63TSSGMB2NHea4tV0aQz/MwLsbmz2IjAFWHA5CHL5WwacIf3UTOSNnhJUSvnkomjJAlAgMBAAECgYANpO2gb/5+g5lSIuNFYov86bJq8r2+ODIW1OE2Rljioc6HSHeiDRF1JuAjECwikRrUVTBTZbnK8jqY14neJsWAKBzGo+ToaQALsNZ9B91DxxL50K5oVOzw5shAS9TnRjN40+KIXFED4ydq4JRdoqb8+cN+N3i0+Cu7tdm+UaHTAQJBAOwFs3ZwqQEqmv9vmgmIFwFpJm1aIw25gEOf3Hy45GP4bL/j0FQgwcXYRbLE5bPqhw/liLKc1GQ97bVm6zs8SvUCQQDnJZA6TFRMiDjezinE1J4e0v4RupyDniVjbE5ArTK5/FRVkjw4Ny0AqZUEyIIqlTeZlCq45pCJy4a2hymDGVJxAj9gzfXNnmezEsZ//kYvoqHM8lPQhifaeTsigW7tuOf0GPCBw+6uksDnZM0xhZCxOoArBPoMSEbU1pGo1Y2lvhUCQF6E5sBgHAybm53Ich4Rz4LNRqWbSIstrR5F2I3sBRU2kInZXZSjQ1zE+7HUCB4/nFfJ1dp8NdiTCEg1Zw072pECQQDnxyQALmWhQbBTl0tq6CwYf9rZDwBzxuY+CXB8Ky1gOmXwan96KZvV4rK8MQQs6HIiYC/j+5lX3A3zlXTFldaz", "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDVG8a7xGN6ZIkDbeecySygcDfsypjUMNPE4QJjis8B316CvsZQ0hcTTLUyiRpHlHZys2k3xEhHBHymFC1AONcvzZzpb40tAhLHO1qtAnut00khjAdjR3muLVdGkM/zMC7G5s9iIwBVhwOQhy+VsGnCH91EzkjZ4SVEr55KJoyQJQIDAQAB"), SAMLLogoutAdapterTest::assertSamlLogoutResponse);
    }

    private void testLogoutDestination(SamlClient.Binding binding, Consumer<CreateLogoutRequestStepBuilder> logoutReqUpdater, Consumer<? super CloseableHttpResponse> responseTester) throws IOException {
        URI clientSamlEndpoint = this.salesPostServlet.getUriBuilder().clone().path("saml").build(new Object[0]);
        ((CreateLogoutRequestStepBuilder)((ModifySamlResponseStepBuilder)new SamlClientBuilder().navigateTo((AbstractPage)this.salesPostServlet).processSamlResponse(SamlClient.Binding.POST).build().login().user(this.bburkeUser).build().processSamlResponse(SamlClient.Binding.POST).targetAttributeSamlResponse().transformObject(this::extractNameId)).build().logoutRequest(clientSamlEndpoint, "http://no.one.cares/", binding).nameId(this.nameIdRef::get).sessionIndex(this.sessionIndexRef::get).apply(logoutReqUpdater)).build().doNotFollowRedirects().assertResponse(responseTester).execute();
    }

    public static void assertSamlLogoutResponse(CloseableHttpResponse response) {
        try {
            Assert.assertThat((Object)SamlClient.Binding.POST.extractResponse(response).getSamlObject(), (Matcher)Matchers.isSamlStatusResponse((JBossSAMLURIConstants[])new JBossSAMLURIConstants[]{JBossSAMLURIConstants.STATUS_SUCCESS}));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void assertBadRequest(HttpResponse response) {
        Assert.assertThat((Object)response, (Matcher)org.hamcrest.Matchers.anyOf((Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.BAD_REQUEST), (Matcher)Matchers.statusCodeIsHC((Response.Status)Response.Status.FORBIDDEN), (Matcher)Matchers.bodyHC((Matcher)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.containsString((String)"Forbidden"), (Matcher)org.hamcrest.Matchers.containsString((String)"HTTP status code: 403"), (Matcher)org.hamcrest.Matchers.containsString((String)"Error reported: 403")))));
    }
}

