/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.wait.StringMatcher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.OfflineToken;
import org.keycloak.testsuite.adapter.servlet.AbstractShowTokensServlet;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.OfflineTokenServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.pages.AccountApplicationsPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.OAuthGrantPage;
import org.keycloak.testsuite.updaters.ClientAttributeUpdater;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.util.InfinispanTestTimeServiceRule;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.By;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class OfflineServletsAdapterTest
extends AbstractServletsAdapterTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected OfflineToken offlineTokenPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected AccountApplicationsPage accountAppPage;
    @Page
    protected OAuthGrantPage oauthGrantPage;
    @Rule
    public InfinispanTestTimeServiceRule ispnTestTimeService = new InfinispanTestTimeServiceRule(this);
    private final String DEFAULT_USERNAME = "test-user@localhost";
    private final String DEFAULT_PASSWORD = "password";
    private final String OFFLINE_CLIENT_ID = "offline-client";

    @Deployment(name="offline-client")
    protected static WebArchive offlineClient() {
        return OfflineServletsAdapterTest.servletDeployment("offline-client", AdapterActionsFilter.class, AbstractShowTokensServlet.class, OfflineTokenServlet.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmPage.setAuthRealm("test");
        this.testRealmLoginPage.setAuthRealm("test");
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/offline-client/offlinerealm.json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServlet() {
        try {
            String servletUri = UriBuilder.fromUri((String)this.offlineTokenPage.toString()).queryParam("scope", new Object[]{"offline_access"}).build(new Object[0]).toString();
            this.oauth.redirectUri(this.offlineTokenPage.toString());
            this.oauth.clientId("offline-client");
            this.driver.navigate().to(servletUri);
            WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken(), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)"Offline", (Matcher)CoreMatchers.is((Object)this.offlineTokenPage.getRefreshToken().getType()));
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken().getExp(), (Matcher)CoreMatchers.nullValue());
            String accessTokenId = this.offlineTokenPage.getAccessToken().getId();
            String refreshTokenId = this.offlineTokenPage.getRefreshToken().getId();
            this.setAdapterAndServerTimeOffset(9999);
            this.offlineTokenPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken().getId(), (Matcher)CoreMatchers.not((Object)refreshTokenId));
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getAccessToken().getId(), (Matcher)CoreMatchers.not((Object)accessTokenId));
            this.driver.navigate().to(this.oauth.getLoginFormUrl());
            WaitUtils.waitForPageToLoad();
            this.loginPage.assertCurrent();
            this.offlineTokenPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
            this.oauth.doLogout(this.offlineTokenPage.getRefreshTokenString(), "secret1");
            this.offlineTokenPage.navigateTo();
            URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.offlineTokenPage);
            this.loginPage.assertCurrent();
        }
        finally {
            this.events.clear();
            this.resetTimeOffsetAuthenticated();
        }
    }

    @Test
    public void testServletWithRevoke() {
        try {
            String servletUri = UriBuilder.fromUri((String)this.offlineTokenPage.toString()).queryParam("scope", new Object[]{"offline_access"}).build(new Object[0]).toString();
            this.driver.navigate().to(servletUri);
            WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken(), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken().getType(), (Matcher)CoreMatchers.is((Object)"Offline"));
            this.setAdapterAndServerTimeOffset(9999);
            this.offlineTokenPage.navigateTo();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
            this.setAdapterAndServerTimeOffset(0);
            this.events.clear();
            this.accountAppPage.open();
            List additionalGrants = ((AccountApplicationsPage.AppEntry)this.accountAppPage.getApplications().get("offline-client")).getAdditionalGrants();
            MatcherAssert.assertThat((Object)additionalGrants.size(), (Matcher)CoreMatchers.is((Object)1));
            MatcherAssert.assertThat(additionalGrants.get(0), (Matcher)CoreMatchers.is((Object)"Offline Token"));
            this.accountAppPage.revokeGrant("offline-client");
            WaitUtils.pause((long)500L);
            MatcherAssert.assertThat((Object)((AccountApplicationsPage.AppEntry)this.accountAppPage.getApplications().get("offline-client")).getAdditionalGrants().size(), (Matcher)CoreMatchers.is((Object)0));
            this.events.expect(EventType.REVOKE_GRANT).client("account").detail("revoked_client", "offline-client").assertEvent();
            this.setAdapterAndServerTimeOffset(19999);
            this.offlineTokenPage.navigateTo();
            URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.offlineTokenPage);
            this.loginPage.assertCurrent();
        }
        finally {
            this.events.clear();
            this.resetTimeOffsetAuthenticated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletWithConsent() throws IOException {
        try (ServerResourceUpdater cau = ClientAttributeUpdater.forClient((Keycloak)this.adminClient, (String)"test", (String)"offline-client").setConsentRequired(Boolean.valueOf(true)).update();){
            this.offlineTokenPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.oauthGrantPage.assertCurrent();
            ((StringMatcher)WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().not()).contains("Offline access");
            this.oauthGrantPage.cancel();
            String servletUri = UriBuilder.fromUri((String)this.offlineTokenPage.toString()).queryParam("scope", new Object[]{"offline_access"}).build(new Object[0]).toString();
            this.driver.navigate().to(servletUri);
            WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
            this.loginPage.login("test-user@localhost", "password");
            this.oauthGrantPage.assertCurrent();
            WaitUtils.waitUntilElement((By)By.xpath((String)"//body")).text().contains("Offline Access");
            this.oauthGrantPage.accept();
            URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.offlineTokenPage);
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken(), (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((Object)this.offlineTokenPage.getRefreshToken().getType(), (Matcher)CoreMatchers.is((Object)"Offline"));
            this.accountAppPage.open();
            AccountApplicationsPage.AppEntry offlineClient = (AccountApplicationsPage.AppEntry)this.accountAppPage.getApplications().get("offline-client");
            MatcherAssert.assertThat((Object)offlineClient.getClientScopesGranted(), (Matcher)Matchers.hasItem((Object)"Offline Access"));
            MatcherAssert.assertThat((Object)offlineClient.getAdditionalGrants(), (Matcher)Matchers.hasItem((Object)"Offline Token"));
            this.offlineTokenPage.logout();
            URLAssert.assertCurrentUrlDoesntStartWith((AbstractPage)this.offlineTokenPage);
            this.loginPage.assertCurrent();
        }
        finally {
            this.events.clear();
            this.resetTimeOffsetAuthenticated();
        }
    }

    private void setAdapterAndServerTimeOffset(int timeOffset) {
        super.setAdapterAndServerTimeOffset(timeOffset, this.offlineTokenPage.toString());
    }

    private void resetTimeOffsetAuthenticated() {
        this.resetTimeOffsetAuthenticated("test-user@localhost", "password");
    }

    private void resetTimeOffsetAuthenticated(String username, String password) {
        if (this.testContext.getAppServerInfo().isUndertow()) {
            this.setAdapterAndServerTimeOffset(0);
            return;
        }
        super.setAdapterServletTimeOffset(0, this.offlineTokenPage.toString());
        if (this.loginPage.isCurrent()) {
            this.loginPage.login(username, password);
            WaitUtils.waitForPageToLoad();
            this.offlineTokenPage.logout();
        }
        this.setTimeOffset(0);
    }
}

