/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.Time;
import org.keycloak.keys.KeyProvider;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.CustomerDb;
import org.keycloak.testsuite.adapter.page.SecurePortal;
import org.keycloak.testsuite.adapter.page.TokenMinTTLPage;
import org.keycloak.testsuite.adapter.servlet.AbstractShowTokensServlet;
import org.keycloak.testsuite.adapter.servlet.CallAuthenticatedServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerDatabaseServlet;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.TokenMinTTLServlet;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.openqa.selenium.By;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
public class OIDCPublicKeyRotationAdapterTest
extends AbstractServletsAdapterTest {
    @Page
    private SecurePortal securePortal;
    @Page
    private TokenMinTTLPage tokenMinTTLPage;
    @Page
    private CustomerDb customerDb;

    @Deployment(name="secure-portal")
    protected static WebArchive securePortal() {
        return OIDCPublicKeyRotationAdapterTest.servletDeployment("secure-portal", CallAuthenticatedServlet.class);
    }

    @Deployment(name="token-min-ttl")
    protected static WebArchive tokenMinTTLPage() {
        return OIDCPublicKeyRotationAdapterTest.servletDeployment("token-min-ttl", AdapterActionsFilter.class, AbstractShowTokensServlet.class, TokenMinTTLServlet.class, ErrorServlet.class);
    }

    @Deployment(name="customer-db")
    protected static WebArchive customerDb() {
        return OIDCPublicKeyRotationAdapterTest.servletDeployment("customer-db", AdapterActionsFilter.class, CustomerDatabaseServlet.class);
    }

    @Before
    public void beforeRotationAdapterTest() {
        this.tokenMinTTLPage.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void testRealmKeyRotationWithNewKeyDownload() throws Exception {
        this.loginToTokenMinTtlApp();
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.tokenMinTTLPage.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.generateNewRealmKey();
        this.tokenMinTTLPage.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith(this.tokenMinTTLPage.getInjectedUrl().toString());
        Assert.assertNull((Object)this.tokenMinTTLPage.getAccessToken());
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.setAdapterAndServerTimeOffset(300, this.tokenMinTTLPage.toString() + "/unsecured/foo");
        this.loginToTokenMinTtlApp();
        this.driver.navigate().to(logoutUri);
        this.resetKeycloakDeploymentForAdapter(this.tokenMinTTLPage.toString() + "/unsecured/foo");
    }

    @Test
    public void testClientWithJwksUri() throws Exception {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"secure-portal");
        ClientRepresentation client = clientResource.toRepresentation();
        OIDCAdvancedConfigWrapper wrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        wrapper.setUseJwksUrl(true);
        wrapper.setJwksUrl(this.securePortal + "/bad-jwks-url");
        clientResource.update(client);
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        String pageSource = this.driver.getPageSource();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.securePortal);
        Assert.assertFalse((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        client = clientResource.toRepresentation();
        wrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation((ClientRepresentation)client);
        wrapper.setUseJwksUrl(true);
        wrapper.setJwksUrl(this.securePortal + "/" + "k_jwks");
        clientResource.update(client);
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.securePortal);
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((pageSource.contains("Bill Burke") && pageSource.contains("Stian Thorgersen") ? 1 : 0) != 0);
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.securePortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
    }

    @Test
    public void testPublicKeyCacheTtl() {
        RealmRepresentation demoRealm = this.adminClient.realm("demo").toRepresentation();
        demoRealm.setAccessTokenLifespan(Integer.valueOf(1200));
        this.adminClient.realm("demo").update(demoRealm);
        this.loginToTokenMinTtlApp();
        String accessTokenString = this.tokenMinTTLPage.getAccessTokenString();
        int status = this.invokeRESTEndpoint(accessTokenString);
        Assert.assertEquals((long)200L, (long)status);
        String oldActiveKeyProviderId = this.getActiveKeyProvider();
        this.generateNewRealmKey();
        this.adminClient.realm("demo").components().component(oldActiveKeyProviderId).remove();
        status = this.invokeRESTEndpoint(accessTokenString);
        Assert.assertEquals((long)200L, (long)status);
        this.setAdapterAndServerTimeOffset(900, this.customerDb.toString() + "/unsecured/foo");
        status = this.invokeRESTEndpoint(accessTokenString);
        Assert.assertEquals((long)401L, (long)status);
        this.resetKeycloakDeploymentForAdapter(this.customerDb.toString() + "/unsecured/foo");
        this.resetKeycloakDeploymentForAdapter(this.tokenMinTTLPage.toString() + "/unsecured/foo");
    }

    @Test
    public void testPublicKeyCacheInvalidatedWhenPushedNotBefore() {
        this.driver.manage().timeouts().pageLoadTimeout(1000L, TimeUnit.SECONDS);
        String customerDBUnsecuredUrl = this.customerDb.getUriBuilder().clone().path("unsecured").path("foo").build(new Object[0]).toASCIIString();
        String customerDBUrlNoTrailSlash = this.customerDb.getUriBuilder().build(new Object[0]).toASCIIString();
        customerDBUrlNoTrailSlash = customerDBUrlNoTrailSlash.substring(0, customerDBUrlNoTrailSlash.length() - 1);
        String tokenMinTTLUnsecuredUrl = this.tokenMinTTLPage.getUriBuilder().clone().path("unsecured").path("foo").build(new Object[0]).toASCIIString();
        RealmRepresentation demoRealm = this.adminClient.realm("demo").toRepresentation();
        demoRealm.setAccessTokenLifespan(Integer.valueOf(1200));
        this.adminClient.realm("demo").update(demoRealm);
        this.loginToTokenMinTtlApp();
        String accessTokenString = this.tokenMinTTLPage.getAccessTokenString();
        String oldActiveKeyProviderId = this.getActiveKeyProvider();
        this.generateNewRealmKey();
        int status = this.invokeRESTEndpoint(accessTokenString);
        Assert.assertEquals((long)200L, (long)status);
        this.adminClient.realm("demo").components().component(oldActiveKeyProviderId).remove();
        this.setAdapterAndServerTimeOffset(130, customerDBUnsecuredUrl, tokenMinTTLUnsecuredUrl);
        demoRealm.setNotBefore(Integer.valueOf(Time.currentTime() - 1));
        this.adminClient.realm("demo").update(demoRealm);
        GlobalRequestResult result = this.adminClient.realm("demo").pushRevocation();
        Assert.assertTrue((boolean)result.getSuccessRequests().contains(customerDBUrlNoTrailSlash));
        status = this.invokeRESTEndpoint(accessTokenString);
        Assert.assertEquals((long)401L, (long)status);
        this.resetKeycloakDeploymentForAdapter(customerDBUnsecuredUrl);
        this.resetKeycloakDeploymentForAdapter(tokenMinTTLUnsecuredUrl);
    }

    private void loginToTokenMinTtlApp() {
        this.tokenMinTTLPage.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.tokenMinTTLPage);
        AccessToken token = this.tokenMinTTLPage.getAccessToken();
        Assert.assertEquals((Object)"bburke@redhat.com", (Object)token.getPreferredUsername());
    }

    private void generateNewRealmKey() {
        String realmId = this.adminClient.realm("demo").toRepresentation().getId();
        ComponentRepresentation keys = new ComponentRepresentation();
        keys.setName("generated");
        keys.setProviderType(KeyProvider.class.getName());
        keys.setProviderId("rsa-generated");
        keys.setParentId(realmId);
        keys.setConfig(new MultivaluedHashMap());
        keys.getConfig().putSingle((Object)"priority", (Object)"150");
        Response response = this.adminClient.realm("demo").components().add(keys);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        response.close();
    }

    private String getActiveKeyProvider() {
        KeysMetadataRepresentation keyMetadata = this.adminClient.realm("demo").keys().getKeyMetadata();
        String activeKid = (String)keyMetadata.getActive().get("RS256");
        for (KeysMetadataRepresentation.KeyMetadataRepresentation rep : keyMetadata.getKeys()) {
            if (!rep.getKid().equals(activeKid)) continue;
            return rep.getProviderId();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private int invokeRESTEndpoint(String accessTokenString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resetKeycloakDeploymentForAdapter(String adapterActionsUrl) {
        String timeOffsetUri = UriBuilder.fromUri((String)adapterActionsUrl).queryParam("resetDeployment", new Object[]{"true"}).build(new Object[0]).toString();
        this.driver.navigate().to(timeOffsetUri);
        WaitUtils.waitUntilElement((By)By.tagName((String)"body")).is().visible();
    }
}

