/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.net.URL;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.page.MultiTenant;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.MultiTenantResolver;
import org.keycloak.testsuite.adapter.servlet.MultiTenantServlet;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
public class MultiTenancyTest
extends AbstractServletsAdapterTest {
    @Page
    private MultiTenant tenantPage;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/tenant1-realm.json"));
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/tenant2-realm.json"));
    }

    @Override
    protected boolean isImportAfterEachMethod() {
        return false;
    }

    @Deployment(name="multi-tenant")
    protected static WebArchive multiTenant() {
        return MultiTenancyTest.servletDeploymentMultiTenant("multi-tenant", MultiTenantServlet.class, ErrorServlet.class, MultiTenantResolver.class);
    }

    @After
    public void afterTest() {
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void testTenantsLoggingOut() {
        this.doTenantRequests("tenant1", true);
        this.doTenantRequests("tenant2", true);
    }

    @Test
    public void testTenantsWithoutLoggingOut() {
        this.doTenantRequests("tenant1", true);
        this.doTenantRequests("tenant2", true);
        this.doTenantRequests("tenant1", false);
        this.doTenantRequests("tenant2", true);
        this.logout("tenant1");
    }

    @Test
    public void testUnauthorizedAccessNotLoggedIn() {
        String keycloakServerBaseUrl = this.authServerPage.toString();
        this.driver.navigate().to(this.tenantPage.getTenantRealmUrl("tenant1"));
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith(keycloakServerBaseUrl);
        this.testRealmLoginPage.form().login("user-tenant2", "user-tenant2");
        URLAssert.assertCurrentUrlStartsWith(keycloakServerBaseUrl);
    }

    @Test
    public void testUnauthorizedAccessLoggedIn() {
        this.doTenantRequests("tenant1", false);
        this.driver.navigate().to(this.tenantPage.getTenantRealmUrl("tenant2"));
        URLAssert.assertCurrentUrlStartsWith(this.authServerPage.toString());
        this.logout("tenant1");
    }

    private void doTenantRequests(String tenant, boolean logout) {
        String tenantLoginUrl = OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)this.authServerPage.getAuthRoot())).build(new Object[]{tenant}).toString();
        URL tenantUrl = this.tenantPage.getTenantRealmUrl(tenant);
        this.driver.navigate().to(tenantUrl);
        URLAssert.assertCurrentUrlStartsWith(tenantLoginUrl);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        this.log.debug((Object)("Current url: " + this.driver.getCurrentUrl()));
        URLAssert.assertCurrentUrlStartsWith(tenantUrl.toString());
        String pageSource = this.driver.getPageSource();
        this.log.debug((Object)pageSource);
        Assert.assertTrue((boolean)pageSource.contains("Username: bburke@redhat.com"));
        Assert.assertTrue((boolean)pageSource.contains("Realm: " + tenant));
        if (logout) {
            this.driver.navigate().to(tenantUrl + "/logout");
            Assert.assertFalse((boolean)this.driver.getPageSource().contains("Username: bburke@redhat.com"));
            Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(tenantLoginUrl));
        }
        this.log.debug((Object)"---------------------------------------------------------------------------------------");
    }

    private void logout(String tenant) {
        String tenantLoginUrl = OIDCLoginProtocolService.authUrl((UriBuilder)UriBuilder.fromUri((String)this.authServerPage.getAuthRoot())).build(new Object[]{tenant}).toString();
        URL tenantUrl = this.tenantPage.getTenantRealmUrl(tenant);
        this.driver.navigate().to(tenantUrl + "/logout");
        Assert.assertFalse((boolean)this.driver.getPageSource().contains("Username: bburke@redhat.com"));
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(tenantLoginUrl));
    }
}

