/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.adapters.OIDCAuthenticationError;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventType;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.filter.AdapterActionsFilter;
import org.keycloak.testsuite.adapter.page.BasicAuth;
import org.keycloak.testsuite.adapter.page.ClientSecretJwtSecurePortal;
import org.keycloak.testsuite.adapter.page.ClientSecretJwtSecurePortalValidAlg;
import org.keycloak.testsuite.adapter.page.CustomerCookiePortal;
import org.keycloak.testsuite.adapter.page.CustomerCookiePortalRoot;
import org.keycloak.testsuite.adapter.page.CustomerDb;
import org.keycloak.testsuite.adapter.page.CustomerDbErrorPage;
import org.keycloak.testsuite.adapter.page.CustomerPortal;
import org.keycloak.testsuite.adapter.page.CustomerPortalNoConf;
import org.keycloak.testsuite.adapter.page.InputPortal;
import org.keycloak.testsuite.adapter.page.InputPortalNoAccessToken;
import org.keycloak.testsuite.adapter.page.ProductPortal;
import org.keycloak.testsuite.adapter.page.ProductPortalAutodetectBearerOnly;
import org.keycloak.testsuite.adapter.page.SecurePortal;
import org.keycloak.testsuite.adapter.page.SecurePortalRewriteRedirectUri;
import org.keycloak.testsuite.adapter.page.SecurePortalWithCustomSessionConfig;
import org.keycloak.testsuite.adapter.page.TokenMinTTLPage;
import org.keycloak.testsuite.adapter.page.TokenRefreshPage;
import org.keycloak.testsuite.adapter.servlet.AbstractShowTokensServlet;
import org.keycloak.testsuite.adapter.servlet.BasicAuthServlet;
import org.keycloak.testsuite.adapter.servlet.CallAuthenticatedServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerDatabaseServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerServlet;
import org.keycloak.testsuite.adapter.servlet.CustomerServletNoConf;
import org.keycloak.testsuite.adapter.servlet.ErrorServlet;
import org.keycloak.testsuite.adapter.servlet.InputServlet;
import org.keycloak.testsuite.adapter.servlet.ProductServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.adapter.servlet.TokenMinTTLServlet;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.account.Applications;
import org.keycloak.testsuite.auth.page.login.OAuthGrant;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.console.page.events.Config;
import org.keycloak.testsuite.console.page.events.LoginEvents;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.Matchers;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.URLUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.BasicAuthHelper;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class DemoServletsAdapterTest
extends AbstractServletsAdapterTest {
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    @JavascriptBrowser
    protected OIDCLogin jsDriverTestRealmLoginPage;
    @Page
    protected CustomerPortal customerPortal;
    @Page
    private CustomerPortalNoConf customerPortalNoConf;
    @Page
    private SecurePortal securePortal;
    @Page
    private SecurePortalWithCustomSessionConfig securePortalWithCustomSessionConfig;
    @Page
    private SecurePortalRewriteRedirectUri securePortalRewriteRedirectUri;
    @Page
    private CustomerDb customerDb;
    @Page
    private CustomerDbErrorPage customerDbErrorPage;
    @Page
    private ProductPortal productPortal;
    @Page
    private ProductPortalAutodetectBearerOnly productPortalAutodetectBearerOnly;
    @Page
    private InputPortal inputPortal;
    @Page
    private InputPortalNoAccessToken inputPortalNoAccessToken;
    @Page
    private TokenMinTTLPage tokenMinTTLPage;
    @Page
    private TokenRefreshPage tokenRefreshPage;
    @Page
    private OAuthGrant oAuthGrantPage;
    @Page
    protected Applications applicationsPage;
    @Page
    protected LoginEvents loginEventsPage;
    @Page
    private BasicAuth basicAuthPage;
    @Page
    protected Config configPage;
    @Page
    private ClientSecretJwtSecurePortal clientSecretJwtSecurePortal;
    @Page
    private ClientSecretJwtSecurePortalValidAlg clientSecretJwtSecurePortalValidAlg;
    @Page
    private CustomerCookiePortal customerCookiePortal;
    @Page
    private CustomerCookiePortalRoot customerCookiePortalRoot;
    @Rule
    public AssertEvents assertEvents = new AssertEvents(this);

    @Deployment(name="customer-portal")
    protected static WebArchive customerPortal() {
        return DemoServletsAdapterTest.servletDeployment("customer-portal", CustomerServlet.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="customer-cookie-portal")
    protected static WebArchive customerCookiePortal() {
        return DemoServletsAdapterTest.servletDeployment("customer-cookie-portal", AdapterActionsFilter.class, CustomerServlet.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="customer-portal-noconf")
    protected static WebArchive customerPortalNoConf() {
        return DemoServletsAdapterTest.servletDeployment("customer-portal-noconf", CustomerServletNoConf.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="secure-portal")
    protected static WebArchive securePortal() {
        return DemoServletsAdapterTest.servletDeployment("secure-portal", CallAuthenticatedServlet.class);
    }

    @Deployment(name="secure-portal-with-rewrite-redirect-uri")
    protected static WebArchive securePortalRewriteRedirectUri() {
        return DemoServletsAdapterTest.servletDeployment("secure-portal-with-rewrite-redirect-uri", CallAuthenticatedServlet.class);
    }

    @Deployment(name="secure-portal-with-custom-session-config")
    protected static WebArchive securePortalWithCustomSessionConfig() {
        return DemoServletsAdapterTest.servletDeployment("secure-portal-with-custom-session-config", CallAuthenticatedServlet.class);
    }

    @Deployment(name="customer-db")
    protected static WebArchive customerDb() {
        return DemoServletsAdapterTest.servletDeployment("customer-db", AdapterActionsFilter.class, CustomerDatabaseServlet.class);
    }

    @Deployment(name="customer-db-audience-required")
    protected static WebArchive customerDbAudienceRequired() {
        return DemoServletsAdapterTest.servletDeployment("customer-db-audience-required", AdapterActionsFilter.class, CustomerDatabaseServlet.class);
    }

    @Deployment(name="customer-db-error-page")
    protected static WebArchive customerDbErrorPage() {
        return DemoServletsAdapterTest.servletDeployment("customer-db-error-page", CustomerDatabaseServlet.class, ErrorServlet.class);
    }

    @Deployment(name="product-portal")
    protected static WebArchive productPortal() {
        return DemoServletsAdapterTest.servletDeployment("product-portal", ProductServlet.class);
    }

    @Deployment(name="product-portal-autodetect-bearer-only")
    protected static WebArchive productPortalAutodetectBearerOnly() {
        return DemoServletsAdapterTest.servletDeployment("product-portal-autodetect-bearer-only", ProductServlet.class);
    }

    @Deployment(name="input-portal")
    protected static WebArchive inputPortal() {
        return DemoServletsAdapterTest.servletDeployment("input-portal", "keycloak.json", InputServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="no-access-token")
    protected static WebArchive inputPortalNoAccessToken() {
        return DemoServletsAdapterTest.servletDeployment("no-access-token", "keycloak.json", InputServlet.class, ServletTestUtils.class);
    }

    @Deployment(name="token-min-ttl")
    protected static WebArchive tokenMinTTLPage() {
        return DemoServletsAdapterTest.servletDeployment("token-min-ttl", AdapterActionsFilter.class, AbstractShowTokensServlet.class, TokenMinTTLServlet.class, ErrorServlet.class);
    }

    @Deployment(name="token-refresh")
    protected static WebArchive tokenRefresh() {
        return DemoServletsAdapterTest.servletDeployment("token-refresh", AdapterActionsFilter.class, AbstractShowTokensServlet.class, TokenMinTTLServlet.class, ErrorServlet.class);
    }

    @Deployment(name="basic-auth")
    protected static WebArchive basicAuth() {
        return DemoServletsAdapterTest.servletDeployment("basic-auth", BasicAuthServlet.class);
    }

    @Deployment(name="client-secret-jwt-secure-portal")
    protected static WebArchive clientSecretSecurePortal() {
        return DemoServletsAdapterTest.servletDeployment("client-secret-jwt-secure-portal", CallAuthenticatedServlet.class);
    }

    @Deployment(name="client-secret-jwt-secure-portal-valid-alg")
    protected static WebArchive clientSecretSecurePortalValidAlg() {
        return DemoServletsAdapterTest.servletDeployment("client-secret-jwt-secure-portal-valid-alg", CallAuthenticatedServlet.class);
    }

    @Deployment(name="customer-cookie-portal-root")
    protected static WebArchive customerCookiePortalRoot() {
        return DemoServletsAdapterTest.servletDeployment("customer-cookie-portal-root", AdapterActionsFilter.class, CustomerServlet.class, ErrorServlet.class, ServletTestUtils.class);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.configPage.setConsoleRealm("demo");
        this.loginEventsPage.setConsoleRealm("demo");
        this.applicationsPage.setAuthRealm("demo");
        this.loginEventsPage.setConsoleRealm("demo");
        this.oAuthGrantPage.setAuthRealm("demo");
    }

    @Before
    public void beforeDemoServletsAdapterTest() {
        this.tokenMinTTLPage.navigateTo();
        this.driver.manage().deleteAllCookies();
    }

    @Test
    public void testTokenInCookieSSO() {
        String tokenCookie = this.loginToCustomerCookiePortal();
        this.customerPortal.navigateTo();
        this.assertLogged();
        this.customerCookiePortal.navigateTo();
        this.assertLogged();
        String tokenCookie2 = this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE").getValue();
        Assert.assertEquals((Object)tokenCookie, (Object)tokenCookie2);
        this.logoutFromCustomerCookiePortal();
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenInCookieRefresh() {
        this.log.debug((Object)"Set token timeout 10 sec");
        RealmRepresentation demo = this.adminClient.realm("demo").toRepresentation();
        int originalTokenTimeout = demo.getAccessTokenLifespan();
        demo.setAccessTokenLifespan(Integer.valueOf(10));
        this.adminClient.realm("demo").update(demo);
        try {
            this.log.debug((Object)"login to customer-cookie-portal");
            String tokenCookie1 = this.loginToCustomerCookiePortal();
            this.log.debug((Object)"Simulate waiting 12 seconds");
            this.setAdapterAndServerTimeOffset(12, this.customerCookiePortal.toString());
            this.log.debug((Object)"assert cookie was refreshed");
            this.customerCookiePortal.navigateTo();
            URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerCookiePortal);
            this.assertLogged();
            String tokenCookie2 = this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE").getValue();
            Assert.assertNotEquals((Object)tokenCookie1, (Object)tokenCookie2);
            this.log.debug((Object)"login to 2nd app and logout from it");
            this.customerPortal.navigateTo();
            URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
            this.assertLogged();
            this.driver.navigate().to(this.customerPortal.logout().toASCIIString());
            WaitUtils.waitUntilElement((By)By.id((String)"customer_portal_logout")).is().present();
            this.customerPortal.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
            this.log.debug((Object)"Simulate another 12 seconds");
            this.setAdapterAndServerTimeOffset(24, this.customerCookiePortal.toString());
            this.log.debug((Object)"assert not logged in customer-cookie-portal");
            this.customerCookiePortal.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        }
        catch (Throwable throwable) {
            this.log.debug((Object)"Set token timeout to original");
            demo.setAccessTokenLifespan(Integer.valueOf(originalTokenTimeout));
            this.adminClient.realm("demo").update(demo);
            this.log.debug((Object)"reset time offset");
            this.setAdapterAndServerTimeOffset(0, this.customerCookiePortal.toString().concat("/unsecured"));
            throw throwable;
        }
        this.log.debug((Object)"Set token timeout to original");
        demo.setAccessTokenLifespan(Integer.valueOf(originalTokenTimeout));
        this.adminClient.realm("demo").update(demo);
        this.log.debug((Object)"reset time offset");
        this.setAdapterAndServerTimeOffset(0, this.customerCookiePortal.toString().concat("/unsecured"));
    }

    @Test
    public void testInvalidTokenCookie() {
        String tokenCookie = this.loginToCustomerCookiePortal();
        String changedTokenCookie = tokenCookie.replace("a", "b");
        this.driver.manage().addCookie(new Cookie("KEYCLOAK_ADAPTER_STATE", changedTokenCookie, "/customer-cookie-portal"));
        this.customerCookiePortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerCookiePortal);
        String currentCookie = this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE").getValue();
        Assert.assertNotEquals((Object)currentCookie, (Object)tokenCookie);
        Assert.assertNotEquals((Object)currentCookie, (Object)changedTokenCookie);
        this.logoutFromCustomerCookiePortal();
    }

    private String loginToCustomerCookiePortal() {
        this.customerCookiePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerCookiePortal);
        this.assertLogged();
        Assert.assertNull((Object)this.driver.manage().getCookieNamed("JSESSIONID"));
        return this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE").getValue();
    }

    private void logoutFromCustomerCookiePortal() {
        String logout = this.customerCookiePortal.logoutURL();
        this.driver.navigate().to(logout);
        WaitUtils.waitUntilElement((By)By.id((String)"customer_portal_logout")).is().present();
        Assert.assertNull((Object)this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE"));
        this.customerCookiePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    protected void assertLogged() {
        this.assertPageContains("Bill Burke");
        this.assertPageContains("Stian Thorgersen");
    }

    private void assertPageContains(String string) {
        String pageSource = this.driver.getPageSource();
        Assert.assertThat((Object)pageSource, (Matcher)org.hamcrest.Matchers.containsString((String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSavedPostRequest() throws Exception {
        this.inputPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.inputPortal);
        this.inputPortal.execute("hello");
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals(this.inputPortal.getUriBuilder().clone().path("secured").path("post").build(new Object[0]));
        WaitUtils.waitForPageToLoad();
        this.assertPageContains("parameter=hello");
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        try (ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)false);){
            Form form = new Form();
            form.param("parameter", "hello");
            String text = (String)client.target(this.inputPortal + "/unsecured").request().post(Entity.form((Form)form), String.class);
            Assert.assertThat((Object)text, (Matcher)org.hamcrest.Matchers.containsString((String)"parameter=hello"));
        }
    }

    @Test
    public void testLoginSSOAndLogout() {
        this.customerPortal.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        this.assertLogged();
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        this.assertPageContains("iPhone");
        this.assertPageContains("iPad");
        List stats = this.testRealmResource().getClientSessionStats();
        Map customerPortalStats = null;
        Map productPortalStats = null;
        for (Map s : stats) {
            switch ((String)s.get("clientId")) {
                case "customer-portal": {
                    customerPortalStats = s;
                    break;
                }
                case "product-portal": {
                    productPortalStats = s;
                }
            }
        }
        Assert.assertEquals((long)1L, (long)Integer.parseInt((String)customerPortalStats.get("active")));
        Assert.assertEquals((long)1L, (long)Integer.parseInt((String)productPortalStats.get("active")));
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testServletRequestLogout() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        this.assertLogged();
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        this.assertPageContains("iPhone");
        this.assertPageContains("iPad");
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        this.assertLogged();
        this.driver.navigate().to(this.customerPortal + "/logout");
        WaitUtils.waitUntilElement((By)By.id((String)"customer_portal_logout")).is().present();
        WaitUtils.waitUntilElement((By)By.id((String)"customer_database_logout")).is().present();
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testLoginSSOIdle() {
        this.customerPortal.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        this.assertLogged();
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        int originalIdle = demoRealmRep.getSsoSessionIdleTimeout();
        try {
            demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(1));
            this.testRealmResource().update(demoRealmRep);
            this.setAdapterAndServerTimeOffset(122, new String[0]);
            this.productPortal.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        }
        finally {
            demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(originalIdle));
            this.testRealmResource().update(demoRealmRep);
        }
    }

    @Test
    public void testLoginSSOIdleRemoveExpiredUserSessions() {
        this.customerPortal.navigateTo();
        this.log.info((Object)("Current url: " + this.driver.getCurrentUrl()));
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        this.log.info((Object)("Current url: " + this.driver.getCurrentUrl()));
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        int originalIdle = demoRealmRep.getSsoSessionIdleTimeout();
        try {
            demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(1));
            this.testRealmResource().update(demoRealmRep);
            this.setAdapterAndServerTimeOffset(122, new String[0]);
            this.productPortal.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        }
        finally {
            demoRealmRep.setSsoSessionIdleTimeout(Integer.valueOf(originalIdle));
            this.testRealmResource().update(demoRealmRep);
        }
    }

    @Test
    public void testLoginSSOMax() throws InterruptedException {
        this.driver.navigate().to(this.customerPortal.getUriBuilder().clone().path("error.html").build(new Object[0]).toASCIIString());
        this.driver.manage().deleteAllCookies();
        this.customerPortal.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.customerPortal);
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        int originalMax = demoRealmRep.getSsoSessionMaxLifespan();
        try {
            demoRealmRep.setSsoSessionMaxLifespan(Integer.valueOf(1));
            this.testRealmResource().update(demoRealmRep);
            TimeUnit.SECONDS.sleep(2L);
            this.productPortal.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        }
        finally {
            demoRealmRep.setSsoSessionMaxLifespan(Integer.valueOf(originalMax));
            this.testRealmResource().update(demoRealmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullBearerToken() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);
        WebTarget target = client.target(this.customerDb.toString());
        try {
            try (Response response = target.request().get();){
                Assert.assertEquals((long)401L, (long)response.getStatus());
            }
            response = target.request().header("Authorization", (Object)"Bearer null").get();
            var4_4 = null;
            try {
                Assert.assertEquals((long)401L, (long)response.getStatus());
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (response != null) {
                    if (var4_4 != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        finally {
            client.close();
        }
    }

    @Test
    public void testNullBearerTokenCustomErrorPage() throws Exception {
        String errorPageResponse;
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);
        WebTarget target = client.target(this.customerDbErrorPage.toString());
        try (Response response = target.request().get();){
            Assert.assertEquals((long)401L, (long)response.getStatus());
            errorPageResponse = (String)response.readEntity(String.class);
            Assert.assertThat((Object)errorPageResponse, (Matcher)org.hamcrest.Matchers.containsString((String)"Error Page"));
            Assert.assertThat((Object)errorPageResponse, (Matcher)org.hamcrest.Matchers.containsString((String)OIDCAuthenticationError.Reason.NO_BEARER_TOKEN.toString()));
        }
        response = target.request().header("Authorization", (Object)"Bearer null").get();
        var4_4 = null;
        try {
            Assert.assertEquals((long)401L, (long)response.getStatus());
            errorPageResponse = (String)response.readEntity(String.class);
            Assert.assertThat((Object)errorPageResponse, (Matcher)org.hamcrest.Matchers.containsString((String)"Error Page"));
            Assert.assertThat((Object)errorPageResponse, (Matcher)org.hamcrest.Matchers.containsString((String)OIDCAuthenticationError.Reason.INVALID_TOKEN.toString()));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (response != null) {
                if (var4_4 != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    response.close();
                }
            }
        }
        client.close();
    }

    @Test
    public void testBadUser() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);
        URI uri = OIDCLoginProtocolService.tokenUrl((UriBuilder)this.authServerPage.createUriBuilder()).build(new Object[]{"demo"});
        WebTarget target = client.target(uri);
        String header = BasicAuthHelper.createHeader((String)"customer-portal", (String)"password");
        Form form = new Form();
        form.param("grant_type", "password").param("username", "monkey@redhat.com").param("password", "password");
        try (Response response = target.request().header("Authorization", (Object)header).post(Entity.form((Form)form));){
            Assert.assertEquals((long)401L, (long)response.getStatus());
        }
        client.close();
    }

    @Test
    public void testAuthenticated() {
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.securePortal);
        this.assertLogged();
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.securePortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testAuthenticatedWithCustomSessionConfig() {
        this.securePortalWithCustomSessionConfig.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.securePortalWithCustomSessionConfig);
        Assert.assertThat((String)"Cookie CUSTOM_JSESSION_ID_NAME should exist", (Object)this.driver.manage().getCookieNamed("CUSTOM_JSESSION_ID_NAME"), (Matcher)org.hamcrest.Matchers.notNullValue());
        this.assertLogged();
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.securePortalWithCustomSessionConfig.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.securePortalWithCustomSessionConfig.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testRewriteRedirectUri() {
        this.securePortalRewriteRedirectUri.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("/rewritten"));
    }

    @Test
    public void testTokenMinTTL() {
        this.tokenMinTTLPage.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.tokenMinTTLPage);
        AccessToken token = this.tokenMinTTLPage.getAccessToken();
        int tokenIssued1 = token.getIssuedAt();
        this.setAdapterAndServerTimeOffset(300, this.tokenMinTTLPage.toString());
        this.tokenMinTTLPage.navigateTo();
        token = this.tokenMinTTLPage.getAccessToken();
        int tokenIssued2 = token.getIssuedAt();
        Assert.assertEquals((long)tokenIssued1, (long)tokenIssued2);
        Assert.assertFalse((boolean)token.isExpired());
        this.setAdapterAndServerTimeOffset(540, this.tokenMinTTLPage.toString());
        this.tokenMinTTLPage.navigateTo();
        token = this.tokenMinTTLPage.getAccessToken();
        int tokenIssued3 = token.getIssuedAt();
        Assert.assertTrue((tokenIssued3 > tokenIssued1 ? 1 : 0) != 0);
        this.setAdapterAndServerTimeOffset(0, this.tokenMinTTLPage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTokenConcurrentRefresh() {
        RealmResource demoRealm = this.adminClient.realm("demo");
        RealmRepresentation demo = demoRealm.toRepresentation();
        demo.setAccessTokenLifespan(Integer.valueOf(2));
        demo.setRevokeRefreshToken(Boolean.valueOf(true));
        demo.setRefreshTokenMaxReuse(Integer.valueOf(0));
        demoRealm.update(demo);
        this.tokenRefreshPage.navigateTo();
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.tokenRefreshPage);
        this.setAdapterAndServerTimeOffset(5, this.tokenRefreshPage.toString());
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicClientCookie jsessionid = new BasicClientCookie("JSESSIONID", this.driver.manage().getCookieNamed("JSESSIONID").getValue());
        jsessionid.setDomain(ServerURLs.APP_SERVER_HOST);
        jsessionid.setPath("/");
        cookieStore.addCookie((org.apache.http.cookie.Cookie)jsessionid);
        ExecutorService executor = Executors.newWorkStealingPool();
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        try {
            for (int i = 0; i < 5; ++i) {
                future = CompletableFuture.allOf(future, CompletableFuture.runAsync(() -> {
                    try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();){
                        HttpGet request = new HttpGet(this.tokenRefreshPage.getInjectedUrl().toString());
                        try (CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)request);){
                            Assert.assertTrue((String)"Token not refreshed", (boolean)EntityUtils.toString((HttpEntity)httpResponse.getEntity()).contains("accessToken"));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, executor));
            }
            future.join();
        }
        finally {
            executor.shutdownNow();
        }
        this.setAdapterAndServerTimeOffset(0, this.tokenRefreshPage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOIDCParamsForwarding() {
        this.securePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.securePortal);
        this.assertLogged();
        int currentTime = Time.currentTime();
        try {
            this.setAdapterAndServerTimeOffset(10, this.securePortal.toString());
            String appUri = this.tokenMinTTLPage.getUriBuilder().queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
            URLUtils.navigateToUri((String)appUri);
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
            this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
            AccessToken token = this.tokenMinTTLPage.getAccessToken();
            int authTime = token.getAuthTime();
            Assert.assertThat((Object)authTime, (Matcher)org.hamcrest.Matchers.is((Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(currentTime + 10))));
        }
        catch (Throwable throwable) {
            this.setAdapterAndServerTimeOffset(0, this.securePortal.toString());
            throw throwable;
        }
        this.setAdapterAndServerTimeOffset(0, this.securePortal.toString());
    }

    private static Map<String, String> getQueryFromUrl(String url) {
        try {
            return URLEncodedUtils.parse((URI)new URI(url), (String)"UTF-8").stream().collect(Collectors.toMap(p -> p.getName(), p -> p.getValue()));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOIDCUiLocalesParamForwarding() {
        ProfileAssume.assumeCommunity();
        RealmRepresentation demoRealmRep = this.testRealmResource().toRepresentation();
        boolean enabled = demoRealmRep.isInternationalizationEnabled();
        String defaultLocale = demoRealmRep.getDefaultLocale();
        Set locales = demoRealmRep.getSupportedLocales();
        demoRealmRep.setInternationalizationEnabled(Boolean.valueOf(true));
        demoRealmRep.setDefaultLocale("en");
        demoRealmRep.setSupportedLocales(Stream.of("en", "de").collect(Collectors.toSet()));
        this.testRealmResource().update(demoRealmRep);
        try {
            String portalUri = this.securePortal.getUriBuilder().build(new Object[0]).toString();
            UriBuilder uriBuilder = this.securePortal.getUriBuilder();
            String appUri = uriBuilder.clone().queryParam("ui_locales", new Object[]{"de en"}).build(new Object[0]).toString();
            URLUtils.navigateToUri((String)appUri);
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
            Map<String, String> parameters = DemoServletsAdapterTest.getQueryFromUrl(this.driver.getCurrentUrl());
            Assert.assertThat((Object)parameters.get("ui_locales"), (Matcher)org.hamcrest.Matchers.allOf((Matcher)org.hamcrest.Matchers.containsString((String)"de"), (Matcher)org.hamcrest.Matchers.containsString((String)"en")));
            String appUriDe = uriBuilder.clone().queryParam("ui_locales", new Object[]{"de"}).build(new Object[0]).toString();
            URLUtils.navigateToUri((String)appUriDe);
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
            this.assertPageContains("Passwort");
            this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
            URLAssert.assertCurrentUrlEquals(portalUri);
            this.assertLogged();
            String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.securePortal.toString()}).build(new Object[]{"demo"}).toString();
            this.driver.navigate().to(logoutUri);
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
            this.securePortal.navigateTo();
            URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        }
        finally {
            demoRealmRep.setInternationalizationEnabled(Boolean.valueOf(enabled));
            demoRealmRep.setDefaultLocale(defaultLocale);
            demoRealmRep.setSupportedLocales(locales);
            this.testRealmResource().update(demoRealmRep);
        }
    }

    @Test
    public void testVerifyTokenAudience() throws Exception {
        String clientScopeId = this.testingClient.testing().generateAudienceClientScope("demo", "customer-db-audience-required");
        ClientResource client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("demo"), (String)"customer-portal");
        client.addOptionalClientScope(clientScopeId);
        this.driver.navigate().to(this.customerPortal.callCustomerDbAudienceRequiredUrl(false).toURL());
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals(this.customerPortal.callCustomerDbAudienceRequiredUrl(false));
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Service returned: 401"));
        Assert.assertFalse((boolean)pageSource.contains("Stian Thorgersen"));
        this.driver.navigate().to(this.customerPortal.logout().toURL());
        WaitUtils.waitForPageToLoad();
        this.driver.navigate().to(this.customerPortal.callCustomerDbAudienceRequiredUrl(true).toURL());
        Assert.assertTrue((boolean)this.testRealmLoginPage.form().isUsernamePresent());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals(this.customerPortal.callCustomerDbAudienceRequiredUrl(false));
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Service returned: 401"));
        this.assertLogged();
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testBasicAuth() throws Exception {
        String value = "hello";
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);
        Response response = client.target(this.basicAuthPage.setTemplateValues(value).buildUri()).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"mposolda", (String)"password")).get();
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.OK));
        Assert.assertEquals((Object)value, (Object)response.readEntity(String.class));
        response.close();
        response = client.target(this.basicAuthPage.setTemplateValues(value).buildUri()).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"invalid-user", (String)"password")).get();
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.UNAUTHORIZED));
        Assert.assertThat((Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.containsString((String)"Unauthorized"), (Matcher)org.hamcrest.Matchers.containsString((String)"Status 401"))));
        response = client.target(this.basicAuthPage.setTemplateValues(value).buildUri()).request().header("Authorization", (Object)BasicAuthHelper.createHeader((String)"admin", (String)"invalid-password")).get();
        Assert.assertThat((Object)response, (Matcher)Matchers.statusCodeIs((Response.Status)Response.Status.UNAUTHORIZED));
        Assert.assertThat((Object)response, (Matcher)Matchers.body((Matcher)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.containsString((String)"Unauthorized"), (Matcher)org.hamcrest.Matchers.containsString((String)"Status 401"))));
        client.close();
    }

    @Test
    public void grantServerBasedApp() {
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)"customer-portal");
        ClientRepresentation client = clientResource.toRepresentation();
        client.setConsentRequired(Boolean.valueOf(true));
        clientResource.update(client);
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("REVOKE_GRANT", "LOGIN"));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        this.testRealmResource().update(realm);
        this.customerPortal.navigateTo();
        this.loginPage.form().login("bburke@redhat.com", "password");
        Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent());
        this.oAuthGrantPage.accept();
        WaitUtils.waitForPageToLoad();
        this.assertLogged();
        String userId = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke@redhat.com").getId();
        this.assertEvents.expectLogin().realm(realm.getId()).client("customer-portal").user(userId).detail("username", "bburke@redhat.com").detail("consent", "consent_granted").detail("redirect_uri", (Matcher<? super String>)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.equalTo((Object)this.customerPortal.getInjectedUrl().toString()), (Matcher)org.hamcrest.Matchers.equalTo((Object)(this.customerPortal.getInjectedUrl().toString() + "/")))).removeDetail("code_id").assertEvent();
        this.assertEvents.expectCodeToToken(null, null).realm(realm.getId()).client("customer-portal").user(userId).session(AssertEvents.isUUID()).removeDetail("code_id").assertEvent();
        this.applicationsPage.navigateTo();
        this.applicationsPage.revokeGrantForApplication("customer-portal");
        this.customerPortal.navigateTo();
        Assert.assertTrue((boolean)this.oAuthGrantPage.isCurrent());
        this.assertEvents.expect(EventType.REVOKE_GRANT).realm(realm.getId()).client("account").user(userId).detail("revoked_client", "customer-portal").assertEvent();
        this.assertEvents.assertEmpty();
        client = clientResource.toRepresentation();
        client.setConsentRequired(Boolean.valueOf(false));
        clientResource.update(client);
    }

    @Test
    public void historyOfAccessResourceTest() throws IOException {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("LOGIN", "LOGIN_ERROR", "LOGOUT", "CODE_TO_TOKEN"));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        this.testRealmResource().update(realm);
        this.customerPortal.navigateTo();
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        WaitUtils.waitForPageToLoad();
        this.assertLogged();
        String userId = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke@redhat.com").getId();
        this.assertEvents.expectLogin().realm(realm.getId()).client("customer-portal").user(userId).detail("username", "bburke@redhat.com").detail("consent", "no_consent_required").detail("redirect_uri", (Matcher<? super String>)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.equalTo((Object)this.customerPortal.getInjectedUrl().toString()), (Matcher)org.hamcrest.Matchers.equalTo((Object)(this.customerPortal.getInjectedUrl().toString() + "/")))).removeDetail("code_id").assertEvent();
        this.assertEvents.expectCodeToToken(null, null).realm(realm.getId()).client("customer-portal").user(userId).session(AssertEvents.isUUID()).removeDetail("code_id").assertEvent();
        this.driver.navigate().to(this.testRealmPage.getOIDCLogoutUrl() + "?redirect_uri=" + this.customerPortal);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.assertEvents.expectLogout(null).realm(realm.getId()).user(userId).session(AssertEvents.isUUID()).detail("redirect_uri", (Matcher<? super String>)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.equalTo((Object)this.customerPortal.getInjectedUrl().toString()), (Matcher)org.hamcrest.Matchers.equalTo((Object)(this.customerPortal.getInjectedUrl().toString() + "/")))).assertEvent();
        this.assertEvents.assertEmpty();
        String serverLogPath = null;
        String appServer = System.getProperty("app.server");
        if (appServer != null && (appServer.equals("wildfly") || appServer.equals("eap6") || appServer.equals("eap"))) {
            serverLogPath = System.getProperty("app.server.home") + "/standalone-test/log/server.log";
        }
        if (serverLogPath != null) {
            this.log.info((Object)("Checking app server log at: " + serverLogPath));
            File serverLog = new File(serverLogPath);
            String serverLogContent = FileUtils.readFileToString((File)serverLog, (String)"UTF-8");
            UserRepresentation bburke = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke@redhat.com");
            Assert.assertThat((Object)serverLogContent, (Matcher)org.hamcrest.Matchers.containsString((String)("User '" + bburke.getId() + "' invoking '" + ServerURLs.getAppServerContextRoot() + "/customer-db/' on client 'customer-db'")));
        } else {
            this.log.info((Object)("Checking app server log on app-server: \"" + System.getProperty("app.server") + "\" is not supported."));
        }
    }

    @Test
    public void testWithoutKeycloakConf() {
        this.customerPortalNoConf.navigateTo();
        String pageSource = this.driver.getPageSource();
        Assert.assertThat((Object)pageSource, (Matcher)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.containsString((String)"Forbidden"), (Matcher)org.hamcrest.Matchers.containsString((String)"forbidden"), (Matcher)org.hamcrest.Matchers.containsString((String)"HTTP Status 401")));
    }

    @Test
    public void testLoginEncodedRedirectUri() {
        this.driver.navigate().to(this.productPortal.getInjectedUrl() + "?encodeTest=a%3Cb");
        System.out.println("Current url: " + this.driver.getCurrentUrl());
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        System.out.println("Current url: " + this.driver.getCurrentUrl());
        URLAssert.assertCurrentUrlEquals(this.productPortal + "?encodeTest=a%3Cb");
        this.assertPageContains("iPhone");
        this.assertPageContains("uriEncodeTest=true");
        this.driver.navigate().to(this.productPortal.getInjectedUrl());
        URLAssert.assertCurrentUrlEquals((AbstractPage)this.productPortal);
        System.out.println(this.driver.getCurrentUrl());
        this.assertPageContains("uriEncodeTest=false");
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.customerPortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.productPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testAutodetectBearerOnly() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)false);
        System.out.println(this.productPortalAutodetectBearerOnly.getInjectedUrl().toString());
        WebTarget target = client.target(this.productPortalAutodetectBearerOnly.getInjectedUrl().toString() + "/");
        Response response = target.request().header("X-Requested-With", (Object)"XMLHttpRequest").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("Faces-Request", (Object)"partial/ajax").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("SOAPAction", (Object)"").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("Accept", (Object)"application/json,text/xml").get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        response = target.request().header("X-Requested-With", (Object)"Dont-Know").header("Accept", (Object)"*/*").get();
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertThat((Object)response.getHeaderString("Location"), (Matcher)org.hamcrest.Matchers.containsString((String)"response_type=code"));
        response.close();
        response = target.request().header("Accept", (Object)"text/html,application/xhtml+xml,application/xml;q=0.9").get();
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertThat((Object)response.getHeaderString("Location"), (Matcher)org.hamcrest.Matchers.containsString((String)"response_type=code"));
        response.close();
        response = target.request().header("Accept", (Object)"*/*").get();
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertThat((Object)response.getHeaderString("Location"), (Matcher)org.hamcrest.Matchers.containsString((String)"response_type=code"));
        response.close();
        client.close();
    }

    @Test
    public void testBasicAuthErrorHandling() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);
        WebTarget target = client.target(this.customerDb.getInjectedUrl().toString());
        Response response = target.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        int LIMIT = 11;
        for (int i = 0; i < 11; ++i) {
            System.out.println("Testing Basic Auth with bad credentials " + i);
            response = target.request().header("Authorization", (Object)"Basic dXNlcm5hbWU6cGFzc3dvcmQ=").get();
            Assert.assertEquals((long)401L, (long)response.getStatus());
            response.close();
        }
        client.close();
    }

    @Test
    public void testNullQueryParameterAccessToken() throws Exception {
        ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);
        WebTarget target = client.target(this.customerDb.getInjectedUrl().toString());
        Response response = target.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        target = client.target(this.customerDb.getInjectedUrl().toString() + "?access_token=");
        response = target.request().get();
        Assert.assertEquals((long)401L, (long)response.getStatus());
        response.close();
        client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestCallWithAccessTokenAsQueryParameter() throws Exception {
        try (ResteasyClient client = AdminClientUtil.createResteasyClient((boolean)true, (Boolean)true);){
            WebTarget webTarget = client.target(this.testRealmPage.toString() + "/protocol/openid-connect/token");
            Form form = new Form();
            form.param("grant_type", "password");
            form.param("client_id", "customer-portal-public");
            form.param("username", "bburke@redhat.com");
            form.param("password", "password");
            Response response = webTarget.request().post(Entity.form((Form)form));
            Assert.assertEquals((long)200L, (long)response.getStatus());
            AccessTokenResponse tokenResponse = (AccessTokenResponse)response.readEntity(AccessTokenResponse.class);
            response.close();
            String accessToken = tokenResponse.getToken();
            response = client.target(this.customerDb.getInjectedUrl().toString()).request().get();
            Assert.assertEquals((long)401L, (long)response.getStatus());
            response.close();
            response = client.target(this.customerDb.getInjectedUrl().toString()).queryParam("access_token", new Object[]{accessToken}).request().get();
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
        }
    }

    @Test
    public void testCallURLWithAccessToken() throws Exception {
        URI applicationURL = this.inputPortalNoAccessToken.getUriBuilder().clone().queryParam("access_token", new Object[]{"invalid_token"}).build(new Object[0]);
        this.driver.navigate().to(applicationURL.toURL());
        Assert.assertEquals((Object)applicationURL.toASCIIString(), (Object)this.driver.getCurrentUrl());
        this.inputPortalNoAccessToken.execute("hello");
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testClientAuthenticatedInClientSecretJwt() {
        String targetClientId = "client-secret-jwt-secure-portal";
        this.expectResultOfClientAuthenticatedInClientSecretJwt(targetClientId, (AbstractPageWithInjectedUrl)this.clientSecretJwtSecurePortal);
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.clientSecretJwtSecurePortal.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
    }

    @Test
    public void testClientNotAuthenticatedInClientSecretJwtBySharedSecretOutOfSync() {
        String targetClientId = "client-secret-jwt-secure-portal";
        String expectedErrorString = "invalid_client_credentials";
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)targetClientId);
        ClientRepresentation client = clientResource.toRepresentation();
        client.setSecret("passwordChanged");
        clientResource.update(client);
        this.expectResultOfClientNotAuthenticatedInClientSecretJwt(targetClientId, expectedErrorString);
    }

    @Test
    public void testClientNotAuthenticatedInClientSecretJwtByAuthnMethodOutOfSync() {
        String targetClientId = "client-secret-jwt-secure-portal";
        String expectedErrorString = "invalid_client_credentials";
        ClientResource clientResource = ApiUtil.findClientResourceByClientId((RealmResource)this.testRealmResource(), (String)targetClientId);
        ClientRepresentation client = clientResource.toRepresentation();
        client.setClientAuthenticatorType("client-secret");
        clientResource.update(client);
        this.expectResultOfClientNotAuthenticatedInClientSecretJwt(targetClientId, expectedErrorString);
    }

    @Test
    public void testClientAuthenticatedInClientSecretJwtValidAlg() {
        String targetClientId = "client-secret-jwt-secure-portal-valid-alg";
        this.expectResultOfClientAuthenticatedInClientSecretJwt(targetClientId, (AbstractPageWithInjectedUrl)this.clientSecretJwtSecurePortalValidAlg);
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).queryParam("redirect_uri", new Object[]{this.clientSecretJwtSecurePortalValidAlg.toString()}).build(new Object[]{"demo"}).toString();
        this.driver.navigate().to(logoutUri);
    }

    @Test
    public void testTokenInCookieSSORoot() {
        String tokenCookie = this.loginToCustomerCookiePortalRoot();
        Cookie cookie = this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE");
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        this.customerPortal.navigateTo();
        this.assertLogged();
        this.customerCookiePortalRoot.navigateTo();
        this.assertLogged();
        cookie = this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE");
        String tokenCookie2 = cookie.getValue();
        Assert.assertEquals((Object)tokenCookie, (Object)tokenCookie2);
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        this.logoutFromCustomerCookiePortalRoot();
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    private String loginToCustomerCookiePortalRoot() {
        this.customerCookiePortalRoot.navigateTo("relative");
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlEquals(this.customerCookiePortalRoot.getInjectedUrl().toString() + "relative");
        this.assertLogged();
        Assert.assertNull((Object)this.driver.manage().getCookieNamed("JSESSIONID"));
        return this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE").getValue();
    }

    private void logoutFromCustomerCookiePortalRoot() {
        String logout = this.customerCookiePortalRoot.logoutURL();
        this.driver.navigate().to(logout);
        WaitUtils.waitUntilElement((By)By.id((String)"customer_portal_logout")).is().present();
        Assert.assertNull((Object)this.driver.manage().getCookieNamed("KEYCLOAK_ADAPTER_STATE"));
        this.customerCookiePortalRoot.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    private void expectResultOfClientAuthenticatedInClientSecretJwt(String targetClientId, AbstractPageWithInjectedUrl portal) {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("LOGIN", "CODE_TO_TOKEN"));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        this.testRealmResource().update(realm);
        portal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        String userId = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke@redhat.com").getId();
        this.assertEvents.expectLogin().realm(realm.getId()).client(targetClientId).user(userId).detail("username", "bburke@redhat.com").detail("consent", "no_consent_required").detail("redirect_uri", (Matcher<? super String>)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.equalTo((Object)portal.getInjectedUrl().toString()), (Matcher)org.hamcrest.Matchers.equalTo((Object)(portal.getInjectedUrl().toString() + "/")))).removeDetail("code_id").assertEvent();
        this.assertEvents.expectCodeToToken(null, null).realm(realm.getId()).client(targetClientId).user(userId).session(AssertEvents.isUUID()).clearDetails().assertEvent();
    }

    private void expectResultOfClientNotAuthenticatedInClientSecretJwt(String targetClientId, String expectedErrorString) {
        RealmRepresentation realm = this.testRealmResource().toRepresentation();
        realm.setEventsEnabled(true);
        realm.setEnabledEventTypes(Arrays.asList("LOGIN", "CODE_TO_TOKEN_ERROR"));
        realm.setEventsListeners(Arrays.asList("jboss-logging", "event-queue"));
        this.testRealmResource().update(realm);
        this.clientSecretJwtSecurePortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPage.form().login("bburke@redhat.com", "password");
        String userId = ApiUtil.findUserByUsername((RealmResource)this.testRealmResource(), (String)"bburke@redhat.com").getId();
        this.assertEvents.expectLogin().realm(realm.getId()).client(targetClientId).user(userId).detail("username", "bburke@redhat.com").detail("consent", "no_consent_required").detail("redirect_uri", (Matcher<? super String>)org.hamcrest.Matchers.anyOf((Matcher)org.hamcrest.Matchers.equalTo((Object)this.clientSecretJwtSecurePortal.getInjectedUrl().toString()), (Matcher)org.hamcrest.Matchers.equalTo((Object)(this.clientSecretJwtSecurePortal.getInjectedUrl().toString() + "/")))).removeDetail("code_id").assertEvent();
        this.assertEvents.expectCodeToToken(null, null).realm(realm.getId()).client(targetClientId).user((String)null).error(expectedErrorString).clearDetails().assertEvent();
    }

    @Test
    public void testLoginHintFromClientRequest() {
        this.driver.navigate().to(this.customerPortal + "?login_hint=blah%3d");
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        Assert.assertThat((Object)this.testRealmLoginPage.form().getUsername(), (Matcher)org.hamcrest.Matchers.is((Object)"blah="));
    }
}

