/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.servlet;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.UriBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Base64Url;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.ActionURIUtils;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.adapter.servlet.ClientInitiatedAccountLinkServlet;
import org.keycloak.testsuite.adapter.servlet.ServletTestUtils;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.broker.BrokerTestTools;
import org.keycloak.testsuite.page.AbstractPageWithInjectedUrl;
import org.keycloak.testsuite.pages.AccountUpdateProfilePage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginUpdateProfilePage;
import org.keycloak.testsuite.util.AdminClientUtil;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.util.JsonSerialization;

@AppServerContainers(value={@AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71")})
public class ClientInitiatedAccountLinkTest
extends AbstractServletsAdapterTest {
    public static final String CHILD_IDP = "child";
    public static final String PARENT_IDP = "parent-idp";
    public static final String PARENT_USERNAME = "parent";
    @Page
    protected LoginUpdateProfilePage loginUpdateProfilePage;
    @Page
    protected AccountUpdateProfilePage profilePage;
    @Page
    private LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;
    @Page
    private ClientApp appPage;
    private String childUserId = null;

    @Override
    public void beforeAuthTest() {
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = new RealmRepresentation();
        realm.setRealm(CHILD_IDP);
        realm.setEnabled(Boolean.valueOf(true));
        ClientRepresentation servlet = new ClientRepresentation();
        servlet.setClientId("client-linking");
        servlet.setProtocol("openid-connect");
        String uri = "/client-linking";
        servlet.setAdminUrl(uri);
        servlet.setDirectAccessGrantsEnabled(Boolean.valueOf(true));
        servlet.setBaseUrl(uri);
        servlet.setRedirectUris(new LinkedList());
        servlet.getRedirectUris().add(uri + "/*");
        servlet.setSecret("password");
        servlet.setFullScopeAllowed(Boolean.valueOf(true));
        realm.setClients(new LinkedList());
        realm.getClients().add(servlet);
        testRealms.add(realm);
        realm = new RealmRepresentation();
        realm.setRealm(PARENT_IDP);
        realm.setEnabled(Boolean.valueOf(true));
        testRealms.add(realm);
    }

    @Deployment(name="client-linking")
    protected static WebArchive accountLink() {
        return ClientInitiatedAccountLinkTest.servletDeployment("client-linking", ClientInitiatedAccountLinkServlet.class, ServletTestUtils.class);
    }

    @Before
    public void addIdpUser() {
        RealmResource realm = this.adminClient.realms().realm(PARENT_IDP);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(PARENT_USERNAME);
        user.setEnabled(Boolean.valueOf(true));
        String userId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user, (String)"password");
    }

    @Before
    public void addChildUser() {
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        UserRepresentation user = new UserRepresentation();
        user.setUsername(CHILD_IDP);
        user.setEnabled(Boolean.valueOf(true));
        this.childUserId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user, (String)"password");
        UserRepresentation user2 = new UserRepresentation();
        user2.setUsername("child2");
        user2.setEnabled(Boolean.valueOf(true));
        String user2Id = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)realm, (UserRepresentation)user2, (String)"password");
        realm.roles().create(new RoleRepresentation("user", null, false));
        RoleRepresentation role = realm.roles().get("user").toRepresentation();
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(role);
        realm.users().get(this.childUserId).roles().realmLevel().add(roles);
        realm.users().get(user2Id).roles().realmLevel().add(roles);
        ClientRepresentation brokerService = (ClientRepresentation)realm.clients().findByClientId("broker").get(0);
        role = realm.clients().get(brokerService.getId()).roles().get("read-token").toRepresentation();
        roles.clear();
        roles.add(role);
        realm.users().get(this.childUserId).roles().clientLevel(brokerService.getId()).add(roles);
        realm.users().get(user2Id).roles().clientLevel(brokerService.getId()).add(roles);
    }

    @Before
    public void createBroker() {
        this.createParentChild();
    }

    public void createParentChild() {
        BrokerTestTools.createKcOidcBroker(this.adminClient, CHILD_IDP, PARENT_IDP);
    }

    @Test
    public void testErrorConditions() throws Exception {
        String helloUrl = this.appPage.getUriBuilder().clone().path("hello").build(new Object[0]).toASCIIString();
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        List links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        ClientRepresentation client = (ClientRepresentation)this.adminClient.realms().realm(CHILD_IDP).clients().findByClientId("client-linking").get(0);
        UriBuilder redirectUri = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("link").queryParam("response", new Object[]{"true"});
        UriBuilder directLinking = UriBuilder.fromUri((String)(ServerURLs.getAuthServerContextRoot() + "/auth")).path("realms/child/broker/{provider}/link").queryParam("client_id", new Object[]{"client-linking"}).queryParam("redirect_uri", new Object[]{redirectUri.build(new Object[0])}).queryParam("hash", new Object[]{Base64Url.encode((byte[])"crap".getBytes())}).queryParam("nonce", new Object[]{UUID.randomUUID().toString()});
        String linkUrl = directLinking.build(new Object[]{PARENT_IDP}).toString();
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("link_error=not_logged_in"));
        this.logoutAll();
        this.navigateTo(helloUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(helloUrl));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Unknown request:"));
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("We are sorry..."));
        this.logoutAll();
        String accountId = ((ClientRepresentation)this.adminClient.realms().realm(CHILD_IDP).clients().findByClientId("account").get(0)).getId();
        RoleRepresentation manageAccount = this.adminClient.realms().realm(CHILD_IDP).clients().get(accountId).roles().get("manage-account").toRepresentation();
        RoleRepresentation manageLinks = this.adminClient.realms().realm(CHILD_IDP).clients().get(accountId).roles().get("manage-account-links").toRepresentation();
        RoleRepresentation userRole = this.adminClient.realms().realm(CHILD_IDP).roles().get("user").toRepresentation();
        client.setFullScopeAllowed(Boolean.valueOf(false));
        ClientResource clientResource = this.adminClient.realms().realm(CHILD_IDP).clients().get(client.getId());
        clientResource.update(client);
        LinkedList<RoleRepresentation> roles = new LinkedList<RoleRepresentation>();
        roles.add(userRole);
        clientResource.getScopeMappings().realmLevel().add(roles);
        this.navigateTo(helloUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(helloUrl));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Unknown request:"));
        UriBuilder linkBuilder = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("link");
        String clientLinkUrl = linkBuilder.clone().queryParam("realm", new Object[]{CHILD_IDP}).queryParam("provider", new Object[]{PARENT_IDP}).build(new Object[0]).toString();
        this.navigateTo(clientLinkUrl);
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("error=not_allowed"));
        this.logoutAll();
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        roles = new LinkedList();
        roles.add(manageLinks);
        clientResource.getScopeMappings().clientLevel(accountId).add(roles);
        this.navigateTo(clientLinkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        this.loginPage.login(PARENT_USERNAME, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(linkBuilder.toTemplate()));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertFalse((boolean)links.isEmpty());
        realm.users().get(this.childUserId).removeFederatedIdentity(PARENT_IDP);
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        clientResource.getScopeMappings().clientLevel(accountId).remove(roles);
        this.logoutAll();
        this.navigateTo(clientLinkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("link_error=not_allowed"));
        this.logoutAll();
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        roles = new LinkedList();
        roles.add(manageAccount);
        clientResource.getScopeMappings().clientLevel(accountId).add(roles);
        this.navigateTo(clientLinkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        this.loginPage.login(PARENT_USERNAME, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(linkBuilder.toTemplate()));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertFalse((boolean)links.isEmpty());
        realm.users().get(this.childUserId).removeFederatedIdentity(PARENT_IDP);
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        clientResource.getScopeMappings().clientLevel(accountId).remove(roles);
        this.logoutAll();
        this.navigateTo(clientLinkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().contains("link_error=not_allowed"));
        this.logoutAll();
        client = (ClientRepresentation)this.adminClient.realms().realm(CHILD_IDP).clients().findByClientId("client-linking").get(0);
        client.setFullScopeAllowed(Boolean.valueOf(true));
        clientResource.update(client);
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        this.logoutAll();
    }

    @Test
    public void testAccountLink() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        List links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        UriBuilder linkBuilder = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("link");
        String linkUrl = linkBuilder.clone().queryParam("realm", new Object[]{CHILD_IDP}).queryParam("provider", new Object[]{PARENT_IDP}).build(new Object[0]).toString();
        System.out.println("linkUrl: " + linkUrl);
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains(PARENT_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        this.loginPage.login(PARENT_USERNAME, "password");
        System.out.println("After linking: " + this.driver.getCurrentUrl());
        System.out.println(this.driver.getPageSource());
        Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(linkBuilder.toTemplate()));
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
        OAuthClient.AccessTokenResponse response = this.oauth.doGrantAccessTokenRequest(CHILD_IDP, CHILD_IDP, "password", null, "client-linking", "password");
        Assert.assertNotNull((Object)response.getAccessToken());
        Assert.assertNull((Object)response.getError());
        ResteasyClient httpClient = AdminClientUtil.createResteasyClient();
        String firstToken = this.getToken(response, (Client)httpClient);
        Assert.assertNotNull((Object)firstToken);
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
        String nextToken = this.getToken(response, (Client)httpClient);
        Assert.assertNotNull((Object)nextToken);
        Assert.assertNotEquals((Object)firstToken, (Object)nextToken);
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertFalse((boolean)links.isEmpty());
        realm.users().get(this.childUserId).removeFederatedIdentity(PARENT_IDP);
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        this.logoutAll();
    }

    private String getToken(OAuthClient.AccessTokenResponse response, Client httpClient) throws Exception {
        String idpToken = (String)httpClient.target(OAuthClient.AUTH_SERVER_ROOT).path("realms").path("child/broker").path(PARENT_IDP).path("token").request().header("Authorization", (Object)("Bearer " + response.getAccessToken())).get(String.class);
        AccessTokenResponse res = (AccessTokenResponse)JsonSerialization.readValue((String)idpToken, AccessTokenResponse.class);
        return res.getToken();
    }

    public void logoutAll() {
        String logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).build(new Object[]{CHILD_IDP}).toString();
        this.navigateTo(logoutUri);
        logoutUri = OIDCLoginProtocolService.logoutUrl((UriBuilder)this.authServerPage.createUriBuilder()).build(new Object[]{PARENT_IDP}).toString();
        this.navigateTo(logoutUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkOnlyProvider() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        IdentityProviderRepresentation rep = realm.identityProviders().get(PARENT_IDP).toRepresentation();
        rep.setLinkOnly(true);
        realm.identityProviders().get(PARENT_IDP).update(rep);
        try {
            List links = realm.users().get(this.childUserId).getFederatedIdentity();
            Assert.assertTrue((boolean)links.isEmpty());
            UriBuilder linkBuilder = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("link");
            String linkUrl = linkBuilder.clone().queryParam("realm", new Object[]{CHILD_IDP}).queryParam("provider", new Object[]{PARENT_IDP}).build(new Object[0]).toString();
            this.navigateTo(linkUrl);
            Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
            Assert.assertFalse((boolean)this.driver.getPageSource().contains(PARENT_IDP));
            this.loginPage.login(CHILD_IDP, "password");
            Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
            this.loginPage.login(PARENT_USERNAME, "password");
            System.out.println("After linking: " + this.driver.getCurrentUrl());
            System.out.println(this.driver.getPageSource());
            Assert.assertTrue((boolean)this.driver.getCurrentUrl().startsWith(linkBuilder.toTemplate()));
            Assert.assertTrue((boolean)this.driver.getPageSource().contains("Account Linked"));
            links = realm.users().get(this.childUserId).getFederatedIdentity();
            Assert.assertFalse((boolean)links.isEmpty());
            realm.users().get(this.childUserId).removeFederatedIdentity(PARENT_IDP);
            links = realm.users().get(this.childUserId).getFederatedIdentity();
            Assert.assertTrue((boolean)links.isEmpty());
            this.logoutAll();
            System.out.println("testing link-only attack");
            this.navigateTo(linkUrl);
            Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
            System.out.println("login page uri is: " + this.driver.getCurrentUrl());
            String pageSource = this.driver.getPageSource();
            String action = ActionURIUtils.getActionURIFromPageSource((String)pageSource);
            System.out.println("action uri: " + action);
            Map queryParams = ActionURIUtils.parseQueryParamsFromActionURI((String)action);
            System.out.println("query params: " + queryParams);
            String uri = "/auth/realms/child/broker/parent-idp/login";
            uri = UriBuilder.fromUri((String)ServerURLs.getAuthServerContextRoot()).path(uri).queryParam("session_code", new Object[]{queryParams.get("session_code")}).queryParam("client_id", new Object[]{queryParams.get("client_id")}).queryParam("tab_id", new Object[]{queryParams.get("tab_id")}).build(new Object[0]).toString();
            System.out.println("hack uri: " + uri);
            this.navigateTo(uri);
            Assert.assertTrue((boolean)this.driver.getPageSource().contains("Could not send authentication request to identity provider."));
        }
        finally {
            rep.setLinkOnly(false);
            realm.identityProviders().get(PARENT_IDP).update(rep);
        }
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void testAccountNotLinkedAutomatically() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        List links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        this.profilePage.open(CHILD_IDP);
        WaitUtils.waitForPageToLoad();
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        this.profilePage.assertCurrent();
        UriBuilder linkBuilder = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("nosuch");
        String linkUrl = linkBuilder.clone().queryParam("prompt", new Object[]{"login"}).build(new Object[0]).toString();
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.clickSocial(PARENT_IDP);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        this.loginPage.login(PARENT_USERNAME, "password");
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        this.loginUpdateProfilePage.assertCurrent();
        this.loginUpdateProfilePage.update("Joe", "Doe", "joe@parent.com");
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"You are already authenticated as different user 'child' in this session. Please sign out first.", (Object)this.errorPage.getError());
        this.logoutAll();
        String newUserId = ApiUtil.findUserByUsername((RealmResource)realm, (String)PARENT_USERNAME).getId();
        this.getCleanup(CHILD_IDP).addUserId(newUserId);
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void testAccountLinkingExpired() throws Exception {
        RealmResource realm = this.adminClient.realms().realm(CHILD_IDP);
        List links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        this.profilePage.open(CHILD_IDP);
        WaitUtils.waitForPageToLoad();
        Assert.assertTrue((boolean)this.loginPage.isCurrent(CHILD_IDP));
        this.loginPage.login(CHILD_IDP, "password");
        this.profilePage.assertCurrent();
        UriBuilder linkBuilder = UriBuilder.fromUri((String)this.appPage.getInjectedUrl().toString()).path("link");
        String linkUrl = linkBuilder.clone().queryParam("realm", new Object[]{CHILD_IDP}).queryParam("provider", new Object[]{PARENT_IDP}).build(new Object[0]).toString();
        this.navigateTo(linkUrl);
        Assert.assertTrue((boolean)this.loginPage.isCurrent(PARENT_IDP));
        realm.logoutAll();
        this.loginPage.login(PARENT_USERNAME, "password");
        links = realm.users().get(this.childUserId).getFederatedIdentity();
        Assert.assertTrue((boolean)links.isEmpty());
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"Requested broker account linking, but current session is no longer valid.", (Object)this.errorPage.getError());
        this.logoutAll();
    }

    private void navigateTo(String uri) {
        this.driver.navigate().to(uri);
        WaitUtils.waitForPageToLoad();
    }

    public static class ClientApp
    extends AbstractPageWithInjectedUrl {
        public static final String DEPLOYMENT_NAME = "client-linking";
        @ArquillianResource
        @OperateOnDeployment(value="client-linking")
        private URL url;

        public URL getInjectedUrl() {
            return this.url;
        }
    }
}

