/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.fuse;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.Hawtio2Page;
import org.keycloak.testsuite.adapter.page.HawtioPage;
import org.keycloak.testsuite.adapter.page.fuse.AdminInterface;
import org.keycloak.testsuite.adapter.page.fuse.CustomerListing;
import org.keycloak.testsuite.adapter.page.fuse.CustomerPortalFuseExample;
import org.keycloak.testsuite.adapter.page.fuse.ProductPortalFuseExample;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.auth.page.AuthRealm;
import org.keycloak.testsuite.auth.page.account.Account;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.auth.page.login.PageWithLoginUrl;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.fuse.FuseUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@AppServerContainers(value={@AppServerContainer(value="app-server-fuse63"), @AppServerContainer(value="app-server-fuse7x")})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class FuseAdapterTest
extends AbstractExampleAdapterTest {
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    @JavascriptBrowser
    private HawtioPage hawtioPage;
    @Page
    @JavascriptBrowser
    private Hawtio2Page hawtio2Page;
    @Page
    @JavascriptBrowser
    private OIDCLogin testRealmLoginPageFuse;
    @Page
    @JavascriptBrowser
    private AuthRealm loginPageFuse;
    @Page
    @JavascriptBrowser
    protected CustomerPortalFuseExample customerPortal;
    @Page
    @JavascriptBrowser
    protected CustomerListing customerListing;
    @Page
    @JavascriptBrowser
    protected AdminInterface adminInterface;
    @Page
    @JavascriptBrowser
    protected ProductPortalFuseExample productPortal;
    @Page
    @JavascriptBrowser
    protected Account testRealmAccount;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation fuseRealm = IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/fuse/demorealm.json"));
        testRealms.add(fuseRealm);
    }

    @Override
    public void setDefaultPageUriParameters() {
        super.setDefaultPageUriParameters();
        this.testRealmLoginPageFuse.setAuthRealm("demo");
        this.testRealmPage.setAuthRealm("demo");
        this.testRealmLoginPage.setAuthRealm("demo");
        this.testRealmAccount.setAuthRealm("demo");
        this.loginPageFuse.setAuthRealm("demo");
    }

    @Before
    public void addJsDriver() {
        DroneUtils.addWebDriver((WebDriver)this.jsDriver);
    }

    @Override
    public boolean isImportAfterEachMethod() {
        return false;
    }

    @Test
    @AppServerContainer(value="app-server-fuse7x", skip=true)
    public void hawtio1LoginTest() throws Exception {
        this.hawtioPage.navigateTo();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPageFuse);
        this.testRealmLoginPageFuse.form().login("user", "invalid-password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPageFuse);
        this.testRealmLoginPageFuse.form().login("invalid-user", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPageFuse);
        this.testRealmLoginPageFuse.form().login("root", "password");
        URLAssert.assertCurrentUrlStartsWith(this.hawtioPage.toString() + "/welcome");
        this.hawtioPage.logout(this.jsDriver);
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmLoginPageFuse);
        this.hawtioPage.navigateTo();
        this.log.debug((Object)"logging in as mary");
        this.testRealmLoginPageFuse.form().login("mary", "password");
        this.log.debug((Object)"Previous WARN waitForPageToLoad time exceeded! is expected");
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getCurrentUrl(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"welcome")));
    }

    @Test
    @AppServerContainer(value="app-server-fuse63", skip=true)
    public void hawtio2LoginTest() throws Exception {
        Assume.assumeTrue((String)"This test doesn't work with phantomjs", (!"phantomjs".equals(System.getProperty("js.browser")) ? 1 : 0) != 0);
        this.hawtio2Page.navigateTo();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPageFuse);
        this.testRealmLoginPageFuse.form().login("user", "invalid-password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPageFuse);
        this.testRealmLoginPageFuse.form().login("invalid-user", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.loginPageFuse);
        this.log.debug((Object)"logging in as root");
        this.testRealmLoginPageFuse.form().login("root", "password");
        URLAssert.assertCurrentUrlStartsWith(this.hawtio2Page.toString());
        this.assertHawtio2Page("camel", true);
        this.assertHawtio2Page("jmx", true);
        this.assertHawtio2Page("osgi", true);
        this.assertHawtio2Page("logs", true);
        this.hawtio2Page.logout();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmLoginPageFuse);
        this.hawtio2Page.navigateTo();
        WaitUtils.waitForPageToLoad();
        this.log.debug((Object)"logging in as mary");
        this.testRealmLoginPageFuse.form().login("mary", "password");
        this.log.debug((Object)("Current URL: " + DroneUtils.getCurrentDriver().getCurrentUrl()));
        URLAssert.assertCurrentUrlStartsWith(this.hawtio2Page.toString());
        this.assertHawtio2Page("camel", false);
        this.assertHawtio2Page("jmx", false);
        this.assertHawtio2Page("osgi", false);
        this.assertHawtio2Page("logs", false);
    }

    private void assertHawtio2Page(String urlFragment, boolean expectedSuccess) {
        DroneUtils.getCurrentDriver().navigate().to(this.hawtio2Page.getUrl() + "/" + urlFragment);
        WaitUtils.waitForPageToLoad();
        WaitUtils.waitUntilElement((By)By.xpath((String)"//img[@alt='Red Hat Fuse Management Console'] | //img[@ng-src='img/fuse-logo.svg']")).is().present();
        if (expectedSuccess) {
            URLAssert.assertCurrentUrlStartsWith(this.hawtio2Page.getUrl() + "/" + urlFragment);
        } else {
            URLAssert.assertCurrentUrlStartsWith(this.hawtio2Page.getUrl() + "/jvm");
        }
    }

    @Test
    @AppServerContainer(value="app-server-fuse7x", skip=true)
    public void sshLoginTestFuse6() throws Exception {
        FuseUtils.assertCommand((String)"mary", (String)"password", (String)"shell:date", (FuseUtils.Result)FuseUtils.Result.NO_CREDENTIALS);
        FuseUtils.assertCommand((String)"john", (String)"password", (String)"shell:info", (FuseUtils.Result)FuseUtils.Result.NO_CREDENTIALS);
        FuseUtils.assertCommand((String)"john", (String)"password", (String)"shell:date", (FuseUtils.Result)FuseUtils.Result.OK);
        FuseUtils.assertCommand((String)"root", (String)"password", (String)"shell:info", (FuseUtils.Result)FuseUtils.Result.OK);
    }

    @Test
    @AppServerContainer(value="app-server-fuse63", skip=true)
    public void sshLoginTestFuse7() throws Exception {
        FuseUtils.assertCommand((String)"mary", (String)"password", (String)"shell:date", (FuseUtils.Result)FuseUtils.Result.NOT_FOUND);
        FuseUtils.assertCommand((String)"john", (String)"password", (String)"shell:info", (FuseUtils.Result)FuseUtils.Result.OK);
        FuseUtils.assertCommand((String)"john", (String)"password", (String)"shell:date", (FuseUtils.Result)FuseUtils.Result.OK);
        this.assertRoles("root", "ssh", "jmxAdmin", "admin", "manager", "viewer", "Administrator", "Auditor", "Deployer", "Maintainer", "Operator", "SuperUser");
    }

    private void assertRoles(String username, String ... expectedRoles) throws Exception {
        String commandOutput = FuseUtils.getCommandOutput((String)username, (String)"password", (String)"jaas:whoami -r --no-format");
        List<String> parsedOutput = Arrays.asList(commandOutput.split("\\n+"));
        Assert.assertThat(parsedOutput, (Matcher)Matchers.containsInAnyOrder((Object[])expectedRoles));
    }

    @Test
    public void jmxLoginTest() throws Exception {
        MBeanServerConnection connection2;
        Throwable throwable;
        JMXConnector jmxConnector;
        ObjectName mbean = new ObjectName("org.apache.karaf:type=config,name=root");
        this.log.debug((Object)"jmxLoginTest - testing: invalid credentials");
        try {
            jmxConnector = this.getJMXConnector(10L, TimeUnit.SECONDS, "mary", "password1");
            throwable = null;
            try {
                jmxConnector.getMBeanServerConnection();
                Assert.fail();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jmxConnector != null) {
                    if (throwable != null) {
                        try {
                            jmxConnector.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        jmxConnector.close();
                    }
                }
            }
        }
        catch (TimeoutException expected) {
            Assert.assertThat((Object)expected.getCause().toString(), (Matcher)Matchers.containsString((String)"java.lang.SecurityException: Authentication failed"));
        }
        this.log.debug((Object)"jmxLoginTest - testing: no role");
        jmxConnector = this.getJMXConnector("mary", "password");
        throwable = null;
        try {
            connection2 = jmxConnector.getMBeanServerConnection();
            this.assertJmxInvoke(false, connection2, mbean, "listProperties", new Object[]{""}, new String[]{String.class.getName()});
            this.assertJmxInvoke(false, connection2, mbean, "setProperty", new Object[]{"", "x", "y"}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Throwable connection2) {
            throwable = connection2;
            throw connection2;
        }
        finally {
            if (jmxConnector != null) {
                if (throwable != null) {
                    try {
                        jmxConnector.close();
                    }
                    catch (Throwable connection2) {
                        throwable.addSuppressed(connection2);
                    }
                } else {
                    jmxConnector.close();
                }
            }
        }
        this.log.debug((Object)"jmxLoginTest - testing: read only role");
        jmxConnector = this.getJMXConnector("john", "password");
        throwable = null;
        try {
            connection2 = jmxConnector.getMBeanServerConnection();
            this.assertJmxInvoke(true, connection2, mbean, "listProperties", new Object[]{""}, new String[]{String.class.getName()});
            this.assertJmxInvoke(false, connection2, mbean, "setProperty", new Object[]{"", "x", "y"}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Throwable connection3) {
            throwable = connection3;
            throw connection3;
        }
        finally {
            if (jmxConnector != null) {
                if (throwable != null) {
                    try {
                        jmxConnector.close();
                    }
                    catch (Throwable connection3) {
                        throwable.addSuppressed(connection3);
                    }
                } else {
                    jmxConnector.close();
                }
            }
        }
        this.log.debug((Object)"jmxLoginTest - testing: read write role");
        jmxConnector = this.getJMXConnector("root", "password");
        throwable = null;
        try {
            connection2 = jmxConnector.getMBeanServerConnection();
            this.assertJmxInvoke(true, connection2, mbean, "listProperties", new Object[]{""}, new String[]{String.class.getName()});
            this.assertJmxInvoke(true, connection2, mbean, "setProperty", new Object[]{"", "x", "y"}, new String[]{String.class.getName(), String.class.getName(), String.class.getName()});
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (jmxConnector != null) {
                if (throwable != null) {
                    try {
                        jmxConnector.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    jmxConnector.close();
                }
            }
        }
    }

    private Object assertJmxInvoke(boolean expectSuccess, MBeanServerConnection connection, ObjectName mbean, String method, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            Object result = connection.invoke(mbean, method, params, signature);
            Assert.assertTrue((boolean)expectSuccess);
            return result;
        }
        catch (SecurityException se) {
            Assert.assertTrue((!expectSuccess ? 1 : 0) != 0);
            return null;
        }
    }

    private JMXConnector getJMXConnector(String username, String password) throws Exception {
        return this.getJMXConnector(2L, TimeUnit.MINUTES, username, password);
    }

    private JMXConnector getJMXConnector(long timeout, TimeUnit unit, String username, String password) throws Exception {
        Exception lastException = null;
        long timeoutMillis = System.currentTimeMillis() + unit.toMillis(timeout);
        while (System.currentTimeMillis() < timeoutMillis) {
            try {
                Map<String, String[]> env = Collections.singletonMap("jmx.remote.credentials", new String[]{username, password});
                return JMXConnectorFactory.connect(new JMXServiceURL(this.getJmxServiceUrl()), env);
            }
            catch (Exception ex) {
                lastException = ex;
                Thread.sleep(500L);
                this.log.debug((Object)("Loop: Getting MBean Server Connection: last caught exception: " + lastException.getClass().getName()));
            }
        }
        this.log.error((Object)("Failed to get MBean Server Connection within " + timeout + " " + unit.toString()));
        TimeoutException timeoutException = new TimeoutException();
        timeoutException.initCause(lastException);
        throw timeoutException;
    }

    private String getJmxServiceUrl() throws Exception {
        return "service:jmx:rmi://localhost:44444/jndi/rmi://localhost:1099/karaf-root";
    }

    @Test
    public void testCustomerListingAndAccountManagement() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortal);
        this.customerPortal.clickCustomerListingLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPageFuse.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerListing);
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getPageSource(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Username: bburke@redhat.com"), (Matcher)Matchers.containsString((String)"Bill Burke"), (Matcher)Matchers.containsString((String)"Stian Thorgersen")));
        this.customerListing.clickAccountManagement();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmAccount);
        Assert.assertThat((Object)this.testRealmAccount.getUsername(), (Matcher)Matchers.equalTo((Object)"bburke@redhat.com"));
        DroneUtils.getCurrentDriver().navigate().back();
        this.customerListing.clickLogOut();
        this.customerPortal.clickCustomerListingLink();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }

    @Test
    public void testAdminInterface() {
        this.customerPortal.navigateTo();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.customerPortal);
        this.customerPortal.clickAdminInterfaceLink();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPageFuse.form().login("admin", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.adminInterface);
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getPageSource(), (Matcher)Matchers.containsString((String)"Hello admin!"));
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getPageSource(), (Matcher)Matchers.containsString((String)"This second sentence is returned from a Camel RestDSL endpoint"));
        this.customerListing.navigateTo();
        WaitUtils.waitForPageToLoad();
        this.customerListing.clickLogOut();
        WaitUtils.waitForPageToLoad();
        WaitUtils.pause((long)2500L);
        this.customerPortal.navigateTo();
        WaitUtils.waitForPageToLoad();
        this.customerPortal.clickAdminInterfaceLink();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPageFuse.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.adminInterface);
        Assert.assertThat((Object)DroneUtils.getCurrentDriver().getPageSource(), (Matcher)Matchers.containsString((String)"Status code is 403"));
    }

    @Test
    @AppServerContainer(value="app-server-fuse63", skip=true)
    public void testProductPortal() {
        this.productPortal.navigateTo();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
        this.testRealmLoginPageFuse.form().login("bburke@redhat.com", "password");
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.productPortal);
        Assert.assertThat((Object)this.productPortal.getProduct1UnsecuredText(), (Matcher)Matchers.containsString((String)"401: Unauthorized"));
        Assert.assertThat((Object)this.productPortal.getProduct1SecuredText(), (Matcher)Matchers.containsString((String)"Product received: id=1"));
        Assert.assertThat((Object)this.productPortal.getProduct2SecuredText(), (Matcher)Matchers.containsString((String)"Product received: id=2"));
        this.productPortal.clickLogOutLink();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWithLoginUrlOf((PageWithLoginUrl)this.testRealmPage);
    }
}

