/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.fuse;

import java.io.IOException;
import java.util.List;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.adapter.page.HawtioPage;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.containers.SelfManagedAppContainerLifecycle;
import org.keycloak.testsuite.auth.page.login.OIDCLogin;
import org.keycloak.testsuite.page.AbstractPage;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.DroneUtils;
import org.keycloak.testsuite.util.JavascriptBrowser;
import org.keycloak.testsuite.util.URLAssert;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.WebDriver;

@AppServerContainer(value="app-server-eap6")
public class EAP6Fuse6HawtioAdapterTest
extends AbstractExampleAdapterTest
implements SelfManagedAppContainerLifecycle {
    @ArquillianResource
    private ContainerController controller;
    @Drone
    @JavascriptBrowser
    protected WebDriver jsDriver;
    @Page
    @JavascriptBrowser
    private HawtioPage hawtioPage;
    @Page
    @JavascriptBrowser
    private OIDCLogin testRealmLoginPageFuse;

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((String)"/adapter-test/hawtio-realm/demorealm.json"));
    }

    @BeforeClass
    public static void enabled() {
        Assume.assumeFalse((boolean)System.getProperty("os.name").startsWith("Windows"));
        ContainerAssume.assumeNotAppServerSSL();
        ContainerAssume.assumeAuthServerSSL();
    }

    @Before
    public void addJSDriver() {
        DroneUtils.addWebDriver((WebDriver)this.jsDriver);
    }

    @Before
    public void startServer() {
        try {
            AppServerTestEnricher.prepareServerDir((String)"standalone-fuse");
        }
        catch (IOException ex) {
            throw new RuntimeException("Wasn't able to prepare server dir.", ex);
        }
        this.controller.start(this.testContext.getAppServerInfo().getQualifier());
    }

    @After
    public void stopServer() {
        this.controller.stop(this.testContext.getAppServerInfo().getQualifier());
    }

    @Test
    public void hawtioLoginAndLogoutTest() {
        this.testRealmLoginPageFuse.setAuthRealm("demo");
        this.log.debug((Object)"Go to hawtioPage");
        this.hawtioPage.navigateTo();
        WaitUtils.waitForPageToLoad();
        this.log.debug((Object)"log in");
        URLAssert.waitUntilUrlStartsWith(this.testRealmLoginPageFuse.toString(), 60);
        this.testRealmLoginPageFuse.form().login("root", "password");
        URLAssert.waitUntilUrlStartsWith(this.hawtioPage.toString() + "/welcome", 180);
        this.hawtioPage.logout(this.jsDriver);
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmLoginPageFuse);
        this.hawtioPage.navigateTo();
        WaitUtils.waitForPageToLoad();
        URLAssert.assertCurrentUrlStartsWith((AbstractPage)this.testRealmLoginPageFuse);
    }
}

