/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.keycloak.testsuite.adapter.example.authorization.AbstractBaseServletAuthzAdapterTest;
import org.keycloak.testsuite.arquillian.AppServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-undertow"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-tomcat7"), @AppServerContainer(value="app-server-tomcat8"), @AppServerContainer(value="app-server-tomcat9")})
public class PermissiveModeAdapterTest
extends AbstractBaseServletAuthzAdapterTest {
    @Deployment(name="servlet-authz-app", managed=false)
    public static WebArchive deployment() throws IOException {
        return (WebArchive)PermissiveModeAdapterTest.exampleDeployment("servlet-authz-app").addAsWebInfResource(new File(TEST_APPS_HOME_DIR + "/servlet-authz-app/servlet-authz-realm.json"), "keycloak-permissive-authz-service.json");
    }

    @Test
    public void testCanAccessWhenPermissive() throws Exception {
        this.performTests(() -> {
            this.login("jdoe", "jdoe");
            this.driver.navigate().to(this.getResourceServerUrl() + "/enforcing/resource");
            if (AppServerTestEnricher.isEAP6AppServer() || AppServerTestEnricher.isTomcatAppServer()) {
                MatcherAssert.assertThat((Object)this.driver.getPageSource(), (Matcher)Matchers.containsString((String)"HTTP Status 404"));
            } else {
                MatcherAssert.assertThat((Object)this.driver.getTitle(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Error")));
                MatcherAssert.assertThat((Object)this.driver.getPageSource(), (Matcher)Matchers.containsString((String)"Not Found"));
            }
            this.driver.navigate().to(this.getResourceServerUrl() + "/protected/admin");
            this.assertWasDenied();
        });
    }
}

