/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.adapter.example.authorization.AbstractPhotozExampleAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainer;
import org.keycloak.testsuite.arquillian.annotation.AppServerContainers;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.keycloak.util.JsonSerialization;

@AppServerContainers(value={@AppServerContainer(value="app-server-wildfly"), @AppServerContainer(value="app-server-wildfly-deprecated"), @AppServerContainer(value="app-server-eap"), @AppServerContainer(value="app-server-eap6"), @AppServerContainer(value="app-server-eap71"), @AppServerContainer(value="app-server-undertow")})
public class LifespanAdapterTest
extends AbstractPhotozExampleAdapterTest {
    @Deployment(name="photoz-html5-client")
    public static WebArchive deploymentClient() throws IOException {
        return LifespanAdapterTest.exampleDeployment("photoz-html5-client");
    }

    @Deployment(name="photoz-restful-api", managed=false, testable=false)
    public static WebArchive deploymentResourceServer() throws IOException {
        return LifespanAdapterTest.exampleDeployment("photoz-restful-api", (WebArchive webArchive) -> {
            WebArchive cfr_ignored_0 = (WebArchive)webArchive.addAsWebInfResource(new File(TEST_APPS_HOME_DIR + "/photoz/keycloak-cache-lifespan-authz-service.json"), "keycloak.json");
        });
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        RealmRepresentation realm = IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/photoz/photoz-realm.json"));
        realm.setAccessTokenLifespan(Integer.valueOf(70));
        testRealms.add(realm);
    }

    @Override
    @Test
    public void testPathConfigInvalidation() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertSuccess();
        ResourceRepresentation resource = (ResourceRepresentation)this.getAuthorizationResource().resources().findByName("Profile Resource").get(0);
        AuthorizationResource authorizationResource = this.getAuthorizationResource();
        authorizationResource.resources().resource(resource.getId()).remove();
        MatcherAssert.assertThat((Object)this.getAuthorizationResource().resources().findByName("Profile Resource").isEmpty(), (Matcher)Matchers.is((Object)true));
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertFailure();
        this.setTimeOffsetOfAdapter(40);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertSuccess();
        this.setTimeOffsetOfAdapter(0);
        try (Response response = authorizationResource.resources().create(resource);){
            resource = (ResourceRepresentation)response.readEntity(ResourceRepresentation.class);
        }
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertSuccess();
        RealmResource realm = this.realmsResouce().realm("photoz");
        UserRepresentation userRepresentation = (UserRepresentation)realm.users().search(this.aliceUser.getUsername()).get(0);
        UserResource userResource = realm.users().get(userRepresentation.getId());
        userRepresentation.setEmail("alice@anotherdomain.org");
        userResource.update(userRepresentation);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertTicket();
        try {
            PolicyRepresentation resourceInstancePermission = new PolicyRepresentation();
            resourceInstancePermission.setName("View User Permission");
            resourceInstancePermission.setType("resource");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("resources", JsonSerialization.writeValueAsString(Collections.singletonList(resource.getId())));
            config.put("applyPolicies", JsonSerialization.writeValueAsString(Collections.singletonList("Only From @keycloak.org or Admin")));
            resourceInstancePermission.setConfig(config);
            authorizationResource.policies().create(resourceInstancePermission);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating policy.", e);
        }
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertFailure();
        userRepresentation.setEmail("alice@keycloak.org");
        userResource.update(userRepresentation);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.assertSuccess();
    }

    private void assertSuccess() {
        this.assertState(true);
    }

    private void assertFailure() {
        this.assertState(false);
    }

    private void assertState(boolean state) {
        this.clientPage.viewProfile((ResponseValidator & Serializable)response -> {
            Object res = response.get("res");
            MatcherAssert.assertThat(res, (Matcher)Matchers.notNullValue());
            Matcher matcher = Matchers.containsString((String)"userName");
            MatcherAssert.assertThat((Object)res.toString(), (Matcher)(state ? matcher : Matchers.not((Matcher)matcher)));
        });
    }

    private void assertTicket() {
        this.clientPage.viewProfile((ResponseValidator & Serializable)response -> {
            Object headers = response.get("responseHeaders");
            MatcherAssert.assertThat(headers, (Matcher)Matchers.notNullValue());
            List<String> headersList = Arrays.asList(headers.toString().split("\r\n"));
            String wwwAuthenticate = headersList.stream().filter(s -> s.toLowerCase().startsWith("www-authenticate:")).findFirst().orElse(null);
            MatcherAssert.assertThat((Object)wwwAuthenticate, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)wwwAuthenticate, (Matcher)Matchers.containsString((String)"UMA"));
        });
    }

    public void setTimeOffsetOfAdapter(int offset) {
        this.driver.navigate().to(this.clientPage.getInjectedUrl() + "timeOffset.jsp?offset=" + offset);
    }
}

