/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.ResourcePermissionsResource;
import org.keycloak.common.Profile;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.authorization.ResourcePermissionRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.testsuite.ProfileAssume;
import org.keycloak.testsuite.adapter.AbstractExampleAdapterTest;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.UIUtils;
import org.keycloak.testsuite.util.WaitUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class AbstractServletPolicyEnforcerTest
extends AbstractExampleAdapterTest {
    protected static final String REALM_NAME = "servlet-policy-enforcer-authz";
    protected static final String RESOURCE_SERVER_ID = "servlet-policy-enforcer";
    @ArquillianResource
    private Deployer deployer;

    @BeforeClass
    public static void enabled() {
        ProfileAssume.assumeFeatureEnabled((Profile.Feature)Profile.Feature.AUTHORIZATION);
    }

    @Override
    public void addAdapterTestRealms(List<RealmRepresentation> testRealms) {
        testRealms.add(IOUtil.loadRealm((File)new File(TEST_APPS_HOME_DIR + "/servlet-policy-enforcer/servlet-policy-enforcer-authz-realm.json")));
    }

    @Test
    public void testPattern1() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/resource/a/b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 1 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/a/b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 1 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/a/b");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern2() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/a/resource-a");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/b/resource-a");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 2 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/a/resource-a");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/b/resource-a");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 2 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/b/resource-a");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern3() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/a/resource-b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/b/resource-b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 3 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/a/resource-b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/b/resource-b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 3 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/b/resource-b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 2 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/b/resource-a");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 3 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/a/resource-b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/b/resource-a");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern4() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/resource-c");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 4 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource-c");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 4 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource-c");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern5() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/a/a/resource-d");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/resource/b/resource-d");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 5 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/a/a/resource-d");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/a/b/resource-d");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 5 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/a/b/resource-d");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern6() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/resource/a");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/resource/b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 6 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/a");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/resource/b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 6 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/b");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern7() throws Exception {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/resource/a/f/b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/resource/c/f/d");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 7 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/a/f/b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/resource/c/f/d");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 7 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/c/f/d");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern8() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/resource");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 8 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 8 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern9() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/file/*.suffix");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 9 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/file/*.suffix");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 9 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/file/*.suffix");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern10() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/resource/a/i/b/c/d/e");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/resource/a/i/b/c/");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 10 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/a/i/b/c/d/e");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/resource/a/i/b/c/d");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 10 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/resource/a/i/b/c/d");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPattern11UsingResourceInstancePermission() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/api/v1/resource-a");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/api/v1/resource-b");
            Assert.assertFalse((boolean)this.wasDenied());
            ResourceRepresentation resource = new ResourceRepresentation("/api/v1/resource-c", new String[0]);
            resource.setUri(resource.getName());
            this.getAuthorizationResource().resources().create(resource);
            this.createResourcePermission(resource.getName() + " permission", resource.getName(), "Default Policy");
            this.login("alice", "alice");
            this.navigateTo(resource.getUri());
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies(resource.getName() + " permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo(resource.getUri());
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies(resource.getName() + " permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo(resource.getUri());
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/api/v1");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/api/v1/");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/api");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/api/");
            Assert.assertTrue((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPathWithPatternSlashAllAndResourceInstance() {
        this.performTests(() -> {
            ResourceRepresentation resource = new ResourceRepresentation("Pattern 15 Instance", new String[0]);
            resource.setType("pattern-15");
            resource.setUri("/keycloak-7148/1");
            resource.setOwner("alice");
            this.getAuthorizationResource().resources().create(resource).close();
            this.login("alice", "alice");
            this.navigateTo("/keycloak-7148/1");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/1/sub-a/2");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/1/sub-a");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/1/sub-a/2/sub-b");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 15 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-7148/1");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/1/sub-a/2");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/1/sub-a");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/1/sub-a/2/sub-b");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7148/2");
            Assert.assertTrue((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPriorityOfURIForResource() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/realm_uri");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak_json_uri");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 12 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/realm_uri");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak_json_uri");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 12 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/realm_uri");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak_json_uri");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testPathOrderWithAllPaths() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/keycloak-6623");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-6623/sub-resource");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 13 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-6623");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-6623/sub-resource");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 14 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-6623");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-6623/sub-resource/resource");
            Assert.assertTrue((boolean)this.wasDenied());
        });
    }

    @Test
    public void testMultipleUriForResourceJSONConfig() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/keycloak-7269/sub-resource1");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource1/whatever/specialSuffix");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource2");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource2/w/h/a/t/e/v/e/r");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 16 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-7269/sub-resource1");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource1/whatever/specialSuffix");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource2");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource2/w/h/a/t/e/v/e/r");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 16 Permission", "Default Policy");
            this.navigateTo("/keycloak-7269/sub-resource1");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource1/whatever/specialSuffix");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource2");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-7269/sub-resource2/w/h/a/t/e/v/e/r");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    @Test
    public void testOverloadedTemplateUri() {
        this.performTests(() -> {
            this.login("alice", "alice");
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/entities");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/someother");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 17 Entities Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/entities");
            Assert.assertTrue((boolean)this.wasDenied());
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/someother");
            Assert.assertFalse((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 17 Entities Permission", "Default Policy");
            this.updatePermissionPolicies("Pattern 17 Permission", "Deny Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/entities");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/someother");
            Assert.assertTrue((boolean)this.wasDenied());
            this.updatePermissionPolicies("Pattern 17 Entities Permission", "Default Policy");
            this.updatePermissionPolicies("Pattern 17 Permission", "Default Policy");
            this.login("alice", "alice");
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/entities");
            Assert.assertFalse((boolean)this.wasDenied());
            this.navigateTo("/keycloak-8823/resource/v1/subresource/123/someother");
            Assert.assertFalse((boolean)this.wasDenied());
        });
    }

    private void navigateTo(String path) {
        this.driver.navigate().to(this.getResourceServerUrl() + path);
    }

    private void performTests(ExceptionRunnable assertion) {
        this.performTests(() -> {}, assertion);
    }

    private void performTests(ExceptionRunnable beforeDeploy, ExceptionRunnable assertion) {
        try {
            beforeDeploy.run();
            this.deployer.deploy(RESOURCE_SERVER_ID);
            assertion.run();
        }
        catch (FileNotFoundException cause) {
            throw new RuntimeException("Failed to import authorization settings", cause);
        }
        catch (Exception cause) {
            throw new RuntimeException("Error while executing tests", cause);
        }
        finally {
            this.deployer.undeploy(RESOURCE_SERVER_ID);
        }
    }

    private AuthorizationResource getAuthorizationResource() {
        return this.getClientResource(RESOURCE_SERVER_ID).authorization();
    }

    private ClientResource getClientResource(String clientId) {
        ClientsResource clients = this.realmsResouce().realm(REALM_NAME).clients();
        ClientRepresentation resourceServer = (ClientRepresentation)clients.findByClientId(clientId).get(0);
        return clients.get(resourceServer.getId());
    }

    private void logOut() {
        this.navigateTo();
        UIUtils.clickLink((WebElement)this.driver.findElement(By.xpath((String)"//a[text() = 'Sign Out']")));
    }

    private void login(String username, String password) {
        try {
            this.navigateTo();
            if (this.driver.getCurrentUrl().startsWith(this.getResourceServerUrl().toString())) {
                this.logOut();
                this.navigateTo();
            }
            this.loginPage.form().login(username, password);
            this.navigateTo();
            Assert.assertFalse((boolean)this.wasDenied());
        }
        catch (Exception cause) {
            throw new RuntimeException("Login failed", cause);
        }
    }

    private void navigateTo() {
        this.driver.navigate().to(this.getResourceServerUrl() + "/");
        WaitUtils.waitForPageToLoad();
    }

    private boolean wasDenied() {
        return this.driver.getPageSource().contains("You can not access this resource");
    }

    private URL getResourceServerUrl() {
        try {
            return new URL(ServerURLs.getAppServerContextRoot() + "/" + RESOURCE_SERVER_ID);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Could not obtain resource server url.", e);
        }
    }

    private void updatePermissionPolicies(String permissionName, String ... policyNames) {
        ResourcePermissionsResource permissions = this.getAuthorizationResource().permissions().resource();
        ResourcePermissionRepresentation permission = permissions.findByName(permissionName);
        permission.addPolicy(policyNames);
        permissions.findById(permission.getId()).update(permission);
    }

    private void createResourcePermission(String name, String resourceName, String ... policyNames) {
        ResourcePermissionRepresentation permission = new ResourcePermissionRepresentation();
        permission.setName(name);
        permission.addResource(resourceName);
        permission.addPolicy(policyNames);
        this.getAuthorizationResource().permissions().resource().create(permission);
    }

    private static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

