/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter.example.authorization;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.PoliciesResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.ResourcesResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.testsuite.adapter.example.authorization.AbstractBasePhotozExampleAdapterTest;
import org.keycloak.testsuite.arquillian.annotation.UncaughtServerErrorExpected;
import org.keycloak.testsuite.util.javascript.JavascriptStateValidator;
import org.keycloak.testsuite.util.javascript.ResponseValidator;
import org.keycloak.util.JsonSerialization;

public abstract class AbstractPhotozExampleAdapterTest
extends AbstractBasePhotozExampleAdapterTest {
    @Test
    public void testUserCanCreateAndDeleteAlbum() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.log.debug((Object)"Check if alice has resources stored");
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.log.debug((Object)"Check if alice has resources deleted");
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @UncaughtServerErrorExpected
    public void createAlbumWithInvalidUser() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbumWithInvalidUser("Alice-Family-Album", (ResponseValidator & Serializable)response -> {
            MatcherAssert.assertThat(response.get("status"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)500L)));
            MatcherAssert.assertThat(response.get("res"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"Could not register protected resource.")));
        });
    }

    @Test
    public void testPathConfigInvalidation() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.log.debug((Object)"Check if alice has resources stored");
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        this.log.debug((Object)"Adding applyPolicies \"Only Owner Policy\" to \"Delete Album Permission\" policies.");
        for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
            if (!"Delete Album Permission".equals(policy.getName())) continue;
            policy.getConfig().put("applyPolicies", "[\"Only Owner Policy\"]");
            this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        this.log.debug((Object)"Check if alice has resources stored");
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        this.log.debug((Object)"Adding applyPolicies \"Only Owner and Administrators Policy\" to \"Delete Album Permission\" policies.");
        for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
            if (!"Delete Album Permission".equals(policy.getName())) continue;
            policy.getConfig().put("applyPolicies", "[\"Only Owner and Administrators Policy\"]");
            this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.log.debug((Object)"Check if alice has resources deleted");
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testRegularUserCanNotAccessAdminResources() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasDenied);
    }

    @Test
    public void testAdminOnlyFromSpecificAddress() throws Exception {
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.log.debug((Object)"Changing codes \"127.0.0.1\" to \"127.3.3.3\" of \"Only From a Specific Client Address\" policies.");
        for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
            if (!"Only From a Specific Client Address".equals(policy.getName())) continue;
            String code = ((String)policy.getConfig().get("code")).replaceAll("127.0.0.1", "127.3.3.3").replaceAll("0:0:0:0:0:0:0:1", "0:0:0:0:0:ffff:7f03:303");
            policy.getConfig().put("code", code);
            this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasDenied);
    }

    @Test
    public void testAdminWithoutPermissionsToTypedResource() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        PoliciesResource policiesResource = this.getAuthorizationResource().policies();
        List policies = policiesResource.policies();
        for (PolicyRepresentation policy : policies) {
            if ("Album Resource Permission".equals(policy.getName())) {
                policy.getConfig().put("applyPolicies", "[\"Any User Policy\"]");
                policiesResource.policy(policy.getId()).update(policy);
            }
            if (!"Any User Policy".equals(policy.getName())) continue;
            ClientResource resourceServerClient = this.getClientResource("photoz-restful-api");
            RoleResource manageAlbumRole = resourceServerClient.roles().get("manage-albums");
            RoleRepresentation roleRepresentation = manageAlbumRole.toRepresentation();
            List roles = (List)JsonSerialization.readValue((String)((String)policy.getConfig().get("roles")), List.class);
            roles = roles.stream().filter(map -> !map.get("id").equals(roleRepresentation.getId())).collect(Collectors.toList());
            policy.getConfig().put("roles", JsonSerialization.writeValueAsString(roles));
            policiesResource.policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        for (PolicyRepresentation policy : policies) {
            if (!"Album Resource Permission".equals(policy.getName())) continue;
            policy.getConfig().put("applyPolicies", "[\"Any User Policy\", \"Administration Policy\"]");
            policiesResource.policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testAdminWithoutPermissionsToDeleteAlbum() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        PoliciesResource policiesResource = this.getAuthorizationResource().policies();
        List policies = policiesResource.policies();
        for (PolicyRepresentation policy : policies) {
            if (!"Delete Album Permission".equals(policy.getName())) continue;
            policy.getConfig().put("applyPolicies", "[\"Only Owner Policy\"]");
            policiesResource.policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.empty())));
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasDenied);
        for (PolicyRepresentation policy : policies) {
            if (!"Delete Album Permission".equals(policy.getName())) continue;
            policy.getConfig().put("applyPolicies", "[\"Only Owner and Administrators Policy\"]");
            policiesResource.policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.deleteAlbum("Alice-Family-Album", this::assertWasNotDenied);
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testClientRoleRepresentingUserConsent() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        RealmResource realmResource = this.realmsResouce().realm("photoz");
        UsersResource usersResource = realmResource.users();
        List users = usersResource.search("alice", null, null, null, null, null);
        Assert.assertFalse((boolean)users.isEmpty());
        UserRepresentation userRepresentation = (UserRepresentation)users.get(0);
        UserResource userResource = usersResource.get(userRepresentation.getId());
        ClientResource html5ClientApp = this.getClientResource("photoz-html5-client");
        ClientRepresentation clientRepresentation = html5ClientApp.toRepresentation();
        userResource.revokeConsent(clientRepresentation.getClientId());
        this.setManageAlbumScopeRequired();
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, "manage-albums");
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
    }

    @Test
    public void testClientRoleNotRequired() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("Alice-Family-Album");
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
        UsersResource usersResource = this.realmsResouce().realm("photoz").users();
        List users = usersResource.search("alice", null, null, null, null, null);
        Assert.assertFalse((boolean)users.isEmpty());
        UserRepresentation userRepresentation = (UserRepresentation)users.get(0);
        UserResource userResource = usersResource.get(userRepresentation.getId());
        ClientResource html5ClientApp = this.getClientResource("photoz-html5-client");
        userResource.revokeConsent(html5ClientApp.toRepresentation().getClientId());
        ClientResource resourceServerClient = this.getClientResource("photoz-restful-api");
        RoleResource manageAlbumRole = resourceServerClient.roles().get("manage-albums");
        RoleRepresentation roleRepresentation = manageAlbumRole.toRepresentation();
        this.setManageAlbumScopeRequired();
        manageAlbumRole.update(roleRepresentation);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasDenied);
        for (PolicyRepresentation policy : this.getAuthorizationResource().policies().policies()) {
            if (!"Any User Policy".equals(policy.getName())) continue;
            List roles = (List)JsonSerialization.readValue((String)((String)policy.getConfig().get("roles")), List.class);
            roles.forEach(role -> {
                String roleId = (String)role.get("id");
                if (roleId.equals(manageAlbumRole.toRepresentation().getId())) {
                    role.put("required", false);
                }
            });
            policy.getConfig().put("roles", JsonSerialization.writeValueAsString((Object)roles));
            this.getAuthorizationResource().policies().policy(policy.getId()).update(policy);
        }
        this.printUpdatedPolicies();
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.viewAlbum("Alice-Family-Album", this::assertWasNotDenied);
    }

    @Test
    public void testOverridePermissionFromResourceParent() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        String resourceName = "My-Resource-Instance";
        this.clientPage.createAlbum(resourceName);
        this.clientPage.viewAlbum(resourceName, this::assertWasNotDenied);
        this.clientPage.deleteAlbum(resourceName, this::assertWasNotDenied);
        this.clientPage.createAlbum(resourceName);
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.viewAlbum(resourceName, this::assertWasNotDenied);
        this.clientPage.deleteAlbum(resourceName, this::assertWasNotDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum(resourceName);
        AuthorizationResource authorizationResource = this.getAuthorizationResource();
        authorizationResource.resources().resources().forEach(resource -> {
            if (resource.getName().equals(resourceName)) {
                try {
                    PolicyRepresentation resourceInstancePermission = new PolicyRepresentation();
                    resourceInstancePermission.setName(resourceName + "Permission");
                    resourceInstancePermission.setType("resource");
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("resources", JsonSerialization.writeValueAsString(Arrays.asList(resource.getId())));
                    config.put("applyPolicies", JsonSerialization.writeValueAsString(Arrays.asList("Only Owner Policy")));
                    resourceInstancePermission.setConfig(config);
                    authorizationResource.policies().create(resourceInstancePermission);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error creating policy.", e);
                }
            }
        });
        this.printUpdatedPolicies();
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.viewAlbum(resourceName, this::assertWasDenied);
        this.clientPage.deleteAlbum(resourceName, this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.deleteAlbum(resourceName, this::assertWasNotDenied);
        MatcherAssert.assertThat(this.getResourcesOfUser("alice"), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testInheritPermissionFromResourceParent() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        String RESOURCE_NAME = "My-Resource-Instance";
        this.clientPage.createAlbum("My-Resource-Instance");
        this.clientPage.viewAlbum("My-Resource-Instance", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("My-Resource-Instance", this::assertWasNotDenied);
        this.clientPage.createAlbum("My-Resource-Instance");
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.navigateToAdminAlbum(this::assertWasNotDenied);
        this.clientPage.viewAlbum("My-Resource-Instance", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("My-Resource-Instance", this::assertWasNotDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.createAlbum("My-Resource-Instance");
        ResourcesResource resourcesResource = this.getAuthorizationResource().resources();
        resourcesResource.resources().forEach(resource -> {
            if (resource.getName().equals("My-Resource-Instance")) {
                try {
                    PolicyRepresentation resourceInstancePermission = new PolicyRepresentation();
                    resourceInstancePermission.setName("My-Resource-InstancePermission");
                    resourceInstancePermission.setType("resource");
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put("resources", JsonSerialization.writeValueAsString(Arrays.asList(resource.getId())));
                    config.put("applyPolicies", JsonSerialization.writeValueAsString(Arrays.asList("Only Owner Policy")));
                    resourceInstancePermission.setConfig(config);
                    this.getAuthorizationResource().policies().create(resourceInstancePermission);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error creating policy.", e);
                }
            }
        });
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.viewAlbum("My-Resource-Instance", this::assertWasDenied);
        this.clientPage.deleteAlbum("My-Resource-Instance", this::assertWasDenied);
        resourcesResource.resources().forEach(resource -> {
            if (resource.getName().equals("My-Resource-Instance")) {
                resource.setScopes(resource.getScopes().stream().filter(scope -> !scope.getName().equals("album:view")).collect(Collectors.toSet()));
                resourcesResource.resource(resource.getId()).update(resource);
            }
        });
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.viewAlbum("My-Resource-Instance", this::assertWasNotDenied);
        this.clientPage.deleteAlbum("My-Resource-Instance", this::assertWasDenied);
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.deleteAlbum("My-Resource-Instance", this::assertWasNotDenied);
        List resources = resourcesResource.resources();
        Assert.assertTrue((boolean)resources.stream().filter(resource -> resource.getOwner().getName().equals("alice")).collect(Collectors.toList()).isEmpty());
    }

    @Test
    public void testEntitlementRequest() throws Exception {
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.requestEntitlements((JavascriptStateValidator & Serializable)(driver1, output, events) -> MatcherAssert.assertThat((Object)((String)output), (Matcher)Matchers.containsString((String)"admin:manage")));
        this.loginToClientPage(this.adminUser, new String[0]);
        this.clientPage.requestEntitlement((JavascriptStateValidator & Serializable)(driver1, output, events) -> {
            MatcherAssert.assertThat((Object)((String)output), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"admin:manage")));
            MatcherAssert.assertThat((Object)((String)output), (Matcher)Matchers.containsString((String)"album:view"));
            MatcherAssert.assertThat((Object)((String)output), (Matcher)Matchers.containsString((String)"album:delete"));
        });
    }

    @Test
    public void testResourceProtectedWithAnyScope() throws Exception {
        this.loginToClientPage(this.aliceUser, new String[0]);
        this.clientPage.requestResourceProtectedAllScope(this::assertWasDenied);
        this.clientPage.requestResourceProtectedAnyScope((ResponseValidator & Serializable)response -> MatcherAssert.assertThat(response.get("status"), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)404L)), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)))));
    }
}

