/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.keycloak.testsuite.adapter.AbstractAdapterTest;
import org.keycloak.testsuite.utils.arquillian.DeploymentArchiveProcessorUtils;

public abstract class AbstractExampleAdapterTest
extends AbstractAdapterTest {
    public static final String EXAMPLES_HOME = System.getProperty("examples.home", null);
    public static final String EXAMPLES_VERSION_SUFFIX;
    public static final String EXAMPLES_HOME_DIR;
    public static final String TEST_APPS_HOME_DIR;
    public static final String EXAMPLES_WEB_XML;

    protected static WebArchive exampleDeployment(String name) {
        return AbstractExampleAdapterTest.exampleDeployment(name, (WebArchive webArchive) -> {});
    }

    protected static WebArchive exampleDeployment(String name, Consumer<WebArchive> additionalResources) {
        WebArchive webArchive = (WebArchive)((WebArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)(name + ".war"))).importFrom(new File(EXAMPLES_HOME + "/" + name + "-" + EXAMPLES_VERSION_SUFFIX + ".war"))).as(WebArchive.class)).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml");
        AbstractExampleAdapterTest.addSameSiteUndertowHandlers(webArchive);
        additionalResources.accept(webArchive);
        AbstractExampleAdapterTest.modifyOIDCAdapterConfig(webArchive);
        return webArchive;
    }

    protected static void modifyOIDCAdapterConfig(WebArchive webArchive) {
        if (webArchive.contains("/WEB-INF/keycloak.json")) {
            DeploymentArchiveProcessorUtils.modifyOIDCAdapterConfig((Archive)webArchive, (String)"/WEB-INF/keycloak.json");
        }
        if (webArchive.contains("/keycloak.json")) {
            DeploymentArchiveProcessorUtils.modifyOIDCAdapterConfig((Archive)webArchive, (String)"/keycloak.json");
        }
    }

    protected static WebArchive exampleDeployment(String name, String contextPath) throws IOException {
        return AbstractExampleAdapterTest.exampleDeployment(name, contextPath, webArchive -> {});
    }

    protected static WebArchive exampleDeployment(String name, String contextPath, Consumer<WebArchive> additionalResources) throws IOException {
        URL webXML = Paths.get(EXAMPLES_WEB_XML, new String[0]).toUri().toURL();
        String webXmlContent = IOUtils.toString((InputStream)webXML.openStream(), (String)"UTF-8").replace("%CONTEXT_PATH%", contextPath);
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)(name + ".war"))).importFrom(new File(EXAMPLES_HOME + "/" + name + "-" + EXAMPLES_VERSION_SUFFIX + ".war"))).as(WebArchive.class)).addAsWebInfResource(jbossDeploymentStructure, "jboss-deployment-structure.xml")).add((Asset)new StringAsset(webXmlContent), "/WEB-INF/web.xml");
        AbstractExampleAdapterTest.addSameSiteUndertowHandlers(webArchive);
        additionalResources.accept(webArchive);
        AbstractExampleAdapterTest.modifyOIDCAdapterConfig(webArchive);
        return webArchive;
    }

    static {
        Assert.assertNotNull((String)"Property ${examples.home} must bet set.", (Object)EXAMPLES_HOME);
        System.out.println(EXAMPLES_HOME);
        EXAMPLES_VERSION_SUFFIX = System.getProperty("examples.version.suffix", null);
        Assert.assertNotNull((String)"Property ${examples.version.suffix} must bet set.", (Object)EXAMPLES_VERSION_SUFFIX);
        System.out.println(EXAMPLES_VERSION_SUFFIX);
        EXAMPLES_HOME_DIR = EXAMPLES_HOME + "/example-realms";
        TEST_APPS_HOME_DIR = EXAMPLES_HOME + "/test-apps-dist";
        EXAMPLES_WEB_XML = EXAMPLES_HOME + "/web.xml";
    }
}

