/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.adapter;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.ContainerController;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.keycloak.testsuite.adapter.AbstractServletsAdapterTest;
import org.keycloak.testsuite.arquillian.ContainerInfo;
import org.keycloak.testsuite.auth.page.login.LoginActions;
import org.keycloak.testsuite.util.ContainerAssume;
import org.keycloak.testsuite.util.ServerURLs;

public abstract class AbstractAdapterClusteredTest
extends AbstractServletsAdapterTest {
    protected static final String NODE_1_NAME = "ha-node-1";
    protected static final String NODE_2_NAME = "ha-node-2";
    public static final String TARGET_CONTAINER_NODE_1 = "app-server-currentha-node-1";
    public static final String TARGET_CONTAINER_NODE_2 = "app-server-currentha-node-2";
    protected static final int PORT_OFFSET_NODE_REVPROXY = NumberUtils.toInt((String)System.getProperty("app.server.reverse-proxy.port.offset"), (int)-1);
    protected static final int HTTP_PORT_NODE_REVPROXY = 8080 + PORT_OFFSET_NODE_REVPROXY;
    protected static final int PORT_OFFSET_NODE_1 = NumberUtils.toInt((String)System.getProperty("app.server.1.port.offset"), (int)-1);
    protected static final int HTTP_PORT_NODE_1 = 8080 + PORT_OFFSET_NODE_1;
    protected static final int PORT_OFFSET_NODE_2 = NumberUtils.toInt((String)System.getProperty("app.server.2.port.offset"), (int)-1);
    protected static final int HTTP_PORT_NODE_2 = 8080 + PORT_OFFSET_NODE_2;
    protected static final URI NODE_1_URI = URI.create("http://" + ServerURLs.APP_SERVER_HOST + ":" + HTTP_PORT_NODE_1);
    protected static final URI NODE_2_URI = URI.create("http://" + ServerURLs.APP_SERVER_HOST + ":" + HTTP_PORT_NODE_2);
    protected LoadBalancingProxyClient loadBalancerToNodes;
    protected Undertow reverseProxyToNodes;
    @ArquillianResource
    protected ContainerController controller;
    @ArquillianResource
    protected Deployer deployer;
    @Page
    LoginActions loginActionsPage;

    @BeforeClass
    public static void checkPropertiesSet() {
        Assume.assumeThat((Object)PORT_OFFSET_NODE_1, (Matcher)Matchers.not((Matcher)Matchers.is((Object)-1)));
        Assume.assumeThat((Object)PORT_OFFSET_NODE_2, (Matcher)Matchers.not((Matcher)Matchers.is((Object)-1)));
        Assume.assumeThat((Object)PORT_OFFSET_NODE_REVPROXY, (Matcher)Matchers.not((Matcher)Matchers.is((Object)-1)));
        ContainerAssume.assumeNotAppServerSSL();
    }

    @Before
    public void prepareReverseProxy() throws Exception {
        this.loadBalancerToNodes = new LoadBalancingProxyClient().addHost(NODE_1_URI, NODE_1_NAME).setConnectionsPerThread(10);
        int maxTime = 3600000;
        this.reverseProxyToNodes = Undertow.builder().addHttpListener(HTTP_PORT_NODE_REVPROXY, ServerURLs.APP_SERVER_HOST).setIoThreads(2).setHandler((HttpHandler)new ProxyHandler((ProxyClient)this.loadBalancerToNodes, maxTime, (HttpHandler)ResponseCodeHandler.HANDLE_404)).build();
        this.reverseProxyToNodes.start();
    }

    @Before
    public void startServers() throws Exception {
        this.prepareServerDirectories();
        for (ContainerInfo containerInfo : this.testContext.getAppServerBackendsInfo()) {
            this.controller.start(containerInfo.getQualifier());
        }
        this.deploy();
    }

    protected abstract void deploy();

    protected void prepareServerDirectories() throws Exception {
        this.prepareServerDirectory("standalone-cluster", "standalone-ha-node-1");
        this.prepareServerDirectory("standalone-cluster", "standalone-ha-node-2");
    }

    protected void prepareServerDirectory(String baseDir, String targetSubdirectory) throws IOException {
        Path path = Paths.get(System.getProperty("app.server.home"), targetSubdirectory);
        File targetSubdirFile = path.toFile();
        FileUtils.deleteDirectory((File)targetSubdirFile);
        FileUtils.forceMkdir((File)targetSubdirFile);
        FileUtils.copyDirectory((File)Paths.get(System.getProperty("app.server.home"), baseDir, "deployments").toFile(), (File)new File(targetSubdirFile, "deployments"));
        FileUtils.copyDirectory((File)Paths.get(System.getProperty("app.server.home"), baseDir, "configuration").toFile(), (File)new File(targetSubdirFile, "configuration"));
    }

    @After
    public void stopReverseProxy() {
        this.reverseProxyToNodes.stop();
    }

    @After
    public void stopServers() {
        this.undeploy();
        for (ContainerInfo containerInfo : this.testContext.getAppServerBackendsInfo()) {
            this.controller.stop(containerInfo.getQualifier());
        }
    }

    protected abstract void undeploy();

    protected void updateProxy(String hostToPointToName, URI hostToPointToUri, URI hostToRemove) {
        this.loadBalancerToNodes.removeHost(hostToRemove);
        this.loadBalancerToNodes.addHost(hostToPointToUri, hostToPointToName);
        this.log.infov("Reverse proxy will direct requests to {0}", (Object)hostToPointToUri);
    }

    protected String getProxiedUrl(URL url) {
        try {
            return new URL(url.getProtocol(), url.getHost(), HTTP_PORT_NODE_REVPROXY, url.getFile()).toString();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

