/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.actions.RequiredActionUpdateProfileTest;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.EnableFeature;
import org.keycloak.testsuite.forms.RegisterWithUserProfileTest;
import org.keycloak.testsuite.forms.VerifyProfileTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.util.ClientScopeBuilder;
import org.keycloak.testsuite.util.KeycloakModelUtils;
import org.openqa.selenium.By;

@EnableFeature(value=Profile.Feature.DECLARATIVE_USER_PROFILE)
@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class RequiredActionUpdateProfileWithUserProfileTest
extends RequiredActionUpdateProfileTest {
    protected static final String PASSWORD = "password";
    protected static final String USERNAME1 = "test-user@localhost";
    private static ClientRepresentation client_scope_default;
    private static ClientRepresentation client_scope_optional;

    @Override
    protected boolean isDynamicForm() {
        return true;
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        super.configureTestRealm(testRealm);
        VerifyProfileTest.enableDynamicUserProfile(testRealm);
        testRealm.setClientScopes(new ArrayList());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("department").protocol("openid-connect").build());
        testRealm.getClientScopes().add(ClientScopeBuilder.create().name("profile").protocol("openid-connect").build());
        client_scope_default = KeycloakModelUtils.createClient(testRealm, "client-a");
        client_scope_default.setDefaultClientScopes(Collections.singletonList("department"));
        client_scope_default.setRedirectUris(Collections.singletonList("*"));
        client_scope_optional = KeycloakModelUtils.createClient(testRealm, "client-b");
        client_scope_optional.setOptionalClientScopes(Collections.singletonList("department"));
        client_scope_optional.setRedirectUris(Collections.singletonList("*"));
    }

    @Override
    @Before
    public void beforeTest() {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), null);
        super.beforeTest();
    }

    @Test
    public void testDisplayName() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"displayName\":\"${firstName}\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"displayName\" : \"Department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"First name", (Object)this.updateProfilePage.getLabelForField("firstName"));
        Assert.assertEquals((Object)"lastName", (Object)this.updateProfilePage.getLabelForField("lastName"));
        Assert.assertEquals((Object)"Department", (Object)this.updateProfilePage.getLabelForField("department"));
    }

    @Test
    public void testAttributeGrouping() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"group\": \"company\"},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"group\": \"contact\"}], \"groups\": [{\"name\": \"company\", \"displayDescription\": \"Company field desc\" },{\"name\": \"contact\" }]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        String htmlFormId = "kc-update-profile-form";
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(1) > div:nth-child(2) > input#lastName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(2) > div:nth-child(2) > input#username"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(3) > div:nth-child(2) > input#firstName"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(1) > label#header-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(4) > div:nth-child(2) > label#description-company"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(5) > div:nth-child(2) > input#department"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(6) > div:nth-child(1) > label#header-contact"))).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)("form#" + htmlFormId + " > div:nth-child(7) > div:nth-child(2) > input#email"))).isDisplayed());
    }

    @Test
    public void testAttributeGuiOrder() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}},{\"name\": \"username\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"email\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(1) > div:nth-child(2) > input#lastName")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(2) > div:nth-child(2) > input#department")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(3) > div:nth-child(2) > input#username")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(4) > div:nth-child(2) > input#firstName")).isDisplayed());
        Assert.assertTrue((boolean)this.driver.findElement(By.cssSelector((String)"form#kc-update-profile-form > div:nth-child(5) > div:nth-child(2) > input#email")).isDisplayed());
    }

    @Test
    public void testAttributeInputTypes() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"defaultType\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"placeholderAttribute\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypePlaceholder\":\"Example.\"}},{\"name\": \"helperTexts\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputHelperTextBefore\":\"Example <b>bold text</b> before.\",\"inputHelperTextAfter\":\"Example <i>i text</i> after.\"}},{\"name\": \"textWithBasicAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"text\",\"inputTypeSize\":\"35\",\"inputTypeMinlength\":\"1\",\"inputTypeMaxlength\":\"10\",\"inputTypePattern\":\".*\"}},{\"name\": \"html5NumberWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"html5-number\",\"inputTypeMin\":\"10\",\"inputTypeMax\":\"20\",\"inputTypeStep\":1}},{\"name\": \"textareaWithAttributes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"textarea\",\"inputTypeCols\":\"35\",\"inputTypeRows\":\"7\",\"inputTypeMaxlength\":\"10\"}},{\"name\": \"selectWithoutOptions\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"annotations\":{\"inputType\":\"select\",\"inputTypeSize\":\"5\"}},{\"name\": \"selectWithOptionsWithoutLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{\"options\":[ \"opt1\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"select\"}},{\"name\": \"multiselectWithOptionsAndSimpleI18nLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"totp\",\"opt2\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabelsI18nPrefix\": \"loginTotp\"}},{\"name\": \"multiselectWithOptionsAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"options\":{ \"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\":{\"dummyOptions\":{\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttons\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"options\" : {\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}},{\"name\": \"selectRadiobuttonsWithOptionsFromCustomValidatorAndLabels\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\" : {\"dummyOptions\" : {\"options\" : [\"vopt1\",\"vopt2\",\"vopt3\"]}} ,\"annotations\":{\"inputType\":\"select-radiobuttons\",\"inputOptionsFromValidation\":\"dummyOptions\",\"inputOptionLabels\":{\"vopt1\": \"Option 1\",\"vopt2\":\"${username}\"}}},{\"name\": \"multiselectCheckboxes\", \"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"validations\": {\"options\":{\"options\":[\"opt1\",\"opt2\",\"opt3\"]}}, \"annotations\":{\"inputType\":\"multiselect-checkboxes\",\"inputOptionLabels\":{\"opt1\": \"Option 1\",\"opt2\":\"${username}\"}}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        RegisterWithUserProfileTest.assertFieldTypes(this.driver);
    }

    @Test
    public void testUsernameOnlyIfEditAllowed() {
        RealmRepresentation realm = this.testRealm().toRepresentation();
        boolean r = realm.isEditUsernameAllowed();
        try {
            realm.setEditUsernameAllowed(Boolean.valueOf(false));
            this.testRealm().update(realm);
            this.loginPage.open();
            this.loginPage.login(USERNAME1, PASSWORD);
            Assert.assertFalse((boolean)this.updateProfilePage.isUsernamePresent());
            realm.setEditUsernameAllowed(Boolean.valueOf(true));
            this.testRealm().update(realm);
            this.driver.navigate().refresh();
            Assert.assertTrue((boolean)this.updateProfilePage.isUsernamePresent());
        }
        finally {
            realm.setEditUsernameAllowed(Boolean.valueOf(r));
            this.testRealm().update(realm);
        }
    }

    @Test
    public void testOptionalAttribute() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.updateProfilePage.isCancelDisplayed());
        this.updateProfilePage.update("New first", "", "new@email.com", USERNAME1);
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("previous_first_name", "Tom").detail("updated_first_name", "New first").detail("previous_last_name", "Brady").detail("previous_email", USERNAME1).detail("updated_email", "new@email.com").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, USERNAME1);
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        MatcherAssert.assertThat((Object)StringUtils.isEmpty((CharSequence)user.getLastName()), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertEquals((Object)"new@email.com", (Object)user.getEmail());
        Assert.assertEquals((Object)USERNAME1, (Object)user.getUsername());
    }

    @Test
    public void testCustomValidationLastName() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        this.updateUserByUsername(USERNAME1, "ExistingFirst", "La", "Department");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}," + VerifyProfileTest.VALIDATIONS_LENGTH + "},{\"name\": \"department\"," + "\"permissions\": {\"view\": [\"admin\"], \"edit\": [\"admin\"]}" + "}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("First", "L", USERNAME1, USERNAME1);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("First", "Last", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
        Assert.assertEquals((Object)"Department", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testRequiredReadOnlyAttribute() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"Brady", (Object)this.updateProfilePage.getLastName());
        Assert.assertFalse((boolean)this.updateProfilePage.isDepartmentEnabled());
        this.updateProfilePage.update("First", "Last", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
    }

    @Test
    public void testRequiredReadOnlyExistingAttribute() {
        this.updateUserByUsername(USERNAME1, "first", "last", "foo");
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"last", (Object)this.updateProfilePage.getLastName());
        Assert.assertFalse((boolean)this.updateProfilePage.isDepartmentEnabled());
        this.updateProfilePage.update("First", "Last", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
    }

    @Test
    public void testAttributeNotVisible() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\"], \"edit\": [\"admin\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"Brady", (Object)this.updateProfilePage.getLastName());
        Assert.assertFalse((String)"'department' field is visible", (boolean)this.updateProfilePage.isDepartmentPresent());
        this.updateProfilePage.update("First", "Last", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"First", (Object)user.getFirstName());
        Assert.assertEquals((Object)"Last", (Object)user.getLastName());
    }

    @Test
    public void testRequiredAttribute() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}}]}");
        this.loginPage.open();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "", USERNAME1, USERNAME1);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "DepartmentCC", USERNAME1, USERNAME1);
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("previous_first_name", "Tom").detail("updated_first_name", "FirstCC").detail("previous_last_name", "Brady").detail("updated_last_name", "LastCC").detail("updated_department", "DepartmentCC").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredForScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "", USERNAME1, USERNAME1);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "DepartmentCC", USERNAME1, USERNAME1);
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).client(client_scope_optional.getClientId()).detail("previous_first_name", "Tom").detail("updated_first_name", "FirstCC").detail("previous_last_name", "Brady").detail("updated_last_name", "LastCC").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredForDefaultScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.clientId(client_scope_default.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "", USERNAME1, USERNAME1);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "DepartmentCC", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredAndSelectedByScope() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "", USERNAME1, USERNAME1);
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "DepartmentCC", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeNotRequiredAndSelectedByScopeCanBeUpdated() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.scope("department").clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertTrue((boolean)this.updateProfilePage.isDepartmentPresent());
        this.updateProfilePage.updateWithDepartment("FirstCC", "LastCC", "DepartmentCC", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
        Assert.assertEquals((Object)"DepartmentCC", (Object)user.firstAttribute("department"));
    }

    @Test
    public void testAttributeRequiredButNotSelectedByScopeIsNotRendered() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"department\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\":{}, \"selector\":{\"scopes\":[\"department\"]}}]}");
        this.oauth.clientId(client_scope_optional.getClientId()).openLoginForm();
        this.loginPage.assertCurrent();
        this.loginPage.login(USERNAME1, PASSWORD);
        this.updateProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.updateProfilePage.isDepartmentPresent());
        this.updateProfilePage.update("FirstCC", "LastCC", USERNAME1, USERNAME1);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        Assert.assertNotNull(this.oauth.getCurrentQuery().get("code"));
        UserRepresentation user = this.getUserByUsername(USERNAME1);
        Assert.assertEquals((Object)"FirstCC", (Object)user.getFirstName());
        Assert.assertEquals((Object)"LastCC", (Object)user.getLastName());
    }

    @Override
    @Test
    public void updateProfileWithoutRemoveCustomAttributes() {
        this.setUserProfileConfiguration("{\"attributes\": [{\"name\": \"firstName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"lastName\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}, \"required\": {}},{\"name\": \"custom\",\"permissions\": {\"view\": [\"admin\", \"user\"], \"edit\": [\"admin\", \"user\"]}}]}");
        super.updateProfileWithoutRemoveCustomAttributes();
    }

    protected void setUserProfileConfiguration(String configuration) {
        VerifyProfileTest.setUserProfileConfiguration(this.testRealm(), configuration);
    }

    protected UserRepresentation getUserByUsername(String username) {
        return VerifyProfileTest.getUserByUsername(this.testRealm(), username);
    }

    protected void updateUserByUsername(String username, String firstName, String lastName, String department) {
        UserRepresentation ur = this.getUserByUsername(username);
        ur.setFirstName(firstName);
        ur.setLastName(lastName);
        ur.singleAttribute("department", department);
        this.testRealm().users().get(ur.getId()).update(ur);
    }
}

