/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.Arrays;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginUpdateProfileEditUsernameAllowedPage;
import org.keycloak.testsuite.util.UserBuilder;
import org.keycloak.userprofile.UserProfileContext;

public class RequiredActionUpdateProfileTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginUpdateProfileEditUsernameAllowedPage updateProfilePage;
    @Page
    protected ErrorPage errorPage;

    protected boolean isDynamicForm() {
        return false;
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        ActionUtil.addRequiredActionForUser(testRealm, "test-user@localhost", UserModel.RequiredAction.UPDATE_PROFILE.name());
        ActionUtil.addRequiredActionForUser(testRealm, "john-doh@localhost", UserModel.RequiredAction.UPDATE_PROFILE.name());
    }

    @Before
    public void beforeTest() {
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation user = UserBuilder.create().enabled(true).username("test-user@localhost").email("test-user@localhost").firstName("Tom").lastName("Brady").emailVerified(true).requiredAction(UserModel.RequiredAction.UPDATE_PROFILE.name()).build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"john-doh@localhost");
        user = UserBuilder.create().enabled(true).username("john-doh@localhost").email("john-doh@localhost").firstName("John").lastName("Doh").emailVerified(true).requiredAction(UserModel.RequiredAction.UPDATE_PROFILE.name()).build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
    }

    @Test
    public void updateProfile() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.updateProfilePage.isCancelDisplayed());
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("previous_first_name", "Tom").detail("updated_first_name", "New first").detail("previous_last_name", "Brady").detail("updated_last_name", "New last").detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)user.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)user.getUsername());
        Assert.assertEquals((Object)false, (Object)user.isEmailVerified());
    }

    @Test
    public void updateUsername() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        String userId = ActionUtil.findUserWithAdminClient(this.adminClient, "john-doh@localhost").getId();
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "john-doh@localhost", "new");
        this.events.expectLogin().event(EventType.UPDATE_PROFILE).detail("updated_first_name", "New first").user(userId).session((Matcher<String>)Matchers.nullValue(String.class)).removeDetail("consent").detail("updated_last_name", "New last").user(userId).session((Matcher<String>)Matchers.nullValue(String.class)).removeDetail("consent").detail("username", "john-doh@localhost").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().detail("username", "john-doh@localhost").user(userId).assertEvent();
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "new");
        Assert.assertEquals((Object)"New first", (Object)user.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)user.getLastName());
        Assert.assertEquals((Object)"john-doh@localhost", (Object)user.getEmail());
        Assert.assertEquals((Object)"new", (Object)user.getUsername());
        Assert.assertEquals((Object)true, (Object)user.isEmailVerified());
        this.getCleanup().addUserId(user.getId());
    }

    @Test
    public void updateProfileMissingFirstName() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("", "New last", "new@email.com", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        if (this.isDynamicForm()) {
            Assert.assertEquals((Object)"Please specify this field.", (Object)this.updateProfilePage.getInputErrors().getFirstNameError());
        } else {
            Assert.assertEquals((Object)"Please specify first name.", (Object)this.updateProfilePage.getInputErrors().getFirstNameError());
        }
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingLastName() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "", "new@email.com", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        if (this.isDynamicForm()) {
            Assert.assertEquals((Object)"Please specify this field.", (Object)this.updateProfilePage.getInputErrors().getLastNameError());
        } else {
            Assert.assertEquals((Object)"Please specify last name.", (Object)this.updateProfilePage.getInputErrors().getLastNameError());
        }
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingEmail() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "", "new");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Please specify email.", (Object)this.updateProfilePage.getInputErrors().getEmailError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileInvalidEmail() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "invalidemail", "invalid");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"invalidemail", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Invalid email address.", (Object)this.updateProfilePage.getInputErrors().getEmailError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileMissingUsername() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"", (Object)this.updateProfilePage.getUsername());
        Assert.assertEquals((Object)"Please specify username.", (Object)this.updateProfilePage.getInputErrors().getUsernameError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileDuplicateUsername() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)this.updateProfilePage.getUsername());
        Assert.assertEquals((Object)"Username already exists.", (Object)this.updateProfilePage.getInputErrors().getUsernameError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileDuplicatedEmail() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.updateProfilePage.update("New first", "New last", "keycloak-user@localhost", "test-user@localhost");
        this.updateProfilePage.assertCurrent();
        Assert.assertEquals((Object)"New first", (Object)this.updateProfilePage.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)this.updateProfilePage.getLastName());
        Assert.assertEquals((Object)"keycloak-user@localhost", (Object)this.updateProfilePage.getEmail());
        Assert.assertEquals((Object)"Email already exists.", (Object)this.updateProfilePage.getInputErrors().getEmailError());
        this.events.assertEmpty();
    }

    @Test
    public void updateProfileExpiredCookies() {
        this.loginPage.open();
        this.loginPage.login("john-doh@localhost", "password");
        this.updateProfilePage.assertCurrent();
        this.driver.manage().deleteAllCookies();
        this.updateProfilePage.update("New first", "New last", "keycloak-user@localhost", "test-user@localhost");
        this.errorPage.assertCurrent();
        String backToAppLink = this.errorPage.getBackToApplicationLink();
        ClientRepresentation client = ApiUtil.findClientByClientId((RealmResource)this.adminClient.realm("test"), (String)"test-app").toRepresentation();
        Assert.assertEquals((Object)backToAppLink, (Object)client.getBaseUrl());
    }

    @Test
    public void updateProfileWithoutRemoveCustomAttributes() {
        UserRepresentation userRep = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        UserResource user = this.adminClient.realm("test").users().get(userRep.getId());
        userRep.setAttributes(new HashMap());
        userRep.getAttributes().put("custom", Arrays.asList("custom"));
        user.update(userRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.updateProfilePage.assertCurrent();
        Assert.assertFalse((boolean)this.updateProfilePage.isCancelDisplayed());
        this.updateProfilePage.update("New first", "New last", "new@email.com", "test-user@localhost");
        this.events.expectRequiredAction(EventType.UPDATE_PROFILE).detail("context", UserProfileContext.UPDATE_PROFILE.name()).detail("previous_email", "test-user@localhost").detail("updated_email", "new@email.com").assertEvent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        userRep = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        Assert.assertEquals((Object)"New first", (Object)userRep.getFirstName());
        Assert.assertEquals((Object)"New last", (Object)userRep.getLastName());
        Assert.assertEquals((Object)"new@email.com", (Object)userRep.getEmail());
        Assert.assertEquals((Object)"test-user@localhost", (Object)userRep.getUsername());
        Assert.assertNotNull((Object)userRep.getAttributes());
        Assert.assertTrue((boolean)userRep.getAttributes().containsKey("custom"));
    }
}

