/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.LinkedList;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LanguageComboboxAwarePage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class RequiredActionTotpSetupTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected LoginConfigTotpPage totpPage;
    @Page
    protected AccountTotpPage accountTotpPage;
    @Page
    protected RegisterPage registerPage;
    protected TimeBasedOTP totp = new TimeBasedOTP();

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        RequiredActionProviderRepresentation requiredAction = new RequiredActionProviderRepresentation();
        requiredAction.setAlias(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        requiredAction.setProviderId(UserModel.RequiredAction.CONFIGURE_TOTP.name());
        requiredAction.setName("Configure Totp");
        requiredAction.setEnabled(true);
        requiredAction.setDefaultAction(true);
        LinkedList<RequiredActionProviderRepresentation> requiredActions = new LinkedList<RequiredActionProviderRepresentation>();
        requiredActions.add(requiredAction);
        testRealm.setRequiredActions(requiredActions);
        testRealm.setResetPasswordAllowed(Boolean.TRUE);
    }

    @Before
    public void setOTPAuthRequired() {
        this.adminClient.realm("test").flows().getExecutions("browser").stream().filter(execution -> execution.getDisplayName().equals("Browser - Conditional OTP")).forEach(execution -> {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.name());
            this.adminClient.realm("test").flows().updateExecutions("browser", execution);
        });
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation user = UserBuilder.create().enabled(true).username("test-user@localhost").email("test-user@localhost").firstName("Tom").lastName("Brady").requiredAction(UserModel.RequiredAction.UPDATE_PROFILE.name()).build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
    }

    @Test
    public void setupTotpRegister() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "email@mail.com", "setupTotp", "password", "password");
        String userId = this.events.expectRegister("setupTotp", "email@mail.com").assertEvent().getUserId();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        Assert.assertFalse((boolean)this.totpPage.isCancelDisplayed());
        LanguageComboboxAwarePage.assertAttemptedUsernameAvailability((WebDriver)this.driver, (boolean)false);
        this.driver.findElement(By.id((String)"userLabel"));
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        String authSessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setuptotp").assertEvent().getDetails().get("code_id");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).session(authSessionId).detail("username", "setuptotp").assertEvent();
    }

    @Test
    public void setupTotpRegisterManual() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "checkQrCode@mail.com", "checkQrCode", "password", "password");
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.clickManual();
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
        Assert.assertTrue((boolean)this.driver.findElement(By.id((String)"kc-totp-secret-key")).getText().matches("[\\w]{4}( [\\w]{4}){7}"));
        Assert.assertEquals((Object)"Type: Time-based", (Object)this.driver.findElement(By.id((String)"kc-totp-type")).getText());
        Assert.assertEquals((Object)"Algorithm: SHA1", (Object)this.driver.findElement(By.id((String)"kc-totp-algorithm")).getText());
        Assert.assertEquals((Object)"Digits: 6", (Object)this.driver.findElement(By.id((String)"kc-totp-digits")).getText());
        Assert.assertEquals((Object)"Interval: 30", (Object)this.driver.findElement(By.id((String)"kc-totp-period")).getText());
        this.totpPage.clickBarcode();
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.driver.findElement(By.id((String)"userLabel"));
    }

    @Test
    public void setupTotpRegisterManualModeSwitchesOnBadSubmit() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "setupTotpRegisterManualModeSwitchesOnBadSubmit@mail.com", "setupTotpRegisterManualModeSwitchesOnBadSubmit", "password", "password");
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.clickManual();
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.submit();
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
        Assert.assertEquals((Object)"Please specify authenticator code.", (Object)this.totpPage.getInputCodeError());
    }

    @Test
    public void setupTotpRegisterBarcodeModeSwitchesOnBadSubmit() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "setupTotpRegisterBarcodeModeSwitchesOnBadSubmit@mail.com", "setupTotpRegisterBarcodeModeSwitchesOnBadSubmit", "password", "password");
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.submit();
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        Assert.assertEquals((Object)"Please specify authenticator code.", (Object)this.totpPage.getInputCodeError());
        this.totpPage.clickManual();
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
    }

    @Test
    public void setupTotpRegisterVerifyCustomOtpLabelSetProperly() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "setupTotpRegister@mail.com", "setupTotpRegister", "password", "password");
        String userId = this.events.expectRegister("setupTotpRegister", "setupTotpRegister@mail.com").assertEvent().getUserId();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        this.driver.findElement(By.id((String)"userLabel"));
        String customOtpLabel = "my-custom-otp-label";
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()), customOtpLabel);
        this.accountTotpPage.open();
        this.accountTotpPage.assertCurrent();
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains(customOtpLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setupTotpModifiedPolicy() {
        RealmResource realm = this.testRealm();
        RealmRepresentation rep = realm.toRepresentation();
        rep.setOtpPolicyDigits(Integer.valueOf(8));
        rep.setOtpPolicyType("hotp");
        rep.setOtpPolicyAlgorithm("HmacSHA256");
        realm.update(rep);
        try {
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.register("firstName", "lastName", "setupTotpModifiedPolicy@mail.com", "setupTotpModifiedPolicy", "password", "password");
            String pageSource = this.driver.getPageSource();
            Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
            Assert.assertFalse((boolean)pageSource.contains("Google Authenticator"));
            this.totpPage.clickManual();
            Assert.assertEquals((Object)"Type: Counter-based", (Object)this.driver.findElement(By.id((String)"kc-totp-type")).getText());
            Assert.assertEquals((Object)"Algorithm: SHA256", (Object)this.driver.findElement(By.id((String)"kc-totp-algorithm")).getText());
            Assert.assertEquals((Object)"Digits: 8", (Object)this.driver.findElement(By.id((String)"kc-totp-digits")).getText());
            Assert.assertEquals((Object)"Counter: 0", (Object)this.driver.findElement(By.id((String)"kc-totp-counter")).getText());
        }
        finally {
            rep.setOtpPolicyDigits(Integer.valueOf(6));
            rep.setOtpPolicyType("totp");
            rep.setOtpPolicyAlgorithm("HmacSHA1");
            realm.update(rep);
        }
    }

    @Test
    public void setupTotpExisting() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpSecret));
        String authSessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getDetails().get("code_id");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(authSessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(authSessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String src = this.driver.getPageSource();
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void setupTotpEnforcedBySessionNotForUserInGeneral() {
        String username = "test-user@localhost";
        String configureTotp = UserModel.RequiredAction.CONFIGURE_TOTP.name();
        UserResource user = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)username);
        UserRepresentation userRepresentation = user.toRepresentation();
        userRepresentation.getRequiredActions().remove(configureTotp);
        user.update(userRepresentation);
        this.loginPage.open();
        this.loginPage.login(username, "password");
        this.totpPage.assertCurrent();
        userRepresentation = user.toRepresentation();
        Assert.assertFalse((boolean)userRepresentation.getRequiredActions().contains(configureTotp));
    }

    @Test
    public void setupTotpRegisteredAfterTotpRemoval() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName2", "lastName2", "email2@mail.com", "setupTotp2", "password2", "password2");
        String userId = this.events.expectRegister("setupTotp2", "email2@mail.com").assertEvent().getUserId();
        this.totpPage.assertCurrent();
        String totpCode = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpCode));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setuptotp2").assertEvent();
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "setuptotp2").assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).user(userId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("setupTotp2", "password2");
        String uri = this.driver.getCurrentUrl();
        String src = this.driver.getPageSource();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertFalse((boolean)this.totpPage.isCurrent());
        this.loginTotpPage.login(this.totp.generateTOTP(totpCode));
        loginEvent = this.events.expectLogin().user(userId).detail("username", "setupTotp2").assertEvent();
        this.accountTotpPage.open();
        this.accountTotpPage.assertCurrent();
        this.accountTotpPage.removeTotp();
        this.events.expectAccount(EventType.REMOVE_TOTP).user(userId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).user(userId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("setupTotp2", "password2");
        this.totpPage.assertCurrent();
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        String sessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setupTotp2").assertEvent().getDetails().get("code_id");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(userId).session(sessionId).detail("username", "setupTotp2").assertEvent();
    }

    @Test
    public void setupOtpPolicyChangedTotp8Digits() {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(1).otpDigits(8).otpPeriod(30).otpType("totp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        TimeBasedOTP timeBased = new TimeBasedOTP("HmacSHA1", 8, 30, 1);
        this.totpPage.configure(timeBased.generateTOTP(totpSecret));
        String sessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getDetails().get("code_id");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String src = this.driver.getPageSource();
        String token = timeBased.generateTOTP(totpSecret);
        Assert.assertEquals((long)8L, (long)token.length());
        this.loginTotpPage.login(token);
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpDigits(6);
        this.adminClient.realm("test").update(realmRep);
    }

    @Test
    public void setupOtpPolicyChangedHotp() {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(0).otpDigits(6).otpPeriod(30).otpType("hotp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        HmacOTP otpgen = new HmacOTP(6, "HmacSHA1", 1);
        this.totpPage.configure(otpgen.generateHOTP(totpSecret, 0));
        String uri = this.driver.getCurrentUrl();
        String sessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getDetails().get("code_id");
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(otpgen.generateHOTP(totpSecret, 1));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(null).session(AssertEvents.isUUID()).assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(5).otpDigits(6).otpPeriod(30).otpType("hotp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(otpgen.generateHOTP(totpSecret, 2));
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(1).otpDigits(6).otpPeriod(30).otpType("totp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
    }
}

