/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.common.Profile;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.AuthServerTestEnricher;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.cluster.AuthenticationSessionFailoverClusterTest;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.InfoPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.pages.ProceedPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.pages.VerifyEmailPage;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.updaters.ServerResourceUpdater;
import org.keycloak.testsuite.updaters.UserAttributeUpdater;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.MailUtils;
import org.keycloak.testsuite.util.SecondBrowser;
import org.keycloak.testsuite.util.UserActionTokenBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
@DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
public class RequiredActionEmailVerificationTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected AppPage appPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected VerifyEmailPage verifyEmailPage;
    @Page
    protected RegisterPage registerPage;
    @Page
    protected InfoPage infoPage;
    @Page
    protected ProceedPage proceedPage;
    @Page
    protected ErrorPage errorPage;
    private String testUserId;
    @Drone
    @SecondBrowser
    protected WebDriver driver2;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setVerifyEmail(Boolean.TRUE);
        ActionUtil.findUserInRealmRep(testRealm, "test-user@localhost").setEmailVerified(Boolean.FALSE);
    }

    @Before
    public void before() {
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation user = UserBuilder.create().enabled(true).username("test-user@localhost").email("test-user@localhost").build();
        this.testUserId = ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
    }

    @Test
    public void verifyEmailConfig() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        Assert.assertEquals((Object)"<auto+bounces@keycloak.org>", (Object)message.getHeader("Return-Path")[0]);
        Assert.assertEquals((Object)"Keycloak SSO <auto@keycloak.org>", (Object)message.getHeader("From")[0]);
        Assert.assertEquals((Object)"Keycloak no-reply <reply-to@keycloak.org>", (Object)message.getHeader("Reply-To")[0]);
    }

    @Test
    public void verifyEmailExisting() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        AssertEvents.ExpectedEvent emailEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost");
        EventRepresentation sendEvent = emailEvent.assertEvent();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        this.driver.navigate().to(verificationUrl.trim());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(this.testUserId).detail("username", "test-user@localhost").detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectLogin().user(this.testUserId).session(mailCodeId).detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void verifyEmailRegister() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "email@mail.com", "verifyEmail", "password", "password");
        String userId = this.events.expectRegister("verifyEmail", "email@mail.com").assertEvent().getUserId();
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        EventRepresentation sendEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).user(userId).detail("username", "verifyemail").detail("email", "email@mail.com").assertEvent();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl.trim());
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(userId).detail("username", "verifyemail").detail("email", "email@mail.com").detail("code_id", mailCodeId).assertEvent();
        this.events.expectLogin().user(userId).session(mailCodeId).detail("username", "verifyemail").assertEvent();
    }

    @Test
    public void verifyEmailResend() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        EventRepresentation sendEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost").assertEvent();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        this.verifyEmailPage.clickResendEmail();
        this.verifyEmailPage.assertCurrent();
        this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("code_id", mailCodeId).detail("email", "test-user@localhost").assertEvent();
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl.trim());
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(this.testUserId).detail("username", "test-user@localhost").detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
        this.events.expectLogin().user(this.testUserId).session(mailCodeId).detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void verifyEmailResendWithRefreshes() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        this.driver.navigate().refresh();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        EventRepresentation sendEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost").assertEvent();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        this.verifyEmailPage.clickResendEmail();
        this.verifyEmailPage.assertCurrent();
        this.driver.navigate().refresh();
        this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("code_id", mailCodeId).detail("email", "test-user@localhost").assertEvent();
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl.trim());
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(this.testUserId).detail("username", "test-user@localhost").detail("email", "test-user@localhost").detail("code_id", mailCodeId).assertEvent();
        this.events.expectLogin().user(this.testUserId).session(mailCodeId).detail("username", "test-user@localhost").assertEvent();
    }

    @Test
    public void verifyEmailResendFirstStillValidEvenWithSecond() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.clickResendEmail();
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message1 = this.greenMail.getReceivedMessages()[0];
        String verificationUrl1 = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message1);
        this.driver.navigate().to(verificationUrl1.trim());
        this.appPage.assertCurrent();
        Assert.assertEquals((Object)AppPage.RequestType.AUTH_RESPONSE, (Object)this.appPage.getRequestType());
        MimeMessage message2 = this.greenMail.getReceivedMessages()[1];
        String verificationUrl2 = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message2);
        this.driver.navigate().to(verificationUrl2.trim());
        this.infoPage.assertCurrent();
        Assert.assertEquals((Object)"You are already logged in.", (Object)this.infoPage.getInfo());
    }

    @Test
    public void verifyEmailResendFirstAndSecondStillValid() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.clickResendEmail();
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)2L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message1 = this.greenMail.getReceivedMessages()[0];
        String verificationUrl1 = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message1);
        this.driver.navigate().to(verificationUrl1.trim());
        this.appPage.assertCurrent();
        this.appPage.logout();
        MimeMessage message2 = this.greenMail.getReceivedMessages()[1];
        String verificationUrl2 = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message2);
        this.driver.navigate().to(verificationUrl2.trim());
        this.proceedPage.assertCurrent();
        this.proceedPage.clickProceedLink();
        this.infoPage.assertCurrent();
        Assert.assertEquals((Object)"Your email address has been verified.", (Object)this.infoPage.getInfo());
    }

    @Test
    public void verifyEmailNewBrowserSession() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        AssertEvents.ExpectedEvent emailEvent = this.events.expectRequiredAction(EventType.SEND_VERIFY_EMAIL).detail("email", "test-user@localhost");
        EventRepresentation sendEvent = emailEvent.assertEvent();
        String mailCodeId = (String)sendEvent.getDetails().get("code_id");
        this.driver.manage().deleteAllCookies();
        this.driver.navigate().to(verificationUrl.trim());
        this.proceedPage.assertCurrent();
        this.proceedPage.clickProceedLink();
        this.infoPage.assertCurrent();
        this.events.expectRequiredAction(EventType.VERIFY_EMAIL).user(this.testUserId).detail("code_id", (Matcher<? super String>)Matchers.not((Matcher)Matchers.is((Object)mailCodeId))).client(this.oauth.getClientId()).detail("redirect_uri", (Matcher<? super String>)Matchers.any(String.class)).assertEvent();
        this.infoPage.assertCurrent();
        Assert.assertEquals((Object)"Your email address has been verified.", (Object)this.infoPage.getInfo());
        this.loginPage.open();
        this.loginPage.assertCurrent();
    }

    @Test
    public void verifyEmailInvalidKeyInVerficationLink() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        verificationUrl = KeycloakUriBuilder.fromUri((String)verificationUrl).replaceQueryParam("key", new Object[]{"foo"}).build(new Object[0]).toString();
        this.events.poll();
        this.driver.navigate().to(verificationUrl.trim());
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"An error occurred, please login again through your application.", (Object)this.errorPage.getError());
        this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("invalid_code").client((String)null).user((String)null).session((String)null).clearDetails().assertEvent();
    }

    @Test
    public void verifyEmailExpiredCode() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.events.poll();
        try {
            this.setTimeOffset(3600);
            this.driver.navigate().to(verificationUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.testUserId).session((String)null).clearDetails().detail("action", "verify-email").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyEmailExpiredCodedPerActionLifespan() throws IOException, MessagingException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().verifyEmailLifespan(60).build());
        this.testRealm().update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.events.poll();
        try {
            this.setTimeOffset(70);
            this.driver.navigate().to(verificationUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.testUserId).session((String)null).clearDetails().detail("action", "verify-email").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyEmailExpiredCodedPerActionMultipleTimeouts() throws IOException, MessagingException {
        RealmRepresentation realmRep = this.testRealm().toRepresentation();
        Map originalAttributes = Collections.unmodifiableMap(new HashMap(realmRep.getAttributes()));
        realmRep.setAttributes(UserActionTokenBuilder.create().verifyEmailLifespan(60).resetCredentialsLifespan(300).build());
        this.testRealm().update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.events.poll();
        try {
            this.setTimeOffset(70);
            this.driver.navigate().to(verificationUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.testUserId).session((String)null).clearDetails().detail("action", "verify-email").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
            realmRep.setAttributes(originalAttributes);
            this.testRealm().update(realmRep);
        }
    }

    @Test
    public void verifyEmailExpiredCodeAndExpiredSession() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.events.poll();
        try {
            this.setTimeOffset(3600);
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(verificationUrl.trim());
            this.errorPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired.", (Object)this.errorPage.getError());
            this.events.expectRequiredAction(EventType.EXECUTE_ACTION_TOKEN_ERROR).error("expired_code").client((String)null).user(this.testUserId).session((String)null).clearDetails().detail("action", "verify-email").assertEvent();
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    public static String getPasswordResetEmailLink(MimeMessage message) throws IOException, MessagingException {
        return MailUtils.getPasswordResetEmailLink((MimeMessage)message);
    }

    @Test
    public void verifyEmailNewBrowserSessionWithClientRedirect() throws IOException, MessagingException {
        try (ServerResourceUpdater u = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(false)).update();){
            this.testRealm().users().get(this.testUserId).executeActionsEmail(Arrays.asList(UserModel.RequiredAction.VERIFY_EMAIL.name()));
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getLastReceivedMessage();
            String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(verificationUrl.trim());
            this.proceedPage.assertCurrent();
            this.proceedPage.clickProceedLink();
            this.infoPage.assertCurrent();
            Assert.assertEquals((Object)"Your account has been updated.", (Object)this.infoPage.getInfo());
            this.accountPage.setAuthRealm(this.testRealm().toRepresentation().getRealm());
            this.accountPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.accountPage.assertCurrent();
        }
    }

    @Test
    public void verifyEmailNewBrowserSessionPreserveClient() throws IOException, MessagingException {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver2.navigate().to(verificationUrl.trim());
        WebElement proceedLink = this.driver2.findElement(By.linkText((String)"\u00bb Click here to proceed"));
        MatcherAssert.assertThat((Object)proceedLink, (Matcher)Matchers.notNullValue());
        String link = proceedLink.getAttribute("href");
        MatcherAssert.assertThat((Object)link, (Matcher)Matchers.containsString((String)"client_id=test-app"));
        proceedLink.click();
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"kc-info-message"));
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"Your email address has been verified."));
        WebElement backToApplicationLink = this.driver2.findElement(By.linkText((String)"\u00ab Back to Application"));
        MatcherAssert.assertThat((Object)backToApplicationLink, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void verifyEmailDuringAuthFlow() throws IOException, MessagingException {
        try (ServerResourceUpdater u = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(false)).setRequiredActions(new UserModel.RequiredAction[]{UserModel.RequiredAction.VERIFY_EMAIL}).update();){
            this.accountPage.setAuthRealm(this.testRealm().toRepresentation().getRealm());
            this.accountPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.verifyEmailPage.assertCurrent();
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getLastReceivedMessage();
            String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
            this.driver.navigate().to(verificationUrl.trim());
            this.accountPage.assertCurrent();
        }
    }

    @Test
    public void verifyEmailDuringAuthFlowFirstClickLink() throws IOException, MessagingException {
        try (ServerResourceUpdater u = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(false)).setRequiredActions(new UserModel.RequiredAction[]{UserModel.RequiredAction.VERIFY_EMAIL}).update();){
            this.testRealm().users().get(this.testUserId).executeActionsEmail(Arrays.asList(UserModel.RequiredAction.VERIFY_EMAIL.name()));
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getLastReceivedMessage();
            String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(verificationUrl);
            this.accountPage.setAuthRealm(this.testRealm().toRepresentation().getRealm());
            this.accountPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.verifyEmailPage.assertCurrent();
        }
    }

    @Test
    public void verifyEmailClickLinkRequiredActionsCleared() throws IOException, MessagingException {
        try (ServerResourceUpdater u = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(true)).setRequiredActions(new UserModel.RequiredAction[0]).update();){
            this.testRealm().users().get(this.testUserId).executeActionsEmail(Arrays.asList(UserModel.RequiredAction.VERIFY_EMAIL.name()));
            Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
            MimeMessage message = this.greenMail.getLastReceivedMessage();
            String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
            this.driver.manage().deleteAllCookies();
            this.driver.navigate().to(verificationUrl);
            this.accountPage.setAuthRealm(this.testRealm().toRepresentation().getRealm());
            this.accountPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.accountPage.assertCurrent();
        }
    }

    @Test
    public void verifyEmailDuringAuthFlowAfterLogout() throws IOException, MessagingException {
        try (ServerResourceUpdater u = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(true)).update();){
            this.accountPage.setAuthRealm(this.testRealm().toRepresentation().getRealm());
            this.accountPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.accountPage.assertCurrent();
            this.driver.navigate().to(this.oauth.getLogoutUrl().redirectUri(this.accountPage.buildUri().toString()).build());
            this.loginPage.assertCurrent();
            this.verifyEmailDuringAuthFlow();
        }
    }

    @Test
    public void verifyEmailDuringAuthFlowAfterRefresh() throws IOException, MessagingException {
        try (ServerResourceUpdater u = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(true)).update();){
            String testRealmName = this.testRealm().toRepresentation().getRealm();
            this.accountPage.setAuthRealm(testRealmName);
            this.accountPage.navigateTo();
            this.loginPage.assertCurrent();
            this.loginPage.login("test-user@localhost", "password");
            this.accountPage.assertCurrent();
            this.driver2.navigate().to(this.accountPage.buildUri().toString());
            MatcherAssert.assertThat((Object)this.driver2.getTitle(), (Matcher)Is.is((Object)("Sign in to " + testRealmName)));
            this.driver2.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{"test-user@localhost"});
            this.driver2.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{"password"});
            this.driver2.findElement(By.id((String)"password")).submit();
            MatcherAssert.assertThat((Object)this.driver2.getCurrentUrl(), (Matcher)Matchers.startsWith((String)this.accountPage.buildUri().toString()));
            try (ServerResourceUpdater u1 = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId)).setEmailVerified(Boolean.valueOf(false)).setRequiredActions(new UserModel.RequiredAction[]{UserModel.RequiredAction.VERIFY_EMAIL}).update();){
                this.driver2.navigate().refresh();
                MatcherAssert.assertThat((Object)this.driver2.getCurrentUrl(), (Matcher)Matchers.startsWith((String)this.accountPage.buildUri().toString()));
                this.driver.navigate().to(this.oauth.getLogoutUrl().redirectUri(this.accountPage.buildUri().toString()).build());
                this.accountPage.navigateTo();
                this.loginPage.assertCurrent();
                this.loginPage.login("test-user@localhost", "password");
                this.verifyEmailPage.assertCurrent();
                Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
                MimeMessage message = this.greenMail.getLastReceivedMessage();
                String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
                this.driver2.navigate().to(verificationUrl.trim());
                WebElement proceedLink = this.driver2.findElement(By.linkText((String)"\u00bb Click here to proceed"));
                MatcherAssert.assertThat((Object)proceedLink, (Matcher)Matchers.notNullValue());
                proceedLink.click();
                MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"kc-info-message"));
                MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"Your email address has been verified."));
                this.driver.navigate().refresh();
                this.accountPage.assertCurrent();
            }
        }
    }

    @Test
    public void verifyEmailWhileLoggedIn() throws IOException, MessagingException {
        UserAttributeUpdater userAttributeUpdater = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId));
        userAttributeUpdater.setEmailVerified(Boolean.valueOf(true)).update();
        String testRealmName = this.testRealm().toRepresentation().getRealm();
        this.accountPage.setAuthRealm(testRealmName);
        this.oauth.realm(testRealmName).clientId("account").redirectUri(this.getAuthServerRoot() + "realms/" + testRealmName + "/account");
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.accountPage.assertCurrent();
        userAttributeUpdater.setEmailVerified(Boolean.valueOf(false)).setRequiredActions(new UserModel.RequiredAction[]{UserModel.RequiredAction.VERIFY_EMAIL}).update();
        this.loginPage.open();
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl);
        this.accountPage.assertCurrent();
        UserRepresentation user = this.testRealm().users().get(this.testUserId).toRepresentation();
        Assert.assertTrue((boolean)user.isEmailVerified());
        Assert.assertThat((Object)user.getRequiredActions(), (Matcher)Matchers.empty());
    }

    @Test
    public void verifyEmailViaAuthSessionWhileLoggedIn() throws IOException, MessagingException {
        Assume.assumeTrue((String)"Works only on auth-server-undertow", (boolean)AuthServerTestEnricher.AUTH_SERVER_CONTAINER.equals("auth-server-undertow"));
        UserAttributeUpdater userAttributeUpdater = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId));
        userAttributeUpdater.setEmailVerified(Boolean.valueOf(false)).update();
        String testRealmName = this.testRealm().toRepresentation().getRealm();
        this.accountPage.setAuthRealm(testRealmName);
        this.oauth.realm(testRealmName).clientId("account").redirectUri(this.getAuthServerRoot() + "realms/" + testRealmName + "/account");
        this.loginPage.open();
        String authSessionId = AuthenticationSessionFailoverClusterTest.getAuthSessionCookieValue(this.driver);
        String realmId = this.testRealm().toRepresentation().getId();
        this.testingClient.server().run((RunOnServer & Serializable)session -> {
            RealmModel realm = session.realms().getRealm(realmId);
            RootAuthenticationSessionModel ras = session.authenticationSessions().getRootAuthenticationSession(realm, authSessionId);
            MatcherAssert.assertThat((String)"Expecting single auth session", ras.getAuthenticationSessions().keySet(), (Matcher)Matchers.hasSize((int)1));
            ras.getAuthenticationSessions().forEach((id, as) -> as.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL));
        });
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver.navigate().to(verificationUrl);
        this.accountPage.assertCurrent();
        UserRepresentation user = this.testRealm().users().get(this.testUserId).toRepresentation();
        Assert.assertTrue((boolean)user.isEmailVerified());
        Assert.assertThat((Object)user.getRequiredActions(), (Matcher)Matchers.empty());
    }

    @Test
    public void verifyEmailInNewBrowserWhileLoggedInFirstBrowser() throws IOException, MessagingException {
        UserAttributeUpdater userAttributeUpdater = new UserAttributeUpdater(this.testRealm().users().get(this.testUserId));
        userAttributeUpdater.setEmailVerified(Boolean.valueOf(true)).update();
        String testRealmName = this.testRealm().toRepresentation().getRealm();
        this.accountPage.setAuthRealm(testRealmName);
        this.oauth.realm(testRealmName).clientId("account").redirectUri(this.getAuthServerRoot() + "realms/" + testRealmName + "/account");
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.accountPage.assertCurrent();
        userAttributeUpdater.setEmailVerified(Boolean.valueOf(false)).setRequiredActions(new UserModel.RequiredAction[]{UserModel.RequiredAction.VERIFY_EMAIL}).update();
        this.loginPage.open();
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        this.driver2.navigate().to(verificationUrl);
        WebElement proceedLink = this.driver2.findElement(By.linkText((String)"\u00bb Click here to proceed"));
        MatcherAssert.assertThat((Object)proceedLink, (Matcher)Matchers.notNullValue());
        proceedLink.click();
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"kc-info-message"));
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"Your email address has been verified."));
        WebElement backToApplicationLink = this.driver2.findElement(By.linkText((String)"\u00ab Back to Application"));
        MatcherAssert.assertThat((Object)backToApplicationLink, (Matcher)Matchers.notNullValue());
        backToApplicationLink.click();
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"kc-login"));
        MatcherAssert.assertThat((Object)this.driver2.getPageSource(), (Matcher)Matchers.containsString((String)"Sign in"));
        UserRepresentation user = this.testRealm().users().get(this.testUserId).toRepresentation();
        Assert.assertTrue((boolean)user.isEmailVerified());
        Assert.assertThat((Object)user.getRequiredActions(), (Matcher)Matchers.empty());
        this.driver.navigate().refresh();
        this.accountPage.assertCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyEmailExpiredRegistration() throws IOException, MessagingException {
        String COMMON_ATTR = "verifyEmailRegistrationUser";
        String appInitiatedRegisterUrl = this.oauth.getLoginFormUrl();
        appInitiatedRegisterUrl = appInitiatedRegisterUrl.replace("openid-connect/auth", "openid-connect/registrations");
        this.driver.navigate().to(appInitiatedRegisterUrl);
        this.registerPage.assertCurrent();
        this.registerPage.register("verifyEmailRegistrationUser", "verifyEmailRegistrationUser", "verifyEmailRegistrationUser@verifyEmailRegistrationUser", "verifyEmailRegistrationUser", "verifyEmailRegistrationUser", "verifyEmailRegistrationUser");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getLastReceivedMessage();
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        try {
            this.setTimeOffset(3600);
            this.driver.navigate().to(verificationUrl.trim());
            this.loginPage.assertCurrent();
            Assert.assertEquals((Object)"Action expired. Please start again.", (Object)this.loginPage.getError());
        }
        finally {
            this.setTimeOffset(0);
        }
    }

    @Test
    public void changeEmailAddressAfterSendingEmail() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.verifyEmailPage.assertCurrent();
        Assert.assertEquals((long)1L, (long)this.greenMail.getReceivedMessages().length);
        MimeMessage message = this.greenMail.getReceivedMessages()[0];
        String verificationUrl = RequiredActionEmailVerificationTest.getPasswordResetEmailLink(message);
        UserResource user = this.testRealm().users().get(this.testUserId);
        UserRepresentation userRep = user.toRepresentation();
        userRep.setEmail("vmuzikar@redhat.com");
        user.update(userRep);
        this.driver.navigate().to(verificationUrl.trim());
        this.errorPage.assertCurrent();
        Assert.assertEquals((Object)"The link you clicked is an old stale link and is no longer valid. Maybe you have already verified your email.", (Object)this.errorPage.getError());
    }
}

