/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.actions.ActionUtil;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.auth.page.login.DeleteAccountActionConfirmPage;
import org.keycloak.testsuite.pages.ErrorPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.UserBuilder;

public class DeleteAccountActionTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public AssertEvents events = new AssertEvents(this);
    @Page
    public DeleteAccountActionConfirmPage deleteAccountPage;
    @Page
    protected LoginPage loginPage;
    @Page
    protected ErrorPage errorPage;

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
    }

    @Before
    public void setUpAction() {
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        UserBuilder.edit(user).requiredAction("delete_account");
        this.testRealm().users().get(user.getId()).update(user);
        this.addDeleteAccountRoleToUserClientRoles();
        RequiredActionProviderRepresentation rep = this.testRealm().flows().getRequiredAction("delete_account");
        rep.setEnabled(true);
        this.adminClient.realm("test").flows().updateRequiredAction("delete_account", rep);
    }

    @Test
    public void deleteAccountActionSucceeds() {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.deleteAccountPage.isCurrent());
        this.deleteAccountPage.clickConfirmAction();
        this.events.expect(EventType.DELETE_ACCOUNT);
        List users = this.testRealm().users().search("test-user@localhost");
        Assert.assertEquals((long)users.size(), (long)0L);
    }

    @Test
    public void deleteAccountFailsWithoutRoleFails() {
        this.removeDeleteAccountRoleFromUserClientRoles();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        Assert.assertTrue((boolean)this.errorPage.isCurrent());
        Assert.assertEquals((Object)this.errorPage.getError(), (Object)"You do not have enough permissions to delete your own account, contact admin.");
    }

    private void addDeleteAccountRoleToUserClientRoles() {
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        ApiUtil.assignClientRoles((RealmResource)this.adminClient.realm("test"), (String)user.getId(), (String)"account", (String[])new String[]{"delete-account"});
    }

    private void removeDeleteAccountRoleFromUserClientRoles() {
        UserRepresentation user = ActionUtil.findUserWithAdminClient(this.adminClient, "test-user@localhost");
        UserResource userResource = this.testRealm().users().get(user.getId());
        ClientRepresentation clientRepresentation = (ClientRepresentation)this.testRealm().clients().findByClientId("account").get(0);
        String deleteRoleId = userResource.roles().clientLevel(clientRepresentation.getId()).listAll().stream().filter(role -> Objects.equals(role.getName(), "delete-account")).findFirst().get().getId();
        RoleRepresentation deleteRole = new RoleRepresentation();
        deleteRole.setName("delete-account");
        deleteRole.setId(deleteRoleId);
        userResource.roles().clientLevel(clientRepresentation.getId()).remove(Arrays.asList(deleteRole));
    }
}

