/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.common.Profile;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.HmacOTP;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.actions.AbstractAppInitiatedActionTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.DisableFeature;
import org.keycloak.testsuite.pages.AccountTotpPage;
import org.keycloak.testsuite.pages.LoginConfigTotpPage;
import org.keycloak.testsuite.pages.LoginTotpPage;
import org.keycloak.testsuite.pages.RegisterPage;
import org.keycloak.testsuite.util.RealmBuilder;
import org.keycloak.testsuite.util.UserBuilder;
import org.openqa.selenium.By;

public class AppInitiatedActionTotpSetupTest
extends AbstractAppInitiatedActionTest {
    @Page
    protected LoginTotpPage loginTotpPage;
    @Page
    protected LoginConfigTotpPage totpPage;
    @Page
    protected AccountTotpPage accountTotpPage;
    @Page
    protected RegisterPage registerPage;
    protected TimeBasedOTP totp = new TimeBasedOTP();

    public AppInitiatedActionTotpSetupTest() {
        super(UserModel.RequiredAction.CONFIGURE_TOTP.name());
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setResetPasswordAllowed(Boolean.TRUE);
    }

    @Before
    public void setOTPAuthRequired() {
        this.adminClient.realm("test").flows().getExecutions("browser").stream().filter(execution -> execution.getDisplayName().equals("Browser - Conditional OTP")).forEach(execution -> {
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED.name());
            this.adminClient.realm("test").flows().updateExecutions("browser", execution);
        });
        ApiUtil.removeUserByUsername((RealmResource)this.testRealm(), (String)"test-user@localhost");
        UserRepresentation user = UserBuilder.create().enabled(true).username("test-user@localhost").email("test-user@localhost").firstName("Tom").lastName("Brady").build();
        ApiUtil.createUserAndResetPasswordWithAdminClient((RealmResource)this.testRealm(), (UserRepresentation)user, (String)"password");
    }

    @Test
    public void setupTotpRegister() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "email@mail.com", "setupTotp", "password", "password");
        String userId = this.events.expectRegister("setupTotp", "email@mail.com").assertEvent().getUserId();
        this.doAIA();
        Assert.assertTrue((boolean)this.totpPage.isCurrent());
        this.totpPage.configure(this.totp.generateTOTP(this.totpPage.getTotpSecret()));
        this.events.poll();
        String authSessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setuptotp").assertEvent().getDetails().get("code_id");
        this.assertKcActionStatus("success");
        this.events.expectLogin().user(userId).session(authSessionId).detail("username", "setuptotp").assertEvent();
    }

    @Test
    public void cancelSetupTotp() throws Exception {
        try {
            this.preConfigureRealmForCancelSetupTotpTest();
            this.doAIA();
            this.loginPage.login("test-user@localhost", "password");
            this.assertKcActionStatus("error");
        }
        finally {
            this.postConfigureRealmForCancelSetupTotpTest();
        }
    }

    private void preConfigureRealmForCancelSetupTotpTest() {
        this.configureRealmEnableRequiredActionByAlias("CONFIGURE_TOTP", false);
        this.configureRealmSetExecutionRequirementByDisplayName("browser", "Browser - Conditional OTP", AuthenticationExecutionModel.Requirement.CONDITIONAL);
        this.configureRealmSetExecutionRequirementByDisplayName("browser", "Condition - user configured", AuthenticationExecutionModel.Requirement.DISABLED);
        this.configureRealmSetExecutionRequirementByDisplayName("browser", "OTP Form", AuthenticationExecutionModel.Requirement.ALTERNATIVE);
    }

    private void postConfigureRealmForCancelSetupTotpTest() {
        this.configureRealmEnableRequiredActionByAlias("CONFIGURE_TOTP", true);
        List<String> executionDisplayNames = Arrays.asList("Browser - Conditional OTP", "Condition - user configured", "OTP Form");
        executionDisplayNames.stream().forEach(name -> this.configureRealmSetExecutionRequirementByDisplayName("browser", (String)name, AuthenticationExecutionModel.Requirement.REQUIRED));
    }

    protected void configureRealmEnableRequiredActionByAlias(String alias, boolean value) {
        this.adminClient.realm("test").flows().getRequiredActions().stream().filter(action -> action.getAlias().equals(alias)).forEach(action -> {
            action.setEnabled(value);
            this.adminClient.realm("test").flows().updateRequiredAction(alias, action);
        });
    }

    protected void configureRealmSetExecutionRequirementByDisplayName(String flowAlias, String executionDisplayName, AuthenticationExecutionModel.Requirement value) {
        this.adminClient.realm("test").flows().getExecutions(flowAlias).stream().filter(execution -> execution.getDisplayName().equals(executionDisplayName)).forEach(execution -> {
            execution.setRequirement(value.name());
            this.adminClient.realm("test").flows().updateExecutions(flowAlias, execution);
        });
    }

    @Test
    public void setupTotpRegisterManual() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "checkQrCode@mail.com", "checkQrCode", "password", "password");
        this.doAIA();
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.clickManual();
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
        Assert.assertTrue((boolean)this.driver.findElement(By.id((String)"kc-totp-secret-key")).getText().matches("[\\w]{4}( [\\w]{4}){7}"));
        Assert.assertEquals((Object)"Type: Time-based", (Object)this.driver.findElement(By.id((String)"kc-totp-type")).getText());
        Assert.assertEquals((Object)"Algorithm: SHA1", (Object)this.driver.findElement(By.id((String)"kc-totp-algorithm")).getText());
        Assert.assertEquals((Object)"Digits: 6", (Object)this.driver.findElement(By.id((String)"kc-totp-digits")).getText());
        Assert.assertEquals((Object)"Interval: 30", (Object)this.driver.findElement(By.id((String)"kc-totp-period")).getText());
        this.totpPage.clickBarcode();
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Install one of the following applications on your mobile"));
        Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
        Assert.assertTrue((boolean)pageSource.contains("Google Authenticator"));
        Assert.assertTrue((boolean)pageSource.contains("Open the application and scan the barcode"));
        Assert.assertFalse((boolean)pageSource.contains("Open the application and enter the key"));
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
    }

    @Test
    public void setupTotpRegisterManualModeSwitchesOnBadSubmit() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "setupTotpRegisterManualModeSwitchesOnBadSubmit@mail.com", "setupTotpRegisterManualModeSwitchesOnBadSubmit", "password", "password");
        this.doAIA();
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.clickManual();
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.submit();
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
        Assert.assertEquals((Object)"Please specify authenticator code.", (Object)this.totpPage.getInputCodeError());
    }

    @Test
    public void setupTotpRegisterBarcodeModeSwitchesOnBadSubmit() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName", "lastName", "setupTotpRegisterBarcodeModeSwitchesOnBadSubmit@mail.com", "setupTotpRegisterBarcodeModeSwitchesOnBadSubmit", "password", "password");
        this.doAIA();
        String pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        this.totpPage.submit();
        pageSource = this.driver.getPageSource();
        Assert.assertTrue((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertFalse((boolean)pageSource.contains("Scan barcode?"));
        Assert.assertEquals((Object)"Please specify authenticator code.", (Object)this.totpPage.getInputCodeError());
        this.totpPage.clickManual();
        pageSource = this.driver.getPageSource();
        Assert.assertFalse((boolean)pageSource.contains("Unable to scan?"));
        Assert.assertTrue((boolean)pageSource.contains("Scan barcode?"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setupTotpModifiedPolicy() {
        RealmResource realm = this.testRealm();
        RealmRepresentation rep = realm.toRepresentation();
        rep.setOtpPolicyDigits(Integer.valueOf(8));
        rep.setOtpPolicyType("hotp");
        rep.setOtpPolicyAlgorithm("HmacSHA256");
        realm.update(rep);
        try {
            this.loginPage.open();
            this.loginPage.clickRegister();
            this.registerPage.register("firstName", "lastName", "setupTotpModifiedPolicy@mail.com", "setupTotpModifiedPolicy", "password", "password");
            this.doAIA();
            String pageSource = this.driver.getPageSource();
            Assert.assertTrue((boolean)pageSource.contains("FreeOTP"));
            Assert.assertFalse((boolean)pageSource.contains("Google Authenticator"));
            this.totpPage.clickManual();
            Assert.assertEquals((Object)"Type: Counter-based", (Object)this.driver.findElement(By.id((String)"kc-totp-type")).getText());
            Assert.assertEquals((Object)"Algorithm: SHA256", (Object)this.driver.findElement(By.id((String)"kc-totp-algorithm")).getText());
            Assert.assertEquals((Object)"Digits: 8", (Object)this.driver.findElement(By.id((String)"kc-totp-digits")).getText());
            Assert.assertEquals((Object)"Counter: 0", (Object)this.driver.findElement(By.id((String)"kc-totp-counter")).getText());
        }
        finally {
            rep.setOtpPolicyDigits(Integer.valueOf(6));
            rep.setOtpPolicyType("totp");
            rep.setOtpPolicyAlgorithm("HmacSHA1");
            realm.update(rep);
        }
    }

    @Test
    public void setupTotpExisting() {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpSecret));
        String authSessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getDetails().get("code_id");
        this.assertKcActionStatus("success");
        EventRepresentation loginEvent = this.events.expectLogin().session(authSessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(authSessionId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.loginTotpPage.login(this.totp.generateTOTP(totpSecret));
        this.events.expectLogin().assertEvent();
    }

    @Test
    @DisableFeature(value=Profile.Feature.ACCOUNT2, skipRestart=true)
    public void setupTotpRegisteredAfterTotpRemoval() {
        this.loginPage.open();
        this.loginPage.clickRegister();
        this.registerPage.register("firstName2", "lastName2", "email2@mail.com", "setupTotp2", "password2", "password2");
        String userId = this.events.expectRegister("setupTotp2", "email2@mail.com").assertEvent().getUserId();
        this.doAIA();
        this.totpPage.assertCurrent();
        String totpCode = this.totpPage.getTotpSecret();
        this.totpPage.configure(this.totp.generateTOTP(totpCode));
        this.assertKcActionStatus("success");
        this.events.poll();
        this.events.expectRequiredAction(EventType.UPDATE_TOTP).user(userId).detail("username", "setuptotp2").assertEvent();
        EventRepresentation loginEvent = this.events.expectLogin().user(userId).detail("username", "setuptotp2").assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).user(userId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("setupTotp2", "password2");
        String uri = this.driver.getCurrentUrl();
        String src = this.driver.getPageSource();
        Assert.assertTrue((boolean)this.loginPage.isCurrent());
        Assert.assertFalse((boolean)this.totpPage.isCurrent());
        this.loginTotpPage.login(this.totp.generateTOTP(totpCode));
        loginEvent = this.events.expectLogin().user(userId).detail("username", "setupTotp2").assertEvent();
        this.accountTotpPage.open();
        this.accountTotpPage.assertCurrent();
        this.accountTotpPage.removeTotp();
        this.events.expectAccount(EventType.REMOVE_TOTP).user(userId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).user(userId).assertEvent();
        this.loginPage.open();
        this.loginPage.login("setupTotp2", "password2");
    }

    @Test
    public void setupOtpPolicyChangedTotp8Digits() {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(1).otpDigits(8).otpPeriod(30).otpType("totp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        TimeBasedOTP timeBased = new TimeBasedOTP("HmacSHA1", 8, 30, 1);
        this.totpPage.configure(timeBased.generateTOTP(totpSecret));
        String sessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getDetails().get("code_id");
        this.assertKcActionStatus("success");
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String src = this.driver.getPageSource();
        String token = timeBased.generateTOTP(totpSecret);
        Assert.assertEquals((long)8L, (long)token.length());
        this.loginTotpPage.login(token);
        this.assertKcActionStatus(null);
        this.events.expectLogin().assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpDigits(6);
        this.adminClient.realm("test").update(realmRep);
    }

    @Test
    public void setupOtpPolicyChangedHotp() {
        RealmRepresentation realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(0).otpDigits(6).otpPeriod(30).otpType("hotp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.totpPage.assertCurrent();
        String totpSecret = this.totpPage.getTotpSecret();
        HmacOTP otpgen = new HmacOTP(6, "HmacSHA1", 1);
        this.totpPage.configure(otpgen.generateHOTP(totpSecret, 0));
        String sessionId = (String)this.events.expectRequiredAction(EventType.UPDATE_TOTP).assertEvent().getDetails().get("code_id");
        this.assertKcActionStatus("success");
        EventRepresentation loginEvent = this.events.expectLogin().session(sessionId).assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        String token = otpgen.generateHOTP(totpSecret, 1);
        this.loginTotpPage.login(token);
        this.assertKcActionStatus(null);
        this.events.expectLogin().assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(null).session(AssertEvents.isUUID()).assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(5).otpDigits(6).otpPeriod(30).otpType("hotp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        token = otpgen.generateHOTP(totpSecret, 4);
        this.loginTotpPage.assertCurrent();
        this.loginTotpPage.login(token);
        this.assertKcActionStatus(null);
        this.events.expectLogin().assertEvent();
        realmRep = this.adminClient.realm("test").toRepresentation();
        RealmBuilder.edit(realmRep).otpLookAheadWindow(1).otpDigits(6).otpPeriod(30).otpType("totp").otpAlgorithm("HmacSHA1").otpInitialCounter(0);
        this.adminClient.realm("test").update(realmRep);
    }
}

