/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.List;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.events.EventType;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.testsuite.actions.AbstractAppInitiatedActionTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.pages.LoginPasswordUpdatePage;
import org.keycloak.testsuite.util.GreenMailRule;
import org.keycloak.testsuite.util.OAuthClient;
import org.keycloak.testsuite.util.SecondBrowser;
import org.openqa.selenium.WebDriver;

public class AppInitiatedActionResetPasswordTest
extends AbstractAppInitiatedActionTest {
    @Rule
    public GreenMailRule greenMail = new GreenMailRule();
    @Page
    protected LoginPasswordUpdatePage changePasswordPage;
    @Drone
    @SecondBrowser
    private WebDriver driver2;

    public AppInitiatedActionResetPasswordTest() {
        super(UserModel.RequiredAction.UPDATE_PASSWORD.name());
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.setResetPasswordAllowed(Boolean.TRUE);
    }

    @After
    public void after() {
        ApiUtil.resetUserPassword((UserResource)this.testRealm().users().get(this.findUser("test-user@localhost").getId()), (String)"password", (boolean)false);
    }

    @Test
    public void resetPassword() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        this.doAIA();
        this.changePasswordPage.assertCurrent();
        Assert.assertTrue((boolean)this.changePasswordPage.isCancelDisplayed());
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.assertKcActionStatus("success");
        EventRepresentation loginEvent = this.events.expectLogin().assertEvent();
        this.oauth.openLogout();
        this.events.expectLogout(loginEvent.getSessionId()).assertEvent();
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "new-password");
        this.events.expectLogin().assertEvent();
    }

    @Test
    public void resetPasswordRequiresReAuth() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        this.setTimeOffset(350);
        this.doAIA();
        this.loginPage.assertCurrent();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        Assert.assertTrue((boolean)this.changePasswordPage.isCancelDisplayed());
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.assertKcActionStatus("success");
    }

    @Test
    public void cancelChangePassword() throws Exception {
        this.doAIA();
        this.loginPage.login("test-user@localhost", "password");
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.cancel();
        this.assertKcActionStatus("cancelled");
    }

    @Test
    public void resetPasswordUserHasUpdatePasswordRequiredAction() throws Exception {
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        UserResource userResource = this.testRealm().users().get(this.findUser("test-user@localhost").getId());
        UserRepresentation userRep = userResource.toRepresentation();
        userRep.getRequiredActions().add(UserModel.RequiredAction.UPDATE_PASSWORD.name());
        userResource.update(userRep);
        this.events.expectLogin().assertEvent();
        this.doAIA();
        this.changePasswordPage.assertCurrent();
        Assert.assertFalse((boolean)this.changePasswordPage.isCancelDisplayed());
        this.changePasswordPage.changePassword("new-password", "new-password");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.assertKcActionStatus("success");
    }

    @Test
    public void checkLogoutSessions() {
        OAuthClient oauth2 = new OAuthClient();
        oauth2.init(this.driver2);
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        UserResource testUser = this.testRealm().users().get(this.findUser("test-user@localhost").getId());
        List sessions = testUser.getUserSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        String firstSessionId = ((UserSessionRepresentation)sessions.get(0)).getId();
        oauth2.doLogin("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        Assert.assertEquals((long)2L, (long)testUser.getUserSessions().size());
        this.doAIA();
        this.changePasswordPage.assertCurrent();
        Assert.assertTrue((String)"Logout sessions is checked by default", (boolean)this.changePasswordPage.isLogoutSessionsChecked());
        this.changePasswordPage.changePassword("All Right Then, Keep Your Secrets", "All Right Then, Keep Your Secrets");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.assertKcActionStatus("success");
        sessions = testUser.getUserSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        Assert.assertEquals((String)"Old session is still valid", (Object)firstSessionId, (Object)((UserSessionRepresentation)sessions.get(0)).getId());
    }

    @Test
    public void uncheckLogoutSessions() {
        OAuthClient oauth2 = new OAuthClient();
        oauth2.init(this.driver2);
        UserResource testUser = this.testRealm().users().get(this.findUser("test-user@localhost").getId());
        this.loginPage.open();
        this.loginPage.login("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        oauth2.doLogin("test-user@localhost", "password");
        this.events.expectLogin().assertEvent();
        Assert.assertEquals((long)2L, (long)testUser.getUserSessions().size());
        this.doAIA();
        this.changePasswordPage.assertCurrent();
        this.changePasswordPage.uncheckLogoutSessions();
        this.changePasswordPage.changePassword("All Right Then, Keep Your Secrets", "All Right Then, Keep Your Secrets");
        this.events.expectRequiredAction(EventType.UPDATE_PASSWORD).assertEvent();
        this.assertKcActionStatus("success");
        Assert.assertEquals((long)2L, (long)testUser.getUserSessions().size());
    }
}

