/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.util.LinkedList;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.RequiredActionProviderRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.util.UserBuilder;

public class ActionUtil {
    public static UserRepresentation findUserInRealmRep(RealmRepresentation testRealm, String username) {
        for (UserRepresentation rep : testRealm.getUsers()) {
            if (!rep.getUsername().equals(username)) continue;
            return rep;
        }
        return null;
    }

    public static UserRepresentation findUserWithAdminClient(Keycloak adminClient, String username) {
        return (UserRepresentation)adminClient.realm("test").users().search(username, null, null, null, Integer.valueOf(0), Integer.valueOf(1)).get(0);
    }

    public static void addRequiredActionForUser(RealmRepresentation testRealm, String userName, String action) {
        UserRepresentation user = ActionUtil.findUserInRealmRep(testRealm, userName);
        UserBuilder.edit(user).requiredAction(action);
    }

    public static void addRequiredActionForRealm(RealmRepresentation testRealm, String providerId) {
        LinkedList<RequiredActionProviderRepresentation> requiredActions = testRealm.getRequiredActions();
        if (requiredActions == null) {
            requiredActions = new LinkedList<RequiredActionProviderRepresentation>();
        }
        RequiredActionProviderRepresentation last = (RequiredActionProviderRepresentation)requiredActions.get(requiredActions.size() - 1);
        RequiredActionProviderRepresentation action = new RequiredActionProviderRepresentation();
        action.setAlias(providerId);
        action.setProviderId(providerId);
        action.setEnabled(true);
        action.setDefaultAction(true);
        action.setPriority(last.getPriority() + 1);
        requiredActions.add(action);
        testRealm.setRequiredActions(requiredActions);
    }
}

