/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.actions;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.arquillian.graphene.page.Page;
import org.junit.Rule;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.pages.AppPage;
import org.keycloak.testsuite.pages.LoginPage;
import org.keycloak.testsuite.util.ServerURLs;
import org.keycloak.testsuite.util.WaitUtils;

public abstract class AbstractAppInitiatedActionTest
extends AbstractTestRealmKeycloakTest {
    @Page
    protected LoginPage loginPage;
    @Page
    protected AppPage appPage;
    @Rule
    public AssertEvents events = new AssertEvents(this);
    protected final String aiaAction;

    public AbstractAppInitiatedActionTest(String aiaAction) {
        this.aiaAction = aiaAction;
    }

    protected void doAIA() {
        UriBuilder builder = OIDCLoginProtocolService.authUrl((UriBuilder)this.authServerPage.createUriBuilder());
        String uri = builder.queryParam("kc_action", new Object[]{this.aiaAction}).queryParam("response_type", new Object[]{"code"}).queryParam("client_id", new Object[]{"test-app"}).queryParam("scope", new Object[]{"openid"}).queryParam("redirect_uri", new Object[]{ServerURLs.getAuthServerContextRoot() + "/auth/realms/master/app/auth"}).build(new Object[]{"test"}).toString();
        this.driver.navigate().to(uri);
        WaitUtils.waitForPageToLoad();
    }

    protected void assertKcActionStatus(String expectedStatus) {
        URI url;
        MatcherAssert.assertThat((Object)this.appPage.getRequestType(), (Matcher)CoreMatchers.is((Object)AppPage.RequestType.AUTH_RESPONSE));
        try {
            url = new URI(this.driver.getCurrentUrl());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        List pairs = URLEncodedUtils.parse((URI)url, (Charset)StandardCharsets.UTF_8);
        String kcActionStatus = null;
        for (NameValuePair p : pairs) {
            if (!p.getName().equals("kc_action_status")) continue;
            kcActionStatus = p.getValue();
            break;
        }
        MatcherAssert.assertThat((Object)expectedStatus, (Matcher)CoreMatchers.is(kcActionStatus));
    }

    protected void assertSilentCancelMessage() {
        String url = this.driver.getCurrentUrl();
        MatcherAssert.assertThat((String)"Expected no 'error=' in url", (Object)url, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"error=")));
        MatcherAssert.assertThat((String)"Expected no 'error_description=' in url", (Object)url, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"error_description=")));
    }
}

