/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.representations.account.AccountLinkUriRepresentation;
import org.keycloak.representations.account.LinkedAccountRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.AbstractTestRealmKeycloakTest;
import org.keycloak.testsuite.AssertEvents;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;
import org.keycloak.testsuite.util.IdentityProviderBuilder;
import org.keycloak.testsuite.util.TokenUtil;
import org.keycloak.testsuite.util.UserBuilder;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class LinkedAccountsRestServiceTest
extends AbstractTestRealmKeycloakTest {
    @Rule
    public TokenUtil tokenUtil = new TokenUtil();
    @Rule
    public AssertEvents events = new AssertEvents(this);
    private CloseableHttpClient client;

    @Before
    public void before() {
        this.client = HttpClientBuilder.create().build();
    }

    @After
    public void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void configureTestRealm(RealmRepresentation testRealm) {
        testRealm.getUsers().add(UserBuilder.create().username("no-account-access").password("password").build());
        testRealm.getUsers().add(UserBuilder.create().username("view-account-access").role("account", "view-profile").password("password").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("github").alias("github").setAttribute("guiOrder", "2").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("saml").alias("mysaml").setAttribute("guiOrder", "0").build());
        testRealm.addIdentityProvider(IdentityProviderBuilder.create().providerId("oidc").alias("myoidc").displayName("MyOIDC").setAttribute("guiOrder", "1").build());
        this.addGitHubIdentity(testRealm);
    }

    private void addGitHubIdentity(RealmRepresentation testRealm) {
        UserRepresentation acctMgtUser = this.findUser(testRealm, "test-user@localhost");
        FederatedIdentityRepresentation fedIdp = new FederatedIdentityRepresentation();
        fedIdp.setIdentityProvider("github");
        fedIdp.setUserId("foo");
        fedIdp.setUserName("foo");
        ArrayList<FederatedIdentityRepresentation> fedIdps = new ArrayList<FederatedIdentityRepresentation>();
        fedIdps.add(fedIdp);
        acctMgtUser.setFederatedIdentities(fedIdps);
    }

    private UserRepresentation findUser(RealmRepresentation testRealm, String userName) {
        for (UserRepresentation user : testRealm.getUsers()) {
            if (!user.getUsername().equals(userName)) continue;
            return user;
        }
        return null;
    }

    private String getAccountUrl(String resource) {
        return this.suiteContext.getAuthServerInfo().getContextRoot().toString() + "/auth/realms/test/account" + (resource != null ? "/" + resource : "");
    }

    private SortedSet<LinkedAccountRepresentation> linkedAccountsRep() throws IOException {
        return (SortedSet)SimpleHttp.doGet((String)this.getAccountUrl("linked-accounts"), (HttpClient)this.client).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<SortedSet<LinkedAccountRepresentation>>(){});
    }

    private LinkedAccountRepresentation findLinkedAccount(String providerAlias) throws IOException {
        for (LinkedAccountRepresentation account : this.linkedAccountsRep()) {
            if (!account.getProviderAlias().equals(providerAlias)) continue;
            return account;
        }
        return null;
    }

    @Test
    @AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
    public void testBuildLinkedAccountUri() throws IOException {
        AccountLinkUriRepresentation rep = (AccountLinkUriRepresentation)SimpleHttp.doGet((String)this.getAccountUrl("linked-accounts/github?redirectUri=phonyUri"), (HttpClient)this.client).auth(this.tokenUtil.getToken()).asJson((TypeReference)new TypeReference<AccountLinkUriRepresentation>(){});
        URI brokerUri = rep.getAccountLinkUri();
        Assert.assertTrue((boolean)brokerUri.getPath().endsWith("/auth/realms/test/broker/github/link"));
        List queryParams = URLEncodedUtils.parse((URI)brokerUri, (Charset)Charset.defaultCharset());
        Assert.assertEquals((long)4L, (long)queryParams.size());
        for (NameValuePair nvp : queryParams) {
            switch (nvp.getName()) {
                case "nonce": {
                    Assert.assertNotNull((Object)nvp.getValue());
                    Assert.assertEquals((Object)rep.getNonce(), (Object)nvp.getValue());
                    break;
                }
                case "hash": {
                    Assert.assertNotNull((Object)nvp.getValue());
                    Assert.assertEquals((Object)rep.getHash(), (Object)nvp.getValue());
                    break;
                }
                case "client_id": {
                    Assert.assertEquals((Object)"account-console", (Object)nvp.getValue());
                    break;
                }
                case "redirect_uri": {
                    Assert.assertEquals((Object)"phonyUri", (Object)nvp.getValue());
                }
            }
        }
    }

    @Test
    public void testGetLinkedAccounts() throws IOException {
        SortedSet<LinkedAccountRepresentation> details = this.linkedAccountsRep();
        Assert.assertEquals((long)3L, (long)details.size());
        int order = 0;
        for (LinkedAccountRepresentation account : details) {
            if (account.getProviderAlias().equals("github")) {
                Assert.assertTrue((boolean)account.isConnected());
            } else {
                Assert.assertFalse((boolean)account.isConnected());
            }
            if (order == 0) {
                Assert.assertEquals((Object)"mysaml", (Object)account.getDisplayName());
            }
            if (order == 1) {
                Assert.assertEquals((Object)"MyOIDC", (Object)account.getDisplayName());
            }
            if (order == 2) {
                Assert.assertEquals((Object)"GitHub", (Object)account.getDisplayName());
            }
            ++order;
        }
    }

    @Test
    public void testRemoveLinkedAccount() throws IOException {
        Assert.assertTrue((boolean)this.findLinkedAccount("github").isConnected());
        SimpleHttp.doDelete((String)this.getAccountUrl("linked-accounts/github"), (HttpClient)this.client).auth(this.tokenUtil.getToken()).acceptJson().asResponse();
        Assert.assertFalse((boolean)this.findLinkedAccount("github").isConnected());
    }
}

