/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.account;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.BadRequestException;
import org.apache.http.client.HttpClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.representations.idm.ErrorRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.account.AbstractRestServiceTest;
import org.keycloak.testsuite.admin.ApiUtil;
import org.keycloak.testsuite.arquillian.annotation.AuthServerContainerExclude;

@AuthServerContainerExclude(value={AuthServerContainerExclude.AuthServer.REMOTE})
public class AccountRestServiceReadOnlyAttributesTest
extends AbstractRestServiceTest {
    private static final Logger logger = Logger.getLogger(AccountRestServiceReadOnlyAttributesTest.class);

    @Test
    public void testUpdateProfileCannotUpdateReadOnlyAttributes() throws IOException {
        this.testAccountUpdateAttributeExpectFailure("usercertificate");
        this.testAccountUpdateAttributeExpectFailure("uSErCertificate");
        this.testAccountUpdateAttributeExpectFailure("KERBEROS_PRINCIPAL", true);
        this.testAccountUpdateAttributeExpectSuccess("noKerberos_Principal");
        this.testAccountUpdateAttributeExpectSuccess("KERBEROS_PRINCIPALno");
        this.testAccountUpdateAttributeExpectFailure("enabled");
        this.testAccountUpdateAttributeExpectFailure("CREATED_TIMESTAMP", true);
        this.testAccountUpdateAttributeExpectSuccess("saml.something");
        this.testAccountUpdateAttributeExpectFailure("deniedfoo");
        this.testAccountUpdateAttributeExpectFailure("deniedFOo");
        this.testAccountUpdateAttributeExpectSuccess("deniedFoot");
        this.testAccountUpdateAttributeExpectFailure("deniedbar");
        this.testAccountUpdateAttributeExpectFailure("deniedBAr");
        this.testAccountUpdateAttributeExpectFailure("deniedBArr");
        this.testAccountUpdateAttributeExpectFailure("deniedbarrier");
        this.testAccountUpdateAttributeExpectSuccess("nodeniedbar");
        this.testAccountUpdateAttributeExpectSuccess("nodeniedBARrier");
        this.testAccountUpdateAttributeExpectFailure("saml.persistent.name.id.for.foo");
        this.testAccountUpdateAttributeExpectFailure("saml.persistent.name.id.for._foo_");
        this.testAccountUpdateAttributeExpectSuccess("saml.persistent.name.idafor.foo");
        this.testAccountUpdateAttributeExpectFailure("deniedsome/thing");
        this.testAccountUpdateAttributeExpectFailure("deniedsome*thing");
        this.testAccountUpdateAttributeExpectSuccess("deniedsomeithing");
        this.testAccountUpdateAttributeExpectSuccess("deniedSomeAdmin");
    }

    private void testAccountUpdateAttributeExpectFailure(String attrName) throws IOException {
        this.testAccountUpdateAttributeExpectFailure(attrName, false);
    }

    private void testAccountUpdateAttributeExpectFailure(String attrName, boolean deniedForAdminAsWell) throws IOException {
        org.keycloak.representations.account.UserRepresentation user = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertThat(user.getAttributes().keySet(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{attrName})));
        user.singleAttribute(attrName, "foo");
        this.updateError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        UserResource adminUserResource = null;
        UserRepresentation adminUserRep = null;
        try {
            adminUserResource = ApiUtil.findUserByUsernameId((RealmResource)this.testRealm(), (String)user.getUsername());
            adminUserRep = adminUserResource.toRepresentation();
            adminUserRep.singleAttribute(attrName, "foo");
            adminUserResource.update(adminUserRep);
            if (deniedForAdminAsWell) {
                Assert.fail((String)("Not expected to update attribute " + attrName + " by admin REST API"));
            }
        }
        catch (BadRequestException bre) {
            if (!deniedForAdminAsWell) {
                Assert.fail((String)("Was expected to update attribute " + attrName + " by admin REST API"));
            }
            return;
        }
        user = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertEquals((Object)"foo", ((List)user.getAttributes().get(attrName)).get(0));
        user.singleAttribute("someOtherAttr", "foo");
        user = this.updateAndGet(user);
        user.singleAttribute(attrName, "foo-updated");
        this.updateError(user, 400, "updateReadOnlyAttributesRejectedMessage");
        user.getAttributes().remove(attrName);
        user = this.updateAndGet(user);
        Assert.assertTrue((boolean)user.getAttributes().containsKey(attrName));
        adminUserRep.getAttributes().remove(attrName);
        adminUserRep.getAttributes().remove("someOtherAttr");
        adminUserResource.update(adminUserRep);
    }

    private void testAccountUpdateAttributeExpectSuccess(String attrName) throws IOException {
        org.keycloak.representations.account.UserRepresentation user = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertThat(user.getAttributes().keySet(), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{attrName})));
        user.singleAttribute(attrName, "foo");
        user = this.updateAndGet(user);
        user = (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
        Assert.assertEquals((Object)"foo", ((List)user.getAttributes().get(attrName)).get(0));
        user.singleAttribute("someOtherAttr", "foo");
        user = this.updateAndGet(user);
        user.singleAttribute(attrName, "foo-updated");
        user = this.updateAndGet(user);
        user.getAttributes().remove(attrName);
        user = this.updateAndGet(user);
        user.getAttributes().remove("foo");
        user.getAttributes().remove("someOtherAttr");
        user = this.updateAndGet(user);
    }

    private org.keycloak.representations.account.UserRepresentation updateAndGet(org.keycloak.representations.account.UserRepresentation user) throws IOException {
        int status = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asStatus();
        Assert.assertEquals((long)204L, (long)status);
        return (org.keycloak.representations.account.UserRepresentation)SimpleHttp.doGet((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).asJson(org.keycloak.representations.account.UserRepresentation.class);
    }

    private void updateError(org.keycloak.representations.account.UserRepresentation user, int expectedStatus, String expectedMessage) throws IOException {
        SimpleHttp.Response response = SimpleHttp.doPost((String)this.getAccountUrl(null), (HttpClient)this.httpClient).auth(this.tokenUtil.getToken()).json((Object)user).asResponse();
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        Assert.assertEquals((Object)expectedMessage, (Object)((ErrorRepresentation)response.asJson(ErrorRepresentation.class)).getErrorMessage());
    }
}

